/* $Header:_faults.c 12.0$ */
/* $ACIS:_faults.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libaed/RCS/_faults.c,v $ */

#ifndef lint
static char *rcsid = "$Header:_faults.c 12.0$";
#endif

#include "whim.h"
fontfault()

  begin
#include "whimdcl.h"
    INT16 fid;		   /* id of font requested */
    INT16 found;		   /* font found */
    fontdesc *font; /* font to be loaded */
    INT16 i;		   /* counter */

    /* get font id */
    fid = vikint[FFID];

    /* see if font is in list */
    font = fonts;
    found = 0;
    while (found == 0 && font != NULL) begin
      if (font->id == fid)
	found = 1;
	else font = font->nfont;
    end;

    /* if not found, answer with no */
    if (found == 0)
      vikint[VIKCMD] = 0;	 /* not found */
      else begin
	vikint[VIKCMD] = 1;    /* found */
	for (i = 0; i < 256; i++) begin
	  if (font->index[i] != NULL)
	    vikint[VIKCMD+1+i] = 0;
	    else vikint[VIKCMD+1+i] = 1;
	end;
      end;

    /* send answer */
    command(257);
  end

/*--------------------------------------------------------------*/
/*  Handle char fault						*/
/*--------------------------------------------------------------*/

charfault()

  begin
#include "whimdcl.h"
    INT16 fid;		   /* id of font requested */
    INT16 cid;		   /* id of char requested */
    INT16 found;		   /* font found */
    fontdesc *font; /* font to be loaded */
    chardesc *defn; /* character definition */
    INT16 len;		   /* length of character definition */
    INT16 i;		   /* counter */

    /* get font id */
    fid = vikint[CFFID];

    /* see if font is in list (must be) */
    font = fonts;
    found = 0;
    while (found == 0 && font != NULL) begin
      if (font->id == fid)
	found = 1;
	else font = font->nfont;
    end;

    len = 0;   /* if no defn found */

    if (found != 0)
      begin
	/* get char id */
	cid = vikint[CFCID];

	/* see if char is defined */
	defn = font->index[cid];
	if (defn == NULL)
	  found = 0;
	  else begin
	    /* load character definition */

	    vikint[VIKCMD] = 1;   /* char found */
	    len = defn->len;
	    vikint[VIKCMD+1] = len;

	    /* copy char into buffer */
	    for (i = 0; i < len; i++)
	      { INT16 temp;
		temp = defn->defn[i];
		temp = (((temp<<8)&0xff00) | ((temp>>8)&0x00ff));
		vikint[VIKCMD+2+i] = temp;
	      }
	  end;
      end;

    if (found == 0)
      vikint[VIKCMD] = 0;	 /* not found */

    /* send answer */
    command(len+2);
  end
