/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rpc.rwalld.c 12.0$ */
/* $ACIS:rpc.rwalld.c 12.0$ */
/* $Source: /ibm/acis/usr/src/nfs/etc/RCS/rpc.rwalld.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rpc.rwalld.c 12.0$";
#endif

#include <sys/nfs_defines.h>

/* @(#)rpc.rwalld.c	1.3 87/08/13 3.2/4.3NFSSRC */
/* @(#)rpc.rwalld.c	1.2 86/11/20 NFSSRC */
#ifndef lint
static  char sccsid[] = "@(#)rpc.rwalld.c 1.1 86/09/25 Copyright 1984, 1987 Sun Microsystems, Inc.";
/*
 *
 * NFSSRC 3.2/4.3 for the VAX*
 * Copyright (C) 1987 Sun Microsystems, Inc.
 * 
 * (*)VAX is a trademark of Digital Equipment Corporation
 *
 */
#endif

/*
 * Copyright (c) 1984, 1987 by Sun Microsystems, Inc.
 */

#include <rpcsvc/rwall.h>
#include <rpc/rpc.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/socket.h>
#include <syslog.h>

int splat();

main()
{
	register SVCXPRT *transp;
	struct sockaddr_in addr;
	int len = sizeof(struct sockaddr_in);
	
	if (getsockname(0, &addr, &len) != 0) {
		syslog(LOG_ERR,"rstat: getsockname: %m");
		exit(1);
	}
	if ((transp = svcudp_create(0)) == NULL) {
		syslog(LOG_ERR, "svc_rpc_udp_create: error\n");
		exit(1);
	}
	if (!svc_register(transp, WALLPROG, WALLVERS, splat, 0)) {
		syslog(LOG_ERR, "svc_rpc_register: error\n");
		exit(1);
	}
	svc_run();
	syslog(LOG_ALERT, "Error: svc_run shouldn't have returned\n");
}

splat(rqstp, transp)
	register struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	FILE *fp, *popen();
	char *msg = NULL;
        struct sockaddr_in addr;	
	struct hostent *hp;
	char buf[256];

	switch (rqstp->rq_proc) {
		case 0:
			if (svc_sendreply(transp, xdr_void, 0)  == FALSE) {
				syslog(LOG_ERR, "err: rusersd");
				exit(1);
			    }
			exit(0);
		case WALLPROC_WALL:
			if (!svc_getargs(transp, xdr_wrapstring, &msg)) {
			    	svcerr_decode(transp);
				exit(1);
			}
			if (svc_sendreply(transp, xdr_void, 0)  == FALSE) {
				syslog(LOG_ERR, "err: rusersd");
				exit(1);
			}
			if (fork() == 0) {/* fork off child to do it */
				fp = popen("/bin/wall", "w");
				fprintf(fp, "%s", msg);
				pclose(fp);
				exit(0);
			}
			exit(0);
		default: 
			svcerr_noproc(transp);
			exit(0);
	}
}

/* 
 * NFSSRC 3.2/4.3 for the VAX*
 * Copyright (C) 1987 Sun Microsystems, Inc.
 * 
 * (*)VAX is a trademark of Digital Equipment Corporation
 */
