/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:mul211.c 12.0$ */
/* $ACIS:mul211.c 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/ca/gen/RCS/mul211.c,v $ */

#ifndef lint
static char *rcsid = "$Header:mul211.c 12.0$";
#endif

/* Multiplication of two signed long integers

The arguments are x and y, two signed longword integers. The 
result is their two longword product, properly signed.

The algorithm uses the equivalent unsigned multiplication routine 
to obtain a product, modifying the product according to whether 
either or both of x and y is negative. If x is negative, y is 
subtracted from the first longword of the product; if y is 
negative, x is subtracted from the first longword of the product.

For processors like the Motorola 68020, this function is 
equivalent to a single machine instruction. */

extern _mulu211();

void _mul211 (x, y, z)
long x, y, z[2];
{int a, b, c, d, e, f;
_mulu211 (x, y, z);
a = x < 0;
b = y * a;
c = y < 0;
d = x * c;
e = b + d;
f = z[0] - (unsigned long) e;
 z[0] = f;}

/* Test program for _mul211 

main ()
{long a, b, c[2];

 for (;;) {printf("? ");
           scanf("%lx %lx", &a, &b);
           printf("a:%08lx  b:%08lx\n", a, b);
           _mul211(a, b, c);
           printf("c: %08lx %08lx\n", c[0], c[1]);}}
*/
