/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:lmul.s 12.0$ */
/* $ACIS:lmul.s 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/ca/gen/RCS/lmul.s,v $ */

	.data
rcsid:	.asciz	"$Header:lmul.s 12.0$"
	.text

#include "LINKG.h"

 #	Signed long multiply of two 32 bit integers
 #	product = lmul(x,y)
 
	.globl	ulmul$$		# Unsigned and signed are identical
	.globl	lmul$$		
	.globl	_.ulmul$$
 
	.set	mq,r10		#multiplier quotient system control reg
 
lmul$$:
ulmul$$:
_.ulmul$$:
ENTRY(lmul$$)
	cli	r3,256		#special-case small arguments
	blx	3f
	s	r0,r0		#zero answer and set carry on
	
	cli	r2,256		#other argument might be small --
	blx	2f		# (note cli did not affect C0)
	mts	%mq,r2		#multiply mq by r3 and put the answer in r0
 
	m	r0,r3	#incremental multiply
	m	r0,r3	#incremental multiply
	m	r0,r3	#incremental multiply
	m	r0,r3	#incremental multiply

	m	r0,r3	#incremental multiply
	m	r0,r3	#incremental multiply
	m	r0,r3	#incremental multiply
	m	r0,r3	#incremental multiply

	m	r0,r3	#incremental multiply
	m	r0,r3	#incremental multiply
	m	r0,r3	#incremental multiply
	m	r0,r3	#incremental multiply

	m	r0,r3	#incremental multiply
	m	r0,r3	#incremental multiply
	m	r0,r3	#incremental multiply
	m	r0,r3	#incremental multiply
 
	brx	r15	#return to calling routine
	mfs	%mq,r2

3:	mts	%mq,r3		# multiply by 8-bit value
	mr	r3,r2		# in mq
2:	m	r0,r3
	m	r0,r3
	m	r0,r3
	m	r0,r3
	bc0x	4f
	mfs	%mq,r2
	a	r0,r3	
 #				Now r0,r2 hold the 32-bit product,
 #				left-shifted by 24.
4:	sri16	r2,8
	sli	r0,8
	brx	r15
	a	r2,r0
 
	TTNOFRM
