/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:cvd10.s 12.0$ */
/* $ACIS:cvd10.s 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/ca/gen/RCS/cvd10.s,v $ */

	.data
rcsid:	.asciz	"$Header:cvd10.s 12.0$"
	.text
#include "LINKG.h"

 #******************************************************************************
 #
 #	Double by single divide to get quotient and remainder		       
 #
 #	_udl2x1 (twol,divisor)
 #		unsigned long twol[2];
 #		long divisor;
 #	behavior not known for negative twol[0] or divisor
 #
 #	Note: Though this is used in conjunction with two calls of _cvd10,
 #	it does  n o t  produce a correct 20-digit result.  The value of the
 #	double-word integer must be <1e18.
 #
 #******************************************************************************
 
.set	mq,r10

ENTRY(_udl2x1)
					#r4,mq = dividend
					#r3    = divisor
					#r2    = dividend & result addr
					#r0    = loop counter
	ls	r4,4(r2)		#second unsigned word
	mts	%mq,r4			#to mq
	ls	r4,0(r2)		#first unsigned word
	lis	r0,8			#set up for partially-unrolled divide
	
d1:	d	r4,r3			#32 divide steps
	d	r4,r3
	d	r4,r3
	sis	r0,1
	bpx	d1
	d	r4,r3

	jc0	d2
	a	r4,r3
d2:	sts	r4,4(r2)
	mfs	%mq,r4
	brx	r15
	sts	r4,0(r2)

 #*****************************************************************************
 #
 #       Convert unsigned long to 10 decimal digits.
 #       _cvd10(digits,value)
 #		char *digits;
 #		unsigned long value;
 #
 #*****************************************************************************

ENTRY(_cvd10)
				# r3 = shifted powers of 10
				# r2,mq = developing bcd
	cas	r4,r2,r0
	srpi	r3,11		# r2	= 00000000 00012345 67812345 67812345
	sli16	r3,16-11	# mq    = 67812345 67800000 00000000 00000000
	mts	%mq,r3

 # Garbage in following operand fields persuades the assembler to build a 16-bit
 # displacement holding the low 16 bits of the operand.  A difficult task,
 # to be sure, but this assembler Can Handle It!

	cal16	r3,((1000000000>>8)&0xffff^0x8000)-0x8000(r0)
	oiu	r3,r3,(1000000000>>8)>>16
	d	r2,r3		# lead digit is at most 4; only 3 ds's needed
	d	r2,r3
	d	r2,r3
	jc0	c2
	a	r2,r3
c2:	cal16	r3,((100000000>>4)&0xffff^0x8000)-0x8000(r0)
	oiu	r3,r3,(100000000>>4)>>16
	d	r2,r3
	d	r2,r3
	d	r2,r3
	d	r2,r3
	jc0	d3
	a	r2,r3
d3:	cal16	r3,((10000000)&0xffff^0x8000)-0x8000(r0)
	oiu	r3,r3,(10000000)>>16	
	d	r2,r3
	d	r2,r3
	d	r2,r3
	d	r2,r3
	jc0	c4
	a	r2,r3
c4:	cal16	r3,((1000000<<4)&0xffff^0x8000)-0x8000(r0)
	oiu	r3,r3,(1000000<<4)>>16
	d	r2,r3
	d	r2,r3
	d	r2,r3
	d	r2,r3
	jc0	c5
	a	r2,r3
c5:	cal16	r3,((100000<<8)&0xffff^0x8000)-0x8000(r0)
	oiu	r3,r3,(100000<<8)>>16
	d	r2,r3
	d	r2,r3
	d	r2,r3
	d	r2,r3
	jc0	c6
	a	r2,r3
c6:	cal16	r3,((10000<<12)&0xffff^0x8000)-0x8000(r0)
	oiu	r3,r3,(10000<<12)>>16
	d	r2,r3
	d	r2,r3
	d	r2,r3
	d	r2,r3
	jc0	c7
	a	r2,r3
c7:	cal16	r3,((1000<<16)&0xffff^0x8000)-0x8000(r0)
	oiu	r3,r3,(1000<<16)>>16
	d	r2,r3
	d	r2,r3
	d	r2,r3
	d	r2,r3
	jc0	c8
	a	r2,r3
c8:	cal16	r3,((100<<20)&0xffff^0x8000)-0x8000(r0)
	oiu	r3,r3,(100<<20)>>16
	d	r2,r3
	d	r2,r3
	d	r2,r3
	d	r2,r3
	jc0	c9
	a	r2,r3
c9:	cal16	r3,((10<<24)&0xffff^0x8000)-0x8000(r0)
	oiu	r3,r3,(10<<24)>>16
	d	r2,r3
	d	r2,r3
	d	r2,r3
	d	r2,r3
	jc0	c10
	a	r2,r3
c10:				# We now have converted decimal abcdefghij
				# to
				#	r2 = 0j00000a
				#	mq = bcdefghi
	mc30	r0,r2
	ai	r0,r0,'0
	stcs	r0,9(r4)	# Get last char out of the way, then start
	lis	r0,9		# the char-storing loop on chars 0-8.
	bx	s2
	mfs	%mq,r3

s1:	inc	r4,1
	srpi16	r3,28-16	# r2,r3 =  xxxxxx'a' bcdefghi
	sli	r3,4		#      to  0000000b  cdefghi0
s2:	ai	r2,r2,'0
	sis	r0,1
	bpx	s1
	stcs	r2,0(r4)
	
	br	r15			
	TTNOFRM
