/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:ctl_msgs.c 12.0$ */
/* $ACIS:ctl_msgs.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/misc/RCS/ctl_msgs.c,v $ */

#ifndef lint
static char *rcsid = "$Header:ctl_msgs.c 12.0$";
#endif


#ifndef lint
static char rcsid_ctl_msgs_c[] = "$Header:ctl_msgs.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"


/* This file contains the skeleton message descriptors for the
 * control messages presently accepted by the vd database manager.
 * The include file ctl_msgs.h defines the "field" offsets in each
 * descriptor.
 */

#include	<sys/types.h>
#include	<stdio.h>
#include	<ctype.h>

#include	"rvd_types.h"
#include	"ctl_pkt.h"
#include	"extern.h"


static struct	item	ITM_padd[] = {	/* add_physical */
	{ "password", NULL, FALSE },	/* ITM_PADD_PASSW */
	{ "filename", NULL, TRUE },	/* ITM_PADD_FILE */
	{ "blocks", NULL, TRUE},	/* ITM_PADD_BLOCKS */
	{ "created", NULL, FALSE},	/* ITM_PADD_CREATED */
	{ "modified", NULL, FALSE}	/* ITM_PADD_MODIFIED */
};
static struct item	ITM_vadd[] = {	/* add_virtual */
	{ "password", NULL, FALSE },	/* ITM_VADD_PASSW */
	{ "physical", NULL, TRUE },	/* ITM_VADD_PHYS */
	{ "name", NULL, TRUE },		/* ITM_VADD_NAME */
	{ "uid", NULL, TRUE },		/* ITM_VADD_UID */
	{ "owner", NULL, TRUE },	/* ITM_VADD_OWN */
	{ "rocap", NULL, TRUE },	/* ITM_VADD_ROCAP */
	{ "excap", NULL, TRUE },	/* ITM_VADD_EXCAP */
	{ "shcap", NULL, TRUE },	/* ITM_VADD_SHCAP */
	{ "modes", NULL, TRUE },	/* ITM_VADD_MODES */
	{ "blocks", NULL, TRUE },	/* ITM_VADD_BLOCKS */
	{ "ownhost", NULL, FALSE },	/* ITM_VADD_OWNH */
	{ "offset", NULL, TRUE },	/* ITM_VADD_OFF */
	{ "created", NULL, FALSE },	/* ITM_VADD_CREATED */
	{ "modified", NULL, FALSE }	/* ITM_VADD_MODIFIED */
};

static struct item	ITM_vdel[] = {	/* delete_virtual */
	{ "password", NULL, FALSE },	/* ITM_VDEL_PASSW */
	{ "name", NULL, TRUE },		/* ITM_VDEL_NAME */
	{ "uid", NULL, FALSE },		/* ITM_VDEL_UID */
};

/* This is the table of all allowable messages */

static struct	msg	all_msgs[] = {	/* all allowable message descriptors */
	{ "add_physical", ITM_padd, nitems(ITM_padd), pd_add },
	{ "add_virtual", ITM_vadd, nitems(ITM_vadd), vd_add }
#ifdef	VDEL
	,{ "delete_virtual", ITM_vdel, nitems(ITM_vdel), vd_del }
#endif	VDEL
};

#define	NMSGS	(sizeof(all_msgs)/sizeof(struct msg))

struct msg *
ctl_msg(opcode)

/* Look up the specified opcode in the table of allowable messages and
 * return a pointer to the message descriptor.  Return NULL if there
 * is no such opcode.
 */

register char	*opcode;			/* opcode name */
{
	register struct	msg	*msgp;		/* temp for message ptr */

	for (msgp = &all_msgs[0]; msgp < &all_msgs[NMSGS]; msgp++)
		if (strcmp(msgp->ms_opcode, opcode) == 0)
			return(msgp);
	return(NULL);
}


struct item *
ctl_item(skel, skellen, key)

/* Look up the specified keyword in the specified skeleton item list and
 * return a pointer to the item descriptor in the list.  If the keyword
 * is not found, return NULL.
 */

register struct	item	skel[];			/* skeleton item list */
register int	skellen;			/* number of items in list */
register char	*key;				/* keyword to look up */
{
	register struct	item	*itp;		/* temp for search */
		
	for (itp = &skel[0]; itp < &skel[skellen]; itp++)
		if (strcmp(itp->it_key, key) == 0)
			return(itp);
	return(NULL);
}
