/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:custom.h 12.0$ */
/* $ACIS:custom.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/h/RCS/custom.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidcustom = "$Header:custom.h 12.0$";
#endif


/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* This file defines all the "customizable" constants used in the
 * RVD server.  Constants not defined in this file may be assumed
 * to be "manifest".
 */

#define	NBUFS		256		/* initial number of packet buffers */
#define	NCONN		256		/* initial number of connections */
#define	BLOCKFACTOR	2		/* maximum disk blocks per packet */
#define	MAXCONTIG	32		/* maximum contiguous blocks per
					 * read or write request
					 */

#define	RVDMASTER	"rvdmaster"		/* name of RVD master file */
#define	RVDRESTART	"/etc/rvd/rvdstart"	/* name of RVD database */
#define	RVDDB		"/etc/rvd/rvddb"	/* name of RVD database */
#define	RVDAUTHOR	"/etc/rvd/rvdauthor"	/* name of RVD password file */
#define	TAPE		"/dev/rmt12"		/* tape default for savervd */

/* Magic numbers for flow control purposes.  This stuff is all very
 * experimental and the following numbers can only be determined empirically.
 */

#define	BURST		16		/* max client packets in a burst */
#define	QLEN		16		/* max total requests outstanding */

/* Time in sec. until rvdsrv starts rejecting packets while not
   configured, i.e., the time period following startup in which an
   unconfigured rvdsrv will eat packets without sending RVDESNA.
 */
#define	RVDSRVDELAY	30

/* Magic number of seconds to add to UNIX time to make it ARPA time
 */

#define LONGTIME	2208988800

/* Clock refresh interval for timestamps (3 min.)
 */

#define	QUANTUM		(3*60)

/* MAX_RW_QLENGTH is used to limit the size of the queue length statistic.
 * It is not used to turn away read/write activity.  MAX_RW_QARRAY is
 * used to limit the size of the statistics array, rw_qlength.
 */
#define MAX_RW_QLENGTH	100000
#define MAX_RW_QARRAY	50
