/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:gen_trans_table.c 12.0$ */
/* $ACIS:gen_trans_table.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/fdb_ca/lib/src/RCS/gen_trans_table.c,v $ */

#ifndef lint
static char *rcsid = "$Header:gen_trans_table.c 12.0$";
#endif

 
#include <stdio.h>
#include <ctype.h>

main (argc, argv)
  int argc;
  char *argv[];
  {

  unsigned int c;
  int c_trans;

  printf ("static unsigned char c_trans[256] = {\n\n  ");

  for (c=0; c<256; c++) {

    if (!isascii(c)) c_trans = 15;	/* check for extended ascii character,
				   check must be done first because most
				   character type checks assume that the
				   character is ascii */
    else if (c == ' ' || c == '\t') c_trans = 0;
    else if (isupper(c)) c_trans = 1;
    else if (islower(c)) c_trans = 1;
    else if (c=='#' || c=='$' || c=='_') c_trans = 1;
    else if (isdigit(c)) c_trans = 2;
    else if (iscntrl(c)) {
      if (c == '\n' || c == '\f') c_trans = 4;
      else if (c == '\0') c_trans = 16;
      else
	c_trans = 17;
    }
    else if (c == '!' || c == '*' ||
	     c == '%' || c == '^' || c == '=') c_trans = 5;
    else if (c == '|' || c == '&' || c == '+') c_trans = 6;
    else if (c == '<' || c == '>') c_trans = 7;
    else if (c == '-') c_trans = 8;
    else if (c == '/') c_trans = 9;
    else if (c == '"') c_trans = 10;
    else if (c == '\'') c_trans = 11;
    else if (c == '.') c_trans = 12;
    else if (c == '(' || c == '[' || c == '{') c_trans = 13;
    else if (c == ')' || c == ']' || c == '}') c_trans = 14;
    else c_trans = 15;

    printf (" %2d /\* %3d %03o %02x  %c *\/",
	     c_trans, c, c, c, (c>127 || iscntrl(c)) ? '_':c);
    if (c<255) printf (",");
    if ((c%3)==2) printf ("\n  ");
  }
  printf ("  };\n");

}
