/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:deviceattr.h 12.0$ */
/* $ACIS:deviceattr.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/ditroff/h/RCS/deviceattr.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsiddeviceattr = "$Header:deviceattr.h 12.0$";
#endif

/*
        deviceattr.h: characteristics of a typesetter
*/
 
typedef long   resolutionunits;
typedef short  fontindex;
typedef short  sizeindex;
 
struct dev {
        long   filesize;       /* number of bytes in file, */
                                        /* excluding dev part */
        long    res;            /* basic resolution in goobies/inch */
        resolutionunits    hor;            /* goobies horizontally */
        resolutionunits    vert;
        short   unitwidth;      /* size at which widths are given, in effect */
        short   nfonts;         /* number of fonts physically available */
        short   nsizes;         /* number of sizes it has */
	short   scalable;	/* 1 == fonts are scalable */
        short   sizescale;      /* scaling for fractional point sizes */
        resolutionunits    paperwidth;     /* max line length in units */
        resolutionunits    paperlength;    /* max paper length in units */
        short   nchtab;         /* number of funny names in chtab */
        short   lchname;        /* length of chname table */
        long    spare1;         /* in case of expansion */
        long    spare2;
};
 
struct charinfo {
    unsigned char code;		/* code to be sent to printer */
    unsigned char kern;		/* kerning information */
    short *widths;	/* width information */
};
 
struct fontattr {           /* characteristics of a font */
	short   searchpathcount;
        unsigned short    numberofchars;         /* number of entries for this font */
        char    specfont;       /* 1 == special font */
        char    ligfont;        /* 1 == ligatures exist on this font */
        char    spare3;         /* unused for now */
        char    namefont[16];   /* name of this font (e.g., "R" */
        char    intname[16];    /* internal name (=number) on device, in ascii */
	fontindex *searchpath;	/* font path to search when character is not found */
	struct charinfo *info;
	unsigned char *charmapping;	/* index into info structure */
};
 
/* ligatures, ORed into ligfont */
 
#define LFF     01
#define LFI     02
#define LFL     04
#define LFFI    010
#define LFFL    020
 
extern struct dev dev;
extern short *pstab;		/* point size table */
extern short *chtab;		/* character name index table */
extern struct fontattr *fontbase[];	/* array of font structures */
extern fontindex smnt;		/* first index of a special font */
extern char *chname;		/* character names */
extern fontindex fontmap[];
