/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:info.h 12.0$ */
/* $ACIS:info.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/ditroff/dit3812/RCS/info.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidinfo = "$Header:info.h 12.0$";
#endif

  /*\
  |* Maintains information about troff characters and fonts. Font info
  |* is loaded from a dvitroff DESC.out or FONT.out file, and a number
  |* of functions which report the various aspects of the fonts are
  |* provided.
  |*
  |* PROVIDES:
  |*    ip_Load(name,fil) --    Loads a description of the printer
  |*    char    *name;          named 'name'.  If 'fil' is not NULL,
  |*    FILE    *fil;           the description is loaded from it,
  |*                            otherwise it is loaded from the default
  |*    printer description file.  The directory containing the printer
  |*    description is constructed by concatenating IP_PREFIX, 'name',
  |*    and IP_SUFFIX. The name of the file describing the printer is
  |*    in IP_DESC. If called more than once (with different printer
  |*    names), all old printer information is discarded and a warning
  |*    is printed.  Multiple loads for the same printer are ignored.
  |*    Returns TRUE if successfully loaded, FALSE otherwise.
  |*
  |*    if_Load(name,fil) -     Loads a description of the font named
  |*    char   *name;           'name' for the current printer.  The
  |*    FILE   *fil;            file describing a font is in the
  |*    directory described above, and the file's name is constructed
  |*    by concatenating the name of the directory determined in
  |*    ip_Load() above, IF_PREFIX, the font name and IF_SUFFIX.
  |*    If the requested font is already loaded, no action is taken.
  |*    If 'fil' is provided (not NULL), it is used rather than the
  |*    default. Returns TRUE if the font is sucessfully loaded, or was
  |*    already loaded, FALSE otherwise.
  |*
  |*    ip_FSpecials()   --     Returns an array of (char *) containing
  |*                            the names of all of the special fonts
  |*    defined for the printer.  The returned array is static, and
  |*    should not be modified. The last element of the array is NULL.
  |*	Returns NULL if the printer has not been initialized
  |*
  |*    ip_CSpecials()   --     Returns a null terminated array of
  |*                            (char *) containing the names of the
  |*    special characters defined for the current printer.  The array
  |*    is static and should not be modified.  Returns NULL if the printer
  |*	has not been initialized.
  |*
  |*    ip_Fonts()       --     Returns a null terminated array of
  |*                            (char *) which contains the names of
  |*    fonts defined for the printer in the order they were loaded.
  |*    The returned array is static and should not be modified.
  |*	Returns NULL if the printer has not been initialized.
  |*
  |*	ip_Sizes()	 --	Returns a 0 terminater array of (short)
  |*				which contains the sizes which are defined
  |*	for the	printer.  The returned array is static and should not be
  |*	modified. Returns NULL if the printer has not been initialized.
  |*
  |*	ip_Info(IP_SIZE,size)
  |*	ip_Info(IP_ALL,buf)
  |*	struct dev *buf;
  |*    ip_Info(attr)    --     Returns the specified attribute of the
  |*    int    attr;            printer (integer).  Returns IP_NOTFOUND if
  |*				printer has not been initialized, or
  |*	IP_ILLEGAL if an illegal attribute is requested. IP_ALL returns
  |*	IP_NOERROR on successful completion.
  |*
  |*	indicated below).
  |*				initialized. Legal printer Attributes are:
  |*        IP_RES    --    printer resolution in points per inch.  <0>
  |*        IP_HOR    --    minimum horizontal motion in PPI (pels)
  |*        IP_VERT   --    mimimum vertical motion in pels.
  |*        IP_WIDTH  --    width of printer in pels
  |*        IP_HEIGHT --    height of printer in pels
  |*        IP_UNITW  --    'unit width' of printer font descriptions.
  |*                        The unit width is the width at which all
  |*                        font descriptions are specified. I.E.  If
  |*                        the width specified for a character 'c' in
  |*                        a font 'f' is 'n', then 'c' is 'n' pels wide
  |*                        ONLY when printed in 'unit width' point face
  |*	    IP_SIZE   --    Returns the index in widths field of a
  |*			    charinfo of point size "size". (i.e.
  |*			    tch->tr_widths[ip_Info(IP_SIZE,12)] is the
  |*			    width of tch at 12 point)
  |*	    IP_ALL    --    Returns the dev structure (in buf) which describes
  |*			    the printer.
  |*
  |*    ic_Info(font,ch,attr)
  |*    ic_Info(font,ch,IC_ALL,buf)
  |*    ic_Info(font,ch,IC_WIDTH,size) -- Returns the specified attribute of
  |*    char   *font,*ch;               the character named 'ch' in the font
  |*    int    attr;                    named 'font'.  Returns IC_NOTFOUND if
  |*    [int   size;]                   the character is not available on the
  |*    [struct charinfo *buf;]		specified font, IC_ILLEGAL if the
  |*					character is not legal for the
  |*    printer, or IF_NOTFOUND if the description file for the
  |*    named font is not found, and the font has not been loaded.
  |*    If the named font has not been loaded, and a description file
  |*    exists, it will be automatically loaded. Two character names
  |*    are taken to be TROFF special character names; one character
  |*    names are taken to be the ascii representation of the character.
  |*	Requests for the attributes IC_WIDTH and IC_ALL take an additional
  |*    parameter, described below.
  |*    Recognized attributes are:
  |*         IC_CODE   --  The code point of the character
  |*         IC_WIDTH  --  The width of the character at "size"
  |*         IC_KERN   --  The kerning codes for the character. The
  |*                       meaning of these codes is described in the
  |*                       manual for dvitroff.
  |*	     IC_ALL    --  Returns a in "buf" all of the above
  |*			   information. Returns IC_NOERROR on succesful
  |*			   completion, IC_ILLEGAL on failure.
  |*
  |*	struct fontattr *if_Info(font) -- Returns the font structure which
  |*	char  *font;		      describes the font named in "font".
  |*				      The font structure is defined in
  |*				      deviceattr.h
  \*/


   /*\
   |*  If IP_AUTOINIT is defined, the default printer description will
   |*  be loaded automatically if necessary.  If not defined, an error will
   |*  returned if ip_Load is not called first.
   \*/

#define IP_AUTOINIT

/*** FILE AND PATH NAME COMPONENTS -- DESCRIBED ABOVE  ***/
/***            Set up for Troff defaults              ***/

#define IP_DFLT_NAME	"3812"
#define IP_DIR          "/usr/lib/font/dev%s/"
#define IP_DESC         "DESC.out"
#define IF_PREFIX       ((char *)NULL)
#define IF_SUFFIX       ".out"

/*** PRINTER ATTRIBUTES -- DESCRIBED ABOVE ***/

#define IP_RES    1
#define IP_HOR    2
#define IP_VERT   3
#define IP_WIDTH  4
#define IP_HEIGHT 5
#define IP_UNITW  6
#define IP_SIZE	  7
#define IP_ALL	  8

/*** CHARACTER ATTRIBUTES -- DESCRIBED ABOVE ***/

#define IC_CODE   101
#define IC_WIDTH  102
#define IC_KERN   103
#define IC_ALL	  104

/*** ERROR RETURNS -- DESCRIBED ABOVE ***/

#define  IP_NOERROR    0
#define  IP_ERROR     -1
#define  IP_ILLEGAL   -2
#define  IP_NOTFOUND  -3

#define  IF_NOERROR    0
#define  IF_ERROR     -11
#define  IF_ILLEGAL   -12
#define  IF_NOTFOUND  -13

#define  IC_NOERROR    0
#define  IC_ERROR     -101
#define  IC_ILLEGAL   -102
#define  IC_NOTFOUND  -103


int if_debug;


extern int    ip_Load();
extern int    if_Load();
extern short *ip_Sizes();
extern char **ip_FSpecials();
extern char **ip_CSpecials();
extern char **ip_Fonts();
extern char **ip_FTable();
extern int    ip_Info();
extern int    ic_Info();
extern int    ic_Search();
extern struct fontattr *if_Info();
