#!/bin/sh
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
# $Header:tailor.sh 12.0$ 
# $ACIS:tailor.sh 12.0$ 
# $Source: /ibm/acis/usr/src/etc/tailor/RCS/tailor.sh,v $ 

if [ `whoami` != root ]
then
      echo Warning: You must be a superuser for all tailor entries to be implemented.
      echo "   "
fi
DEBUG=
LIB=/usr/lib/tailor
HELP=/usr/lib/tailor 
UUCP=/usr/lib/uucp
#clear
echo "Type '<CTRL>-c' to cancel  at any time. Type '?' for help at any prompt"
echo "Your work station can be customized as one of the following types:"
echo "m:  Network installation master."
echo "c:  uucp connection machine."
echo "b:  Both master and connection machine."
echo "s:  Stand-alone station or end user station."
type=`$LIB/tailor.query "Enter work station type:" $HELP/help.type s m c b s`
###########
case $type in
###### SCRIPT FOR STAND_ALONE, NETWORK MASTER OR END USER STATION #####
s|m) 
      ohost=`hostname=master;if [ -s /etc/rc.config ]; then . /etc/rc.config; fi; echo ${hostname}`
      nhost=`$LIB/tailor.query "Enter host name" $HELP/help.hostname "$ohost" "*"`
      onetdev=`network=un0;if [ -s /etc/rc.config ]; then . /etc/rc.config; fi; echo ${network}`
      nnetdev=`${LIB}/tailor.query "Enter network device" ${HELP}/help.netdev "${onetdev}" un0 un1 lan0 lan1`
      #Put host name in /etc/rc.config and kernel
      $LIB/tailor.host "$ohost" "$nhost" "$type"
      ${LIB}/tailor.netdev ${nnetdev}
      echo "Tailor completed."
      exit 0
      ;;
##### SCRIPT FOR CONNECTION MACHINE OR BOTH #####
c|b)
      echo "To customize your work station you will need the following information:"
      echo "host name    serial port name    modem type"
      echo "long distance dial digits    uucp password"
      echo "Do not continue unless you have this information."
      rep=`$LIB/tailor.query "Do you wish to continue ? y/n" $HELP/help.ans"*" y y n`
      if [ "${rep}" = n ]
      then
            exit 0
      fi
      #Find old parameters
      ohost=`hostname=master;if [ -s /etc/rc.config ]; then . /etc/rc.config; fi; echo ${hostname}`
      onetdev=`network=un0;if [ -s /etc/rc.config ]; then . /etc/rc.config; fi; echo ${network}`
      odial=`awk '/ibmsupt/  {print $5}' $UUCP/L.sys`
      opass=`awk '/ibmsupt/  {print $11}' $UUCP/L.sys`
      omodem=`awk '/ACU/ {print $5}' $UUCP/L-devices`
      oport=`awk '/ACU/ {print $2}' $UUCP/L-devices`
      #clear 
      nhost=`$LIB/tailor.query "Enter host name" $HELP/help.ansh "$ohost" "*"`
      nnetdev=`${LIB}/tailor.query "Enter network device" ${HELP}/help.netdev "${onetdev}" un0 un1 lan0 lan1`
      npass=`$LIB/tailor.query "Enter uucp password" $HELP/help.ansp $opass "*"`
      nmodem=`$LIB/tailor.query "Enter modem type" $HELP/help.ansm $omodem hayestone vadic va212`
      ndial=`$LIB/tailor.query "Enter dial digits" $HELP/help.ansd $odial "*"`
      ports=`cd /dev; ls tty[01cs]*`
      nport=`$LIB/tailor.query "Enter serial port name" $HELP/help.anss $oport $ports`
      echo "   "
      echo "      These are the changes you entered:"
      echo "   "
      (echo '.pl 1'
      echo '.TS'
      echo 'tab(:);'
      echo 'l l l.'
      echo NAME:OLD:NEW
      echo host name:$ohost:$nhost
      echo network device:${onetdev}:${nnetdev}
      echo password:$opass:$npass
      echo modem type:$omodem:$nmodem
      echo serial port:$oport:$nport
      echo dial digits:$odial:$ndial
      echo ".TE") | tbl | nroff | colcrt
      echo "  "
      rep=`$LIB/tailor.query "Implement these changes ? y/n" $HELP/help.no y y n`
      if [ "${rep}" = n ]
      then
            exit 0
      fi
      $LIB/tailor.host "$ohost" "$nhost" "$type"
      ${LIB}/tailor.netdev ${nnetdev}
      #Edit L.sys and L-devices in uucp files 
      $LIB/tailor.uucp $ohost $nhost $opass $npass $odial $ndial $omodem $nmodem $oport $nport                  
      (cd /usr/src/usr.bin/uucp; $DEBUG make mkdirs)
      chmod 666 /dev/$nport
      echo "Tailor completed"
      ;;
esac
exit 0
