/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:setscreen.c_ca 12.0$ */
/* $ACIS:setscreen.c_ca 12.0$ */
/* $Source: /ibm/acis/usr/src/etc/RCS/setscreen.c_ca,v $ */

#ifndef lint
static char *rcsid = "$Header:setscreen.c_ca 12.0$";
#endif

/* setscreens -- used to read /etc/consoles and enable/disable 
 *	use of specified screen devices.
 */
#include <stdio.h>
#include <ctype.h>
#include <machinecons/consio.h>
#include <sys/ioctl.h>
#include <sys/file.h>

int dev,access;
int cons;
struct screen_control devflg;
char *s;
extern int errno,perror();

#define INFILE "/etc/consoles"
FILE *fd;
char line[80],val[2],*s1,c;
int filestat = 0;

INIT_CONSOLES_TAB;	/* allocate and initialize device table */

main(argc,argv)
	int argc; char *argv[];
{
	char *infile;
	if (argc < 2)
		{
		printf("setscreen mode device\n");
		printf("setscreen -f [file]\n");
		exit(1);
		}
	if (*argv[1] == '-')	/* test for f option and process file */
		{
		if(strcmp(argv[1],"-f"))
			{
			printf("unrecognized option %s\n",++argv[1]);
			exit(1);
			}
		if (argc < 3)
			infile = INFILE;
		else
			infile = argv[2];
		if ((fd=fopen(infile,"r")) == NULL)
			{
			perror(infile);
			exit(1);
			}
		opencons();  
		val[1] = '\0';	/* string termination */
		while(fgets(line,80,fd))
			{
			if (!isdigit(line[0]))
				continue;
			val[0] = line[0];
			access = atoi(val);
			s = &line[1];
			while(isspace(*s)) ++s;	/* search for start of str */
			if (!*s) continue;	
			s1 = s;
			while (isalnum(*s1))
				s1++;
			*s1 = '\0'; /* terminate string at last alphanumeric */
			process_str();
			}
		}
	else	/* no options -- process mode and device */
		{
		if (!isdigit(*argv[1]))
			{
			printf("access mode %c not valid\n",*argv[1]);
			exit(1);
			}
		opencons();
		access = atoi(argv[1]);
		s = argv[2];	
		process_str();
		}
}

opencons()
{
	if ((cons = open ("/dev/console", O_WRONLY)) <= 0) 
		{
		printf ("Could not open /dev/console\n");
		exit (1);
		}
}

process_str()
{
	int i = NUMBER_CONS - 2;
	dev = CONS_DUMMY;

	do	{
		if (!strcmp(s,consoles_tab[i].name))
			{
			dev = consoles_tab[i].consnum;
			break;
			}
		}
	while (i--);	/* quit after checking entry zero */	
	if (dev != CONS_DUMMY)
			call_ioctl();
	else printf("%s is not recognized as screen device\n",s);
}

call_ioctl()
{

	if (access < 0 || access > 3)
		{
		printf("access value %d is not implemented\n",access);
		}
	devflg.device = dev;
	if (ioctl (cons, SCRIOCGETF, &devflg) == -1) 
		{
		perror(s);
		return(0);	/* no action on missing devices */
		}
	switch (access)
		{
		case 0: /* no console, no hardware access */
				devflg.switches = CONSDEV_NONE;
				break;	
		case 1: /* console, but no hardware access */
				devflg.switches = CONSDEV_KERNEL;
				break;	
		case 2: /* no console, but hardware access */
				devflg.switches = CONSDEV_USER;
				break;	
		case 3: /* console and hardware access */
				devflg.switches = CONSDEV_BOTH;
		}
		if((ioctl (cons, SCRIOCSETC, &devflg)) < 0)
			perror(s);
}
