/*
   mkbrec.c - build a boot record for the RT for various ESDI disks
		Mark Dapoz
*/

#include <stdio.h>
#include <sys/types.h>
#include "hdinfo.h"

/* defines that are compatible with existing AOS/VRM-ism's */
#define HD_BOOT_CYL	0
#define HD_BOOT_HD	4		/* constant for ESDI disks */
#define HD_BOOT_SEC	1
#define HD_BOOT_LEN(heads,sectors)	(((heads)-HD_BOOT_HD)*sectors+15)
#define HD_BOOT_ENTRY	0

main(argc, argv)
int argc;
char **argv;
{
    extern char *optarg;
    extern int optind;
    int ch;

    char *progname=argv[0];
    char *model=NULL;
    int pcyl=0, hd=0, sec=0, israw=0;
    int bck=0, bcyl=0, bhd=0, bsec=0, blen=0, bentry=0;

    while ((ch = getopt(argc, argv, "m:c:h:s:C:H:S:K:L:E:")) != EOF) {
	switch(ch) {
	    case 'm':
		    model=optarg;
		    break;
	    case 'c':
		    pcyl=atoi(optarg);
		    break;
	    case 'h':
		    hd=atoi(optarg);
		    break;
	    case 's':
		    sec=atoi(optarg);
		    break;
	    case 'K':
		    israw++;
		    bck=atoi(optarg);
		    break;
	    case 'C':
		    israw++;
		    bcyl=atoi(optarg);
		    break;
	    case 'H':
		    israw++;
		    bhd=atoi(optarg);
		    break;
	    case 'S':
		    israw++;
		    bsec=atoi(optarg);
		    break;
	    case 'L':
		    israw++;
		    blen=atoi(optarg);
		    break;
	    case 'E':
		    israw++;
		    bentry=atoi(optarg);
		    break;
	    case '?':
	    default:
		    usage(progname);
		    exit(0);
	}
    }
    argc -= optind;
    argv += optind;
    if ((model != NULL && (pcyl || hd || sec)) || 
	    (model == NULL && (!pcyl && !hd && !sec))) {
	usage(progname);
	exit(0);
    }
    if (model != NULL) {
	if (!strcmp(model, "hd114e"))
	    hd_boot_rec(915, 7, 35, 0, 0xb4, 0, 0, 1);  /* hd114e */
	else if (!strcmp(model, "hd70e"))
	    hd_boot_rec(583, 7, 35, 2, 0x30, 0, 0, 1);  /* hd70e */
	else if (!strcmp(model, "hd70r"))
	    hd_boot_rec(566, 7, 36, 0, 0, 0, 0, 0);     /* hd70r */
	else if (!strcmp(model, "hd310h"))
	    hd_boot_rec(1189, 15, 34, 1, 9, 0, 0, 1);   /* hd310h */
	else if (!strcmp(model, "hd310e"))
	    hd_boot_rec(1225, 15, 33, 1, 0x2c, 0, 0, 1);/* hd310e */
	else if (!strcmp(model, "hd442c"))
	    hd_boot_rec(1412, 15, 36, 0, 0, 0, 0, 1);   /* hd442c */
	else {
	    models();			/* unknown */
	    exit(0);
	}
	exit(0);
    } 

    /* user-specified section */
    if (israw) {
	mk_boot_rec(israw, bck, pcyl, hd, sec, bcyl, bhd, bsec, blen, bentry,
		0, 0, 0, 0, 0);
	exit (0);
    }
    hd_boot_rec(pcyl, hd, sec);		/* user specified (hard drive) */
}

usage(cmd)
char *cmd;
{
    fprintf(stderr, "%s: [-m model] | [ -c num_cyl -h num_hd -s num_sec ]\n", cmd);
    fprintf(stderr, "    [-C boot_cyl -H boot_hd -S boot_sec -L boot_len -K boot_ckeck -E boot_entry]\n");
}

models()
{
    fprintf(stderr, "Only the following disk models are known: hd70e hd70r hd114e hd310h\n");
    fprintf(stderr, "                                          hd310e hd442c\n");
}

hd_boot_rec(pcyl, hd, sec, r11, r12, r13, r14, r21)
int pcyl, hd, sec;		/* disk geometry */
short r11, r12, r13, r14, r21;	/* misc reserved values */
{
    mk_boot_rec(0, 0x459, pcyl, hd, sec, 
	    HD_BOOT_CYL, HD_BOOT_HD, HD_BOOT_SEC, HD_BOOT_LEN(hd,sec), 
	    HD_BOOT_ENTRY, r11, r12, r13, r14, r21);
}

mk_boot_rec(israw, bck, pcyl, hd, sec, bcyl, bhd, bsec, blen, bentry,
	r11, r12, r13, r14, r21)
int israw;				/* do calcs different if raw-mode */
int bck;				/* boot check ? */
int pcyl, hd, sec;			/* disk geometry */
int bcyl, bhd, bsec, blen, bentry;	/* boot location info */
short r11, r12, r13, r14, r21;		/* misc reserved values */
{
	struct boothdr hdr;

	bzero(&hdr, sizeof(struct boothdr));

	hdr.boot_check=bck;
	hdr.boot_lastcyl=pcyl- (israw ? 1 : 2);
	hdr.boot_lasttrack=hd-1;
	hdr.boot_lastsect=sec;
	hdr.boot_sectorsize=512;	/* constant for ESDI disks */
	hdr.boot_interleave=0;		/* mostly constant */
	hdr.boot_sectorcount=(israw ? pcyl*hd*sec : (pcyl-1)*hd*sec);
	hdr.boot_formatdate=0;
	hdr.boot_cyl=bcyl;
	hdr.boot_track=bhd;
	hdr.boot_sector=bsec;
	hdr.boot_length=blen;
	hdr.boot_entry=bentry;
	hdr.boot_vrmminidisk=0;
	hdr.boot_llp=0;
	hdr.boot_vrmlength=0;

	hdr.boot_ibma[0]=0xc9;		/* IBMA in ebcdic */
	hdr.boot_ibma[1]=0xc2;
	hdr.boot_ibma[2]=0xd4;
	hdr.boot_ibma[3]=0xc1;

	hdr.boot_reserved1[0]=r11;	/* not sure what these are */
	hdr.boot_reserved1[1]=r12;
	hdr.boot_reserved1[2]=r13;
	hdr.boot_reserved1[3]=r14;

	hdr.boot_reserved2[0]=r21;	/* constant? */
	hdr.boot_reserved2[1]=0x00;
	hdr.boot_reserved2[2]=0x00;

	write(1, &hdr, sizeof(struct boothdr));
}
