/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: displayUid.c,v $ $Revision: 1.4 $ $Date: 92/03/13 17:57:35 $"
#endif
#endif
/*

	This a "generic" routine that will display widgets that are
	created in uil files. This routine assumes that a single
	Hierarchy will be opened.

	Syntax - displayUid root_filename or
		 displayUid (and will ask you for the UID root filename)

	The uid file will be opened and the widget realized.
*/


#include <stdio.h>

#define MAX_FILES	10
#define MAX_CALLBACK	32
#define MAX_LEN		255

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <Mrm/MrmAppl.h>    
#include <Xm/Xm.h>

/* Callback routines */

static void exit_test();
static void Report_Callback();
static void Place_Next();

static MrmHierarchy	s_MrmHierarchy;
static char		*vec[MAX_FILES];   	
static MrmCode		class;


static MRMRegisterArg reglist[] = {
  {"exit_test", (caddr_t)exit_test},
  {"Report_Callback", (caddr_t)Report_Callback}
};

static int reglist_num = (sizeof (reglist) / sizeof (reglist[0]));

Display		*dsp;
Screen		*screen;
Colormap	cmap;

Pixmap		images[2];
int		num_images = 2;

    
Pixel		image_background,
		image_foreground;

Widget toplevel = NULL;                    
Widget  widgetmain = NULL;

/*
 *  Main program
 */
int main(argc, argv)
int argc;
char **argv;

{
    Arg arglist[1];
    char uidname[MAX_LEN];


    /* 
       Set up uid file name from arg list and place .uid extention 
       on root filename.
    */

    if (argc > 2)
	{
	printf("Syntax is: \n\t -- %s <rootname of uid file>\n", argv[0]);
	exit(1);	
	}
    if (argc == 1)
	{
	printf("Enter the rootname of the UIL file you want displayed --> ");
	scanf("%s", uidname);
	printf("\n");
	}
    else
	strcpy(uidname, argv[1]);
    strcat(uidname, ".uid");
    printf("/*********************************************************/\n");
    printf("---- The uid file to be opened is %s ---- \n", uidname);
    printf("/*********************************************************/\n\n");
    vec[0] = uidname;

    /*
     *  Initialize the Mrm
     */

    MrmInitialize ();

    /*
     *  Initialize the toolkit.  This call returns the id of the "toplevel"
     *  widget.  The applications "main" widget must be the only child
     *  of this widget.
     */

    toplevel = XtInitialize(
	argv[1],	 		/* application name */
	"genericclass",                 /* application class */
	NULL, 0,                        /* options */
	&argc, argv);                   /* command line parameters */

    XtSetArg (arglist[0], XtNallowShellResize, TRUE) ;
    XtSetValues (toplevel, arglist, 1) ;

    /*
     *  Define the Mrm hierarchy (only 1 file)
     */

    if (MrmOpenHierarchy (1,			    /* number of files	    */
			vec, 			    /* files     	    */
			NULL,			    /* os_ext_list (null)   */
			&s_MrmHierarchy)	    /* ptr to returned id   */
			!= MrmSUCCESS) 
			{
				printf ("Can't open hierarchy\n");
     				exit(1);
			}

    /*
     *		Register all Mrm functions
     */	


    if (MrmRegisterNames (reglist, reglist_num)
			!= MrmSUCCESS)
			{
			    printf("Can't register names\n");
			    exit(1);
			}

    /*
     *  Call Mrm to fetch the main widget
     */

    if (MrmFetchWidget (s_MrmHierarchy,
			"widgetmain",
			toplevel,
			&widgetmain,
			&class)
			!= MrmSUCCESS)
			{
			    printf("Can't fetch interface\n");
			    exit(1);
			}

    /*
     *  Make the toplevel widget "manage" the main window (or whatever the
     *  the uil defines as the topmost widget).  This will
     *  cause it to be "realized" when the toplevel widget is "realized"
     */

    XtManageChild(widgetmain);
    
    /*
     *  Realize the toplevel widget.  This will cause the entire "managed"
     *  widget hierarchy to be displayed
     */

    Place_Next();

    XtRealizeWidget(toplevel);


    XmAddTabGroup(widgetmain);

    /*
     *  Loop and process events
     */


    XtMainLoop();
}

/****************************************************************************/
/*	Procedure exit_test()  - called when user had examined test and     */
/*	is ready to exit test. Called via a callback defined in UIL. 	    */
/****************************************************************************/

static void exit_test( widget, tag, callback_data )
Widget  widget;
char    *tag;
XmAnyCallbackStruct *callback_data;
{
	printf("Test finished -- Exiting....\n");
	exit(0);
}

/***************************************************************************/
/* 	Procedure Report_Callback() -					   */
/*	   when called will print to stdout the name of the callback 	   */
/*	   which is contained in tag. It also prints out the reason	   */
/*	   for the callback. This info is found in the CallbackStruct	   */
/*	   and in the header file reasons.h which contains all possible    */
/*	   Reasons in the array REASONS.				   */
/***************************************************************************/

static void Report_Callback( widget, tag, callback_data )
Widget  widget;
char    *tag;
XmAnyCallbackStruct *callback_data;
{
char *reason;
int reason_num;
int num_items;
int i, j;
Arg args[5];
XmString label_string;
XmString *list_items;

	printf("\n");
	printf("/*********************************************************/\n");
	printf("---- %s callback made ----\n", tag);
	printf("/*********************************************************/\n");
	printf("\n");
}

/****************************************************************************/
/*	Procedure fetch() - will extract from a heirarchy the widget ID of  */
/*	the specified widget name.				    	    */
/****************************************************************************/

void fetch(widget_index_string,widgetptr)
char *widget_index_string;
Widget *widgetptr;
{
  MrmType class;
  *widgetptr = NULL;
  if(MrmFetchWidget(s_MrmHierarchy,
		widget_index_string,
		toplevel,
		widgetptr,
		&class)!=MrmSUCCESS)
		  printf("fetch failed\n");
}


static void Place_Next()
{
Arg args[1];
Widget  widget = NULL;

if (MrmFetchWidget (s_MrmHierarchy,
                        "Next_Action",
                        toplevel,
                        &widget,
                        &class)
                        != MrmSUCCESS)
                        {
                            printf("Can't fetch interface\n");
                            exit(1);
                        }
XtSetArg(args[0], XtNgeometry, "+500+0");
XtSetValues(widget, args, 1);
XtManageChild(widget);
}

