/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: PIHints.c,v $ $Revision: 1.5 $ $Date: 92/03/13 17:53:05 $"
#endif
#endif

#include	<testlib.h>
#include	<PITests.h>

#include	"PIHints.h" 
#include	"btn1.bmp"


main(argc, argv)
unsigned int	argc;
char	*argv[];
{

	Arg     args[10];
	int     n;
	int		i;

	XmString    message;

    CommonTestInit(argc, argv);

    n = 0;
	XtSetArg(args[n], XmNwidth, 10); n++;
	XtSetArg(args[n], XmNheight, 10); n++;
	XtSetValues(Shell1, args, n);

	XtRealizeWidget(Shell1);

    CommonPause();
	/*
 	 * Initialize the PIInfo data values
  	 */
	for (i = 0; i < NUM_TESTS; i++)
		PIInfo[i].actual_return = False;

/*
    
/*
 * Create top level shell widget as parent for test1_btn1 widget
 */
	n = 0;
	XtSetArg(args[n], XtNallowShellResize, TRUE); n++;

	test_top = XtAppCreateShell("test_top",				/* application name */
		 						"Test_top",				/* application class */
		 						topLevelShellWidgetClass,	/* widget class */
		 						display,				/* display */
		 						args, n);				/* arguments */

/*
 * Create button1 widget
 */
	display = XtDisplay(test_top);
	screen = DefaultScreenOfDisplay(display);
	test1_btn1_icon = XCreatePixmapFromBitmapData(display, rootWindow,
								btn1_bits, btn1_width,
								btn1_height,
								CommonGetColor("red"),
								CommonGetColor("yellow"),
								DefaultDepth(display, DefaultScreen(display)));
	n = 0;
	XtSetArg(args[n], XmNlabelType, XmPIXMAP); n++;
	XtSetArg(args[n], XmNlabelPixmap, test1_btn1_icon); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	test1_btn1 = XmCreatePushButton(test_top, "test1_btn1", args, n);
	XtManageChild(test1_btn1);
	XtRealizeWidget(test_top);

	test_wdw = XtWindow(test_top);
	top_wdw = XtWindow(Shell1);
	button_wdw = XtWindow(test1_btn1);


	/*
	 * Move the test_top shell window and the Shell1 window
	 */
	XMoveWindow(display, test_wdw, 100, 100);
	/*
 	 * Change Normal Size Hints - position, size (WM_NORMAL_HINTS)
  	 */
	test_atom = XmInternAtom(display, "WM_NORMAL_HINTS", False);
	wm_set_size.flags = (PPosition | PSize);
	wm_set_size.x = wm_set_size.y = 250;
	wm_set_size.width = wm_set_size.height = 100;
	XChangeProperty(display, test_wdw, test_atom, XA_WM_SIZE_HINTS, 32, 
					PropModeReplace, (unsigned char *)&wm_set_size, 
					sizeof(XSizeHints)/sizeof(int));

	/*
 	 * Change Normal Hints - mins/maxs width/height
  	 */
	test_atom = XmInternAtom(display, "WM_NORMAL_HINTS", False);
	wm_set_size.flags = (PMinSize | PMaxSize);
	wm_set_size.min_width = wm_set_size.min_height = 200;
	wm_set_size.max_width = wm_set_size.max_height = 380;
	XChangeProperty(display, test_wdw, test_atom, XA_WM_SIZE_HINTS, 32, 
					PropModeReplace, (unsigned char *)&wm_set_size, 
					sizeof(XSizeHints)/sizeof(int));

	/*
     * Unmap and remap the window to change state
     */
	PIUnmapWindow(test_wdw);
    wm_set_hints.flags = (StateHint);
    wm_set_hints.initial_state = NormalState;
	XSetWMHints(display, test_wdw, &wm_set_hints);
	XMapWindow(display, test_wdw);
    XMoveWindow(display, test_wdw, 100, 100);

	test_atom = XmInternAtom(display, "WM_NORMAL_HINTS", False);
	XGetWindowProperty(display, test_wdw, test_atom, 0, 100, False, 
					   AnyPropertyType, &new_type, &new_format, 
					   &new_nitems, &new_bytes_after, 
					   (unsigned char **)(&wm_get_size));
	/*
 	 * Change Normal Size Hints - position, size (WM_NORMAL_HINTS)
  	 */
	PIInfo[PIInfo_cnt].actual_return = ((wm_get_size->x == wm_set_size.x) &&
								(wm_get_size->y == wm_set_size.y) &&
								(wm_get_size->width == wm_set_size.width) &&
								(wm_get_size->height == wm_set_size.height));

    PIInfo_cnt++;
	/*
 	 * Change Normal Hints - mins/maxs width/height
  	 */
	PIInfo[PIInfo_cnt].actual_return = 
		(
		(wm_get_size->min_width == wm_set_size.min_width) &&
        (wm_get_size->min_height == wm_set_size.min_height) &&
		(wm_get_size->max_width == wm_set_size.max_width) &&
		(wm_get_size->max_height == wm_set_size.max_height));
	PIInfo_cnt++;

	/*
 	 * Create another simple window to play with the XWMHints stuff
 	 */

	hints_wdw = XCreateSimpleWindow(display, DefaultRootWindow(display),
									100, 300, 150, 30, 5, 0,
									CommonGetColor("white"));
	XMapWindow(display, hints_wdw);
	XSync(display, False);
	XStoreName(display, hints_wdw, hints_winname);
	XSetIconName(display, hints_wdw, hints_winname);

	/*
 	 * Change WM Hints - icon pixmap for window            WM_HINTS
 	 */
	hints_icon_pm = XCreatePixmapFromBitmapData(display, rootWindow,
												PIIcon_bits, PIIcon_width,
												PIIcon_height, 1, 0, 1);
	hints_icon_msk_pm = XCreatePixmapFromBitmapData(display, rootWindow,
													PIIcon_msk_bits,
													PIIcon_msk_width,
													PIIcon_msk_height,
													1, 1, 1);

	/*
	 * Unmap the window to change state
	 */
	PIUnmapWindow(hints_wdw);

	test_atom = XmInternAtom(display, "WM_HINTS", False);
	wm_set_hints.flags = (StateHint | IconPixmapHint | IconMaskHint);
	wm_set_hints.initial_state = IconicState;
	wm_set_hints.icon_pixmap = hints_icon_pm;
	wm_set_hints.icon_mask = hints_icon_msk_pm;
	XChangeProperty(display, hints_wdw, test_atom, XA_WM_HINTS, 32, 
					PropModeReplace, (unsigned char *)&wm_set_hints, 
					sizeof(XWMHints)/sizeof(int));
	/* 
	 * Map the window into iconic state
	 */
	XMapWindow(display, hints_wdw);

	XGetWindowProperty(display, hints_wdw, test_atom, 0, 100, False, 
					   AnyPropertyType, &new_type, &new_format, 
					   &new_nitems, &new_bytes_after,
					   (unsigned char **)(&wm_get_hints));
	PIInfo[PIInfo_cnt].actual_return =
		(
		(wm_get_hints->icon_pixmap == wm_set_hints.icon_pixmap) &&
		(wm_get_hints->icon_mask == wm_set_hints.icon_mask));
	PIInfo_cnt++;

	CommonPause();

	/*
 	 * Change Normal Hints - width/height increments
 	 */
	test_atom = XmInternAtom(display, "WM_NORMAL_HINTS", False);
	wm_set_size.flags=(PResizeInc);
	wm_set_size.width_inc = wm_set_size.height_inc = 20;
	XChangeProperty(display, test_wdw, test_atom, XA_WM_SIZE_HINTS, 32,
					PropModeReplace, (unsigned char *)&wm_set_size, 
					sizeof(XSizeHints)/sizeof(int));

	/*
 	 * Change Normal Hints - min/max aspect ratios
 	 */
	test_atom = XmInternAtom(display, "WM_NORMAL_HINTS", False);
	wm_set_size.flags=(PAspect);
	wm_set_size.min_aspect.x = 2;
	wm_set_size.min_aspect.y = 1;
	wm_set_size.max_aspect.x = 4;
	wm_set_size.max_aspect.y = 1;
	XChangeProperty(display, test_wdw, test_atom, XA_WM_SIZE_HINTS, 32, 
					PropModeReplace, (unsigned char *)&wm_set_size, 
					sizeof(XSizeHints)/sizeof(int));

	/*
     * Unmap and remap the window to change state
     */
	PIUnmapWindow(test_wdw);

    wm_set_hints.flags = (StateHint);
    wm_set_hints.initial_state = NormalState;
	XSetWMHints(display, test_wdw, &wm_set_hints);
    XMapWindow(display, test_wdw);
    XMoveWindow(display, test_wdw, 100, 100);

	test_atom = XmInternAtom(display, "WM_NORMAL_HINTS", False);
	XGetWindowProperty(display, test_wdw, test_atom, 0, 100, False, 
					   AnyPropertyType, &new_type, &new_format, 
					   &new_nitems, &new_bytes_after,
					   (unsigned char **)(&wm_get_size));

	/*
 	 * Change Normal Hints - width/height increments
 	 */
	PIInfo[PIInfo_cnt].actual_return =
		(
		(wm_get_size->width_inc == wm_set_size.width_inc) &&
		(wm_get_size->height_inc == wm_set_size.height_inc));
	PIInfo_cnt++;

	/*
 	 * Change Normal Hints - min/max aspect ratios
 	 */
	PIInfo[PIInfo_cnt].actual_return =
		(
		(wm_get_size->min_aspect.x == wm_set_size.min_aspect.x) &&
		(wm_get_size->min_aspect.y == wm_set_size.min_aspect.y) &&
		(wm_get_size->max_aspect.x == wm_set_size.max_aspect.x) &&
		(wm_get_size->max_aspect.y == wm_set_size.max_aspect.y));
	PIInfo_cnt++;
	/* 
 	 * Change WM Hints - icon window for window            WM_HINTS
 	 */
	hints_icon_wdw = XCreateSimpleWindow(display, rootWindow, 0, 0, 50, 50,
										 5, 1, CommonGetColor("black"));

	/* 
	 * put window from IconicState to WithdrawnState
	 */
	PIUnmapWindow(hints_wdw);

	test_atom = XmInternAtom(display, "WM_HINTS", False);
	wm_set_hints.flags = (StateHint | IconWindowHint | IconPositionHint);
	wm_set_hints.initial_state = IconicState;
	wm_set_hints.icon_window = hints_icon_wdw;
	wm_set_hints.icon_x = wm_set_hints.icon_y = 20;
	XChangeProperty(display, hints_wdw, test_atom, XA_WM_HINTS, 32, 
					PropModeReplace, (unsigned char *)&wm_set_hints, 
					sizeof(XWMHints)/sizeof(int));
	/*
	 * revive from the WithdrawnState to IconicState
	 */
	XMapWindow(display, hints_wdw);

	XGetWindowProperty(display, hints_wdw, test_atom, 0, 100, False, 
					   AnyPropertyType, &new_type, &new_format, 
					   &new_nitems, &new_bytes_after,
					   (unsigned char **)(&wm_get_hints));
	PIInfo[PIInfo_cnt].actual_return =
		((wm_get_hints->icon_window == wm_set_hints.icon_window));
	PIInfo_cnt++;

#ifdef	DONT
	CommonPause();

	/* 
 	 * Change WM Hints - input focus for window            WM_HINTS
 	 */
	/* 
	 * put window from IconicState to WithdrawnState
	 */
	PIUnmapWindow(hints_wdw);

	test_atom = XmInternAtom(display, "WM_HINTS", False);
	wm_set_hints.flags = (StateHint | InputHint);
	wm_set_hints.initial_state = NormalState;
	wm_set_hints.input = True;
	XChangeProperty(display, hints_wdw, test_atom, XA_WM_HINTS, 32, 
					PropModeReplace, (unsigned char *)&wm_set_hints, 
					sizeof(XWMHints)/sizeof(int));
	/*
	 * revive from the WithdrawnState to NormalState
	 */
	XMapWindow(display, hints_wdw);
	XMoveWindow(display, hints_wdw, 100, 300);

	XGetWindowProperty(display, hints_wdw, test_atom, 0, 100, False, 
					   AnyPropertyType, &new_type, &new_format, 
					   &new_nitems, &new_bytes_after,
					   (unsigned char **)(&wm_get_hints));
	PIInfo[PIInfo_cnt].actual_return =
		((wm_get_hints->icon_window == wm_set_hints.icon_window));
	PIInfo_cnt++;

#endif	/* DONT */

	CommonPause();

    n = 0;
	XtSetArg(args[n], XmNx, 10); n++;
	XtSetArg(args[n], XmNy, 100); n++;
	XtSetArg(args[n], XmNwidth, 100); n++;
	XtSetArg(args[n], XmNheight, 100); n++;
	XtSetValues(Shell1, args, n);

	win_attrs.background_pixel = CommonGetColor("black");

	black_window = XCreateWindow(display, rootWindow, 200, 10, 100, 100, 1,
							   CopyFromParent, CopyFromParent, CopyFromParent,
							   CWBackPixel, &win_attrs);

	transient_for_window = top_wdw;

	XSetTransientForHint(display, black_window, transient_for_window);

	PIUnmapWindow(top_wdw);
	XMapWindow(display, top_wdw);

	XMapWindow(display, black_window);
	XStoreName(display, black_window, black_winname);
	if (XGetTransientForHint(display, black_window, &new_trans_for_window)
		== 0)
		fprintf(stderr, "XGetTransientForHint call 1 failed\n");

	PIInfo[PIInfo_cnt].actual_return =
		((new_trans_for_window == transient_for_window));
	PIInfo_cnt++;

	CommonPause();

	transient_for_window = test_wdw;

	XSetTransientForHint(display, black_window, transient_for_window);

	PIUnmapWindow(black_window);
	XMapWindow(display, black_window);

	if (XGetTransientForHint(display, black_window, &new_trans_for_window)
		== 0)
		fprintf(stderr, "XGetTransientForHint call 2 failed\n");
	PIInfo[PIInfo_cnt].actual_return =
		((new_trans_for_window == transient_for_window));
	PIInfo_cnt++;

	CommonPause();

	win_attrs.background_pixel = CommonGetColor("white");

	white_window = XCreateWindow(display, rootWindow, 200, 200, 100, 100, 1,
							   CopyFromParent, CopyFromParent, CopyFromParent,
							   CWBackPixel, &win_attrs);

	XMapWindow(display, white_window);
	XStoreName(display, white_window, white_winname);

	transient_for_window = black_window;

	XSetTransientForHint(display, white_window, transient_for_window);

	XMapWindow(display, white_window);
	if (XGetTransientForHint(display, white_window, &new_trans_for_window)
		== 0)
		fprintf(stderr, "XGetTransientForHint call 3 failed\n");

	PIInfo[PIInfo_cnt].actual_return =
		((new_trans_for_window == transient_for_window));
	PIInfo_cnt++;

	CommonPause();

/*
 * Put up a message box with the results of the test.
 */
	display_summary(NUM_TESTS, TEST_DESCRIP_LENGTH, PIInfo);

	CommonPause();

/*
 *  Loop and process events.
 */

	XtAppMainLoop(app_context);

}

