/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: MList1.c,v $ $Revision: 1.3.2.3 $ $Date: 1992/05/05 17:55:22 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */
#include <testlib.h>

#define NITEMS 6

char *Istrings[] = {
    "DrawnButton", 	"Label",
    "List",		"PushButton",
    "Separator",	"ArrowButton"
};

Widget List1;

/*  Private Functions  */

#ifdef _NO_PROTO
static void  HowMany();
#else /* _NO_PROTO */
static void HowMany(Widget w, XtPointer client_data,
		    XtPointer call_data);
#endif /* _NO_PROTO */

#ifdef _NO_PROTO
static void HowMany(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
#else /* _NO_PROTO */
static void HowMany(Widget w, XtPointer client_data,
		    XtPointer call_data)
#endif /* _NO_PROTO */
{
    short 		whichCallback;
    Arg 		args[2];
    int 		count, n;
    XmStringTable       my_items;

    n = 0;
    XtSetArg (args[n], XmNselectedItemCount, &count);		n++;
    XtSetArg (args[n], XmNselectedItems, &my_items);		n++;
    XtGetValues (w, args, n);

    whichCallback = (short) client_data;

    if (whichCallback) { 	/* default action */
   	printf ("Default Action callback, selectedItemCount is %d\n", count);
    }
    else 			/* selectionCallback */
   	printf ("Selection callback, selectedItemCount is %d\n", count);
}

void  main (argc, argv)
int argc;
char **argv;
{
    register int n;
    Arg args[MAX_ARGS];
    XmString ItemList[NITEMS], SelectionList[NITEMS];
	XrmDatabase        new_db, save_db;

    CommonTestInit(argc, argv);

    XrmInitialize();

    new_db = XrmGetFileDatabase("MList1DB");

#ifdef MOTIF1_1
    XrmMergeDatabases(new_db, &(display->db));
#else
    save_db = XtDatabase(display);
    XrmCombineDatabase(new_db, &save_db, True);
#endif

    for (n = 0; n < NITEMS; n++)
	ItemList[n] = XmStringLtoRCreate(Istrings[n],
			                 XmSTRING_DEFAULT_CHARSET);

    for (n = 0; n < NITEMS - 1; n++)
	SelectionList[n] = XmStringLtoRCreate(Istrings[n],
			              XmSTRING_DEFAULT_CHARSET);

    /* Create a List with no resources set. Control all resources
       in a separate resource file for this test */

    n = 0;
    List1 = XmCreateList(Shell1, "List1", args, n);
    XtManageChild(List1);

	n = 0;
	XtSetArg(args[n], XmNvisibleItemCount, 6); n++;
	XtSetValues(List1, args, n);

    XtRealizeWidget(Shell1);

    CommonPause();

    n = 0;
    XtSetArg(args[n], XmNitems, ItemList); 			n++;
    XtSetArg(args[n], XmNselectedItems, SelectionList); 	n++;
    XtSetArg(args[n], XmNselectedItemCount, NITEMS - 1); 	n++;
    XtSetArg(args[n], XmNitemCount, NITEMS); 			n++;
    XtSetArg(args[n], XmNvisibleItemCount, NITEMS);		n++;
    XtSetArg(args[n], XmNshadowThickness, 10);			n++;
    XtSetArg(args[n], XmNlistSpacing, 10); 			n++;
    XtSetArg(args[n], XmNlistMarginWidth, 20);			n++;
    XtSetArg(args[n], XmNlistMarginHeight, 20);			n++;
    XtSetArg(args[n], XmNselectionPolicy, XmMULTIPLE_SELECT);	n++;
    XtSetArg(args[n], XmNheight, 200);				n++;
    XtSetArg(args[n], XmNwidth, 200);				n++;
    XtSetValues(List1, args, n);

    /* Free up the strings */

    for (n = 0; n < NITEMS; n++)
	XmStringFree(ItemList[n]);

    for (n = 0; n < NITEMS - 1; n++)
	XmStringFree(SelectionList[n]); 

    XtAddCallback (List1, XmNmultipleSelectionCallback, HowMany, (XtPointer) 0);
    XtAddCallback (List1, XmNdefaultActionCallback, HowMany, (XtPointer) 1);

    CommonPause();

    XtAppMainLoop(app_context);
}
