/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Text9.c,v $ $Revision: 1.6.2.3 $ $Date: 1992/04/16 15:21:08 $"
#endif
#endif
#include <testlib.h>

Widget Manager1;
Widget Text1, Text2;
Widget veriTB1, veriTB2, doitTB1, doitTB2;
Widget cursScale1, cursScale2;
Widget topScale1, topScale2;
Widget showPosPB1, showPosPB2;
Widget fonttitle1, fonttitle2;
Widget baselabel1, baselabel2, basevalue1, basevalue2;
Widget lengthlabel1, lengthlabel2, lengthvalue1, lengthvalue2;
Widget separator;
Boolean	doit_flag1 = False, doit_flag2 = False;

typedef	struct	_FontWidgetPair
	{
	char*	font;
	Widget	w;
	}	FontWidgetPair;

char new_string2[] = "\
Jack Sprat could eat no fat\n\
His wife could eat no lean\n\
And so between them both\n\
They licked the platter  clean";


#ifdef _NO_PROTO
static void HelpCB(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void HelpCB(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{
	Arg args[MAX_ARGS];
	int n;
	
	Widget info_box = NULL;
	XmString helpString, titleString, okString;
	 
	helpString = XmStringCreateLtoR("Help has arrived!",
		XmSTRING_DEFAULT_CHARSET);
	titleString = XmStringCreateLtoR("Info box", XmSTRING_DEFAULT_CHARSET);
	okString = XmStringCreateLtoR("Dismiss", XmSTRING_DEFAULT_CHARSET);
	n=0;
	XtSetArg(args[n], XmNmessageString, helpString); n++;
	XtSetArg(args[n], XmNokLabelString, okString); n++;
	XtSetArg(args[n], XmNdialogTitle, titleString); n++;
	info_box = XmCreateInformationDialog(Shell1, "info_box", args, n);
	XtManageChild(info_box);
}

#ifdef _NO_PROTO
static void veriTBCB(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void veriTBCB(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{
	XmToggleButtonCallbackStruct *tb_calldata =
		(XmToggleButtonCallbackStruct *)call_data;
	Arg args[MAX_ARGS];
	int n;
	Boolean	curr_state;

	n = 0;
	XtSetArg(args[n], XmNverifyBell, tb_calldata->set); n++;
	XtSetValues((Widget)client_data, args, n);
}

#ifdef _NO_PROTO
static void doitTBCB(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void doitTBCB(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{
	XmToggleButtonCallbackStruct *tb_calldata =
		(XmToggleButtonCallbackStruct *)call_data;
	if (((Widget)client_data) == Text1)
		{
		doit_flag1 = tb_calldata->set;
		}
	else
		{
		doit_flag2 = tb_calldata->set;
		}
}

#ifdef _NO_PROTO
static void showPosCB(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void showPosCB(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{
	XmTextShowPosition((Widget)client_data,
		XmTextGetCursorPosition((Widget)client_data));
}

#ifdef _NO_PROTO
static void topScaleCB(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void topScaleCB(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{
	XmScaleCallbackStruct *scale_calldata =
		(XmScaleCallbackStruct *)call_data;
	XmTextSetTopCharacter((Widget)client_data, scale_calldata->value);
}

#ifdef _NO_PROTO
static void cursScaleCB(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void cursScaleCB(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{
	XmScaleCallbackStruct *scale_calldata =
		(XmScaleCallbackStruct *)call_data;
	XmTextSetCursorPosition((Widget)client_data, scale_calldata->value);
}


#ifdef _NO_PROTO
static void fontTBCB(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void fontTBCB(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{
	FontWidgetPair	*fwp_clientdata = (FontWidgetPair *)client_data;
	XmToggleButtonCallbackStruct *tb_calldata =
		(XmToggleButtonCallbackStruct *)call_data;
	Arg args[MAX_ARGS];
	int n;
	XmTextPosition	curr_pos;
	char	baseval[5];

	if (tb_calldata->set)
		{
		curr_pos = XmTextGetCursorPosition(fwp_clientdata->w);
		n = 0;
		XtSetArg(args[n], XmNfontList,
			CommonGetFontList(fwp_clientdata->font));  n++;
		XtSetValues(fwp_clientdata->w, args, n);
		XmTextSetCursorPosition(fwp_clientdata->w, curr_pos);

		sprintf(baseval, "%d", XmTextGetBaseLine(fwp_clientdata->w)); 
		XtSetArg(args[0], XmNlabelString,
			XmStringCreate(baseval, XmSTRING_DEFAULT_CHARSET));
		if (fwp_clientdata->w == Text1)
			{
			XtSetValues(basevalue1, args, 1);
			}
		else
			{
			XtSetValues(basevalue2, args, 1);
			}
		}
}

#ifdef _NO_PROTO
static void ModifyCB(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void ModifyCB(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{
Arg args[MAX_ARGS];
int n;
	char	lengthval[5];

	sprintf(lengthval, "%d", XmTextGetLastPosition((Widget)client_data)); 
	XtSetArg(args[0], XmNlabelString,
		XmStringCreate(lengthval, XmSTRING_DEFAULT_CHARSET));
	if (((Widget)client_data) == Text1)
		{
		XtSetValues(lengthvalue1, args, 1);
		}
	else
		{
		XtSetValues(lengthvalue2, args, 1);
		}
}

#ifdef _NO_PROTO
static void VerifyCB(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void VerifyCB(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{
	XmTextVerifyCallbackStruct *tv_calldata =
		(XmTextVerifyCallbackStruct *)call_data;
	if (((Widget)client_data) == Text1)
		{
		tv_calldata->doit = doit_flag1;
		}
	else
		{
		tv_calldata->doit = doit_flag2;
		}
}

#ifdef _NO_PROTO
static void SetTextSelectionArray(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void SetTextSelectionArray(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{
	static XmTextScanType selection_array[4];
	Arg args[MAX_ARGS];
	int n;

	selection_array[0] = XmSELECT_POSITION;

	switch ((int)client_data) {
	case 0:   selection_array[1] = XmSELECT_POSITION;
		break;
	case 1:   selection_array[1] = XmSELECT_WHITESPACE;
		break;
	case 2:   selection_array[1] = XmSELECT_WORD;
		break;
	case 3:   selection_array[1] = XmSELECT_LINE;
		break;
	case 4:   selection_array[1] = XmSELECT_ALL;
	break;
	case 5:   selection_array[1] = XmSELECT_PARAGRAPH;
		break;
	default:  printf("Error: no selection change made to text widgets!\n");
	return;
	}

	n = 0;
	XtSetArg(args[n], XmNselectionArray, selection_array); n++;
	XtSetArg(args[n], XmNselectionArrayCount, 2); n++;
	XtSetValues(Text1, args, n);
	XtSetValues(Text2, args, n);

	fflush(stdout);
}

#ifdef _NO_PROTO
static void ParseUserData(string, bug_flag1)
	char	*string;
	Boolean	*bug_flag1;
#else /* _NO_PROTO */
static void ParseUserData(char *string, Boolean *bug_flag1)
#endif /* _NO_PROTO */
{
	if (string == NULL)
	{
		*bug_flag1 = False;
	}
	else
	{
		*bug_flag1 = True;
	}
	return;
}

#define	BTN_COUNT	11
#define	TB_COUNT	3
#define	TEXT1_TOPCHAR	35
#define	TEXT2_TOPCHAR	30

#define	TEXT1_X		10
#define	TEXT1_Y		130
#define	TEXT2_X		245
#define	TEXT2_Y		130

main(argc, argv)
int argc;
char **argv;
{
	Arg args[MAX_ARGS];
	int n;
	Widget	SWin;
	Widget	Popup1Btn[BTN_COUNT], Popup1;
	Widget	fontTB1[TB_COUNT], fontTB2[TB_COUNT], fontRB1, fontRB2;
	Widget	selectionOption1;
	Widget	pd_menu, m_item[6];
	FontWidgetPair	FWP[6];
	char	baseval[5];
	char	lengthval[5];
	XmString	optionString;
	Boolean	show_pir3701 = False;
	int	i;

	/*  initialize toolkit  */
	CommonTestInit(argc, argv);
    
	ParseUserData(UserData, &show_pir3701);

	if (show_pir3701)
	{
	/* test case for PIR 3701 */
#ifndef	MOTIF1_2
		n = 0; /* have to give width/height before realize */
		XtSetArg(args[n], XmNwidth, 10); n++;
		XtSetArg(args[n], XmNheight, 10); n++;
		XtSetValues(Shell1, args, n);
#endif /* MOTIF1_2 */
		XtRealizeWidget(Shell1);
	/* end of test case for PIR 3701 */
	}

	/* create main bulletin board */
	n = 0;
	/* uncommenting causes cursScale[12] to not show in PIR 3701
	XtSetArg(args[n], XmNallowOverlap, False); n++;
	*/
	Manager1 = XmCreateBulletinBoard(Shell1, "Manager1", args, n);
	XtManageChild(Manager1);
		
	/* create scrolledtext widget */
	n = 0;
	XtSetArg(args[n], XmNbackground, CommonGetColor("goldenrod")); n++;
	XtSetArg(args[n], XmNtopCharacter, TEXT1_TOPCHAR); n++;
	XtSetArg(args[n], XmNrows, 4);  n++;
	XtSetArg(args[n], XmNwidth, 180); n++;
	XtSetArg(args[n], XmNscrollVertical, True);  n++;
	XtSetArg(args[n], XmNscrollHorizontal, True);  n++;
	XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNvalue, new_string2); n++;

	XtSetArg(args[n], XmNfontList, CommonGetFontList("8x13"));  n++;
	Text1 = XmCreateScrolledText(Manager1, "Text1", args, n);
	XtAddCallback(Text1, XmNmodifyVerifyCallback, VerifyCB,
				 (XtPointer) Text1);
	XtAddCallback(Text1, XmNvalueChangedCallback, ModifyCB,
				 (XtPointer) Text1);
	XtManageChild(Text1);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y); n++;
	XtSetArg(args[n], XmNset, True); n++;
	XtSetArg(args[n], XmNshadowThickness, 2); n++;
	XtSetArg(args[n], XmNlabelString, 
		XmStringCreate("verifyBell", XmSTRING_DEFAULT_CHARSET)); n++;
	veriTB1 = XmCreateToggleButton(Manager1, "veriTB1", args, n);
	XtAddCallback(veriTB1, XmNvalueChangedCallback, veriTBCB, Text1);
	XtManageChild(veriTB1);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 40); n++;
	XtSetArg(args[n], XmNset, False); n++;
	XtSetArg(args[n], XmNshadowThickness, 2); n++;
	XtSetArg(args[n], XmNlabelString,
		XmStringCreate("doit flag", XmSTRING_DEFAULT_CHARSET)); n++;
	doitTB1 = XmCreateToggleButton(Manager1, "doitTB1", args, n);
	XtAddCallback(doitTB1, XmNvalueChangedCallback, doitTBCB, 
		      (XtPointer) Text1);
	XtManageChild(doitTB1);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X + 110); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 20); n++;
	XtSetArg(args[n], XmNlabelString,
		XmStringCreate("text length", XmSTRING_DEFAULT_CHARSET)); n++;
	lengthlabel1 = XmCreateLabel(Manager1, "lengthlabel", args, n);
	XtManageChild(lengthlabel1);
	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X + 140); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 35); n++;
	sprintf(lengthval, "%d", XmTextGetLastPosition(Text1)); 
	XtSetArg(args[n], XmNlabelString,
		XmStringCreate(lengthval, XmSTRING_DEFAULT_CHARSET)); n++;
	lengthvalue1 = XmCreateLabel(Manager1, "lengthvalue", args, n);
	XtManageChild(lengthvalue1);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 85); n++;
	XtSetArg(args[n], XmNhighlightThickness, 2); n++;
	XtSetArg(args[n], XmNhighlightOnEnter, True); n++;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg(args[n], XmNscaleHeight, 20); n++;
	XtSetArg(args[n], XmNscaleWidth, 180); n++;
	XtSetArg(args[n], XmNvalue, XmTextGetTopCharacter(Text1)); n++;
	XtSetArg(args[n], XmNshowValue, True); n++;
	XtSetArg(args[n], XmNprocessingDirection, XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n], XmNtitleString,
		 XmStringCreate("top character", 
				XmSTRING_DEFAULT_CHARSET)); n++;
	topScale1 = XmCreateScale(Manager1, "topScale1", args, n);
	XtAddCallback(topScale1, XmNvalueChangedCallback, topScaleCB, 
		      (XtPointer) Text1);
	XtManageChild(topScale1);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 145); n++;
	XtSetArg(args[n], XmNshadowThickness, 2); n++;
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate("show position", 
				XmSTRING_DEFAULT_CHARSET)); n++;
	showPosPB1 = XmCreatePushButton(Manager1, "showPosPB1", args, n);
	XtAddCallback(showPosPB1, XmNactivateCallback, showPosCB, Text1);
	XtManageChild(showPosPB1);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 170); n++;
	XtSetArg(args[n], XmNhighlightThickness, 2); n++;
	XtSetArg(args[n], XmNhighlightOnEnter, True); n++;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg(args[n], XmNscaleHeight, 20); n++;
	XtSetArg(args[n], XmNscaleWidth, 180); n++;
	XtSetArg(args[n], XmNvalue, XmTextGetCursorPosition(Text1)); n++;
	XtSetArg(args[n], XmNshowValue, True); n++;
	XtSetArg(args[n], XmNprocessingDirection, XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n], XmNtitleString,
		 XmStringCreate("cursor position", 
				XmSTRING_DEFAULT_CHARSET)); n++;
	cursScale1 = XmCreateScale(Manager1, "cursScale1", args, n);
	XtAddCallback(cursScale1, XmNvalueChangedCallback, cursScaleCB, Text1);
	XtManageChild(cursScale1);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 235); n++;
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate("text font", XmSTRING_DEFAULT_CHARSET)); n++;
	fonttitle1 = XmCreateLabel(Manager1, "fonttitle", args, n);
	XtManageChild(fonttitle1);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 255); n++;
	XtSetArg(args[n], XmNborderWidth, 2); n++;
	XtSetArg(args[n], XmNisHomogeneous, False); n++;
	fontRB1 = XmCreateRadioBox(Manager1, "fontRB1", args, n);

	n = 0;
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate("6x12", XmSTRING_DEFAULT_CHARSET)); n++;
	fontTB1[0] = XmCreateToggleButtonGadget(fontRB1, "RB1_6x12", args, n);
	n = 0;
	XtSetArg(args[n], XmNset, True); n++;
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate("8x13", XmSTRING_DEFAULT_CHARSET)); n++;
	fontTB1[1] = XmCreateToggleButtonGadget(fontRB1, "RB1_8x13", args, n);
	n = 0;
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate("9x15", XmSTRING_DEFAULT_CHARSET)); n++;
	fontTB1[2] = XmCreateToggleButtonGadget(fontRB1, "RB1_9x15", args, n);

	FWP[0].font = "6x12"; FWP[0].w = Text1;
	XtAddCallback(fontTB1[0], XmNvalueChangedCallback, fontTBCB, &FWP[0]);
	FWP[1].font = "8x13"; FWP[1].w = Text1;
	XtAddCallback(fontTB1[1], XmNvalueChangedCallback, fontTBCB, &FWP[1]);
	FWP[2].font = "9x15"; FWP[2].w = Text1;
	XtAddCallback(fontTB1[2], XmNvalueChangedCallback, fontTBCB, &FWP[2]);

	XtManageChild(fontRB1);
	XtManageChildren(fontTB1, TB_COUNT);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X + 70); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 255); n++;
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate("text baseline",
				XmSTRING_DEFAULT_CHARSET)); n++;
	baselabel1 = XmCreateLabel(Manager1, "baselabel", args, n);
	XtManageChild(baselabel1);
	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X + 110); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 270); n++;
	sprintf(baseval, "%d", XmTextGetBaseLine(Text1)); 
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate(baseval, XmSTRING_DEFAULT_CHARSET)); n++;
	basevalue1 = XmCreateLabel(Manager1, "basevalue", args, n);
	XtManageChild(basevalue1);

	optionString = XmStringCreateSimple("Double click selects...");

/* test case for PIR 3635 - MenuShell created with BBoard parent 
   and no fontlist specified */
	pd_menu = XmCreatePulldownMenu(Manager1, "pd_menu", NULL, 0);

	m_item[0] = XmCreatePushButton(pd_menu, "Position", NULL, 0);
	m_item[1] = XmCreatePushButton(pd_menu, "Whitespace", NULL, 0);
	m_item[2] = XmCreatePushButton(pd_menu, "Word", NULL, 0);
	m_item[3] = XmCreatePushButton(pd_menu, "Line", NULL, 0);
	m_item[4] = XmCreatePushButton(pd_menu, "All", NULL, 0);
	m_item[5] = XmCreatePushButton(pd_menu, "Paragraph", NULL, 0);
	for (i = 0; i < XtNumber(m_item); i++)
	{
		XtAddCallback(m_item[i], XmNactivateCallback,
			SetTextSelectionArray, (XtPointer) i);
	}
	XtManageChildren(m_item, XtNumber(m_item));

	n = 0;
	XtSetArg(args[n], XmNsubMenuId, pd_menu); n++;
	XtSetArg(args[n], XmNmenuHistory, m_item[2]); n++;
	XtSetArg(args[n], XmNlabelString, optionString); n++;
	XtSetArg(args[n], XmNx, TEXT1_X + 50); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 400); n++;
	selectionOption1 = XmCreateOptionMenu(Manager1, "selectionOption1",
		args, n);
	XtManageChild(selectionOption1);
/* end of test case for PIR 3635 */

	XmStringFree(optionString);

/*-------------------------*/
	n = 0;
	XtSetArg(args[n], XmNx,	230); n++;
	XtSetArg(args[n], XmNheight, 470); n++;
	XtSetArg(args[n], XmNshadowThickness, 4); n++;
	XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
	separator = XmCreateSeparator(Manager1, "separator", args, n);
	XtManageChild(separator);
/*-------------------------*/


	/* create single line text widget */
	n = 0;
	XtSetArg(args[n], XmNbackground, CommonGetColor("seagreen")); n++;
	XtSetArg(args[n], XmNx, 245); n++;
	XtSetArg(args[n], XmNverifyBell, False); n++;
	XtSetArg(args[n], XmNvalue, new_string2); n++;
	XtSetArg(args[n], XmNfontList, CommonGetFontList("8x13"));  n++;
	Text2 = XmCreateText(Manager1, "Text2", args, n);
	XtAddCallback(Text2, XmNmodifyVerifyCallback, (XtCallbackProc)VerifyCB,
				 Text2);
	XtAddCallback(Text2, XmNvalueChangedCallback, (XtCallbackProc)ModifyCB,
				 Text2);
	XtManageChild(Text2);

	XmTextSetTopCharacter(Text2, (XmTextPosition)TEXT2_TOPCHAR);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT2_X); n++;
	XtSetArg(args[n], XmNy, TEXT2_Y); n++;
	XtSetArg(args[n], XmNset, False); n++;
	XtSetArg(args[n], XmNshadowThickness, 2); n++;
	XtSetArg(args[n], XmNlabelString, 
		XmStringCreate("verifyBell", XmSTRING_DEFAULT_CHARSET)); n++;
	veriTB2 = XmCreateToggleButton(Manager1, "veriTB2", args, n);
	XtAddCallback(veriTB2, XmNvalueChangedCallback, veriTBCB, Text2);
	XtManageChild(veriTB2);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT2_X); n++;
	XtSetArg(args[n], XmNy, TEXT2_Y + 40); n++;
	XtSetArg(args[n], XmNset, False); n++;
	XtSetArg(args[n], XmNshadowThickness, 2); n++;
	XtSetArg(args[n], XmNlabelString,
		XmStringCreate("doit flag", XmSTRING_DEFAULT_CHARSET)); n++;
	doitTB2 = XmCreateToggleButton(Manager1, "doitTB2", args, n);
	XtAddCallback(doitTB2, XmNvalueChangedCallback, doitTBCB, Text2);
	XtManageChild(doitTB2);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT2_X + 110); n++;
	XtSetArg(args[n], XmNy, TEXT2_Y + 20); n++;
	XtSetArg(args[n], XmNlabelString,
		XmStringCreate("text length", XmSTRING_DEFAULT_CHARSET)); n++;
	lengthlabel2 = XmCreateLabel(Manager1, "lengthlabel", args, n);
	XtManageChild(lengthlabel2);
	n = 0;
	XtSetArg(args[n], XmNx, TEXT2_X + 140); n++;
	XtSetArg(args[n], XmNy, TEXT2_Y + 35); n++;
	sprintf(lengthval, "%d", XmTextGetLastPosition(Text2)); 
	XtSetArg(args[n], XmNlabelString,
		XmStringCreate(lengthval, XmSTRING_DEFAULT_CHARSET)); n++;
	lengthvalue2 = XmCreateLabel(Manager1, "lengthvalue", args, n);
	XtManageChild(lengthvalue2);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT2_X); n++;
	XtSetArg(args[n], XmNy, TEXT2_Y + 85); n++;
	XtSetArg(args[n], XmNhighlightThickness, 2); n++;
	XtSetArg(args[n], XmNhighlightOnEnter, True); n++;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg(args[n], XmNscaleHeight, 20); n++;
	XtSetArg(args[n], XmNscaleWidth, 180); n++;
	XtSetArg(args[n], XmNvalue, XmTextGetTopCharacter(Text2)); n++;
	XtSetArg(args[n], XmNshowValue, True); n++;
	XtSetArg(args[n], XmNprocessingDirection, XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n], XmNtitleString,
		 XmStringCreate("top character", 
				XmSTRING_DEFAULT_CHARSET)); n++;
	topScale2 = XmCreateScale(Manager1, "topScale2", args, n);
	XtAddCallback(topScale2, XmNvalueChangedCallback, topScaleCB, Text2);
	XtManageChild(topScale2);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT2_X); n++;
	XtSetArg(args[n], XmNy, TEXT2_Y + 145); n++;
	XtSetArg(args[n], XmNshadowThickness, 2); n++;
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate("show position", 
				XmSTRING_DEFAULT_CHARSET)); n++;
	showPosPB2 = XmCreatePushButton(Manager1, "showPosPB2", args, n);
	XtAddCallback(showPosPB2, XmNactivateCallback, showPosCB, Text2);
	XtManageChild(showPosPB2);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT2_X); n++;
	XtSetArg(args[n], XmNy, TEXT2_Y + 170); n++;
	XtSetArg(args[n], XmNhighlightThickness, 2); n++;
	XtSetArg(args[n], XmNhighlightOnEnter, True); n++;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg(args[n], XmNscaleHeight, 20); n++;
	XtSetArg(args[n], XmNscaleWidth, 180); n++;
	XtSetArg(args[n], XmNvalue, XmTextGetCursorPosition(Text2)); n++;
	XtSetArg(args[n], XmNshowValue, True); n++;
	XtSetArg(args[n], XmNprocessingDirection, XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n], XmNtitleString,
		 XmStringCreate("cursor position", 
				XmSTRING_DEFAULT_CHARSET)); n++;
	cursScale2 = XmCreateScale(Manager1, "cursScale2", args, n);
	XtAddCallback(cursScale2, XmNvalueChangedCallback, cursScaleCB, Text2);
	XtManageChild(cursScale2);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT2_X); n++;
	XtSetArg(args[n], XmNy, TEXT2_Y + 235); n++;
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate("text font", XmSTRING_DEFAULT_CHARSET)); n++;
	fonttitle2 = XmCreateLabel(Manager1, "fonttitle", args, n);
	XtManageChild(fonttitle2);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT2_X); n++;
	XtSetArg(args[n], XmNy, TEXT2_Y + 255); n++;
	XtSetArg(args[n], XmNborderWidth, 2); n++;
	XtSetArg(args[n], XmNisHomogeneous, False); n++;
	fontRB2 = XmCreateRadioBox(Manager1, "fontRB2", args, n);

	n = 0;
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate("6x12", XmSTRING_DEFAULT_CHARSET)); n++;
	fontTB2[0] = XmCreateToggleButtonGadget(fontRB2, "RB2_6x12", args, n);
	n = 0;
	XtSetArg(args[n], XmNset, True); n++;
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate("8x13", XmSTRING_DEFAULT_CHARSET)); n++;
	fontTB2[1] = XmCreateToggleButtonGadget(fontRB2, "RB2_8x13", args, n);
	n = 0;
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate("9x15", XmSTRING_DEFAULT_CHARSET)); n++;
	fontTB2[2] = XmCreateToggleButtonGadget(fontRB2, "RB2_9x15", args, n);

	FWP[3].font = "6x12"; FWP[3].w = Text2;
	XtAddCallback(fontTB2[0], XmNvalueChangedCallback, fontTBCB, &FWP[3]);
	FWP[4].font = "8x13"; FWP[4].w = Text2;
	XtAddCallback(fontTB2[1], XmNvalueChangedCallback, fontTBCB, &FWP[4]);
	FWP[5].font = "9x15"; FWP[5].w = Text2;
	XtAddCallback(fontTB2[2], XmNvalueChangedCallback, fontTBCB, &FWP[5]);

	XtManageChild(fontRB2);
	XtManageChildren(fontTB2, TB_COUNT);

	n = 0;
	XtSetArg(args[n], XmNx, TEXT2_X + 70); n++;
	XtSetArg(args[n], XmNy, TEXT2_Y + 255); n++;
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate("text baseline", 
				XmSTRING_DEFAULT_CHARSET)); n++;
	baselabel2 = XmCreateLabel(Manager1, "baselabel", args, n);
	XtManageChild(baselabel2);
	n = 0;
	XtSetArg(args[n], XmNx, TEXT2_X + 110); n++;
	XtSetArg(args[n], XmNy, TEXT2_Y + 270); n++;
	sprintf(baseval, "%d", XmTextGetBaseLine(Text2)); 
	XtSetArg(args[n], XmNlabelString,
		 XmStringCreate(baseval, XmSTRING_DEFAULT_CHARSET)); n++;
	basevalue2 = XmCreateLabel(Manager1, "basevalue", args, n);
	XtManageChild(basevalue2);

	XtRealizeWidget(Shell1);
	CommonPause();

	CommonPause();

	CommonPause();

	CommonPause();

	CommonPause();

	CommonPause();

	CommonPause();

	CommonPause();

	XtAppMainLoop(app_context);
}
