/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Text8.c,v $ $Revision: 1.6.2.3 $ $Date: 1992/04/16 15:21:04 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */

#include <testlib.h>

Widget BBoard1 = NULL;
Widget Form1 = NULL;
Widget help_dialog = NULL;
Arg args[MAX_ARGS];

static char  *stat_msg[] = 
{
  "This is generic help for the application,\nor the widget you've selected has no help",
  "This is help for the Default Button.\nPress to make things happen",
  "This is help for the text. Type.",
  "This is help for the Other Button."
};

#ifdef _NO_PROTO
static void GenericHelp(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void GenericHelp(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{	/*
	1 = bulletinBoard or a widget with no help 
	2 = Default button
	3 = Text1 (the single line text)
	4 = OtherButton
	*/
	XmString message;
	int n;

	message = XmStringLtoRCreate(stat_msg[((int)client_data) - 1],
				XmSTRING_DEFAULT_CHARSET);

	n = 0;
	XtSetArg(args[n], XmNmessageString, message); n++;
	XtSetValues(help_dialog, args, n);

	XtManageChild(help_dialog);
}                                            
	           

#ifdef _NO_PROTO
static void MyReturnRoutine(w, event, params, num_params)
	Widget w;
	XEvent *event;
	String *params;
	Cardinal *num_params;
#else /* _NO_PROTO */
static void MyReturnRoutine(Widget w, XEvent *event,
				String *params, Cardinal *num_params)
#endif /* _NO_PROTO */
{
	printf("The return key has been remapped to this routine.\n");
}

#ifdef _NO_PROTO
static void DblClickRoutine(w, event, params, num_params)
	Widget w;
	XEvent *event;
	String *params;
	Cardinal *num_params;
#else /* _NO_PROTO */
static void DblClickRoutine(Widget w, XEvent *event,
				String *params, Cardinal *num_params)
#endif /* _NO_PROTO */
{
	printf("The user has double-clicked.\n");
}


#ifdef _NO_PROTO
static void ActivationDB(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void ActivationDB(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{
	printf("The Default Button Activate callback was made.\n");
}

#ifdef _NO_PROTO
static void setInsensitive(w, client_data, call_data)
        Widget  w;
        XtPointer       client_data;
        XtPointer       call_data;
#else /* _NO_PROTO */
static void setInsensitive(Widget w, XtPointer client_data,
                                XtPointer call_data)
#endif /* _NO_PROTO */
{
	XtSetArg(args[0], XmNsensitive, False);
	XtSetValues(w, args, 1);
}

#ifdef	_NO_PROTO
Widget CreateTheBBoard();
Widget CreateTheForm();
Widget CreateSingleLineText();
Widget CreateOtherButton();
Widget CreateTheDefaultButton();
Widget CreateMultiLineText();
Widget CreateTextField();
Widget CreateToggleButton();
Widget CreateScrollBar();
#else	/* _NO_PROTO */
Widget CreateTheBBoard(Widget parent, Boolean dialog);
Widget CreateTheForm(Widget parent);
Widget CreateSingleLineText(Widget parent);
Widget CreateOtherButton(Widget parent);
Widget CreateTheDefaultButton(Widget parent);
Widget CreateMultiLineText(Widget parent);
Widget CreateTextField(Widget parent);
Widget CreateToggleButton(Widget parent);
Widget CreateScrollBar(Widget parent);
#endif	/* _NO_PROTO */

void main(argc, argv)
int argc;
char **argv;
{
	Widget Text1 = NULL;        /* single line text widget */
	Widget Text2 = NULL;        /* multi-line text widget */
	Widget TextF = NULL;        /* Text field widget */
	Widget DefaultB = NULL;
	Widget ToggleB = NULL;
	Widget OtherB = NULL;
	Widget ScrollB = NULL;
	int n = 0;

	/* the translation for BtnUp(2+) shows PIR 3113 */
	static XtActionsRec actions[] = {{ "MyReturnRoutine", MyReturnRoutine},
				    { "DblClickRoutine", DblClickRoutine}};
	static char translation_table[] = "<Key>Return: MyReturnRoutine()\n\
	                                   <Btn1Up>(2+): DblClickRoutine()";

	/*  initialize toolkit  */
	CommonTestInit(argc, argv);

	help_dialog = XmCreateMessageDialog(Shell1, "help_dialog", args, n);

	XtAppAddActions(app_context, actions, 2);

/* Test 1: Bulletin Board with default button. */

	BBoard1 = CreateTheBBoard(Shell1, False);

	DefaultB = CreateTheDefaultButton(BBoard1);
	n = 0;
	XtSetArg(args[n], XmNdefaultButton, DefaultB); n++;
	XtSetValues(BBoard1, args, n);

	Text1 = CreateSingleLineText(BBoard1);

	Text2 = CreateMultiLineText(BBoard1);

	TextF = CreateTextField(BBoard1);

	OtherB = CreateOtherButton(BBoard1);

	ToggleB = CreateToggleButton(BBoard1);

	ScrollB = CreateScrollBar(BBoard1);

	XtManageChild(BBoard1);
	XtManageChild(Text1);
	XtManageChild(Text2);
	XtManageChild(TextF);
	XtManageChild(DefaultB);
	XtManageChild(ToggleB);
	XtManageChild(OtherB);
	XtManageChild(ScrollB);
	XtRealizeWidget(Shell1);


	CommonPause();      /* #1: activate callback tests */
	CommonPause();      /* #2: ditto */
	CommonPause();      /* #3: more */
	CommonPause();      /* #4: help */

	XtOverrideTranslations(Text2,
		XtParseTranslationTable(translation_table));

	CommonPause();      /* #5: reset translations on text */

	XtRemoveCallback(OtherB, XmNactivateCallback, CommonGenericCB, NULL);
	XtAddCallback(OtherB, XmNactivateCallback, setInsensitive, NULL);

	XtRemoveCallback(DefaultB, XmNactivateCallback, CommonGenericCB, NULL);
	XtAddCallback(DefaultB, XmNactivateCallback, setInsensitive, NULL);

	CommonPause();     /* #6: button insensitivity */

	XtDestroyWidget(BBoard1);



/* Test 2: Bulletin Board Dialog with default button. */

	/* make Shell smaller, just for convenience */
	n = 0;
	XtSetArg(args[n], XmNheight, 50); n++;
	XtSetArg(args[n], XmNwidth, 50); n++;
	XtSetValues(Shell1, args, n);

	BBoard1 = CreateTheBBoard(Shell1, True);

	DefaultB = CreateTheDefaultButton(BBoard1);
	n = 0;
	XtSetArg(args[n], XmNdefaultButton, DefaultB); n++;
	XtSetValues(BBoard1, args, n);

	Text1 = CreateSingleLineText(BBoard1);

	Text2 = CreateMultiLineText(BBoard1);

	TextF = CreateTextField(BBoard1);

	OtherB = CreateOtherButton(BBoard1);

	ToggleB = CreateToggleButton(BBoard1);

	ScrollB = CreateScrollBar(BBoard1);

	XtManageChild(BBoard1);
	XtManageChild(Text1);
	XtManageChild(Text2);
	XtManageChild(TextF);
	XtManageChild(DefaultB);
	XtManageChild(ToggleB);
	XtManageChild(OtherB);
	XtManageChild(ScrollB);
	XtRealizeWidget(Shell1);

	CommonPause();   /* #7: check again */
	CommonPause();   /* #8: help */

	XtOverrideTranslations(Text2,
		XtParseTranslationTable(translation_table));

	CommonPause();   /* #9: override text translations */

	XtRemoveCallback(OtherB, XmNactivateCallback, CommonGenericCB, NULL);
	XtAddCallback(OtherB, XmNactivateCallback, setInsensitive, NULL);

	XtRemoveCallback(DefaultB, XmNactivateCallback, CommonGenericCB, NULL);
	XtAddCallback(DefaultB, XmNactivateCallback, setInsensitive, NULL);

	CommonPause();  /* #10: insensitive buttons */



/* Test 3: Form with with default button. */

	XtDestroyWidget(BBoard1);

	n = 0;

	Form1 = CreateTheForm(Shell1);

	DefaultB = CreateTheDefaultButton(Form1);
	n = 0;
	XtSetArg(args[n], XmNdefaultButton, DefaultB); n++;
	XtSetValues(Form1, args, n);

	Text1 = CreateSingleLineText(Form1);

	Text2 = CreateMultiLineText(Form1);

	TextF = CreateTextField(Form1);
	
	OtherB =  CreateOtherButton(Form1);

	ToggleB = CreateToggleButton(Form1);

	ScrollB = CreateScrollBar(Form1);

	XtManageChild(Form1);
	XtManageChild(Text1);
	XtManageChild(Text2);
	XtManageChild(TextF);
	XtManageChild(DefaultB);
	XtManageChild(ToggleB);
	XtManageChild(OtherB);
	XtManageChild(ScrollB);
	XtRealizeWidget(Shell1);
  
	CommonPause();  /* form */  /* number #11 */

	XtAppMainLoop(app_context);
}


#ifdef _NO_PROTO
Widget CreateTheBBoard(parent, dialog)
	Widget parent;
	Boolean dialog;
#else /* _NO_PROTO */
Widget CreateTheBBoard(Widget parent, Boolean dialog)
#endif /* _NO_PROTO */
{
	int n;
	Widget widget;

	n = 0;
#ifdef	MOTIF1_1
	XtSetArg(args[n], XmNwidth, 400); n++;
	XtSetArg(args[n], XmNheight, 400); n++;
#endif	/* MOTIF1_1 */
	/* test for PIR 2657 */
	XtSetArg(args[n], XmNtextFontList,
		CommonGetFontList("variable")); n++;
	if (dialog)
	{
		XtSetArg(args[n], XmNautoUnmanage, False); n++;
		XtSetArg(args[n], XmNdialogStyle, XmDIALOG_MODELESS); n++;
		widget = XmCreateBulletinBoardDialog(parent,
			"BBoard1", args, n);
	}
	else
	{
		widget = XmCreateBulletinBoard(parent, "BBoard1", args, n);
	}
	XtAddCallback(widget, XmNhelpCallback, GenericHelp, (XtPointer)1);
	return(widget);
}

#ifdef _NO_PROTO
Widget CreateTheForm(parent)
	Widget parent;
#else /* _NO_PROTO */
Widget CreateTheForm(Widget parent)
#endif /* _NO_PROTO */
{
	int n;
	Widget widget;
	
	n = 0;
#ifdef	MOTIF1_1
	XtSetArg(args[n], XmNwidth, 400); n++;
	XtSetArg(args[n], XmNheight, 400); n++;
#endif	/* MOTIF1_1 */
	/* test for PIR 2657 */
	XtSetArg(args[n], XmNtextFontList,
		CommonGetFontList("variable")); n++;
	widget = XmCreateForm(parent, "Form1", args, n);
	XtAddCallback(widget, XmNhelpCallback, GenericHelp, (XtPointer)1);
	return(widget);
}

#ifdef _NO_PROTO
Widget CreateSingleLineText(parent)
	Widget parent;
#else /* _NO_PROTO */
Widget CreateSingleLineText(Widget parent)
#endif /* _NO_PROTO */
{
	int n;
	Widget widget;

	n = 0;
	XtSetArg(args[n], XmNfontList, CommonGetFontList("fixed"));  n++;
	XtSetArg(args[n], XmNresizeWidth, False);  n++;
	XtSetArg(args[n], XmNresizeHeight, False);  n++;
	XtSetArg(args[n], XmNcolumns, 40);  n++;
	XtSetArg(args[n], XmNrows, 1);  n++;
	XtSetArg(args[n], XmNeditMode, XmSINGLE_LINE_EDIT); n++;
	XtSetArg(args[n], XmNforeground, CommonGetColor("Red"));  n++;
	XtSetArg(args[n], XmNbackground, CommonGetColor("White"));  n++;
	XtSetArg(args[n], XmNx, 10); n++;
	XtSetArg(args[n], XmNy, 10); n++;
	XtSetArg(args[n], XmNtraversalOn, True); n++;
	widget = XmCreateText(parent, "Text1", args, n);
	XtAddCallback(widget, XmNactivateCallback,
		(XtCallbackProc) CommonGenericCB, NULL);
	XtAddCallback(widget, XmNhelpCallback, GenericHelp, (XtPointer)3);

	/* test case for PIR 684: cannot set XmNvalue and XmNcursorPosition */
	/* simultaneosly at SetValues time or cursorPosition is ignored. */

	n = 0;
	XtSetArg(args[n], XmNvalue, "Single Line Text Widget");  n++;
	XtSetArg(args[n], XmNcursorPosition, 5);  n++;
	XtSetValues(widget, args, n);
	/* end of test case for PIR 684 */

	return(widget);
}

#ifdef _NO_PROTO
Widget CreateOtherButton(parent)
	Widget parent;
#else /* _NO_PROTO */
Widget CreateOtherButton(Widget parent)
#endif /* _NO_PROTO */
{
	int n;
	Widget OtherB;

	n = 0;
	XtSetArg(args[n], XmNx, 375); n++;
	XtSetArg(args[n], XmNy, 330); n++;
	XtSetArg(args[n], XmNlabelString, 
		XmStringLtoRCreate("Other Button",
		XmSTRING_DEFAULT_CHARSET)); n++;
	OtherB = XmCreatePushButtonGadget(parent, "OtherB", args, n);
	XtAddCallback(OtherB, XmNactivateCallback, CommonGenericCB, NULL);
	XtAddCallback(OtherB, XmNhelpCallback, GenericHelp, (XtPointer)4);
	return(OtherB);
}

#ifdef _NO_PROTO
Widget CreateTheDefaultButton(parent)
	Widget parent;
#else /* _NO_PROTO */
Widget CreateTheDefaultButton(Widget parent)
#endif /* _NO_PROTO */
{
	int n;
	Widget DefaultB;

	n = 0;
	XtSetArg(args[n], XmNlabelString,
		XmStringLtoRCreate("Default Button",
		XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n], XmNx, 375); n++;
	XtSetArg(args[n], XmNy, 375); n++;
	XtSetArg(args[n], XmNtraversalOn, True); n++;
	XtSetArg(args[n], XmNdefaultButtonShadowThickness, 2); n++;
	DefaultB = XmCreatePushButtonGadget(parent, "DefaultB", args, n);
	XtAddCallback(DefaultB, XmNactivateCallback, ActivationDB, NULL);
	XtAddCallback(DefaultB, XmNhelpCallback, GenericHelp, (XtPointer)2);
	return(DefaultB);
}

#ifdef _NO_PROTO
Widget CreateMultiLineText(parent)
	Widget parent;
#else /* _NO_PROTO */
Widget CreateMultiLineText(Widget parent)
#endif /* _NO_PROTO */
{
	int n;
	Widget Text2;

	n = 0;
	XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNrows, 4); n++;
	/* test case for PIR 2657
	XtSetArg(args[n], XmNfontList, CommonGetFontList("variable"));  n++;
	*/
	XtSetArg(args[n], XmNcolumns, 20);  n++;
	XtSetArg(args[n], XmNcursorPosition, 1);  n++;
	XtSetArg(args[n], XmNvalue, "Multi Line Text Widget");  n++;
	XtSetArg(args[n], XmNforeground, CommonGetColor("Red"));  n++;
	XtSetArg(args[n], XmNbackground, CommonGetColor("White"));  n++;
	XtSetArg(args[n], XmNx, 10); n++;
	XtSetArg(args[n], XmNy, 150); n++;
	XtSetArg(args[n], XmNtraversalOn, True); n++;
	Text2 = XmCreateText(parent, "Text2", args, n);
	XtAddCallback(Text2, XmNactivateCallback, CommonGenericCB, NULL);
	return(Text2);
}

#ifdef _NO_PROTO
Widget CreateTextField(parent)
	Widget parent;
#else /* _NO_PROTO */
Widget CreateTextField(Widget parent)
#endif /* _NO_PROTO */
{
	int n;
	Widget TextF;

	n = 0;
	XtSetArg(args[n], XmNfontList, CommonGetFontList("fixed"));  n++;
	XtSetArg(args[n], XmNresizeWidth, False);  n++;
	XtSetArg(args[n], XmNcolumns, 40);  n++;
	XtSetArg(args[n], XmNcursorPosition, 5);  n++;
	XtSetArg(args[n], XmNvalue, "Text Field Widget");  n++;
	XtSetArg(args[n], XmNforeground, CommonGetColor("Red"));  n++;
	XtSetArg(args[n], XmNbackground, CommonGetColor("White"));  n++;
	XtSetArg(args[n], XmNx, 10); n++;
	XtSetArg(args[n], XmNy, 300); n++; 
	TextF = XmCreateTextField(parent, "TextF", args, n);
	XtAddCallback(TextF, XmNactivateCallback, CommonGenericCB, NULL);
	return(TextF);
}

#ifdef _NO_PROTO
Widget CreateToggleButton(parent)
	Widget parent;
#else /* _NO_PROTO */
Widget CreateToggleButton(Widget parent)
#endif /* _NO_PROTO */
{
	int n;
	Widget ToggleB;

	n = 0;
	XtSetArg(args[n], XmNx, 375); n++;
	XtSetArg(args[n], XmNy, 300); n++;
	XtSetArg(args[n], XmNtraversalOn, True); n++;
	ToggleB = XmCreateToggleButton(parent, "Toggle Button", args, n);
	XtAddCallback(ToggleB, XmNvalueChangedCallback, CommonGenericCB, NULL);
	return(ToggleB);
}

#ifdef _NO_PROTO
Widget CreateScrollBar(parent)
	Widget parent;
#else /* _NO_PROTO */
Widget CreateScrollBar(Widget parent)
#endif /* _NO_PROTO */
{
	int n;
	Widget ScrollB;

	n = 0;
	XtSetArg(args[n], XmNx, 300); n++;
	XtSetArg(args[n], XmNy, 150); n++;
	XtSetArg(args[n], XmNtraversalOn, True); n++;
	XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
	XtSetArg(args[n], XmNhighlightOnEnter, True); n++;
	XtSetArg(args[n], XmNhighlightThickness, 2); n++;
	ScrollB = XmCreateScrollBar (parent, "ScrollB", args, n);   
	return(ScrollB);
}
