/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Scale10.c,v $ $Revision: 1.4.2.2 $ $Date: 1992/04/03 15:42:13 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */
/* 
	The problems: (Pirs 865, 902)

	* setting scaleHeight of horizontal widget shrinks
	  width down to 100; 

	* setting scaleWidth of vertical widget shrinks
	  height down to 100; 
*/


/* Scale set value test */

#include <testlib.h>

Arg args[MAX_ARGS];
int n;

void set_scale_height (w, sw, call_data) 
Widget	w;		/*  widget id		*/
XtPointer sw;           /*  scale widget client data */
XtPointer call_data;	/*  data from widget class  */
{
   n = 0;
   XtSetArg(args[n], XmNscaleHeight, 50);  n++;
   XtSetValues((Widget) sw, args, n);
}


void set_scale_width (w, sw, call_data) 
Widget	w;		/*  widget id		*/
XtPointer sw;           /*  scale widget client data */
XtPointer call_data;	/*  data from widget class  */
{
   n = 0;
   XtSetArg(args[n], XmNscaleWidth, 50);  n++;
   XtSetValues((Widget) sw, args, n);
}

static XtCallbackProc valueChangedProc (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	XmScaleCallbackStruct *eventStruct;
	static int oldValue = 0;
	int newValue;

	eventStruct = (XmScaleCallbackStruct *) call_data;
	newValue = eventStruct->value;
	printf ("Old value was %d, new value is %d\n", oldValue, newValue);
	oldValue = newValue;
	fflush (stdout);
}


void main (argc, argv)
int argc;
char **argv;
{
   Widget bb, scale1, scale2;
   Widget pb1, pb2, pb3, pb4;
   Display *display;


   CommonTestInit(argc, argv);
    

   n=0;
   XtSetArg(args[n], XmNwidth, 455);  n++;
   XtSetArg(args[n], XmNheight, 490);  n++;
   bb = XmCreateBulletinBoard(Shell1, "bb", args, n);
   XtManageChild(bb);

   n = 0;
   XtSetArg(args[n], XmNwidth, 375);  n++;
   XtSetArg(args[n], XmNheight, 75);  n++;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL);  n++;
   XtSetArg(args[n], XmNshowValue, True);  n++;
   XtSetArg(args[n], XmNvalue, 44);  n++;
   XtSetArg(args[n], XmNscaleWidth, 375);  n++;
   XtSetArg(args[n], XmNscaleHeight, 30);  n++;
   scale1 = XmCreateScale(bb, "scale1", args, n);
   XtManageChild(scale1);

   XtAddCallback(scale1, XmNvalueChangedCallback, 
		 (XtCallbackProc) valueChangedProc, NULL);

   n = 0;
   XtSetArg(args[n], XmNy, 100); n++;
   XtSetArg(args[n], XmNwidth, 75);  n++;;
   XtSetArg(args[n], XmNheight, 375);  n++;;
   XtSetArg(args[n], XmNorientation, XmVERTICAL);  n++;;
   XtSetArg(args[n], XmNshowValue, True); n++;
   XtSetArg(args[n], XmNvalue, 66); n++;
   XtSetArg(args[n], XmNscaleWidth, 30);  n++;;
   XtSetArg(args[n], XmNscaleHeight, 375);  n++;;
   scale2 = XmCreateScale(bb, "scale2", args, n);
   XtManageChild(scale2);

   n = 0;
   XtSetArg(args[n], XmNx, 100);  n++;;
   XtSetArg(args[n], XmNy, 100);  n++;;
   pb1 = XmCreatePushButton(bb, "Horiz scaleHeight to 50", args, n);
   XtManageChild(pb1);
   XtAddCallback(pb1, XmNactivateCallback,
	set_scale_height, (XtPointer)scale1);

   n = 0;
   XtSetArg(args[n], XmNx, 100);  n++;;
   XtSetArg(args[n], XmNy, 130);  n++;;
   pb2 = XmCreatePushButton(bb, "Vert scaleHeight to 50", args, n);
   XtManageChild(pb2);
   XtAddCallback(pb2, XmNactivateCallback,
	set_scale_height, (XtPointer)scale2);

   n = 0;
   XtSetArg(args[n], XmNy, 100);  n++;;
   XtSetArg(args[n], XmNx, 300);  n++;;
   pb3 = XmCreatePushButton(bb, "Horiz scaleWidth to 50", args, n);
   XtManageChild(pb3);
   XtAddCallback(pb3, XmNactivateCallback,
	set_scale_width, (XtPointer)scale1);

   n=0;
   XtSetArg(args[n], XmNy, 130);  n++;;
   XtSetArg(args[n], XmNx, 300);  n++;;
   pb4 = XmCreatePushButton(bb, "Vert scaleWidth to 50", args, n);
   XtManageChild(pb4);
   XtAddCallback(pb4, XmNactivateCallback,
	set_scale_width, (XtPointer)scale2);

   XtRealizeWidget(Shell1);

   CommonPause();

   XtAppMainLoop(app_context);
}
