/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: DrawnBtnM1.c,v $ $Revision: 1.3.2.2 $ $Date: 1992/04/07 13:26:56 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */

#include <testlib.h>
#include <signal.h>
#include "dp.bmp"

Widget RowColumn1 = NULL;
Widget DrawnButton1 = NULL;
Widget Separator1 = NULL;
Widget DrawnButton2 = NULL;
Widget Separator2 = NULL;
Widget DrawnButton3 = NULL;
Widget Separator3 = NULL;
Widget DrawnButton4 = NULL;
Widget Separator4 = NULL;

void ReDrawdb4();

Pixmap nopanic;
GC db4gc;
XGCValues db4gcv;

void ReDrawCB( w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  Arg args[MAX_ARGS];
  int n;
  static int srcx,srcy,destx,desty,pwid,phite;
  static int firstime = 1;
  int drawsize, border;
  Dimension bwidt, w_width, w_height;
  short hlthick, shthick;

  printf("ReDrawCB\n");

  /* if event was resize, or if this is the first time thru,
   * we need to recalculate the coordinates
   */

  if (((XmAnyCallbackStruct*)call_data)->reason == XmCR_RESIZE ||
      firstime ) 
    {
      firstime = 1;
      /* Get new size of widget */
      n=0;
      XtSetArg(args[n],XmNwidth,&w_width); n++;
      XtSetArg(args[n],XmNheight,&w_height); n++;
      XtSetArg(args[n],XmNborderWidth,&bwidt); n++;
      XtSetArg(args[n],XmNhighlightThickness,&hlthick); n++;
      XtSetArg(args[n],XmNshadowThickness,&shthick); n++;
      XtGetValues(w,args,n);

      /* calculate available drawing area, width 1st */
      border = bwidt + hlthick + shthick;
      
      /* 
       * See if window is bigger that pixmap (center it),
       *  or if pixmap is bigger (clip it) 
       */

      drawsize = w_width- 2*border;
      if (drawsize > dont_panic_width){
	srcx = 0; pwid = dont_panic_width;
	destx = (drawsize-dont_panic_width)/2 + border;
      }
      else {
	destx = border; pwid = drawsize;
	srcx = (dont_panic_width - drawsize)/2;
      }

      drawsize = w_height - 2*border;
      if (drawsize > dont_panic_height){
	srcy = 0; phite = dont_panic_height;
	desty = (drawsize-dont_panic_height)/2 + border;
      }
      else {
	desty = border; phite = drawsize;
	srcy = (dont_panic_height - drawsize)/2;
      }
    }

  /* now copy pixmap to widget window. */

  XCopyArea(XtDisplay(w),nopanic,XtWindow(w),db4gc,
	    srcx,srcy,pwid,phite,destx,desty);
}


void  main (argc, argv)
int     argc;
char  **argv;
{
  register int       n;
  Arg                args[MAX_ARGS];
  XmString           tcs;
  XEvent             DummyEvent;
  XmFontList         fontlist;
  XFontStruct        *newfont;

  CommonTestInit(argc, argv);
    
  n = 0;
  XtSetArg(args[n], XmNwidth, 100);  n++;
  XtSetArg(args[n], XmNheight, 100);  n++;
  XtSetValues(Shell1, args, n);
    
  newfont = XLoadQueryFont(display, "12x24");
  fontlist = XmFontListCreate(newfont, XmSTRING_DEFAULT_CHARSET);

  XtRealizeWidget(Shell1);

  /*   Define the pixmap from data */
  nopanic = 
    XCreatePixmapFromBitmapData(display,
				DefaultRootWindow(display), dont_panic_bits,
				dont_panic_width, dont_panic_height,
				WhitePixel(display,DefaultScreen(display)),
				BlackPixel(display,DefaultScreen(display)),
				DefaultDepth(display,DefaultScreen(display)));
    
  n = 0;
  XtSetArg(args[n], XmNwidth, 100);  n++;
  XtSetArg(args[n], XmNheight, 100);  n++;
  XtSetArg(args[n], XmNpushButtonEnabled, TRUE);  n++;
  XtSetArg(args[n], XmNshadowThickness, 50); n++;
  XtSetArg(args[n], XmNfontList, fontlist); n++;
  tcs = XmStringCreateLtoR("supercalifragalixspelling", 
			   XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  DrawnButton4 = XmCreateDrawnButton(Shell1, "DrawnButton4", args, n);
  XtManageChild(DrawnButton4);
  
  /* add expose and resize callbacks */
  XtAddCallback(DrawnButton4,XmNexposeCallback,ReDrawCB,NULL);
  XtAddCallback(DrawnButton4,XmNresizeCallback,ReDrawCB,NULL);
    
  /* Get the graphics context needed by the callback */
  db4gc = XtGetGC(DrawnButton4, GCForeground | GCBackground, &db4gcv);
  
  CommonPause();
  CommonPause();

  XtAppMainLoop(app_context);
  XtDestroyWidget(DrawnButton4);
}
