/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: TextData1.c,v $ $Revision: 1.4 $ $Date: 92/03/13 18:33:27 $"
#endif
#endif

/*
 *	file: TextData1.c
 *
 *	Has a Multi line Scrolled Text widget under Form. The XmNcolumns resource 
 *	is being set to 80 at creation time, and XmNrows to 24. The wordWrap 
 *	is off. The file RowColumn.c from Motif 1.1 is read in and the
 *	memory measured.
 */

/*  Standard C headers  */
#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>

/*  X headers  */
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>

#include <testlib.h>

#define	TEXT1_TOPCHAR	1
#define	NUM_COLUMNS	80
#define	NUM_ROWS	24
#define	IN_FILE		"RowCol1_1.c"

#define	TEXT1_X		10
#define	TEXT1_Y		10

#define	MAX_TRIALS	50

static void		fill_text_buf();
static void 	enableMallocCB();
static void  	fillTextCB();
static void  	quitCB();
static void  	measureMemoryCB();
static void  	disableMallocCB();
static void  	clearTextCB();
static void  	fillSmallTextCB();
static void  	destroyTextCB();
static void  	createTextCB();


/*  Global Variables  */

char *text_string;
char *small_text_string = "SMALL TEXT";

Widget Form1;
Widget Text1;
Widget	enableMalloc;
Widget	fillText;
Widget	measureMemory;
Widget	disableMalloc;
Widget	fillSmallText;
Widget	clearText;
Widget	destroyText, createText;
XmFontList	newfontlist;
XFontStruct	*newfont;

Arg args[MAX_ARGS];
int n;
FILE	*in_fp;
int		in_fd;
int		memory_measured[MAX_TRIALS];
int		num_trials = 0;
int		start_memory, allocated_memory, memory_in_use;


main (argc, argv)
int argc;
char **argv;
{

	Widget	quit;

	/*  initialize toolkit  */
    CommonTestInit(argc, argv);
    
    n = 0;
	XtSetArg(args[n], XtNwidth, 800);  n++;
	XtSetArg(args[n], XtNheight, 500);  n++;
    XtSetValues(Shell1, args, n);
    

	/* create main form */
	n = 0;
	Form1 = XmCreateForm (Shell1, "Form1", args, n);
	XtManageChild (Form1);

	/* Read the text file into a buffer */
	fill_text_buf();

	/* create multi line text widget */
	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X); n++;
	newfont = XLoadQueryFont(XtDisplay(Shell1),"9x15");
	if (newfont != NULL) {
		newfontlist = XmFontListCreate(newfont, XmSTRING_DEFAULT_CHARSET);
		XtSetArg(args[n], XmNfontList, newfontlist);  n++;
	}
	XtSetArg(args[n], XmNcolumns, NUM_COLUMNS);  n++;
	XtSetArg(args[n], XmNrows, NUM_ROWS);  n++;
	XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNscrollHorizontal, False); n++;
	XtSetArg(args[n], XmNeditable, False); n++;
	Text1 = XmCreateScrolledText(Form1, "Text1", args, n);
	XtManageChild(Text1);

	n = 0;
	XtSetArg(args[n], XmNx, 10); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 400); n++;
	enableMalloc = XmCreatePushButtonGadget(Form1, "enableMalloc", args, n);
	XtManageChild(enableMalloc);
	XtAddCallback(enableMalloc, XmNactivateCallback, enableMallocCB, NULL);

	n = 0;
	XtSetArg(args[n], XmNx, 150); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 400); n++;
	XtSetArg(args[n], XmNsensitive, False); n++;
	disableMalloc = XmCreatePushButtonGadget(Form1, "disableMalloc", args, n);
	XtManageChild(disableMalloc);
	XtAddCallback(disableMalloc, XmNactivateCallback, disableMallocCB, NULL);

	n = 0;
	XtSetArg(args[n], XmNx, 300); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 400); n++;
	XtSetArg(args[n], XmNsensitive, False); n++;
	measureMemory = XmCreatePushButtonGadget(Form1, "measureMemory", args, n);
	XtManageChild(measureMemory);
	XtAddCallback(measureMemory, XmNactivateCallback, measureMemoryCB, NULL);

	n = 0;
	XtSetArg(args[n], XmNx, 450); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 400); n++;
	createText = XmCreatePushButtonGadget(Form1, "createText", args, n);
	XtManageChild(createText);
	XtAddCallback(createText, XmNactivateCallback, createTextCB, NULL);

	n = 0;
	XtSetArg(args[n], XmNx, 10); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 450); n++;
	fillText = XmCreatePushButtonGadget(Form1, "fillText", args, n);
	XtManageChild(fillText);
	XtAddCallback(fillText, XmNactivateCallback, fillTextCB, NULL);

	n = 0;
	XtSetArg(args[n], XmNx, 150); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 450); n++;
	clearText = XmCreatePushButtonGadget(Form1, "clearText", args, n);
	XtManageChild(clearText);
	XtAddCallback(clearText, XmNactivateCallback, clearTextCB, NULL);

	n = 0;
	XtSetArg(args[n], XmNx, 300); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 450); n++;
	destroyText = XmCreatePushButtonGadget(Form1, "destroyText", args, n);
	XtManageChild(destroyText);
	XtAddCallback(destroyText, XmNactivateCallback, destroyTextCB, NULL);

	n = 0;
	XtSetArg(args[n], XmNx, 450); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 450); n++;
	quit = XmCreatePushButtonGadget(Form1, "quit", args, n);
	XtManageChild(quit);
	XtAddCallback(quit, XmNactivateCallback, quitCB, NULL);

	n = 0;
	XtSetArg(args[n], XmNx, 600); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 450); n++;
	fillSmallText = XmCreatePushButtonGadget(Form1, "fillSmallText", args, n);
	XtManageChild(fillSmallText);
	XtAddCallback(fillSmallText, XmNactivateCallback, fillSmallTextCB, NULL);

	XtRealizeWidget(Shell1);

	MallocDisable();

	XtAppMainLoop(app_context);
}


static void  quitCB(w, client_data, call_data)
Widget	w;
caddr_t  client_data;
caddr_t  call_data;
{

	int	i;

	XtFree(text_string);
	XtDestroyWidget(Shell1);
	printf("\nMemory Measurement Data: \n");
	for (i = 0; i < num_trials; i++)
		printf("\tCase %d:\t\tMeasured memory: %d\n", i, memory_measured[i]);
	fflush(stdout);
	exit(0);

}


static void  enableMallocCB(w, client_data, call_data)
Widget	w;
caddr_t  client_data;
caddr_t  call_data;
{

	MallocEnable();
	n = 0;
	XtSetArg(args[n], XmNsensitive, False); n++;
	XtSetValues(w, args, n);
	n = 0;
	XtSetArg(args[n], XmNsensitive, True); n++;
	XtSetValues(measureMemory, args, n);
	XtSetValues(disableMalloc, args, n);
	MallocLeakInfo(&allocated_memory, &memory_in_use);
	start_memory = memory_in_use;

}


static void  disableMallocCB(w, client_data, call_data)
Widget	w;
caddr_t  client_data;
caddr_t  call_data;
{

	static int	disable_count = 0;

	if (disable_count > 0) {
		MallocLeakInfo(&allocated_memory, &memory_in_use);
#ifdef	DEBUG
		printf("From Inside disableMallocCB\n");
		printf("total memory allocated = %d\n", allocated_memory);
		printf("total memory in use = %d\n", memory_in_use);
#endif
	}
	disable_count++;
	n = 0;
	XtSetArg(args[n], XmNsensitive, False); n++;
	XtSetValues(w, args, n);
	XtSetArg(args[n], XmNsensitive, True); n++;
	XtSetValues(enableMalloc, args, n);
	MallocDisable();

}


static void  measureMemoryCB(w, client_data, call_data)
Widget	w;
caddr_t  client_data;
caddr_t  call_data;
{

	static int  memory_count = 0;

	if (num_trials >= MAX_TRIALS) {
		if (num_trials == MAX_TRIALS) {
			n = 0;
			XtSetArg(args[n], XmNsensitive, False); n++;
			XtSetValues(w, args, n);
		}
		fprintf(stderr, "Max no. of trials exceeded\n");
		return;
	}

	MallocLeakInfo(&allocated_memory, &memory_in_use);
	memory_measured[num_trials] = abs(memory_in_use - start_memory);
	num_trials++;
	memory_count++;

#ifdef	DEBUG
	printf("From Inside measureMemoryCB\n");
	printf("Current total memory allocated = %d\n", allocated_memory);
	printf("Current total memory in use = %d\n", memory_in_use);
#endif

}


static void  fillTextCB(w, client_data, call_data)
Widget	w;
caddr_t  client_data;
caddr_t  call_data;
{

	if (Text1 == NULL)
		return;
	XmTextSetString(Text1, text_string);

}


static void  fillSmallTextCB(w, client_data, call_data)
Widget	w;
caddr_t  client_data;
caddr_t  call_data;
{

	if (Text1 == NULL)
		return;
	XmTextSetString(Text1, small_text_string);

}


static void  clearTextCB(w, client_data, call_data)
Widget	w;
caddr_t  client_data;
caddr_t  call_data;
{

	if (Text1 == NULL)
		return;
	XmTextSetString(Text1, "");

}


static void  destroyTextCB(w, client_data, call_data)
Widget	w;
caddr_t  client_data;
caddr_t  call_data;
{

	if (Text1 == NULL)
		return;
	XtDestroyWidget(Text1);
	Text1 = NULL;

}


static void  createTextCB(w, client_data, call_data)
Widget	w;
caddr_t  client_data;
caddr_t  call_data;
{

	/* create multi line text widget */
	if (Text1 != NULL)
		return;
	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X); n++;
	if (newfont != NULL)
		XtSetArg(args[n], XmNfontList, newfontlist);  n++;
	XtSetArg(args[n], XmNcolumns, NUM_COLUMNS);  n++;
	XtSetArg(args[n], XmNrows, NUM_ROWS);  n++;
	XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNscrollHorizontal, False); n++;
	XtSetArg(args[n], XmNeditable, False); n++;
	Text1 = XmCreateScrolledText(Form1, "Text1", args, n);
	XtManageChild(Text1);

}


static void	fill_text_buf()
{

	struct stat	stat_buf;
	int	filesize, bytes_read;

	/* Read the file into a text buffer */
	if ((in_fp = fopen(IN_FILE, "r")) == NULL) {
		fprintf(stderr, "Can not open %s\n", IN_FILE);
		exit(0);
	}

	in_fd = fileno(in_fp);
	fstat(in_fd, &stat_buf);
	filesize = stat_buf.st_size;

	text_string = (char *)XtMalloc(filesize + 1);
	bytes_read = fread(text_string, sizeof(char ), filesize, in_fp);
	if (bytes_read != filesize) {
		printf("filesize = %d bytes_read = %d\n", filesize, bytes_read);
		fclose(in_fp);
		exit(0);
	}
	*(text_string + filesize) = '\0';
	fclose(in_fp);

}
