/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: FetchIL.c,v $ $Revision: 1.5.2.2 $ $Date: 1992/04/08 15:52:31 $"
#endif
#endif

#include <MrmTest.h>

/*
 * Data for summary
 */

#define NUM_TESTS		7
#define TEST_DESCRIP_LENGTH	37

struct TestInfo FetchIconLiteralInfo[NUM_TESTS] = 
{
    {"Fetch non-exported icon              ", MrmNOT_FOUND,	NULL},
    {"Fetch nonexistent icon               ", MrmNOT_FOUND,	NULL},
    {"Fetch icon from nonexistent hierarchy", MrmBAD_HIERARCHY,	NULL},
    {"Fetch valid icon                     ", MrmSUCCESS,	NULL},
    {"Fetch valid icon                     ", MrmSUCCESS,	NULL},
    {"Fetch valid icon                     ", MrmSUCCESS,	NULL},
    {"Fetch valid icon                     ", MrmSUCCESS,	NULL},
};

/*
 * External declarations
 */

extern MrmHierarchy	s_MrmHierarchy;
extern MrmType		class;

extern Widget		widgetmain;

extern String		summary();

/*
 * Local declarations
 */

#define START		0
#define VALID_TEST1	1
#define VALID_TEST2	2
#define FINISH		3

Display		*dsp;
Screen		*screen;

Widget		test_top = NULL,
		test_box = NULL,
		button1 = NULL,
		button2 = NULL;

int		iteration = 0;

void continue_proc(w, tag, reason)
     Widget		w;
     int		*tag;
     unsigned long	*reason;
{ 	

    String	msg_start_tst1 = "There should now be two buttons in the second window.\nThe button faces should be the same color as the window.\n\nAlso, note that there should be four Mrm Toolkit Warning\nmessages on stdout/stderr about MrmFAILUREs.\n\nPress the continue button to continue the test.";

    String	msg_valid_tst1 = "The two buttons should now have labels which read\n    TEST                   TEST\n      1         and          1 \n    BTN1                   BTN2.\nThe colors should be: background - yellow, foreground - red.\nPress the continue button to continue the test.";

    String	msg_valid_tst2 = "The two buttons should now have labels which read\n    BTN1                   BTN2\n    TEST        and        TEST\n      2                      2 .\nThe colors should be: background - red, foreground - yellow.\nPress the continue button to continue the test.";

    Arg		args[2];
    int		nargs;

    Pixmap	btn1_pix,
		btn2_pix,
		bad_pix;

    Pixel	btn1_fg_color = NULL,
		btn1_bg_color = NULL,
		btn2_fg_color = NULL,
		btn2_bg_color = NULL,
		white,
		black;

    XmString	message;

    String	summary_msg;

    int		i;

    if(iteration == START)
    {
	iteration++;

/*
 * Get display, screen
 */

	dsp = XtDisplay(widgetmain);
	
	screen = DefaultScreenOfDisplay(dsp);

/*
 * Get pixels for white & black
 */

	white = WhitePixel(dsp, DefaultScreen(dsp));
	black = BlackPixel(dsp, DefaultScreen(dsp));
	
/*
 * Try to fetch an icon which is not exported
 */

	FetchIconLiteralInfo[0].actual_return = 
	MrmFetchIconLiteral(s_MrmHierarchy,	/* id of uid hierarchy	*/
			    "bad_test1_icon",	/* uil name of widget	*/
			    screen,		/* screen		*/
			    dsp,		/* display		*/
			    white,		/* foreground color	*/
			    black,		/* background color	*/
			    &bad_pix);		/* pixmap		*/
	
/*
 * Try to fetch an icon which is nonexistent
 */

	FetchIconLiteralInfo[1].actual_return =
	MrmFetchIconLiteral(s_MrmHierarchy,
			    "bad_test2_icon",
			    screen,
			    dsp,
			    white,
			    black,
			    &bad_pix);
	
/*
 * Try to fetch an icon from a NULL hierarchy
 */

	FetchIconLiteralInfo[2].actual_return =
	MrmFetchIconLiteral(NULL,
			    "test1_btn1_icon",
			    screen,
			    dsp,
			    white,
			    black,
			    &bad_pix);

/*
 * Create top level shell widget as parent for test_box widget
 */
	
	test_top =
	XtAppCreateShell("test_top",			/* application class */
			 "TEST_TOP",			/* application name  */
			 topLevelShellWidgetClass,	/* widget class	     */
			 dsp,				/* display	     */
			 NULL, 0);			/* arguments	     */

/*
 * Fetch test_box widget
 */

	if(MrmFetchWidget(s_MrmHierarchy,	/* id of uid hierarchy	   */
			  "test_box",		/* uil name of widget	   */
			  test_top,		/* parent of widget	   */
			  &test_box,		/* ptr to widget id	   */
			  &class)		/* ptr to widget class	   */
	   != MrmSUCCESS)
	{
	    error_proc("Can't fetch test_box widget\n");
	}

/*
 * Manage test_box widget
 */

	XtManageChild(test_box);

/*
 * Realize top level shell widget
 */

	XtRealizeWidget(test_top);

/*
 * Replace the instruction message with "start test 1" message
 */

	message = XmStringCreateLtoR(msg_start_tst1, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
			       
    }
    else if(iteration == VALID_TEST1)
    {
	iteration++;

/*
 * Get ID's of button widgets
 */

	button1 = XtNameToWidget(test_box, "button1");
	button2 = XtNameToWidget(test_box, "button2");

/*
 * Get background and foreground colors for button widgets
 */

	nargs = 0;
	XtSetArg(args[nargs], XmNbackground, &btn1_bg_color ); nargs++;
	XtSetArg(args[nargs], XmNforeground, &btn1_fg_color ); nargs++;
	XtGetValues(button1, args, nargs);
	
	nargs = 0;
	XtSetArg(args[nargs], XmNbackground, &btn2_bg_color ); nargs++;
	XtSetArg(args[nargs], XmNforeground, &btn2_fg_color ); nargs++;
	XtGetValues(button2, args, nargs);
	
/*
 * Fetch the icons for each button for valid test 1
 */

	FetchIconLiteralInfo[3].actual_return =
	MrmFetchIconLiteral(s_MrmHierarchy,
			    "test1_btn1_icon",
			    screen,
			    dsp,
			    btn1_fg_color,
			    btn1_bg_color,
			    &btn1_pix);
	
	FetchIconLiteralInfo[4].actual_return =
	MrmFetchIconLiteral(s_MrmHierarchy,
			    "test1_btn2_icon",
			    screen,
			    dsp,
			    btn2_fg_color,
			    btn2_bg_color,
			    &btn2_pix);
	

/*
 * Replace the labels for both buttons with the valid test 1 icons
 */

	nargs = 0;
	XtSetArg(args[nargs], XmNlabelPixmap, btn1_pix); nargs++;
	XtSetValues(button1, args, nargs);
			       
	nargs = 0;
	XtSetArg(args[nargs], XmNlabelPixmap, btn2_pix); nargs++;
	XtSetValues(button2, args, nargs);
			       
/*
 * Replace the instruction message with description of valid test 1 results
 */

	message = XmStringCreateLtoR(msg_valid_tst1, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
			       
    }
    else if(iteration == VALID_TEST2)
    {
	iteration++;

/*
 * Fetch the icons for each button for valid test 2
 */

	FetchIconLiteralInfo[5].actual_return =
	MrmFetchIconLiteral(s_MrmHierarchy,
			    "test2_btn1_icon",
			    screen,
			    dsp,
			    btn1_fg_color,
			    btn1_bg_color,
			    &btn1_pix);
	
	FetchIconLiteralInfo[6].actual_return =
	MrmFetchIconLiteral(s_MrmHierarchy,
			    "test2_btn2_icon",
			    screen,
			    dsp,
			    btn2_fg_color,
			    btn2_bg_color,
			    &btn2_pix);
	
/*
 * Replace the labels for both buttons with the valid test 1 icons
 */

	nargs = 0;
	XtSetArg(args[nargs], XmNlabelPixmap, btn1_pix); nargs++;
	XtSetValues(button1, args, nargs);
			       
	nargs = 0;
	XtSetArg(args[nargs], XmNlabelPixmap, btn2_pix); nargs++;
	XtSetValues(button2, args, nargs);
			       
/*
 * Replace the instruction message with description of valid test 2 results
 */

	message = XmStringCreateLtoR(msg_valid_tst2, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
			       
    }
    else if(iteration == FINISH)
    {
	iteration++;

/*
 * Replace the instruction message with test end message
 */

	summary_msg = summary(NUM_TESTS,
			      TEST_DESCRIP_LENGTH,
			      FetchIconLiteralInfo);

	fprintf (stdout, summary_msg);

	message = XmStringCreateLtoR(summary_msg, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
    }
}
