/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: CloseH.c,v $ $Revision: 1.6.2.3 $ $Date: 1992/04/08 17:54:36 $"
#endif
#endif

#include <MrmTest.h> 

/* 
 * Data for summary
 */

#define NUM_TESTS    4
#define TEST_DESCRIP_LENGTH    	60

struct TestInfo CloseHierarchyInfo[NUM_TESTS] = 
{
    {"Close a valid hierarchy                                     ",
        MrmSUCCESS,	NULL},
    {"Close an empty hierarchy                                    ",
        MrmBAD_HIERARCHY,	NULL},
#ifdef	BADTEST
    {"Close a already closed hierarchy                            ",
        MrmBAD_HIERARCHY,	NULL},
#endif 	/* BADTEST */
    {"Close a garbage hierarchy                                   ",
        MrmBAD_HIERARCHY,	NULL},
    {"Close a valid hierarchy opened from three files             ",
        MrmSUCCESS,	NULL},
};
int    CH_info_cnt = 0;

/*
 * External declarations
 */

extern MrmHierarchy	s_MrmHierarchy;
extern MrmType		class;

extern Widget	toplevel,
		widgetmain;

extern String	summary();

/*
 * Local declarations
 */

#define VALID_TEST1	1
#define VALID_TEST2	2
#define FINISH		3

#define	MEM_LOOP_CNT	10

Widget	test_top,
	test_box,
	CH_test[8];
int	CH_test_cnt = 0;
int	iteration = 1;

FILE	*CH_logfile;
#define	LOGFILE_NAME	"CH_log"

void continue_proc(w, tag, reason)
     Widget	w;
     int	*tag;
     unsigned long	*reason;
{ 

    String	msg_valid_tst1 = "There should now be one label widget.\nIt should say:\n\"OpenH_vh is completed.\"\n\nAlso, note that there should be four Mrm Toolkit Warning\nmessages on stdout/stderr about MrmFAILUREs.\n\nWARNING: The next phase of this test may perform\na VERY LARGE number of disk file operations.\nDO NOT CONTINUE if this will disrupt other people's work!\n\nPress the continue button to continue the test.";

    String	msg_valid_tst2 = "There should now be three new label widgets.\nThey should say:\n\"OpenH_mf1 is completed.\"\n\"OpenH_mf2 is completed.\"\n\"OpenH_mf3 is completed.\"\nPress the continue button to continue the test.";

    Arg	args[4];
    int	nargs;

    XmString	message;

    String	summary_msg;

    MrmHierarchy	OpenHierarchy[3];
    int			emptyhier = 1;
    String		OH_filename_vec[3];
    MrmCount	OH_filename_num = 0;

    char	uidname[3][80];
    int		fetch_return, open_return;
    int		i;



    if(iteration == VALID_TEST1)
    {
        iteration++;
    
    /*
     * Create top level shell widget as parent for test_box widget
     */
        nargs = 0;
        XtSetArg(args[nargs], XtNallowShellResize, TRUE); nargs++;
    
        test_top =
        XtAppCreateShell("test_top",               /* application class */
                         "TEST_TOP",               /* application name  */
                         topLevelShellWidgetClass, /* widget class      */
                         XtDisplay(widgetmain),    /* display           */
                         args, nargs);             /* arguments         */
    
    /*
     * Fetch valid test_box widget
     */
        test_box = NULL;
        MrmFetchWidget(
                       s_MrmHierarchy,
                       "test_box",
                       test_top,
                       &test_box,
                       &class);
    
        XtManageChild(test_box);
        XtRealizeWidget(test_top);

    /*
     * Close a valid hierarchy
     */
        sprintf(uidname[0], "OpenH_vh");
        OH_filename_num = 0;
        OH_filename_vec[OH_filename_num] = uidname[0]; OH_filename_num++;
    
        OpenHierarchy[0] = NULL;
        open_return = MrmOpenHierarchy(
                               OH_filename_num,
                               OH_filename_vec,
                               NULL,
                               &OpenHierarchy[0]);
    
        if (open_return == MrmSUCCESS)
        {
            CH_test[CH_test_cnt] = NULL;
            fetch_return = MrmFetchWidget(
                               OpenHierarchy[0],
                               "OH_vh",
                               test_box,
                               &CH_test[CH_test_cnt],
                               &class);
            if (fetch_return == MrmSUCCESS)
            {
                XtManageChild(CH_test[CH_test_cnt]);
                CH_test_cnt++;
            }
        }
        CloseHierarchyInfo[CH_info_cnt].actual_return =
            MrmCloseHierarchy(OpenHierarchy[0]);
        CH_info_cnt++;
    
    /*
     * Close an empty hierarchy
     */
	/* just pass it an address that has junk in it */
        CloseHierarchyInfo[CH_info_cnt].actual_return =
            MrmCloseHierarchy((MrmHierarchy)&emptyhier);
        CH_info_cnt++;

#ifdef    BADTEST
    /*
     * Close a already closed hierarchy
     */

        CloseHierarchyInfo[CH_info_cnt].actual_return =
            MrmCloseHierarchy(OpenHierarchy[0]);
        CH_info_cnt++;
#endif /* BADTEST */
    
    /*
     * Close a garbage hierarchy
     */
        OH_filename_num = 0;
        sprintf(uidname[0], "OpenH_if");
        OH_filename_vec[OH_filename_num] = uidname[0]; OH_filename_num++;
    
        OpenHierarchy[0] = NULL;
        open_return = MrmOpenHierarchy(
                               OH_filename_num,
                               OH_filename_vec,
                               NULL,
                               &OpenHierarchy[0]);
    
        if (open_return == MrmSUCCESS)
        {    /* This will never happen, not a valid hierarchy */
            CH_test[CH_test_cnt] = NULL;
            fetch_return = MrmFetchWidget(
                               OpenHierarchy[0],
                               "OH_if",
                               test_box,
                               &CH_test[CH_test_cnt],
                               &class);
            if (fetch_return == MrmSUCCESS)
            {
                XtManageChild(CH_test[CH_test_cnt]);
                CH_test_cnt++;
            }
        }
        CloseHierarchyInfo[CH_info_cnt].actual_return =
            MrmCloseHierarchy(OpenHierarchy[0]);
        CH_info_cnt++;
    

        message = XmStringCreateLtoR(msg_valid_tst1, XmSTRING_DEFAULT_CHARSET);
    
        nargs = 0;
        XtSetArg(args[nargs], XmNmessageString, message); nargs++;
        XtSetValues(widgetmain, args, nargs);
        XmStringFree(message);
    }
    else if(iteration == VALID_TEST2)
    {
        iteration++;
    
    /*
     * Close a valid hierarchy opened from three files
     */
        OH_filename_num = 0;
        sprintf(uidname[0], "OpenH_mf1");
        OH_filename_vec[OH_filename_num] = uidname[0]; OH_filename_num++;
        sprintf(uidname[1], "OpenH_mf2");
        OH_filename_vec[OH_filename_num] = uidname[1]; OH_filename_num++;
        sprintf(uidname[2], "OpenH_mf3");
        OH_filename_vec[OH_filename_num] = uidname[2]; OH_filename_num++;
    
        OpenHierarchy[0] = NULL;
        open_return = MrmOpenHierarchy(
                               OH_filename_num,
                               OH_filename_vec,
                               NULL,
                               &OpenHierarchy[0]);
        if (open_return == MrmSUCCESS)
        {
            CH_test[CH_test_cnt] = NULL;
            fetch_return = MrmFetchWidget(
                            OpenHierarchy[0],
                            "OH_mf1",
                            test_box,
                            &CH_test[CH_test_cnt],
                            &class);
            if (fetch_return == MrmSUCCESS)
            {
                XtManageChild(CH_test[CH_test_cnt]);
                CH_test_cnt++;
            }
            CH_test[CH_test_cnt] = NULL;
            fetch_return = MrmFetchWidget(
                            OpenHierarchy[0],
                            "OH_mf2",
                            test_box,
                            &CH_test[CH_test_cnt],
                            &class);
            if (fetch_return == MrmSUCCESS)
            {
                XtManageChild(CH_test[CH_test_cnt]);
                CH_test_cnt++;
            }
            CH_test[CH_test_cnt] = NULL;
            fetch_return = MrmFetchWidget(
                            OpenHierarchy[0],
                            "OH_mf3",
                            test_box,
                            &CH_test[CH_test_cnt],
                            &class);
            if (fetch_return == MrmSUCCESS)
            {
                XtManageChild(CH_test[CH_test_cnt]);
                CH_test_cnt++;
            }
        }
        CloseHierarchyInfo[CH_info_cnt].actual_return =
            MrmCloseHierarchy(OpenHierarchy[0]);
        CH_info_cnt++;

    /*
     * Replace the instruction message with "valid test 2" message
     */
    
        message = XmStringCreateLtoR(msg_valid_tst2, XmSTRING_DEFAULT_CHARSET);
    
        nargs = 0;
        XtSetArg(args[nargs], XmNmessageString, message); nargs++;
        XtSetValues(widgetmain, args, nargs);
        XmStringFree(message);
    }
    else if(iteration == FINISH)
    {
        iteration++;
    
    /*
     * Replace the instruction message with test end message
     */
    
        summary_msg = summary(NUM_TESTS,
                      TEST_DESCRIP_LENGTH,
                      CloseHierarchyInfo);

        fprintf (stdout, summary_msg);

        message = XmStringCreateLtoR(summary_msg, XmSTRING_DEFAULT_CHARSET);
        XtFree(summary_msg);
    
        nargs = 0;
        XtSetArg(args[nargs], XmNmessageString, message); nargs++;
        XtSetValues(widgetmain, args, nargs);
        XmStringFree(message);
    }
}
