/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: MallocExit.c,v $ $Revision: 1.3 $ $Date: 92/03/13 18:31:01 $"
#endif
#endif
/*
 * FILE: MallocExit.c
 * 
 * PURPOSE: This routine is called when the process is exiting and
 *          we need to dump malloc structures then exit.
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <signal.h>
#include "Malloc.h"

void exit();
static void malloc_timeout();

/*
 * Function:    MallocExit()
 *
 * Purpose:     To dump out the malloc information and then exit.
 *
 * Arguments:   None
 *
 * Implicit inputs : 
 *              m_end_dump - boolean to specify whether to dump
 * 
 * Implicit outputs :
 *              malloc_inited 
 *
 * Returns:     Void
 *
 *
 */

#ifdef _NO_PROTO
void MallocExit(signal_param)
int signal_param;
#else
void MallocExit(int signal_param)
#endif
{
  extern Widget Shell1;
  extern XtAppContext app_context;

  /*
   * If we die because of a segmentation violation, get out.
   *  Don't bother trying to continue with exit code.
   */  

  if (signal_param == SIGSEGV)
    {
      printf("Segmentation Violation detected, exiting...\n");
      exit(0);
    }

  /*
   *  Delete the shell, to clean up any memory that's been
   *   allocated for it.
   */
  
  XtDestroyWidget(Shell1);
  XtDestroyApplicationContext(app_context);  

  if (m_end_dump)
    {
      MallocDump();
    }

  malloc_inited = False;

  exit(0);
}

















