/*
 *  Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.
 *  ALL RIGHTS RESERVED
 *
 * $Header: /project/docsrc/src/sml/RCS/sml_synt.y,v 1.2 91/04/10 08:41:52 bowe Exp $
 */
%{
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "sml_def.h"
#include "sml_str.h"
#include "sml_glob.h"
int yylex();
%}
%start macro_descr
%token	DEF_LIST DEF_NAMES DEF_ARG  DEF_CHILD
%token	END_DEF ERROR_TYPE
%token	WORD NEW_LINE EODESC 

%%	/* rules	*/
macro_descr	:	list_descr macros eodesc
		;	
list_descr	:
		|	list_descr list_desc
		;
list_desc	:	DEF_LIST list_name  list NEW_LINE
			{
				SaveList();
			}
		;
list_name	:	WORD
			{
				strcpy(List,"");
				strcpy(ListName,Word);
				strcpy(MacroName,Word);
			}
		;
list		:
		|	list WORD
			{
			if ( ( Work_int = CheckList(Word)) != -1 ) {
				strcpy(TempList,List_desc[Work_int].list);
				Work_name = strchr(TempList,' ');
				while( Work_name != NULL ) {
					*Work_name = '\0';
					strcat(List,TempList);
					strcat(List," ");
					strcpy(TempList,&Work_name[1]);
					Work_name = (char*)strchr(TempList,' ');
				}
			}
			else {
				strcat(List,Word);
				strcat(List," ");
			}
			}
		;
macros		: macro
		| macros macro
		;
macro		: m_names m_arg m_ch_list m_end_def
			{
				SaveMacro();
			}
		;
m_names		:	DEF_NAMES s_name full_name 
		;
s_name		:	WORD
			{
if ( Debug )
printf("Short name=%s\n",Word);
				strcpy(MacroName,Word);
				DefLineNumb = LineNumb;
				strcpy(ArgList,"");
				strcpy(LineTail,"");
			}
		;
full_name	:	line
			{
				strcpy(LongName,LineTail);
			}
		;
line		:	line1 NEW_LINE
line1		:
			{
				strcpy(LineTail,"");
			}
		|	line1 WORD
			{
				strcat(LineTail,Word);
				strcat(LineTail," ");
			}
		;
m_arg		:
		|	def_arg arg_list NEW_LINE
		;
def_arg		:	DEF_ARG 
			{
			}
arg_list	:	WORD 
			{
if ( Debug )
printf("Argument descr=%s\n",Word);
				CheckArg();
			}
		;
m_ch_list	:
		|	DEF_CHILD signed_names_list NEW_LINE
		;
signed_names_list	:
		|	signed_names_list signed_name
		;
signed_name	:	WORD
			{
				strcpy(Name,Word);
				AddRelName();
			}
		;
m_end_def	:
		|	END_DEF
		|	m_end_def line
		;
eodesc		:	EODESC
			{
if ( Debug )
printf("End of description\n");
				fclose( MdFile);
/*
				if ( MacFile != NULL ) fclose ( MacFile );
				if ( RelFile != NULL ) fclose ( RelFile );
				PrintRez();
*/
				Checker();
				YYACCEPT;
			}
		;

%%	/* start of programs	*/
main1()
{
	LastStatus = NEW_LINE;
	yyparse();
}
int	yylex()
{	
int i;
int ret;
int	good_line;
char* w_line;
	strcpy(Word,"");
        yydebug = Debug;

/*	Select current token				*/

	if ( LastStatus == NEW_LINE) {
		good_line = 0;
		while ( good_line == 0 ) {
			strcpy(Line," ");
			if  (fgets(Line,L_SIZE,MdFile) == NULL ) {
				ret = EODESC;
				return(ret);
			}
			else {
				strcpy(LineForParce,Line);
				SymbNumb = 0;
				w_line = (char*) strtok(LineForParce," \t\n");
				LineNumb++;
		/* Check for the comment and empty line		*/
				good_line =1;
				if ( strcmp(Line,"\n") == 0 ) good_line = 0;
		/* For wrong fgets ( which not include \n ! ) !	*/
				if ( strcmp(Line,"") == 0 ) good_line = 0;
				if ( strncmp(Line,"..",2) == 0 ) good_line =0;
			}
		}
        }
        else {
                w_line = (char*)strtok(NULL," \t\n");
        }

/* w_line - current token, if != NULL save in Word	*/

	if ( w_line == NULL ) {
		LastStatus = NEW_LINE;
		ret = NEW_LINE;
if ( Debug )
printf("Lex: NEW_LINE\n");
		return (ret);
	}
	else {
		strcpy(Word,w_line); 
		SymbNumb += strlen(Word);
	}

/* Define type of token					*/

	if ( LastStatus == NEW_LINE ) {
		LastStatus = NEW_LINE+1;
		ret = WORD;
		if ( strcmp(Word,"..") == 0 )  {
			ret = END_DEF;
			strcpy(TypeName,"end of definition.");
		}
		if ( strcmp(Word,".dl") == 0 )  {
			ret = DEF_LIST;
			strcpy(TypeName,"macros list definition.");
		}
		if ( strcmp(Word,".dn") == 0 )  {
			ret = DEF_NAMES;
			strcpy(TypeName,"name definition.");
		}
		if ( strcmp(Word,".da") == 0 )  {
			ret = DEF_ARG;
			strcpy(TypeName,"argument definition.");
		}
		if ( strcmp(Word,".dc") == 0 )  {
			ret = DEF_CHILD;
			strcpy(TypeName,"childs definition.");
		}
	}
	else {
		ret = WORD;
	}
if ( Debug ) 
printf("Lex: ret=%d, Word=%s\n",ret,Word);
	return(ret);
}
