#!/bin/sh
#
# Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.
# ALL RIGHTS RESERVED
#
#    make-ptx.sh -- generate permuted indexes from a list of manpages
#
#	generates output that should be sent to troff with -mptx
#	Depends on defines being passed in environment variable
#	"defines" (set in fmt-piece).
#
#  $Header: /project/docsrc/src/dte/RCS/make-ptx.sh,v 1.10 91/12/20 16:32:56 bowe Exp $

if [ -z "$PTX" ] ; then PTX=ptx ; fi

for i in $* ; do

    # derive the last column of the permuted index (the name(sec#) part)
    # from the TH line, not the filename.

    # the "top" portion - the .TH line and stuff between .SH NAME / .SH whatever
    top="`rmifdef $defines $i | sed -n -e 's/^\.TH/TH/p' -e '/^\.[^S][^H]/d' \
	-e 's/\\\\\*(..//g' -e 's/\\\\\*.//g' \
	-e 's/ *\\\\*-/:/' -e 's/\\\\f.//g' \
	-e '/^\.SH "*NAME"*/,/^\.SH/p'`"

    n=`echo "$top"|sed -n -e 's/\\\&//' -e 's/^\.*TH //p'`
    if echo "$n" | egrep '^"' >/dev/null ; then
	n1=`echo $n | sed -e 's/^"//' -e 's/".*$//'`
	n2=`echo $n | sed -e "s/$n1//" -e 's/""//g' -e 's/ //g' \
		-e 's/^"//' -e 's/".*$//'`
	name="$n1($n2)"
    else
	name=`echo $n | sed -e 's/\([^ ]*\) \([^ ]*\).*/\1(\2)/' -e 's/"//g'`
    fi

    echo "$top" | awk '
		BEGIN { s=""; }
		/^TH/ { next }
		/^\./ { next }
		/REVIEW NOTE/ { next }
		{ s=s" "$0; }
		END { printf "%s\n", s }
	' | $PTX | sed -e "s,\$, \"$name\","
done | sort -f -t\" +4.1

