#!/bin/sh
#
#
# Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.
# ALL RIGHTS RESERVED
# 
#    format-piece - build a piece of a book
#
#    see help message below for usage
#
#  $Header: /project/docsrc/src/dte/RCS/fmt-piece.sh,v 1.25 91/12/20 16:40:30 bowe Exp $


# initialize control variables

# some default settings
doNroff=false
doTroff=false
doExpress=false
whichFormatter=NONE
outDir=NONE
form=NONE
style=NONE
preProcess=NONE
nopost=false
doSML=false
descFile=Description
defines=""
verbose=false
showifdef=false
xmacs=""
alt_dir=""
doPrintOrder=false

# parse command line

badInit=false

while test $# != 0
do
    case $1 in
	-n)	doNroff=true
		whichFormatter=-n
		;;
	-t)	doTroff=true
		whichFormatter=-t
		;;
	-x)	doExpress=true
		whichFormatter=-t
		;;
	-d)	style=d
		outDir=draft
		form=draft
		;;
	-p)	style=p
		outDir=publish
		form=pub
		;;
	-mac)	
		xmacs="$xmacs $2"
		shift
		;;
	-pre)	
		if [ "$preProcess" = "NONE" ]; then
		    preProcess="$2"
		else
		    preProcess="$preProcess | $2"
		fi
		shift
		;;
	-libdir | -root)
		DTE_LIBDIR=$2
		shift
		;;
	-out*)	OUTPUT=$2
		shift
		;;
	-des*)	descFile=$2
		shift
		;;
	-D*)	defines="$defines $1"
		;;
	-alt)   alt_dir=$2
		shift
		;;
	-showif*)
		showifdef=true;;
	-v)	verbose=true;;
	-T*)	TYPESETTER=`echo $1 | sed "s/-T//"`
		nopost=true;;
	-sml)	doSML=true;;
	-nosml)	doSML=false;;
	-printorder)	doPrintOrder=true ;;
	*)	Piece="$1"
		shift
		break
		;;
    esac
    shift
done

if [ " $whichFormatter" = " NONE" -o "$outDir" = "NONE" -o "$form" = "NONE" -o \
	"$style" = "NONE" -o -z "$Piece" ]; then
	badInit=true
fi

#nextPiece=`expr $Piece + 1`
nextPiece=`echo $Piece | awk '{printf "%03d",$1+1}'`
Piece=`echo $Piece | awk '{printf "%03d",$1}'`
masterDoSML=$doSML
Options="$*"

if $badInit ; then
    cat << EOF

synopsis:  build-piece -n|-t|-x -d|-p <piece #> [special-options]

    -n		build for nroff
    -t		build for troff
    -x		build for express

    -d		draft formatting
    -p		publish formatting
    -sml	Build with sml macros
    -nosml	Build without sml macros (default)
    -mac <macs>	include macros <macs> after others

    -showifdef	embolden and offset #ifdef/#else/#endif
    -D<symbol>	define <symbol> and filter thru rmifdef

    -out <dir>	Set directory for output to <dir>
    -des <file>	Specify alternate Description file to <file>
    -libdir <dir> Set root directory of DTE library to <dir>

    -Ttypesetter argument (ps is default)

    <piece #> is which piece of the book to build

EOF
    exit 1
fi

if [ ! -r $descFile ]
	then echo "Can't find book Description file"
		 exit 1
fi

if [ -z "$DTE_LIBDIR" ]
	then echo "ERROR: DTE_LIBDIR not defined"
		exit 2
fi

if [ -z "$OUTPUT" ] ; then OUTPUT=Output ; fi
if [ -z "$TYPESETTER" ] ; then TYPESETTER=ps ; fi
if [ -z "$SYNC_DIR" ] ; then SYNC_DIR="Sync" ; fi

if [ ! -d "$SYNC_DIR" ] ; then mkdir $SYNC_DIR ; fi

if $showifdef ; then
    defines=""
    if [ "$preProcess" = "NONE" ]; then
	preProcess="show-ifdefs"
    else
	preProcess="$preProcess | show-ifdefs"
    fi
fi

#
#    make sure that the necessary output places exist
#
# dirs = ascii, postscript, device independent troff output (dito)
#

#for i in $OUTPUT $OUTPUT/draft $OUTPUT/publish \
#	$OUTPUT/draft/$TYPESETTER $OUTPUT/draft/ascii \
#	$OUTPUT/publish/$TYPESETTER $OUTPUT/publish/ascii
#do
#    if [ ! -d $i ] ; then mkdir $i ; fi
#done
#if $doExpress ; then
#    if [ ! -d $OUTPUT/draft/dito ] ; then mkdir $OUTPUT/draft/dito ; fi
#    if [ ! -d $OUTPUT/publish/dito ] ; then mkdir $OUTPUT/publish/dito ; fi
#fi

# be tolerant of fonts loaded into the wrong place

if [ ! -d /usr/lib/font/dev$TYPESETTER -a -d /usr/local/lib/font ]
	then LIB="-F/usr/local/lib/font"
	else LIB=""
fi

if [ -z "$DTE_OUTFILTER" ] ; then DTE_OUTFILTER="eps $LIB" ; fi

Macros=$DTE_LIBDIR/macros

if $doNroff ; then
    outFilter=forward
    outForm=ascii
    ext=""
fi

if $doTroff ; then
    if $nopost
	then outFilter=cat
	else outFilter="$DTE_OUTFILTER"
    fi
    Options="$LIB $Options"
    outForm=$TYPESETTER
    ext=".$TYPESETTER"
fi

if $doExpress ; then
    outFilter=cat
    Options="$LIB $Options"
    outForm=dito
    ext=".x"
fi

syncFile=$style$whichFormatter
Out=$OUTPUT/$outDir/$outForm

#
#	produce synchronized head from the previous piece
#

echo '!SYNC: "0" "0" "0" "0" "0" "0" "0"' > $SYNC_DIR/$syncFile.001

lastH1=`grep '^\!H1' $SYNC_DIR/$syncFile.$Piece | tail -1`
rm -f $SYNC_DIR/$syncFile.$nextPiece
if [ "$lastH1" != "" ]
	then echo "$lastH1" > $SYNC_DIR/$syncFile.$nextPiece
	else cat /dev/null  > $SYNC_DIR/$syncFile.$nextPiece
fi

lastPART=`grep '^\!PART:' $SYNC_DIR/$syncFile.$Piece | tail -1`
if [ "$lastPART" != "" ]
	then echo "$lastPART" >> $SYNC_DIR/$syncFile.$nextPiece
fi

# get the details of the piece we are to format

#  A bit of a hack here.  Piping a shell expression that expands to > 4K
#  into sed caused problems.  This will expand and sed separately.
#  There still may be a problem if/when we hit the shell cmd line limit
#  (we haven't yet).					-JBowe
eval `sed -e '/^#/d' -e '/^$/d' $descFile | sed -n ${Piece}p | awk '
BEGIN { special=""; ff=""; }
{
    printf("name=%s\nType=%s\n",$1,$2);
    for (fld=3; fld<=NF; fld++) {
	if ($fld == "APPENDIX" || $fld == "PREFACE" || \
		$fld == "FRONT" || $fld == "SGREF" || \
		$fld == "UNNUMBERED") { special=special" "$fld;	}
	else if (substr($fld,0,1) == "<") { ff=ff" \`cat "$fld"\`"; }
	else { ff=ff" "$fld; }
    }
}
END { printf("special=\"%s\"\nff=\"%s\"\n", special,ff); }'`

files=`echo $special | \
    sed -e "s@APPENDIX@$Macros/appendix.mac@" \
	-e "s@PREFACE@$Macros/preface.mac@" \
	-e "s@FRONT@$Macros/front.mac@" \
	-e "s@SGREF@$Macros/sgref.mm@" \
	-e "s@UNNUMBERED@$Macros/unnumbered.mm@" \
	-e "s@GLOSSARY@$Macros/glossary.mm@"`

if [ -n "$alt_dir" ] ; then
#    a="-alt $alt_dir"
    files="$files `expand_fname $ff -alt $alt_dir`"
else
#    a=""
    files="$files $ff"
fi

#files="$files `expand_fname $ff $a`"
#files="$files $ff"			# OLD WAY

if [ "$Type" = "gpsml" ]; then
    type=mm
    doSML=true
elif [ "$Type" = "rsml" ]; then
    type=man
    doSML=true
else
    type=$Type
    doSML=$masterDoSML
fi

# look through description file for special instructions
if egrep '^##.*CHAPTERPART' $descFile >/dev/null ; then
    if [ "$type" = "mm" ] ; then   files="$Macros/chappart.sml $files" ; fi
fi
if egrep '^##.*PARTS' $descFile >/dev/null ; then
    parts="$Macros/parts.sml"
else
    parts=""
fi
if egrep '^##.*OSFHEAD' $descFile >/dev/null ; then
    files="$Macros/osfhead.rsml $files"
fi

if $verbose ; then
    echo "Processing files: $files"
fi

#  Yuck!  This is to get rid of the newlines in the files string.
#  (Another reason why this whole thing should be re-done in C...)
files=`eval echo $files`

if $doPrintOrder ; then
    echo $special | grep FRONT >/dev/null
    if [ $? -eq 0 ] ; then
	np=`echo $nextPiece | awk '{printf "%03d",$1-1}'`
    else
	np=$nextPiece
    fi
    OutfileName=$Out/$np.$name$ext
else
    OutfileName=$Out/$name$ext
fi

rm -f $OutfileName

if [ -z "$name" -o -z "$type" -o -z "$files" ]; then
    echo ""
    echo "Error in Description file, line $Piece"
    echo ""
    echo "name='$name', type='$type', files='$files'"
    echo ""
    exit 4
fi

echo ""
echo "formatting body $name ($Type) for $outForm;  part $Piece of" `sed -e '/^#/d' -e '/^$/d' $descFile | wc -l`

# do body stuff

if [ "$type" = "mm" ]
then
	(if [ ! -r Headers/header.mm ]
	 	then echo "Can't find Headers/header.mm"
	 		 exit 2
	 fi

	 rm -f $SYNC_DIR/head.$syncFile.$Piece
	 echo "$lastH1" | sync-h1-mm > $SYNC_DIR/head.$syncFile.$Piece
	 if [ -n "$lastPART" ] ; then
	     echo "$lastPART" |
		sed 's/\!PART:\(.*\)$/.ds |P \1/' >> $SYNC_DIR/head.$syncFile.$Piece
	 fi

	 if $doTroff && [ "$form" = "pub" ]
		then macs="$Macros/mmt"
		else macs="-mm"
	 fi

	 if [ "$form" = "draft" ]
		then macs="$macs $Macros/draft.mac"
	 fi

	macs="$macs $Macros/header.all $parts $Macros/$form-hdr.mm \
          $Macros/headfoot.mm $Macros/$form-mmt+.mm $Macros/bookdefs.mac"

	 if $doTroff ; then
	     if [ -r /usr/lib/tmac/tmac.eroff ]
		then macs="$macs /usr/lib/tmac/tmac.eroff"
		else macs="$macs $Macros/ps.mm"
	     fi
	     Options="$Options -T$TYPESETTER"
	     PicPrep=""
	 else
	     macs="$macs $Macros/nroff-hdr.mm"
	     Options="$Options -Tlp"
	     if $doExpress
		then PicPrep=""
		else PicPrep="rmPic"
#		else PicPrep="-p rmPic"
	     fi
	 fi

	 if $doExpress ; then
	     if [ -r /usr/lib/tmac/tmac.eroff ]
		then macs="$macs /usr/lib/tmac/tmac.eroff"
		else macs="$macs $Macros/ps.mm"
	     fi
	     Options="$Options -Tps"
	 fi

	 if $doSML
		then macs="$macs $Macros/sml $Macros/gpsml"
	 fi

	 prefiles="$SYNC_DIR/head.$syncFile.$Piece \
		Headers/header.mm $Macros/sync-pre.mm"
	 postfiles="$Macros/sync-post.mm"
	 syncOptions=`syncGen $SYNC_DIR/$syncFile.$Piece`
	 allOptions="$Options -rN5 $syncOptions $macs $xmacs \
		$prefiles - $postfiles 2>>$SYNC_DIR/$syncFile.$nextPiece"
	 if [ "$preProcess" = "NONE" ]; then
	    preProcess="$PicPrep"
	 else
	    if [ -n "$PicPrep" ]; then
		preProcess="$preProcess | $PicPrep"
	    fi
	 fi
	 if $verbose ; then
	     echo ""
	     echo "command to execute:"
	     echo "`roff-cmd $whichFormatter $defines -p \"$preProcess\" \
		-o \"$allOptions\" $files`"
	     echo ""
	 fi
	 eval "`roff-cmd $whichFormatter $defines -p \"$preProcess\" \
		-o \"$allOptions\" $files `" | \
		$outFilter >$OutfileName

	 grep -v "^\!" $SYNC_DIR/$syncFile.$nextPiece | sed "s/^/ERROR: /"

	 if [ "`tail -1 $SYNC_DIR/$syncFile.$nextPiece | cut -f1 -d' '`" != "!SYNC:" ]
		then echo "ERROR: this piece did not format to completion, and the section and page"
		     echo "ERROR:     numbers in the following pieces will be wrong"
	 fi
	)

# do man stuff

elif [ "$type" = "man" ]
then
	if [ ! -r Headers/header.man ] ; then
	    echo "Can't find Headers/header.man"
	    exit 2
	fi

	echo "$lastH1" | sync-h1-man > $SYNC_DIR/manhd.$syncFile.$Piece
	if [ -n "$lastPART" ] ; then
	    echo "$lastPART" |
		sed 's/\!PART:\(.*\)$/.ds |P \1/' >> $SYNC_DIR/manhd.$syncFile.$Piece
	fi

	if $doTroff && [ "$form" = "pub" ]
	    then macs="$Macros/an"
	    else macs="-man"
	fi

	macs="$macs $Macros/header.all $Macros/$form-hdr.man $Macros/$form-an+.man $Macros/bookdefs.mac"

	if $doTroff ; then
	    if [ -r /usr/lib/tmac/tmac.eroff ]
		then macs="$macs /usr/lib/tmac/tmac.eroff"
		else macs="$macs $Macros/ps.mm"
	    fi
	    Options="$Options -T$TYPESETTER"
	else
	    Options="$Options -Tlp"
	fi

	if $doExpress ; then
	    if [ -r /usr/lib/tmac/tmac.eroff ]
		then macs="$macs /usr/lib/tmac/tmac.eroff"
		else macs="$macs $Macros/ps.mm"
	     fi
	     Options="$Options -Tps"
	fi

	if $doSML
	    then macs="$macs $Macros/sml $Macros/rsml"
	fi

	prefiles="$SYNC_DIR/manhd.$syncFile.$Piece Headers/header.man $Macros/sync-pre.man"
	postfiles="$Macros/sync-post.man"
	syncOptions=`syncGen $SYNC_DIR/$syncFile.$Piece`
	allOptions="$Options $syncOptions $macs $xmacs $prefiles - $postfiles \
		2>>$SYNC_DIR/$syncFile.$nextPiece"

	if [ "$form" = "pub" ]; then
		if [ "$preProcess" = "NONE" ]; then
			preProcess="fix-man"
		else
			preProcess="$preProcess | fix-man"
		fi
	else
		if [ "$preProcess" = "NONE" ]; then
			preProcess="cat"
		fi
	fi

	if $verbose ; then
	    echo ""
	    echo "command to execute:"
	    echo "`roff-cmd $whichFormatter $defines -p \"$preProcess\" \
		-o \"$allOptions\" $files`"
	    echo ""
	fi
	eval "`roff-cmd $whichFormatter $defines -p \"$preProcess\" \
		-o \"$allOptions\" $files`" | \
		$outFilter >$OutfileName

	grep -v "^\!" $SYNC_DIR/$syncFile.$nextPiece | sed "s/^/ERROR: /"

	 if [ "`tail -1 $SYNC_DIR/$syncFile.$nextPiece | cut -f1 -d' '`" != "!SYNC:" ]
		then echo "ERROR: this piece did not format to completion, and the section and page"
		     echo "ERROR:     numbers in the following pieces will be wrong"
	 fi


elif [ "$type" = "ptx" -o "$type" = "mptx" ] ; then

# handle permuted indexes.  We get a "ptx" in the second column of
# the Description file, then the list of files is the manpages from
# within which to grab the description lines.

    if $verbose ; then echo "Permuted index" ; fi

	(if [ ! -r Headers/header.mm ] ; then
	    echo "Can't find Headers/header.mm"
	    exit 2
	 fi

	 echo "$lastH1" | sync-h1-mm > $SYNC_DIR/head.$syncFile.$Piece
	 if [ -n "$lastPART" ] ; then
	     echo "$lastPART" |
		sed 's/\!PART:\(.*\)$/.ds |P \1/' >> $SYNC_DIR/head.$syncFile.$Piece
	 fi

	 if $doTroff && [ "$form" = "pub" ]
		then macs="$Macros/mmt"
		else macs="-mm"
	 fi

	 if [ "$form" = "draft" ]
		then macs="$macs $Macros/draft.mac"
	 fi

	macs="$macs $Macros/header.all $parts $Macros/$form-hdr.mm \
		$Macros/headfoot.mm $Macros/$form-mmt+.mm \
		$Macros/bookdefs.mac /usr/lib/tmac/tmac.ptx"

	 if $doTroff ; then
	     Options="$Options -T$TYPESETTER"
	     PicPrep=""
	 else
	     macs="$macs $Macros/nroff-hdr.mm"
	     Options="$Options -Tlp"
		 PicPrep=""
	 fi

	 if $doExpress ; then
	     Options="$Options -T$TYPESETTER"
	 fi

	 if $doSML
		then macs="$macs $Macros/sml $Macros/gpsml"
	 fi

	 prefiles="$SYNC_DIR/head.$syncFile.$Piece \
		Headers/header.mm $Macros/sync-pre.mm"
	 postfiles="$Macros/sync-post.mm"
	 syncOptions=`syncGen $SYNC_DIR/$syncFile.$Piece`
	 allOptions="$Options $syncOptions $macs $xmacs \
		$prefiles $Macros/ptx.mm - $postfiles 2>>$SYNC_DIR/$syncFile.$nextPiece"

	 ptxtmp=/tmp/ptx-$$-p
	 trap "rm -f $ptxtmp ; exit $?" 0 1 2 3 4 15
	 echo "...\\\"build -rmifdef -tbl -pic -eqn" > $ptxtmp
	 export defines
	 make-ptx $files >> $ptxtmp
	 if $verbose ; then
	     echo ""
	     echo "command to execute:"
	     echo "`roff-cmd $whichFormatter $defines \
		-o \"$allOptions\" $ptxtmp`"
	     echo ""
	 fi

	 eval "`roff-cmd $whichFormatter $defines \
		-o \"$allOptions\" $ptxtmp `" | $outFilter >$OutfileName

	 grep -v "^\!" $SYNC_DIR/$syncFile.$nextPiece | sed "s/^/ERROR: /"

	 if [ "`tail -1 $SYNC_DIR/$syncFile.$nextPiece | cut -f1 -d' '`" != "!SYNC:" ]
		then echo "ERROR: this piece did not format to completion, and the section and page"
		     echo "ERROR:     numbers in the following pieces will be wrong"
	 fi
	)

else
	echo "Error in Description file:  '$type' is an unknown type."
fi

#endof format-piece.sh
