#!/bin/sh
#
# Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.
# ALL RIGHTS RESERVED
#

#   format-index -- format an index from info gleaned from sync files
#
#   synopsis:  format-index -n|-t|-x -d|-p [-Ttypesetter]
#
#   do the index from info in the sync files
#
#  $Header: /project/docsrc/src/dte/RCS/fmt-index.sh,v 1.21 91/12/30 13:44:23 fred Exp $

# set some defaults
whichFormatter=-t
outDir=publish
Form=pub
style=p
nopost=false
descFile=Description
verbose=false
PREP=""
doPrintOrder=false

while test $# != 0
do
    case $1 in
	-n)	whichFormatter=-n ;;
	-t)	whichFormatter=-t ;;
	-x)	whichFormatter=-x ;;

	-d)	outDir=draft
		Form=draft
		style=d
		;;
	-p)	outDir=publish
		Form=pub
		style=p
		;;
	
	-prep)	PREP=$2
		shift
		;;

	-des*)	descFile=$2
		shift
		;;

	-out*)	OUTPUT=$2
		shift
		;;

	-libdir | -root)
		DTE_LIBDIR=$2
		shift
		;;

	-v)	verbose=true
		;;

	-h*)	
		echo "usage: $0 [-n|-t|-x] [-d|-p] [-Ttypesetter] [-des DescriptFile] [-out OutputDir] [-libdir LibDir] [-prep <file>] [-help]"
		exit 0
		;;

	-T*)	TYPESETTER=`echo $1 | sed "s/-T//"`
		nopost=true
		;;

	-printorder)	doPrintOrder=true ;;

	-D*)	;;
    esac
    shift
done

if [ -z "$TROFF" ] ; then TROFF=troff ; fi
if [ -z "$NROFF" ] ; then NROFF=nroff ; fi
if [ -z "$TYPESETTER" ] ; then TYPESETTER=ps ; fi
if [ -z "$SYNC_DIR" ] ; then SYNC_DIR="Sync" ; fi

#if [ -r `which Where_DTE_Is` ]
#	then . `which Where_DTE_Is`
#		 Macros=$MACROBIN
#	else Macros=$DTE_LIBDIR/macros
#fi
Macros=$DTE_LIBDIR/macros

# be tolerant of fonts loaded into the wrong place

if [ ! -d /usr/lib/font/dev$TYPESETTER -a -d /usr/local/lib/font ]; then
    LIB="-F/usr/local/lib/font"
else
    LIB=""
fi
if [ -z "$DTE_OUTFILTER" ] ; then DTE_OUTFILTER="eps $LIB" ; fi

if [ "$Form" = "draft" ]
	then macs="$macs $Macros/draft.mac"
fi

macs="$macs Headers/header.mm $Macros/$Form-hdr.mm $Macros/$Form-mmt+.mm"

if egrep '^##.*PARTS' $descFile >/dev/null ; then
    macs="$macs $Macros/parts.sml"
fi

macs="$macs $Macros/headfoot.mm $Macros/index-pre.mm - $Macros/index-post.mm"

if $doPrintOrder ; then Pc="999." ; fi

if [ "X$whichFormatter" = "X-n" ]; then
    formatter="$NROFF -Tlp -mm $nroffOptions $macs"
    outForm=ascii
    outFile=$OUTPUT/$outDir/$outForm/${Pc}index
    outFilter="forward > $outFile"

elif [ "X$whichFormatter" = "X-t" ]; then
    formatter="$TROFF -T$TYPESETTER $LIB -mm $troffOptions $macs"
    outForm=$TYPESETTER
    outFile=$OUTPUT/$outDir/$outForm/${Pc}index.$TYPESETTER
    if `$nopost`
	then outFilter="cat > $outFile"
	else outFilter="$DTE_OUTFILTER > $outFile"
    fi

elif [ "X$whichFormatter" = "X-x" ]; then
    formatter="$TROFF -Tps $LIB -mm $troffOptions $macs"
    outForm=dito
    outFile=$OUTPUT/$outDir/$outForm/${Pc}index.x
    outFilter="cat $LIB > $outFile"
    whichFormatter=-t
fi

echo ""
echo "formatting index ($outForm)"

syncFile=$style$whichFormatter

FILES="$SYNC_DIR/$syncFile.???"

Special="!@#$%^&\*\-_=+;:\\|,\./?'\""

rm -f $outFile
cat $FILES | sed -n -e 's///g' -e 's/\!INDEX: //p' |
	indpresort $PREP |
	sed -e "s/^\(.\)\([${Special}]\)\(.*\)/\1!\2\3/" |
	sort -f | uniq | sed -e 's/^\(.\)!\(.*\)/\1\2/' | indpostsort |
	eval "$formatter" | eval "$outFilter"


# finally, add an entry to the TOC--

echo "!TOC: .)T 1 1 \"\h'|0i'\" Index Index-1" > $SYNC_DIR/$style$whichFormatter.999
