/* 
 * (c) Copyright 1989, 1990, 1991, 1992, 1993 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Xmos.c,v $ $Revision: 1.6.11.2 $ $Date: 92/12/02 14:20:45 $"
#endif
#endif
/*
*  (c) Copyright 1989, DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS. */
/*
*  (c) Copyright 1987, 1988, 1989, 1990, 1991, 1992 HEWLETT-PACKARD COMPANY */

#include <stdio.h>

#ifdef __cplusplus
extern "C" { /* some 'locale.h' do not have prototypes (sun) */
#endif
#include <X11/Xlocale.h>
#ifdef __cplusplus
} /* Close scope of 'extern "C"' declaration */
#endif /* __cplusplus */

#include <X11/Xos.h>

#ifndef X_NOT_STDC_ENV
#include <stdlib.h>
#include <unistd.h>
#endif

#include <sys/time.h>  /* For declaration of select(). */

#if defined(NO_REGCOMP) && !defined(NO_REGEX)
#ifdef __sgi
extern char *regcmp();
#else
#if defined(SVR4) || defined(SYSV)
#include <libgen.h>
#endif /* sysv */
#endif /* __sgi */
#endif /* NO_REGEX */

#ifndef NO_REGCOMP
#include <regex.h>
#endif /* NO_REGCOMP */

#ifdef SYS_DIR
#include <sys/dir.h>
#else
#ifdef NDIR
#include <ndir.h>
#else
#ifdef __apollo
#include <sys/dir.h>
#else
#include <sys/types.h>
#include <dirent.h>
#endif
#endif
#endif

#include <sys/stat.h>
#ifndef MCCABE
#include <pwd.h>
#endif

#include <Xm/XmosP.h>

#ifdef USE_GETWD
#include <sys/param.h>
#define MAX_DIR_PATH_LEN    MAXPATHLEN
#else
#define MAX_DIR_PATH_LEN    1024
#endif
#define MAX_USER_NAME_LEN   256

#ifndef S_ISDIR
#define S_ISDIR(m) ((m & S_IFMT)==S_IFDIR)
#endif

#ifndef S_ISREG
#define S_ISREG(m) ((m & S_IFMT)==S_IFREG)
#endif

#define FILE_LIST_BLOCK 64

/********
set defaults for resources that are implementation dependant
and may be modified.
********/ 

char _XmSDEFAULT_FONT[] = "fixed";
char _XmSDEFAULT_BACKGROUND[] = "#729FFF";

/**************** end of vendor dependant defaults ********/

/********    Static Function Declarations    ********/
#ifdef _NO_PROTO

static String GetQualifiedDir() ;
static String GetFixedMatchPattern() ;

#else

static String GetQualifiedDir( 
                        String dirSpec) ;
static String GetFixedMatchPattern( 
                        String pattern) ;

#endif /* _NO_PROTO */
/********    End Static Function Declarations    ********/


/****************************************************************/
static String
#ifdef _NO_PROTO
GetQualifiedDir( dirSpec)
            String          dirSpec ;
#else
GetQualifiedDir(
            String          dirSpec)
#endif
/*************GENERAL:
 * dirSpec is a directory name, that can contain relative 
 *   as well as logical reference. This routine resolves all these
 *   references, so that dirSpec is now suitable for open().
 * The routine allocates memory for the result, which is guaranteed to be
 *   of length >= 1.  This memory should eventually be freed using XtFree().
 ****************/
/*************UNIX:
 * Builds directory name showing descriptive path components.  The result
 *   is a directory path beginning at the root directory and terminated
 *   with a '/'.  The path will not contain ".", "..", or "~" components.  
 ****************/
{
            int             dirSpecLen ;
            struct passwd * userDir ;
            int             userDirLen ;
            int             userNameLen ;
            char *          outputBuf ;
            char *          destPtr ;
            char *          srcPtr ;
            char *          scanPtr ;
            char            nameBuf[MAX_USER_NAME_LEN] ;
            char            dirbuf[MAX_DIR_PATH_LEN] ;

    dirSpecLen = strlen( dirSpec) ;
    outputBuf = NULL ;

    switch(    *dirSpec    )
    {   case '~':
        {   if(    !(dirSpec[1])  ||  (dirSpec[1] == '/')    )
	    {
		userDir = (struct passwd *) getpwuid( getuid()) ;
                if(    userDir    )
                {   
    		    userDirLen = strlen( userDir->pw_dir) ;
    		    outputBuf = XtMalloc( userDirLen + dirSpecLen + 2) ;
                    strcpy( outputBuf, userDir->pw_dir) ;
    		    strcpy( &outputBuf[userDirLen], (dirSpec + 1)) ;
                    }
    	        }
	    else
	    {
		destPtr = nameBuf ;
                userNameLen = 0 ;
		srcPtr = dirSpec + 1 ;
		while(    *srcPtr  &&  (*srcPtr != '/')
                       && (++userNameLen < MAX_USER_NAME_LEN)    )
		{   *destPtr++ = *srcPtr++ ;
                    } 
		*destPtr = '\0' ;

                userDir = (struct passwd *)getpwnam( nameBuf) ;
		if(    userDir    )
		{   
		    userDirLen = strlen( userDir->pw_dir) ;
		    dirSpecLen = strlen( srcPtr) ;
		    outputBuf = XtMalloc( userDirLen + dirSpecLen + 2) ;
                    strcpy( outputBuf, userDir->pw_dir) ;
                    strcpy( &outputBuf[userDirLen], srcPtr) ;
                    } 
		}
            break ;
            } 
        case '/':
        {   outputBuf = XtMalloc( dirSpecLen + 2) ;
	    strcpy( outputBuf, dirSpec) ;
            break ;
            } 
        default:
        {  
#ifdef USE_GETWD
            destPtr = (char*)getwd( dirbuf) ;
#else
            destPtr = (char*)getcwd( dirbuf, MAX_DIR_PATH_LEN) ;
#endif
            if(    destPtr    )
            {   userDirLen = strlen( destPtr) ;
	        outputBuf = XtMalloc( userDirLen + dirSpecLen + 3) ;
                strcpy( outputBuf, destPtr) ;
	        outputBuf[userDirLen++] = '/';
                strcpy( &outputBuf[userDirLen], dirSpec) ;
                } 
            break ;
            } 
        } 
    if(    !outputBuf    )
    {   outputBuf = XtMalloc( 2) ;
        outputBuf[0] = '/' ;
        outputBuf[1] = '\0' ;
        } 
    else
    {   userDirLen = strlen( outputBuf) ;
        if(    outputBuf[userDirLen - 1]  !=  '/'    )
        {   outputBuf[userDirLen] = '/' ;
            outputBuf[++userDirLen] = '\0' ;
            } 
        /* The string in outputBuf is assumed to begin and end with a '/'.
        */
        scanPtr = outputBuf ;
        while(    *++scanPtr    )               /* Skip past '/'. */
        {   /* scanPtr now points to non-NULL character following '/'.
            */
            if(    scanPtr[0] == '.'    )
            {   
                if(    scanPtr[1] == '/'    )
                {   /* Have "./", so just erase (overwrite with shift).
                    */
                    destPtr = scanPtr ;
                    srcPtr = &scanPtr[2] ;
                    while(    *destPtr++ = *srcPtr++    )
                    {   } 
                    --scanPtr ;     /* Leave scanPtr at preceding '/'. */
                    continue ;
                    } 
                else
                {   if(    (scanPtr[1] == '.')  &&  (scanPtr[2] == '/')    )
                    {   /* Have "../", so back up one directory.
                        */
                        srcPtr = &scanPtr[2] ;
                        --scanPtr ;      /* Move scanPtr to preceding '/'.*/
                        if(    scanPtr != outputBuf    )
                        {   while(    (*--scanPtr != '/')    )
                            {   }          /* Now move to previous '/'.*/
                            } 
                        destPtr = scanPtr ;
                        while(    *++destPtr = *++srcPtr    )
                        {   }               /* Overwrite "../" with shift.*/
                        continue ;
                        } 
                    } 
                } 
            else
            {   /* Check for embedded "//".  Posix allows a leading double
                *   slash (and Apollos require it).
                */
                if(    *scanPtr == '/'    )
                {   
		    if(    (scanPtr > (outputBuf + 1))
                        || (scanPtr[1] == '/')    )
                    {
                        /* Have embedded "//" (other than root specification),
			 *   so erase with shift and reset scanPtr.
			 */
			srcPtr = scanPtr ;
			--scanPtr ;
			destPtr = scanPtr ;
			while(    *++destPtr = *++srcPtr    )
			    {   } 
		    }
                    continue ;
		}
	    } 
            while(    *++scanPtr != '/'    )
		{   } 
	} 
    } 
	    return( outputBuf) ;
}

/****************************************************************/
String
#ifdef _NO_PROTO
_XmOSFindPatternPart(fileSpec)
String   fileSpec ;
#else    
_XmOSFindPatternPart(String  fileSpec)
#endif
/****************GENERAL:
 * fileSpec is made of a directory part and a pattern part.
 * Returns the pointer to the first character of the pattern part
 ****************/
/****************UNIX:
 * Returns the pointer to the character following the '/' of the name segment
 *   which contains a wildcard or which is not followed by a '/'.
 ****************/
{
    char *          lookAheadPtr = fileSpec ;
    char *          maskPtr ;
    Boolean         hasWildcards ;
    char            prevChar ;
    char            prev2Char  ;

    do {   /* Stop at final name segment or if wildcards were found.*/
	maskPtr = lookAheadPtr ;
        hasWildcards = FALSE ;
        prevChar = '\0' ;
        prev2Char = '\0' ;
        while((*lookAheadPtr != '/') && !hasWildcards && *lookAheadPtr) {   
	    switch (*lookAheadPtr) {   
	    case '*': case '?': case '[': 
                if((prevChar != '\\')  ||  (prev2Char == '\\')) {   
		    hasWildcards = TRUE ;
		    break ;
		} 
	    }
            prev2Char = prevChar ;
            prevChar = *lookAheadPtr ;
            ++lookAheadPtr ;
	} 
    } while (!hasWildcards  &&  *lookAheadPtr++) ;

    if(*maskPtr == '/') ++maskPtr ;

    return(maskPtr) ;
}

/****************************************************************/
void
#ifdef _NO_PROTO
_XmOSQualifyFileSpec( dirSpec, filterSpec, pQualifiedDir, pQualifiedPattern)
            String          dirSpec ;
            String          filterSpec ;
            String *        pQualifiedDir ;     /* Cannot be NULL.*/
            String *        pQualifiedPattern ; /* Cannot be NULL.*/
#else
_XmOSQualifyFileSpec(
            String          dirSpec,
            String          filterSpec,
            String *        pQualifiedDir,      /* Cannot be NULL.*/
            String *        pQualifiedPattern)  /* Cannot be NULL.*/
#endif
/************GENERAL:
 * dirSpec, filterSpec can contain relative or logical reference.
 * dirSpec cannot contain pattern characters.
 * if filterSpec does not specify all for its last segment, a pattern 
 * for 'all' is added.
 * Use GetQualifiedDir() for dirSpec.
 ****************/
/************UNIX:
 * 'all' is '*' and '/' is the delimiter.
 ****************/
{
    int             filterLen ;
    int             dirLen ;
    char *          fSpec ;
    char *          remFSpec ;
    char *          maskPtr ;
    char *          dSpec ;
    char *          dPtr ;

    if(!dirSpec) dirSpec = "" ;
    if(!filterSpec) filterSpec = "" ;
        
    filterLen = strlen(filterSpec) ;

    /* Allocate extra for NULL character and for the appended '*' (as needed).
    */
    fSpec = XtMalloc( filterLen + 2) ;
    strcpy( fSpec, filterSpec) ;

    /* If fSpec ends with a '/' or is a null string, add '*' since this is
    *   the interpretation.
    */
    if(!filterLen  ||  (fSpec[filterLen - 1] == '/')){   
	fSpec[filterLen] = '*' ;
        fSpec[filterLen + 1] = '\0' ;
    } 

    /* Some parts of fSpec may be copied to dSpec, so allocate "filterLen" 
    *   extra, plus some for added literals.
    */
    dirLen = strlen(dirSpec) ;
    dSpec = XtMalloc(filterLen + dirLen + 4) ;
    strcpy(dSpec, dirSpec) ;
    dPtr = dSpec + dirLen ;

    /* Check for cases when the specified filter overrides anything
    *   in the dirSpec.
    */
    remFSpec = fSpec ;
    switch(*fSpec) {   
    case '/':
	dSpec[0] = '/' ;
	dSpec[1] = '\0' ;
	dPtr = dSpec + 1 ;
	++remFSpec ;
	break ;
    case '~':
        dPtr = dSpec ;
	while((*dPtr = *remFSpec)  &&  (*remFSpec++ != '/')) ++dPtr ;
	*dPtr = '\0' ;
	break ;
    } 

    /* If directory spec. is not null, then make sure that it has a
    *   trailing '/', to be prepared for appending from filter spec.
    */
    if(*dSpec  &&  (*(dPtr - 1) != '/')) {   
	*dPtr++ = '/' ;
        *dPtr = '\0' ;
    } 

    maskPtr = _XmOSFindPatternPart(remFSpec) ;

    if(maskPtr != remFSpec) {  
        do {   
	    *dPtr++ = *remFSpec++ ;
	} while(remFSpec != maskPtr) ;
        *dPtr = '\0' ;
    } 

    if(remFSpec != fSpec) {   
	/* Shift remaining filter spec. to the beginning of the buffer. */
        remFSpec = fSpec ;
        while(*remFSpec++ = *maskPtr++ ) ;
    } 

    *pQualifiedDir = GetQualifiedDir( dSpec) ;
    *pQualifiedPattern = fSpec ;
    XtFree(dSpec) ;
}

/****************************************************************/
static String
#ifdef _NO_PROTO
GetFixedMatchPattern( pattern)
            String         pattern ;
#else
GetFixedMatchPattern(
            String         pattern)
#endif
/**********GENERAL:
 * The pattern parameter is converted to the format required of the
 *   the regular expression library routines.
 * Memory is allocated and returned with the result.  This memory
 *   should eventually be freed by a call to XtFree().
 ****************/
/**********UNIX:
 * '/' is used as a delimiter for the pattern.
 ****************/
{
    register char *         bufPtr ;
    char *          outputBuf ;

    outputBuf = XtCalloc( 2, strlen( pattern) + 4) ;

    bufPtr = outputBuf ;
    *bufPtr++ = '^' ;

    while(*pattern  &&  (*pattern != '/')) {   
        switch(*pattern) {   
	case '.':
            *bufPtr++ = '\\' ;
	    *bufPtr++ = '.' ;
	    break ;
	case '?':
            *bufPtr++ = '.' ;
	    break;
	case '*':
            *bufPtr++ = '.' ;
	    *bufPtr++ = '*' ;
	    break ;
	default:
            *bufPtr++ = *pattern ;
	    break ;
	} 
        ++pattern ;
    } 
    *bufPtr++ = '$' ;
    *bufPtr = '\0' ;

    return( outputBuf) ;
}

/****************************************************************/
void
#ifdef _NO_PROTO
_XmOSGetDirEntries(qualifiedDir, matchPattern, fileType, matchDotsLiterally,
	      listWithFullPath, pEntries, pNumEntries, pNumAlloc)
            String          qualifiedDir ;
            String          matchPattern ;
            unsigned char   fileType ;
            Boolean         matchDotsLiterally ;
            Boolean         listWithFullPath ;
            String * *      pEntries ;      /* Cannot be NULL. */
            unsigned int *  pNumEntries ;   /* Cannot be NULL. */
            unsigned int *  pNumAlloc ;     /* Cannot be NULL. */
#else
_XmOSGetDirEntries(
            String          qualifiedDir,
            String          matchPattern,
#if NeedWidePrototypes
	      unsigned int fileType,
	      int matchDotsLiterally,
	      int listWithFullPath,
#else
	      unsigned char fileType,
	      Boolean matchDotsLiterally,
	      Boolean listWithFullPath,
#endif /* NeedWidePrototypes */
            String * *      pEntries,       /* Cannot be NULL. */
            unsigned int *  pNumEntries,    /* Cannot be NULL. */
            unsigned int *  pNumAlloc)      /* Cannot be NULL. */
#endif
/***********GENERAL:
 * This routine opens the specified directory and builds a buffer containing
 * a series of strings containing the full path of each file in the directory 
 * The memory allocated should eventually be freed using XtFree.
 * The 'qualifiedDir' parameter must be a fully qualified directory path 
 * The matchPattern parameter must be in the proper form for a regular 
 * expression parsing.
 * If the location pointed to by pEntries is NULL, this routine allocates
 *   and returns a list to *pEntries, though the list may have no entries.
 *   pEntries, pEndIndex, pNumAlloc are updated as required for memory 
 *   management.
 ****************/
/***********UNIX:
 * Fully qualified directory means begins with '/', does not have 
 * embedded "." or "..", but does not need trailing '/'.
 * Regular expression parsing is regcmp or re_comp.
 * Directory entries are also Unix dependent.
 ****************/
 
{
            char *          fixedMatchPattern ;
            String          entryPtr ;
            DIR *           dirStream ;
            struct stat     statBuf ;
            Boolean         entryTypeOK ;
            unsigned int    dirLen = strlen( qualifiedDir) ;
#ifndef NO_REGCOMP
            regex_t         preg ;
            int             comp_status ;
#else /* NO_REGCOMP */
#ifndef NO_REGEX
            char *          compiledRE = NULL ;
#endif
#endif /* NO_REGCOMP */
#ifdef NDIR 
            struct direct * dirEntry ;
#else 
#ifdef SYS_DIR
            struct direct * dirEntry ;
#else
            struct dirent * dirEntry ;
#endif
#endif
/****************/

    if(    !*pEntries    )
    {   *pNumEntries = 0 ;
        *pNumAlloc = FILE_LIST_BLOCK ;
        *pEntries = (String *) XtMalloc( FILE_LIST_BLOCK * sizeof( char *)) ;
        } 
    fixedMatchPattern = GetFixedMatchPattern( matchPattern) ;

    if(    fixedMatchPattern    )
    {   
        if(    !*fixedMatchPattern    )
        {   
            XtFree( fixedMatchPattern) ;
            fixedMatchPattern = NULL ;
            } 
        else
        {   
#ifndef NO_REGCOMP
            comp_status = regcomp( &preg, fixedMatchPattern, REG_NOSUB) ;
            if(    comp_status    )
#else /* NO_REGCOMP */
#  ifndef NO_REGEX
            compiledRE = (char *)regcmp( fixedMatchPattern, (char *) NULL) ;
            if(    !compiledRE    )
#  else
            if(    re_comp( fixedMatchPattern)    )
#  endif
#endif /* NO_REGCOMP */
            {   XtFree( fixedMatchPattern) ;
                fixedMatchPattern = NULL ;
                } 
            }
        }
    dirStream = opendir( qualifiedDir) ;

    if(    dirStream    )
    {   
        while(    dirEntry = readdir( dirStream)    )
        {   
            if(    fixedMatchPattern    )
            {   
#ifndef NO_REGCOMP
                if(    regexec( &preg, dirEntry->d_name, 0, NULL, 0)    )
#else /* NO_REGCOMP */
#  ifndef NO_REGEX
                if(    !regex( compiledRE, dirEntry->d_name)    )
#  else
                if(    !re_exec( dirEntry->d_name)    )
#  endif
#endif /* NO_REGCOMP */
                {   continue ;
                    } 
                } 
            if(    matchDotsLiterally
                && (dirEntry->d_name[0] == '.')
                && (*matchPattern != '.')    )
            {   continue ;
                } 
            if(    *pNumEntries == *pNumAlloc    )
            {   *pNumAlloc += FILE_LIST_BLOCK ;
                *pEntries = (String *) XtRealloc((char*) *pEntries, 
					(*pNumAlloc* sizeof( char *))) ;
                } 
            if(    listWithFullPath    )
            {   entryPtr = XtMalloc( strlen(dirEntry->d_name) + dirLen + 1) ;
                strcpy( entryPtr, qualifiedDir) ;
                strcpy( &entryPtr[dirLen], dirEntry->d_name) ;
                }
            else
            {   entryPtr = XtMalloc( strlen(dirEntry->d_name) + 1) ;
                strcpy( entryPtr, dirEntry->d_name) ;
                } 
            /* Now screen entry according to type.
            */
            entryTypeOK = FALSE ;
	    if (fileType == XmFILE_ANY_TYPE) {
		entryTypeOK = TRUE ;
	    } else
            if(    !stat( entryPtr, &statBuf)    )
            {   
                switch(    fileType    )
                {   
                    case XmFILE_REGULAR:
                    {   
                        if(    S_ISREG( statBuf.st_mode)    )
                        {   
                            entryTypeOK = TRUE ;
                            } 
                        break ;
                        } 
                    case XmFILE_DIRECTORY:
                    {   
                        if(    S_ISDIR( statBuf.st_mode)    )
                        {   
                            entryTypeOK = TRUE ;
                            } 
                        break ;
                        } 
                    } 
	    }
            if(    entryTypeOK    )
            {   (*pEntries)[(*pNumEntries)++] = entryPtr ;
                } 
            else
            {   XtFree( entryPtr) ;
                } 
            }
        closedir( dirStream) ;
        }
#ifndef NO_REGCOMP
    if(    !comp_status    )
    {   regfree( &preg) ;
        } 
#else /* NO_REGCOMP */
#  ifndef NO_REGEX
    if(    compiledRE    )
    {   /* Use free instead of XtFree since malloc is inside of regex().
        */
        free( compiledRE) ; 
        } 
#  endif
#endif /* NO_REGCOMP */
    XtFree( fixedMatchPattern) ;
    return ;
    }

/****************************************************************/
void
#ifdef _NO_PROTO
_XmOSBuildFileList(dirPath, pattern, typeMask, pEntries, pNumEntries, pNumAlloc)
            String          dirPath ;
            String          pattern ;
            unsigned char   typeMask ;
            String * *      pEntries ;      /* Cannot be NULL. */
            unsigned int *  pNumEntries ;   /* Cannot be NULL. */
            unsigned int *  pNumAlloc ;     /* Cannot be NULL. */
#else
_XmOSBuildFileList(
	      String          dirPath,
	      String          pattern,
#if NeedWidePrototypes
	      unsigned int typeMask,
#else
	      unsigned char typeMask,
#endif /* NeedWidePrototypes */
	      String * *      pEntries,       /* Cannot be NULL. */
	      unsigned int *  pNumEntries,    /* Cannot be NULL. */
	      unsigned int *  pNumAlloc)      /* Cannot be NULL. */
#endif
/************GENERAL:
 * The 'dirPath' parameter must be a qualified directory path.
 * The 'pattern' parameter must be valid as a suffix to dirPath.
 * typeMask is an Xm constant coming from Xm.h.
 ****************/
/************UNIX:
 * Qualified directory path means no match characters, with '/' at end.
 ****************/
{  
    String          qualifiedDir ;
    String          nextPatternPtr ;
    String *        localEntries ;
    unsigned int    localNumEntries ;
    unsigned int    localNumAlloc ;
    unsigned int    entryIndex ;
/****************/

    qualifiedDir = GetQualifiedDir( dirPath) ;
    nextPatternPtr = pattern ;
    while(*nextPatternPtr  &&  (*nextPatternPtr != '/')) ++nextPatternPtr ;

    if(!*nextPatternPtr) {   
	/* At lowest level directory, so simply return matching entries.*/
        _XmOSGetDirEntries( qualifiedDir, pattern, typeMask, FALSE, TRUE, 
		      pEntries, pNumEntries, pNumAlloc) ;
    } else {   
	++nextPatternPtr ;               /* Move past '/' character.*/
        localEntries = NULL ;
        _XmOSGetDirEntries( qualifiedDir, pattern, XmFILE_DIRECTORY, TRUE, TRUE, 
		      &localEntries, &localNumEntries, &localNumAlloc) ;
        entryIndex = 0 ;
        while(entryIndex < localNumEntries) {   
	    _XmOSBuildFileList( localEntries[entryIndex], nextPatternPtr, 
			  typeMask, pEntries, pNumEntries, pNumAlloc) ;
            XtFree( localEntries[entryIndex]) ;
            ++entryIndex ;
	} 
        XtFree((char*)localEntries) ;
    }
    XtFree( qualifiedDir) ;
    return ;
}


/****************************************************************/
int
#ifdef _NO_PROTO
_XmOSFileCompare(sp1, sp2)
        XmConst void *sp1 ;
        XmConst void *sp2 ;
#else
_XmOSFileCompare(
        XmConst void *sp1,
        XmConst void *sp2)
#endif
/*********GENERAL:
 * The routine must return an integer less than, equal to, or greater than
 * 0 according as the first argument is to be considered less
 * than, equal to, or greater than the second.
 ****************/
{
    return( strcmp( *((String *) sp1), *((String *) sp2))) ;
}


/************************************<+>*************************************
 *
 *   Path code, used in Mwm and Xm.
 *   Returned pointer should not be freed!
 *
 *************************************<+>************************************/
String
#ifdef _NO_PROTO
_XmOSGetHomeDirName()
#else
_XmOSGetHomeDirName()
#endif
{
    uid_t uid;
    struct passwd *pw;
    char *ptr = NULL;
    static char empty = '\0';
    static char *homeDir = NULL;

    if (homeDir == NULL) {
        if((ptr = (char *)getenv("HOME")) == NULL) {
            if((ptr = (char *)getenv("USER")) != NULL)
                pw = getpwnam(ptr);
            else {
                uid = getuid();
                pw = getpwuid(uid);
            }
            if (pw)
                ptr = pw->pw_dir;
            else
                ptr = NULL;
        }
	if (ptr != NULL) {
	    homeDir = XtMalloc (strlen(ptr) + 1);
	    strcpy (homeDir, ptr);
	}
	else {
	    homeDir = &empty;
	}
    }

    return (homeDir);
}


#ifndef LIBDIR
#define LIBDIR "/usr/lib/X11"
#endif
#ifndef INCDIR
#define INCDIR "/usr/include/X11"
#endif

static char libdir[] = LIBDIR;
static char incdir[] = INCDIR;

static char XAPPLRES_DEFAULT[] = "\
%%P\
%%S:\
%s/%%L/%%T/%%N/%%P\
%%S:\
%s/%%l/%%T/%%N/%%P\
%%S:\
%s/%%T/%%N/%%P\
%%S:\
%s/%%L/%%T/%%P\
%%S:\
%s/%%l/%%T/%%P\
%%S:\
%s/%%T/%%P\
%%S:\
%s/%%T/%%P\
%%S:\
%s/%%P\
%%S:\
%s/%%L/%%T/%%N/%%P\
%%S:\
%s/%%l/%%T/%%N/%%P\
%%S:\
%s/%%T/%%N/%%P\
%%S:\
%s/%%L/%%T/%%P\
%%S:\
%s/%%l/%%T/%%P\
%%S:\
%s/%%T/%%P\
%%S:\
%s/%%T/%%P\
%%S";

static char PATH_DEFAULT[] = "\
%%P\
%%S:\
%s/%%L/%%T/%%N/%%P\
%%S:\
%s/%%l/%%T/%%N/%%P\
%%S:\
%s/%%T/%%N/%%P\
%%S:\
%s/%%L/%%T/%%P\
%%S:\
%s/%%l/%%T/%%P\
%%S:\
%s/%%T/%%P\
%%S:\
%s/%%P\
%%S:\
%s/%%L/%%T/%%N/%%P\
%%S:\
%s/%%l/%%T/%%N/%%P\
%%S:\
%s/%%T/%%N/%%P\
%%S:\
%s/%%L/%%T/%%P\
%%S:\
%s/%%l/%%T/%%P\
%%S:\
%s/%%T/%%P\
%%S:\
%s/%%T/%%P\
%%S";

static char ABSOLUTE_PATH[] = "\
%P\
%S";

String
#ifdef _NO_PROTO
_XmOSInitPath(file_name, env_pathname, user_path)
        String	file_name ;
        String	env_pathname ;
        Boolean * user_path ;
#else
_XmOSInitPath(
        String	file_name,
        String	env_pathname,
	Boolean * user_path)
#endif
{
  String path;
  String old_path;
  char *homedir;
  String local_path;

  *user_path = False ;

  if (file_name[0] == '/') {
      path = XtMalloc(strlen(ABSOLUTE_PATH) + 1);
      strcpy (path, ABSOLUTE_PATH);
  } else {
      local_path = (char *)getenv (env_pathname);
      if (local_path  == NULL) {
	  homedir = _XmOSGetHomeDirName();
	  old_path = (char *)getenv ("XAPPLRESDIR");
	  if (old_path == NULL) {
	      path = XtCalloc(1, 7*strlen(homedir) + strlen(PATH_DEFAULT) 
			         + 6*strlen(libdir) + strlen(incdir) + 1);
	      sprintf(path, PATH_DEFAULT, homedir, homedir, homedir,
		      homedir, homedir, homedir, homedir,
		      libdir, libdir, libdir, libdir, libdir, libdir, incdir);
	  } else {
	      path = XtCalloc(1, 6*strlen(old_path) + 2*strlen(homedir) 
			      + strlen(XAPPLRES_DEFAULT) + 6*strlen (libdir)
			      +	strlen(incdir) + 1);
	      sprintf(path, XAPPLRES_DEFAULT, 
		      old_path, old_path, old_path, old_path, old_path, 
		      old_path, homedir, homedir,
		      libdir, libdir, libdir, libdir, libdir, libdir, incdir);
	  }
      } else {
	  path = XtMalloc(strlen(local_path) + 1);
	  strcpy (path, local_path);
	  *user_path = True ;
      }
  }
  return (path);
}

void
#ifdef _NO_PROTO
_XmSleep( secs )
        unsigned int secs ;
#else
_XmSleep(
        unsigned int secs)
#endif
{   sleep( secs) ;
    }


int
#ifdef _NO_PROTO
_XmMicroSleep( usecs )
        long    usecs ;
#else
_XmMicroSleep(
        long    usecs)
#endif
{
#  ifndef _STRUCT_TIMEVAL
#    define _STRUCT_TIMEVAL
       /* Structure returned by gettimeofday(2) system call and others */
       struct timeval {
       unsigned long  tv_sec;         /* seconds */
       long           tv_usec;        /* and microseconds */
       };
#   endif /* _STRUCT_TIMEVAL */
    struct timeval      timeoutVal;

    timeoutVal.tv_sec = 0;
    timeoutVal.tv_usec = usecs;

    return (select(0, (int *) 0, (int *) 0, (int *) 0, &timeoutVal));
}

/************************************************************************
 *                                                                    *
 *    _XmOSSetLocale   wrapper so vendor can disable call to set       *
 *                    if locale is superset of "C".                   *
 *                                                                    *
 ************************************************************************/

String
#ifdef _NO_PROTO
_XmOSSetLocale(locale)
     String locale;
#else
_XmOSSetLocale(String locale)
#endif
{
  return(setlocale(LC_ALL, locale));
}

/************************************************************************
 *                                                                    *
 *	_XmOSGetLocalizedString	Map an X11 R5 XPCS string in a locale	*
 *				sensitive XmString.			*
 *                                                                    *
 *		reserved	Reserved for future use.		*
 *		widget		The widget id.				*
 *		resource	The resource name.			*
 *		string		The input 8859-1 value.			*
 *                                                                    *
 ************************************************************************/

XmString
#ifdef _NO_PROTO
_XmOSGetLocalizedString( reserved, widget, resource, string)
        char *reserved ;
        Widget widget ;
        char *resource ;
        String string ;
#else
_XmOSGetLocalizedString(
        char *reserved,
        Widget widget,
        char *resource,
        String string)
#endif
{
  return( XmStringCreateLocalized( string)) ;
}


/************************************************************************
 *									*
 *    _XmOSBuildFileName						*
 *									*
 *	Build an absolute file name from a directory and file.		*
 *	Handle case where 'file' is already absolute.
 *	Return value should be freed by XtFree()			*
 *									*
 ************************************************************************/

String
#ifdef _NO_PROTO
_XmOSBuildFileName( path, file)
    String path;
    String file;
#else
_XmOSBuildFileName(
    String path,
    String file)
#endif
{
    String fileName;

    if (file[0] == '/') {
	fileName = XtMalloc (strlen (file) + 1);
	strcpy (fileName, file);
    }
    else {
	fileName = XtMalloc (strlen(path) + strlen (file) + 2);
	strcpy (fileName, path);
	strcat (fileName, "/");
	strcat (fileName, file);
    }

    return (fileName);
}


/************************************************************************
 *									*
 *    _XmOSPutenv							*
 *									*
 *	Provide a standard interface to putenv (BSD) and setenv (SYSV)  *
 *      functions.                                                      *
 *									*
 ************************************************************************/

int
#ifdef _NO_PROTO
_XmOSPutenv( string)
    char *string;
#else
_XmOSPutenv(
    char *string)
#endif
{
#ifndef NO_PUTENV
    return (putenv(string));

#else
    char *value;

    if ( (value = strchr(string, '=')) != NULL)
      {
	char *name  = XtNewString(string);
	int result;

	name[value-string] = '\0';

	result = setenv(name, value+1, 1);
	XtFree(name);
	return result;
      }
    else
      return -1;
#endif
}
