...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmStringHasSubstring 3X "" "" "" ""
.SH NAME
\*LXmStringHasSubstring\*O\(emA compound string function that indicates whether one compound string is contained within another
.iX "XmStringHasSubstring"
.iX "compound string functions" "XmStringHasSubstring"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/Xm.h>
.sp \n(PDu
Boolean XmStringHasSubstring (\*Vstring, substring\*L)
.ta .5i 1.5i
	XmString	\*Vstring\*L;
	XmString	\*Vsubstring\*L;
.wH .fi
.iE
.sE
.SH DESCRIPTION
\*LXmStringHasSubstring\*O
indicates whether or not one compound string is contained within
another.
.VL .75i 
.LI "\*Vstring\*O"
Specifies the compound string to be searched
.LI "\*Vsubstring\*O"
Specifies the compound string to be searched for
.LE
.nL
.ne 10
.SH RETURN VALUE
Returns True if
\*Vsubstring\*O
has a single segment and if its text is completely contained within any
single segment of \*Vstring\*O; otherwise, returns False.
If two compound strings created using \*LXmStringCreateLocalized\*O in
the same language environment satisfy this condition, the function
returns True.  If two compound strings created with the same character
set using \*LXmStringCreate\*O satisfy this condition, the function
returns True.
.SH RELATED INFORMATION
.na
\*LXmStringCreate(3X)\*O and
\*LXmStringCreateLocalized(3X).
.ad
