...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmStringByteCompare 3X "" "" "" ""
.SH NAME
\*LXmStringByteCompare\*O\(emA compound string function that indicates the results of a byte-by-byte comparison
.iX "XmStringByteCompare"
.iX "compound string functions" "XmStringByteCompare"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/Xm.h>
.sp \n(PDu
Boolean XmStringByteCompare (\*Vs1, s2\*L)
.ta .5i 1.5i
	XmString	\*Vs1\*L;
	XmString	\*Vs2\*L;
.wH .fi
.iE
.sE
.SH DESCRIPTION
\*LXmStringByteCompare\*O
returns a Boolean indicating the results of a byte-by-byte
comparison of two compound strings.
.PP
In general, if two compound strings are created with the same (char *)
string using \*LXmStringCreateLocalized\*O in the same language
environment, the compound strings compare as equal.
If two compound strings are created with the same (char *) string and
the same font list element tag set other than \*LXmFONTLIST_DEFAULT_TAG\*O
using \*LXmStringCreate\*O, the strings compare as
equal.
.PP 
In some cases, once a compound string
is put into a widget, that string is converted into an internal form to
allow faster processing.  Part of the conversion process strips out
unnecessary or redundant information.  If an application then does an
\*LXtGetValues\*O to retrieve a compound string from a widget (specifically,
Label and all of its subclasses), it is not guaranteed that the compound
string returned is byte-for-byte the same as the string given to
the widget originally.
.VL .75i 
.LI "\*Vs1\*O"
Specifies a compound string to be compared with \*Vs2\*O
.LI "\*Vs2\*O"
Specifies a compound string to be compared with \*Vs1\*O
.LE 
.SH RETURN VALUE
Returns True if two compound strings are identical byte-by-byte.
.SH RELATED INFORMATION
.na
\*LXmStringCreate(3X)\*O and
\*LXmStringCreateLocalized(3X)\*O.
.ad
