...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmScrollVisible 3X "" "" "" ""
.SH NAME
\*LXmScrollVisible\*O\(emA ScrolledWindow function that makes an invisible
 descendant of a ScrolledWindow work area visible
.iX "XmScrollVisible"
.iX "Scrolled Window functions" "XmScrollVisible"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/ScrolledW.h>
.sp \n(PDu
void XmScrollVisible (\*Vscrollw_widget, widget, left_right_margin, top_bottom_margin\*L)
.ta .5i 1.75i
	Widget	\*Vscrollw_widget\*L;
	Widget	\*Vwidget\*L;
	Dimension	\*Vleft_right_margin\*L;
	Dimension	\*Vtop_bottom_margin\*L;
.iE
.sE
.SH DESCRIPTION
\*LXmScrollVisible\*O makes an obscured or partially obscured
widget or gadget descendant of a ScrolledWindow work area visible.  The 
function repositions the work area and sets the specified margins
between the widget and the nearest viewport boundary.  The widget's
location relative to the viewport determines whether one or both
of the margins must be adjusted.  This function requires that
the \*LXmNscrollingPolicy\*O of the ScrolledWindow widget be set
to \*LXmAUTOMATIC\*O.
.VL .75i
.LI "\*Vscrollw_widget\*O"
Specifies the ID of the ScrolledWindow widget whose work area
window contains an obscured descendant.
.LI "\*Vwidget\*O"
Specifies the ID of the widget to be made visible.
.LI "\*Vleft_right_margin\*O"
Specifies the margin to establish between the left
or right edge of the widget and the associated edge of the
viewport.
This margin is established only if the widget must be moved horizontally
to make it visible.
.LI "\*Vtop_bottom_margin\*O"
Specifies the margin to establish between the top
or bottom edge of the widget and the associated edge of the
viewport.
This margin is established only if the widget must be moved vertically
to make it visible.
.LE
.PP
For a complete definition of ScrolledWindow and its associated
resources, see \*LXmScrolledWindow(3X)\*.
.SH RELATED INFORMATION
.na
\*LXmScrolledWindow(3X)\*O.
.ad
