...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmResolvePartOffsets 3X "" "" "" ""
...\" ______________ start of SML macros ______________
.ds !) CW
.ds !] (CW
.cs \*(!) 20
.bd \*(!) 2
.ds |A Chapter
.nr |P 0
.nr |D 1
.deaS
..
.deaE
..
.deoS
.SP
.ps -1
.ft \\*(!)
.nf
.nr !x 8*\\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.if\\n(.$>0 .in 0
..
.deoE
.ps +1
.ft R
.fi
.SP
..
.deiS
.SP
.ps -1
.ft B
.nf
..
.deiE
.ps +1
.ft R
.fi
.SP
..
.decS
.ig cE
..
.decE
..
.dezA
.SP 1
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (start)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (start)\ \ \\l\\n(|Qu
.br
..
.dezZ
.br
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (end)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (end)\ \ \\l\\n(|Qu
.SP 1
..
.delS
..
.delE
..
.nr Nn 0 1
.denS
.P
.nr Nn +1
.ie\\$1warning .ds yy Warning:\ \
.el.ie\\$1caution .ds yy Caution:\ \
.el.ie\\$1note .ds yy Note:\ \
.el.ie\\$1reviewnote \{\
.	ds yy
.	ps +2
.	ft B
.	P
Review Note To Developers:
.	P
.	ft
.	ps -2 \}
.el.ds yy \\$1:\ \
.ft B
.ll -\w\\*(yyu
.in +\w\\*(yyu
.ti -\w\\*(yyu
\\*(yy\c
.ft
..
.denE
.nr Nn -1
.in -\w\\*(yyu
.ll +\w\\*(yyu
.P
..
.de |F
.ie\\$1table .nr |F 1
.el.nr |F 0
.ie\\n(|D=0&\\n(|F=1 \{\
.	ds L \&\\f(HB
.	ds V \&\\f(HI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fH
.	ds C \&\\f\\*(!]
.	ds U \&\\f(HB
.	ds E \&\\f(HI
'	br \}
.el\{\
.	ds L \&\\fB
.	ds V \&\\fI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fR
.	ds C \&\\f\\*(!]
.	ds U \&\\fB
.	ds E \&\\fI
'	br \}
..
.|F general
.am TS
.|F table
..
.am TE
.|F general
..
.desS
.SP
..
.desE
.SP
..
.defS
.br
\&\fB\\$1(\fP
.nr !+ 1
.nr !% 0
..
.defE
\fB);\fP
.br
.if\\n(!%=1 .in -5i
.nr !+ 0
.nr !% 0
..
.dedS
.if\\n(!+=1 \{\
.	ie \\n(!%=0 .in +.5i
.	el \fB,\fP
'	br \}
.br
\&\fB\\$1\fR
.nr !% 1
..
.dedE
.if\\n(!+=0 \fB;\fR
..
.dekY
.ft B
<\\$1>
.ft
..
.de K,
\fB<\\$1>\fP\\$2
..
.de ,K
\&\\$1\fB<\\$2>\fP
..
.deeM
.ft I
\&\\$1
.ft
..
.de E,
\&\fI\\$1\fP\^\\$2
..
.de ,E
\&\\$1\^\fI\\$2\fP
..
.dedI
.so \\$1
..
.deeI
.nf
.ft CW
.nr !x 8*\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.de !~
so\\$1
\\..
.wh \\n(nlu+\\n(.tu-1v e,
.e:
!~
e;
.ft
.fi
.ch e,
..
.de e:
.eo
.c2 
.cc 
..
.de e;
cc
.c2
.ec
..
.de e,
e;
'bp
.e:
..
.depI
.br
.fl
.rs
.sy includePS "\\$1" "\\$2" "\\$3" > /tmp/pI.tmp.
.so /tmp/pI.tmp.
.sy rm -f /tmp/pI.tmp.
..
.depM
..
.denP
.bp
..
.denL
.br
..
.dewH
..
.rn RS rS
.rn RE rE
.detH
..
.am TH
.|Y TH "\\$1"
..
.am SH
.|Y SH "\\$1"
..
.am SS
.|Y SS "\\$1"
..
.nr Ll 0 1
.nr $A 0 1
.nr $M 0 1
.nr $V 0 1
.de |Y
.if\\n(Ll>0 \{\
.	tm unterminated list (no .LE) -- noticed by the .\\$1 "\\$2"
.	nr Ll 0
'	br \}
..
.rn PP P#
.dePP
.ie(\\n(Ll>0):(\\n(Nn>0) .sp \\n(PDu
.el.P#
..
.deML
.SP
.nr $M +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($M=1 .ds %\\n(Ll \(bu
.el\{\
.	ie t .ds %\\n(Ll \(em
.	el .ds %\\n(Ll --
'	br \}
.ien .ds %\\n(Ll "\ \ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \ \ \\*(%\\n(Ll
.nr #\\n(Ll 0 1
.ds #\\n(Ll M
..
.deVL
.SP
.nr $V +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.ie\\$1 .nr %\\n(Ll 1i
.el.nr %\\n(Ll \\$1n
.ds #\\n(Ll V
..
.deAL
.SP
.nr $A +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($A=1 .af #\\n(Ll 1
.el.ie\\n($A=2 .af #\\n(Ll a
.el.af #\\n(Ll i
.nr #\\n(Ll 0 1
.ds %\\n(Ll \\\\\\\\\\\\\\\\n+(#\\n(Ll
.ien .ds %\\n(Ll "\ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \\*(%\\n(Ll
.ds #\\n(Ll A
..
.deLI
.SP .25
.ie\\*(#\\n(LlV \{\
.	IP "\\$1" \\n(%\\n(Llu
'	br \}
.el.ie\\*(#\\n(LlM \{\
.	IP \\*(%\\n(Ll \\n(%\\n(Llu
'	br \}
.el.IP \\*(%\\n(Ll. \\n(%\\n(Llu
..
.deLE
.ie\\*(#\\n(LlA \{\
.	nr $A -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.ie\\*(#\\n(LlV \{\
.	nr $V -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.if\\*(#\\n(LlM \{\
.	nr $M -1
.	nr Ll -1
.	if \\n(Ll>=0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.SP
..
.deFG
.)F Figure 0 \\n+(Fg "\\$1"
..
.deTB
.)F Table 1 \\n+(Tb "\\$1"
..
.deEC
.)F Equation 2 \\n+(Ec "\\$1"
..
.deEX
.)F Exhibit 3 \\n+(Ex "\\$1"
..
.de )F
.sp \\n(PDu
.ce 1
\\$1\ \\n(H1\(mi\\$3.\ \ \\$4
.sp \\n(PDu
.if\\n(|Z=1 .tm !TOC: .if \\$2=\\\\\\\\$1 .)T 1 1 "\\$1\ \\n(H1\(mi\\$3.\ \ " "\\$4" \\nP \\n(H1
..
.deSP
.br
.nr |Q \\n(PDu
.if\\n(.$ .nr |Q \\$1v
.if!(\\n(nl=\\n(|B) .nr |A 0
.nr |Q -\\n(|Au
.if\\n(|Q \{\
.	sp \\n(|Qu
.	nr |A +\\n(|Qu
'	br \}
.nr |B \\n(nl
..
...\" ______________ end of SML macros ______________
.SH NAME
\*LXmResolvePartOffsets\*O\(emA function that allows writing of upward-compatible applications and widgets
.iX "XmResolvePartOffsets"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/XmP.h>
.sp \n(PDu
void XmResolvePartOffsets (\*Vwidget_class, offset\*L)
.ta .5i 1.5i
	WidgetClass	\*Vwidget_class\*L;
	XmOffsetPtr	\*V* offset\*L;
.wH .fi
.iE
.sE
.SH DESCRIPTION
The use of offset records requires one extra global variable per widget
class.
The variable consists of a pointer to an array of offsets into the
widget record for each part of the widget structure.
The \*LXmResolvePartOffsets\*O function
allocates the offset records needed by an application to guarantee
upward-compatible access to widget instance records by
applications and widgets.
These offset records are used by the widget to access all of the
widget's variables.
A widget needs to take the following steps:
.ML
.LI
Instead of creating a resource list, the widget creates an offset
resource list.
To help you accomplish this, use the \*LXmPartResource\*O
structure and the \*LXmPartOffset\*O macro.
The \*LXmPartResource\*O data structure looks just like a
resource list, but instead of having
one integer for its offset, it has two shorts.
This is put into the class record as if it were a normal resource
list.  Instead of using \*LXtOffset\*O for the offset, the widget uses
\*LXmPartOffset\*O.
.oS
XmPartResource resources[] = {
  { BarNxyz, BarCXyz, XmRBoolean,
    sizeof(Boolean), XmPartOffset(Bar,xyz),
    XmRImmediate, (XtPointer)False }
};
.oE
.LI
Instead of putting the widget size in the class record, the widget puts the
widget part size in the same field.
.LI
Instead of putting \*LXtVersion\*O in the class record, the widget puts
\*LXtVersionDontCheck\*O in the class record.
.LI
The widget defines a variable, of type \*LXmOffsetPtr\*O, to point to
the offset record.
This can be part of the widget's class record or a separate global
variable.
.LI
In class initialization, the widget calls \*LXmResolvePartOffsets\*O,
passing it a pointer to contain the address of the offset
record and the class record.
This does several things:
.PP
Adds the superclass (which, by definition, has already been initialized)
size field to the part size field
.PP
Allocates an array based upon the number of superclasses
.PP
Fills in the offsets of all the widget parts with the appropriate
values, determined by examining the size fields of all superclass
records
.PP
Uses the part offset array to modify the offset entries in the resource
list to be real offsets, in place
.LI
The widget defines a constant which will be the index to its part
structure in the offsets array.
The value should be 1 greater than
the index of the widget's superclass.
Constants defined for all Xm
widgets can be found in \*LXmP.h\*O.
.oS
\&#define BarIndex (XmBulletinBIndex + 1)
.oE
.LI
Instead of accessing fields directly, the widget must always go through
the offset table.
The \*LXmField\*O macro helps you access these fields.
Because the \*LXmPartOffset\*O and \*LXmField\*O
macros concatenate things together, you must
.ne 4
ensure that there is no space
after the part argument.
For example, the following macros do not work because of the space
after the part (Label) argument:
.oS
XmField(w, offset, Label , text, char *)
XmPartOffset(Label , text)
.oE
Therefore, you must not have any spaces after the part (Label)
argument, as illustrated here:
.oS
XmField(w, offset, Label, text, char *)
.oE
You can define macros for each field to make this easier.
Assume an integer field \*Vxyz\*O:
.oS
.ta 0.25i
\&#define BarXyz(w) (*(int *)(((char *) w) + \e
	offset[BarIndex] + XtOffset(BarPart,xyz)))
.oE
.LE 
.PP 
The parameters for \*LXmResolvePartOffsets\*O are defined below:
.VL 1.0i 
.LI "\*Vwidget_class\*O"
Specifies the widget class pointer for the created widget.
.LI "\*Voffset\*O"
Returns the offset record.
.LE
.SH "RELATED INFORMATION"
.na
\*LXmResolveAllPartOffsets(3X)\*O.
.ad
