...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **
.TH XmListPosToBounds 3X "" "" "" ""
.SH NAME
\*LXmListPosToBounds\*O\(emA List function that returns the bounding
box of an item at a specified position in a list
.iX "XmListPosToBounds"
.iX "List functions" "XmListPosToBounds"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/List.h>
.sp \n(PDu
Boolean XmListPosToBounds (\*Vwidget, position, x, y, width, height\*L)
.ta .5i 1.5i
	Widget	\*Vwidget\*L;
	int	\*Vposition\*L;
	Position	*\*Vx\*L;
	Position	*\*Vy\*L;
	Dimension	*\*Vwidth\*L;
	Dimension	*\*Vheight\*L;
.iE
.sE
.SH DESCRIPTION
\*LXmListPosToBounds\*O returns the coordinates
of an item within a list and the dimensions of its bounding
box.  The function returns the associated x and y coordinates
of the upper left corner of the bounding box relative to the
upper left corner of the List widget, as well as the width
and the height of the box.  The caller can pass a NULL value
for the \*Vx\*O, \*Vy\*O, \*Vwidth\*O, or \*Vheight\*O parameters
to indicate that the return value for that parameter is not
requested.
.VL .75i
.LI "\*Vwidget\*O"
Specifies the ID of the List widget.
.LI "\*Vposition\*O"
Specifies the position of the specified item. 
A value of 1 indicates the first item in
the list; a value of 2 indicates the second item; and so on.  A
value of 0 specifies the last item in the list.
.LI "\*Vx\*O"
Specifies a pointer to the returned x coordinate of the item.
.LI "\*Vy\*O"
Specifies the pointer to the returned y coordinate of the item.
.LI "\*Vwidth\*O"
Specifies the pointer to the returned width of the item.
.LI "\*Vheight\*O"
Specifies the pointer to the returned height of the item.
.LE 
.PP
For a complete definition of List and its associated resources, see
\*LXmList(3X)\*O.
.SH RETURN VALUE
If the item at the specified position is not visible, 
returns False, and the returned values (if any) are undefined.  Otherwise,
returns True.
.SH RELATED INFORMATION
.na
\*LXmList(3X)\*O and
\*LXmListYToPos(3X)\*O.
.ad
