...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmLabelGadget 3X "" "" "" ""
.SH NAME
\*LXmLabelGadget\*O\(emThe LabelGadget widget class
.iX "XmLabelGadget"
.iX "widget class" "LabelGadget"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/LabelG.h>
.iE
.sE
.SH DESCRIPTION
LabelGadget is an instantiable widget and is also used as a superclass for
other button gadgets, such as PushButtonGadget and ToggleButtonGadget.
.PP 
LabelGadget can contain either text or a pixmap.  LabelGadget text is a
compound string.
Refer to the \*VOSF/Motif Programmer's\*O
Guide\*O for more information on compound strings.
The text can be multilingual,
multiline, and/or multifont.  When a LabelGadget is insensitive, its text is
stippled, or the user-supplied insensitive pixmap is displayed.
.PP 
LabelGadget supports both accelerators and mnemonics primarily for use in
LabelGadget subclass widgets that are contained in
menus.  Mnemonics are available in
a  menu system when the button is visible.  Accelerators in a
menu system are accessible even when the button is not visible.
The LabelGadget displays the mnemonic by underlining the first matching
character in the text string.  The accelerator is displayed
as a text string adjacent to the label text or pixmap.
.PP
LabelGadget consists of many margin fields surrounding the text or
pixmap.
These margin fields are resources that may
be set by the user, but LabelGadget subclasses and Manager parents also
modify some of these fields.  They tend to modify the
\*LXmNmarginLeft\*O, \*LXmNmarginRight\*O, \*LXmNmarginTop\*O, and
\*LXmNmarginBottom\*O resources and leave the \*LXmNmarginWidth\*O and
\*LXmNmarginHeight\*O resources as set by the application.
.PP
LabelGadget takes into account \*LXmNshadowThickness\*O in determining
its layout but does not draw the shadow.
That is, if \*LXmNshadowThickness\*O is greater than 0, LabelGadget
leaves space for the shadow, but the shadow does not appear.
.PP 
In a LabelGadget \*LXmNtraversalOn\*O and \*LXmNhighlightOnEnter\*O are
forced to False inside Popup MenuPanes, Pulldown MenuPanes, and
OptionMenus.
Otherwise these resources default to False.
.SS "Classes"
LabelGadget inherits behavior and
resources from \*LObject\*O, \*LRectObj\*O and \*LXmGadget\*O classes.
.PP 
The class pointer is \*LxmLabelGadgetClass\*O.
.PP 
The class name is \*LXmLabelGadget\*O.
.SS "New Resources"
The following table defines a set of widget resources used by the programmer
to specify data.  The programmer can also set the resource values for the
inherited classes to set attributes for this widget.  To reference a
resource by name or by class in a .Xdefaults file, remove the \*LXmN\*O or
\*LXmC\*O prefix and use the remaining letters.  To specify one of the defined
values for a resource in a .Xdefaults file, remove the \*LXm\*O prefix and use
the remaining letters (in either lowercase or uppercase, but include any
underscores between words).
The codes in the access column indicate if the given resource can be
set at creation time (C),
set by using \*LXtSetValues\*O (S),
retrieved by using \*LXtGetValues\*O (G), or is not applicable (N/A).
.P 
.wH .in 0 
.TS 
center allbox;
cBp9 ssss
lBp8 lBp8 lBp8 lBp8 lBp8
lp8 lp8 lp8 lp8 lp8.
XmLabelGadget Resource Set
Name	Class	Type	Default	Access
_
XmNaccelerator	XmCAccelerator	String	NULL	CSG
XmNacceleratorText	XmCAcceleratorText	XmString	NULL 	CSG
XmNalignment	XmCAlignment	unsigned char	dynamic	CSG
XmNfontList	XmCFontList	XmFontList	dynamic	CSG
XmNlabelInsensitivePixmap	XmCLabelInsensitivePixmap	Pixmap	XmUNSPECIFIED_PIXMAP	CSG
XmNlabelPixmap	XmCLabelPixmap	Pixmap	XmUNSPECIFIED_PIXMAP	CSG
XmNlabelString	XmCXmString	XmString	dynamic	CSG
XmNlabelType	XmCLabelType	unsigned char	XmSTRING	CSG
XmNmarginBottom	XmCMarginBottom	Dimension	0	CSG
XmNmarginHeight	XmCMarginHeight	Dimension	2	CSG
XmNmarginLeft	XmCMarginLeft	Dimension	0	CSG
XmNmarginRight	XmCMarginRight	Dimension	0	CSG
XmNmarginTop	XmCMarginTop	Dimension	0	CSG
XmNmarginWidth	XmCMarginWidth	Dimension	2	CSG
.wH .tH
XmNmnemonic	XmCMnemonic	KeySym	NULL	CSG
XmNmnemonicCharSet	XmCMnemonicCharSet	String	dynamic	CSG
XmNrecomputeSize	XmCRecomputeSize	Boolean	True	CSG
XmNstringDirection	XmCStringDirection	XmStringDirection	dynamic	CSG
.TE
.wH .in  
.VL  
.LI "\*LXmNaccelerator\*O"
Sets the accelerator on a button widget in a menu, which
activates a visible or invisible, but managed, button from the keyboard.
This resource is a string that describes a set of modifiers
and the key that may be used to select the button.
The format of this string
is identical to that used by the translations manager, with the exception
that only a single event may be specified and only \*LKeyPress\*O events are
allowed.
.PP
Accelerators for buttons are supported only for
PushButtonGadgets and ToggleButtonGadgets in Pulldown and Popup menus.
.LI "\*LXmNacceleratorText\*O"
Specifies the text displayed
for the accelerator.
The text is displayed adjacent to the label
string or pixmap.
Accelerator text for buttons is displayed only for
PushButtonGadgets and ToggleButtonGadgets in Pulldown and Popup Menus.
.LI "\*LXmNalignment\*O"
Specifies the label alignment for text or pixmap.
.wH .rS 
.ML
.LI
\*LXmALIGNMENT_BEGINNING\*O (left alignment)\(emcauses the left sides of
the lines of text to be vertically aligned with the
left edge of the gadget.  For a pixmap, its left side is vertically
aligned with the left edge of the gadget.
.nL
.ne 4
.LI
\*LXmALIGNMENT_CENTER\*O (center alignment)\(emcauses the centers of the
lines of text to be vertically aligned in the center
of the gadget.  For a pixmap, its center is vertically aligned with the
center of the gadget.
.LI
\*LXmALIGNMENT_END\*O (right alignment)\(emcauses the right sides of the
lines of text to be vertically aligned with the
right edge of the gadget.  For a pixmap, its right side is
vertically aligned with the right edge of the gadget.
.LE 
.wH .rE
.PP
The above descriptions for text are correct when \*LXmNstringDirection\*O is
\*LXmSTRING_DIRECTION_L_TO_R\*O; the descriptions for
\*LXmALIGNMENT_BEGINNING\*O and \*LXmALIGNMENT_END\*O are switched when the
resource is \*LXmSTRING_DIRECTION_R_TO_L\*O.
.PP
If the parent is a RowColumn whose \*LXmNisAligned\*O resource is True,
\*LXmNalignment\*O is forced to the same value as the RowColumn's
\*LXmNentryAlignment\*O if the RowColumn's \*LXmNrowColumnType\*O is
\*LXmWORK_AREA\*O or if the gadget is a subclass of XmLabelGadget.
Otherwise, the default is \*LXmALIGNMENT_CENTER\*O.
.LI "\*LXmNfontList\*O"
Specifies the font of the text used in the gadget.  If this value is
NULL at initialization, the font list is initialized by looking up the
parent hierarchy of the widget for an ancestor that is a subclass of the
XmBulletinBoard, VendorShell, or XmMenuShell widget class.  If such
an ancestor is found, the font list is initialized to the
\*LXmNbuttonFontList\*O (for button gadget subclasses) or
\*LXmNlabelFontList\*O of the ancestor widget.  If no such ancestor
is found, the default is implementation dependent.  Refer to
\*LXmFontList(3X)\*O for more information on the creation and
structure of a font list.
.LI "\*LXmNlabelInsensitivePixmap\*O"
Specifies a pixmap used as the button face if \*LXmNlabelType\*O is
\*LXmPIXMAP\*O and the button is insensitive.
The default value, \*LXmUNSPECIFIED_PIXMAP\*O, displays an empty label.
.LI "\*LXmNlabelPixmap\*O"
Specifies the pixmap when \*LXmNlabelType\*O is
\*LXmPIXMAP\*O.
The default value, \*LXmUNSPECIFIED_PIXMAP\*O, displays an empty label.
.LI "\*LXmNlabelString\*O"
Specifies the compound string when \*LXmNlabelType\*O is \*LXmSTRING\*O.
If this value is NULL, it is initialized by converting the name of the
gadget to a compound string.
Refer to \*LXmString(3X)\*O
for more information on the
creation and the structure of compound strings.
.nL
.ne 4
.LI "\*LXmNlabelType\*O"
Specifies the label type.
.ML
.LI
\*LXmSTRING\*O - text displays \*LXmNlabelString\*O
.LI
\*LXmPIXMAP\*O - icon data in pixmap displays \*LXmNlabelPixmap\*O or
\*LXmNlabelInsensitivePixmap\*O
.LE 
.LI "\*LXmNmarginBottom\*O"
Specifies the amount of spacing between the bottom of the label text
and the top of the bottom margin specified by \*LXmNmarginHeight\*O.
This may be modified by LabelGadget's subclasses.
For example, CascadeButtonGadget may increase this field to make room
for the cascade pixmap.
.LI "\*LXmNmarginHeight\*O"
Specifies an equal amount of spacing above the margin
defined by \*LXmNmarginTop\*O and below the margin defined by
\*LXmNmarginBottom\*O. \*LXmNmarginHeight\*O specifies the amount
of spacing between the top edge of the margin set by \*LXmNmarginTop\*O
and the bottom edge of the top shadow, and the amount of spacing between
the bottom edge of the margin specified by \*LXmNmarginBottom\*O and the
top edge of the bottom shadow.
.LI "\*LXmNmarginLeft\*O"
Specifies the amount of spacing
between the left edge of the label text and the right side of the left
margin (specified by \*LXmNmarginWidth\*O).
This may be modified by LabelGadget's subclasses.
For example, ToggleButtonGadget may increase this field to make room for
the toggle indicator and for spacing between the indicator and label.
Whether this actually applies to the left or right side of the label may
depend on the value of \*LXmNstringDirection\*O.
.LI "\*LXmNmarginRight\*O"
Specifies the amount of spacing
between the right edge of the label text and the left side of the right
margin (specified by \*LXmNmarginWidth\*O).
This may be modified by LabelGadget's subclasses.
For example, CascadeButtonGadget may increase this field to make room
for the cascade pixmap.
Whether this actually applies to the left or right side of the label may
depend on the value of \*LXmNstringDirection\*O.
.nL
.ne 5
.LI "\*LXmNmarginTop\*O"
Specifies the amount of spacing between the top of the label text and
the bottom of the top margin specified by \*LXmNmarginHeight\*O.
This may be modified by LabelGadget's subclasses.
For example, CascadeButtonGadget may increase this field to make room
for the cascade pixmap.
.LI "\*LXmNmarginWidth\*O"
Specifies an equal amount of spacing to the left of the margin defined
by \*LXmNmarginLeft\*O and to the right of the margin defined by
\*LXmNmarginRight\*O.  \*LXmNmarginWidth\*O specifies the amount
of spacing between the left edge of the margin set by \*LXmNmarginLeft\*O
and the right edge of the left shadow, and the amount of spacing between
the right edge of the margin specified by \*LXmNmarginRight\*O and the
left edge of the right shadow.
.LI "\*LXmNmnemonic\*O"
Provides the user with an alternate means of activating a button.
A button in a MenuBar, a Popup MenuPane, or a Pulldown
MenuPane can have a mnemonic.
.PP
This resource contains a keysym as listed in the X11 keysym table.
The first character in the label string that exactly matches
the mnemonic in the character set specified in
\*LXmNmnemonicCharSet\*O
is underlined when the button is displayed.
.PP
When a mnemonic has been specified, the user activates the button by
pressing the mnemonic key while the button is visible.
If the button is a CascadeButtonGadget in a MenuBar and the MenuBar does
not have the focus, the user must use the \*LMAlt\*O modifier while
pressing the mnemonic.
The user can activate the button by pressing either the shifted or the
unshifted mnemonic key.
.nL
.ne 4
.LI "\*LXmNmnemonicCharSet\*O"
Specifies the character set of the mnemonic for the label.
The default is \*LXmFONTLIST_DEFAULT_TAG\*O.
.nL
.ne 12
.LI "\*LXmNrecomputeSize\*O"
Specifies a Boolean value that indicates whether the gadget
shrinks or expands to accommodate its contents (label string or
pixmap) as a result of an \*LXtSetValues\*O resource value that
would change the size of the gadget.  If True, the gadget shrinks
or expands to exactly fit the label string or pixmap.
If False, the gadget never attempts to change size on its own.
.LI "\*LXmNstringDirection\*O"
Specifies the direction in which the string is to be drawn.  The
following are the values:
.ML
.LI
\*LXmSTRING_DIRECTION_L_TO_R\*O - left to right
.LI
\*LXmSTRING_DIRECTION_R_TO_L\*O - right to left
.LE 
.PP
The default for this resource is determined at creation time.
If no value is specified for this resource and the widget's parent is a
manager, the value is inherited from the parent; otherwise, it defaults
to \*LXmSTRING_DIRECTION_L_TO_R\*O.
.LE 
.SS "Inherited Resources"
LabelGadget inherits behavior and resources from the following
superclasses.  For a complete description of each resource, refer to the
man page for that superclass.
.P 
.TS 
center allbox;
cBp9 ssss
lBp8 lBp8 lBp8 lBp8 lBp8
lp8 lp8 lp8 lp8 lp8.
XmGadget Resource Set
Name	Class	Type	Default	Access
_
XmNbottomShadowColor	XmCBottomShadowColor	Pixel	dynamic	G
XmNhelpCallback	XmCCallback	XtCallbackList	NULL	C
XmNhighlightColor	XmCHighlightColor	Pixel	dynamic	G
XmNhighlightOnEnter	XmCHighlightOnEnter	Boolean	False	CSG
XmNhighlightThickness	XmCHighlightThickness	Dimension	0	CSG
XmNnavigationType	XmCNavigationType	XmNavigationType	XmNONE	CSG
XmNshadowThickness	XmCShadowThickness	Dimension	0	CSG
XmNtopShadowColor	XmCTopShadowColor	Pixel	dynamic	G
XmNtraversalOn	XmCTraversalOn	Boolean	False	CSG
XmNunitType	XmCUnitType	unsigned char	dynamic	CSG
XmNuserData	XmCUserData	XtPointer	NULL	CSG
.TE
.P 
.TS 
center allbox;
cBp9 ssss
lBp8 lBp8 lBp8 lBp8 lBp8
lp8 lp8 lp8 lp8 lp8.
RectObj Resource Set
Name	Class	Type	Default	Access
_
XmNancestorSensitive	XmCSensitive	Boolean	dynamic	G
XmNborderWidth	XmCBorderWidth	Dimension	0	CSG
XmNheight	XmCHeight	Dimension	dynamic	CSG
XmNsensitive	XmCSensitive	Boolean	True	CSG
XmNwidth	XmCWidth	Dimension	dynamic	CSG
XmNx	XmCPosition	Position	0	CSG
XmNy	XmCPosition	Position	0	CSG
.TE
.P 
.TS 
center allbox;
cBp9 ssss
lBp8 lBp8 lBp8 lBp8 lBp8
lp8 lp8 lp8 lp8 lp8.
Object Resource Set
Name	Class	Type	Default	Access
_
XmNdestroyCallback	XmCCallback	XtCallbackList	NULL	C
.TE
.SS "Behavior"
XmLabelGadget includes behavior from XmGadget.
Additional XmLabelGadget behavior is described below:
.VL  
.LI "\*LBDrag\ Press\*O:"
Drags the contents of a LabelGadget, identified by
pressing \*LBDrag\*O.  This action creates a DragContext object
whose \*LXmNexportTargets\*O resource is set to "COMPOUND_TEXT" for
a label type of \*LXmSTRING\*O; otherwise, "PIXMAP" if the
label type is \*LXmPIXMAP\*O.  This action is undefined for
LabelGadgets used in a menu system.
.LI "\*LKHelp\*O:"
In a Popup or Pulldown MenuPane, unposts all menus in the menu hierarchy
and, when the shell's keyboard focus policy is \*LXmEXPLICIT\*O,
restores keyboard focus to the widget that had the focus before the
menu system was entered.
Calls the callbacks for \*LXmNhelpCallback\*O if any exist.
If there are no help
callbacks for this widget, this action calls the help callbacks
for the nearest ancestor that has them.
.LI "\*LMAny\ KCancel\*O:"
In a MenuBar, disarms the CascadeButton and the menu and, when the
shell's keyboard focus policy is \*LXmEXPLICIT\*O, restores keyboard
focus to the widget that had the focus before the menu was entered.
.P
In a toplevel Pulldown MenuPane from a MenuBar, unposts the menu,
disarms the MenuBar CascadeButton and the MenuBar, and, when the shell's
keyboard focus policy is \*LXmEXPLICIT\*O, restores keyboard focus to
the widget that had the focus before the MenuBar was entered.
In other Pulldown MenuPanes, unposts the menu.
.P
In a Popup MenuPane, unposts the menu and, when the shell's keyboard
focus policy is \*LXmEXPLICIT\*O, restores keyboard focus to the widget
from which the menu was posted.
.LI "\*LKDown\*O:"
If the current menu item has a submenu and is in a MenuBar, then this
action posts the submenu, disarms the current menu item, and arms
the submenu's first traversable menu item.
.P
If the current menu item is in a MenuPane, then this action disarms the
current menu item and arms the item below it.  This action wraps within the
MenuPane.  When the current menu item is at the MenuPane's
bottom edge, then this action wraps to the topmost menu item in the column
to the right, if one exists.  When the current menu item is at the bottom,
rightmost corner of the MenuPane, then this action wraps to the tear-off
control, if present, or to the top, leftmost menu item.
.LI "\*LKLeft\*O:"
When the current menu item is in a MenuBar, then this action disarms the
current item and arms the MenuBar item to the left.
This action wraps within the MenuBar.
.P
In MenuPanes, if the current menu item is not at the left edge of a MenuPane,
this action disarms the current item and arms the item to its left.
If the current menu item is at the left edge of a submenu attached to a
MenuBar item, then this action unposts the submenu and traverses to the
MenuBar item to the left, wrapping if necessary.  If that MenuBar item
has a submenu, it posts the submenu and arms the first traversable
item in the submenu.
If the current menu item is at the left edge of a submenu not directly
attached to a MenuBar item, then this action unposts the current submenu only.
.P
In Popup or Torn-off MenuPanes, when the current menu item is at the
left edge, this  action wraps within the MenuPane.  If the current menu
item is at the left edge of the MenuPane and not in the top row, this
action wraps to the rightmost menu item in the row above.  If the current
menu item is in the upper, leftmost corner, this action wraps
to the tear-off control, if present, or else it wraps to the bottom,
rightmost menu item in the MenuPane.
.LI "\*LKRight\*O:"
If the current menu item is in a MenuBar, then this action disarms the
current item and arms the MenuBar item to the right.
This action wraps within the MenuBar.
.P
In MenuPanes, if the current menu item is a CascadeButton, then this
action posts its associated submenu.
If the current menu item is not a CascadeButton and is not at the right
edge of a MenuPane, this action disarms the current item and arms the
item to its right, wrapping if necessary.
If the current menu item is not a CascadeButton and is at the right edge of a
submenu that is a descendent of a MenuBar, then this action unposts all
submenus and traverses to the MenuBar item to the right.
If that MenuBar item has a submenu, it posts the submenu and arms
the submenu's first traversable item.
.P
In Popup or Torn-off menus, if the current menu item is not a
CascadeButton and is at the right edge of a row (except the
bottom row), this action wraps to the leftmost menu item in the
row below.  If the current menu item is not a CascadeButton and
is in the bottom, rightmost corner of a Popup or Pulldown MenuPane, this
action wraps to the tear-off control, if present, or else it wraps to
the top, leftmost menu item of the MenuPane.
.LI "\*LKUp\*O:"
When the current menu item is in a MenuPane, then
this action disarms the current menu item and arms the item above it.  This
action wraps within the MenuPane.  When the current menu item is at the
MenuPane's top edge, then this action wraps to the bottommost menu item in the
column to the left, if one exists.  When the current menu item is at the top,
leftmost corner of the MenuPane, then this action wraps to the tear-off
control, if present, or to the bottom, rightmost menu item.
.LE
.SS "Virtual Bindings"
The bindings for virtual keys are vendor specific.
For information about bindings for virtual buttons and keys, see \*LVirtualBindings(3X)\*O.
.nL
.ne 10
.SH RELATED INFORMATION
.na
\*LObject(3X)\*O, \*LRectObj(3X)\*O,
\*LXmCreateLabelGadget(3X)\*O, \*LXmFontListCreate(3X)\*O,
\*LXmStringCreate(3X)\*O,
\*LXmStringCreateLtoR(3X)\*O,
and \*LXmGadget(3X)\*O.
.ad
