...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmIsTraversable 3X "" "" "" ""
.SH NAME
\*LXmIsTraversable\*O\(emA function that identifies whether a widget can
be traversed
.iX "XmIsTraversable"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/Xm.h>
.sp \n(PDu
Boolean XmIsTraversable (\*Vwidget\*L)
.ta .5i 1.5i
	Widget	\*Vwidget\*L;
.iE
.sE
.SH DESCRIPTION
\*LXmIsTraversable\*O determines whether the specified widget is
eligible to receive focus through keyboard traversal.
In general, a widget is eligible to receive focus when all of the
following conditions are true:
.ML
.LI
The widget and its ancestors are not being destroyed, are sensitive, and
have a value of True for \*LXmNtraversalOn\*O.
.LI
The widget and its ancestors are realized, managed, and (except for
gadgets) mapped.
.LI
Some part of the widget's rectangular area is unobscured by the widget's
ancestors, or some part of the widget's rectangular area is inside the
work window (but possibly outside the clip window) of a ScrolledWindow
whose \*LXmNscrollingPolicy\*O is \*LXmAUTOMATIC\*O and whose
\*LXmNtraverseObscuredCallback\*O is not NULL.
.LE
.PP
Some widgets may not be eligible to receive focus even if they meet all
these conditions.
For example, most managers cannot receive focus through keyboard traversal.
Some widgets may be eligible to receive focus under particular
conditions.
For example, a DrawingArea is eligible to receive focus if it meets the
conditions above and has no child whose \*LXmNtraversalOn\*O resource is
True.
.VL .75i
.LI "\*Vwidget\*O"
Specifies the ID of the widget 
.LE
.SH RETURN VALUE
Returns True if the widget is eligible to receive focus through keyboard
traversal; otherwise, returns False.
.SH RELATED INFORMATION
.na
\*LXmGetVisibility(3X)\*O and \*LXmProcessTraversal(3X)\*O.
.ad
