...\" **
...\" **
...\" **  (c) Copyright 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **
.TH XmGetSecondaryResourceData 3X "" "" "" ""
.SH NAME
\*LXmGetSecondaryResourceData\*O\(emA function that provides access to secondary widget resource data
.iX "XmGetSecondaryResourceData"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/Xm.h>
.sp \n(PDu
Cardinal XmGetSecondaryResourceData (\*Vwidget_class, secondary_data_return\*L)
.ta .5i 2.5i
	WidgetClass	\*Vwidget_class\*L;
	XmSecondaryResourceData	**\*Vsecondary_data_return\*L;
.iE
.sE
.SH DESCRIPTION
Some Motif widget classes (such as Gadget, Text, and VendorShell) have
resources that are not accessible via the functions
\*LXtGetResourceList\*O and \*LXtGetConstraintResourceList\*O.
In order to retrieve the descriptions of these resources, an application
must use \*LXmGetSecondaryResourceData\*O.
.PP
When a widget class has such resources, this function provides
descriptions of the resources in one or more data structures.
\*LXmGetSecondaryResourceData\*O takes a widget class argument and
returns the number of these data structures associated with the widget
class.
If the return value is greater than 0, the function allocates and fills
an array of pointers to the corresponding data structures.
It returns this array at the address that is the value of the
\*Vsecondary_data_return\*O argument.
.PP
The type \*LXmSecondaryResourceData\*O is a pointer to a structure with
two members that are useful to an application: \*Vresources\*O, of type
\*LXtResourceList\*O, and \*Vnum_resources\*O, of type \*LCardinal\*O.
The \*Vresources\*O member is a list of the widget resources that are
not accessible using Xt functions.
The \*Vnum_resources\*O member is the length of the \*Vresources\*O
list.
.PP
If the return value is greater than 0, \*LXmGetSecondaryResourceData\*O
allocates memory that the application must free.
Use \*LXtFree\*O to free the resource list in each structure (the value
of the \*Vresources\*O member), the structures themselves, and the array
of pointers to the structures (the array whose address is
\*Vsecondary_data_return\*O).
.VL .75i
.LI "\*Vwidget_class\*O"
Specifies the widget class for which secondary resource data is to be
retrieved.
.LI "\*Vsecondary_data_return\*O"
Specifies a pointer to an array of \*LXmSecondaryResourceData\*O
pointers to be returned by this function.
If the widget class has no secondary resource data (i.e., if the value
returned by the function is 0), the function returns no meaningful value
for this argument.
.LE
.SH RETURN VALUE
Returns the number of secondary resource data structures associated with
this widget class.
.SH EXAMPLE
The following example uses \*LXmGetSecondaryResourceData\*O to print the
names of the secondary resources of the Motif Text widget and then frees
the data allocated by the function:
.oS
XmSecondaryResourceData * block_array ;
Cardinal num_blocks, i, j ;
if (num_blocks = XmGetSecondaryResourceData (xmTextWidgetClass, 
                                             &block_array)) {
  for (i = 0; i < num_blocks; i++) {
    for (j = 0 ; j < block_array[i]->num_resources; j++) {
      printf("%s\en", block_array[i]->resources[j].resource_name);
    }
    XtFree((char*)block_array[i]->resources);
    XtFree((char*)block_array[i]);
  }
  XtFree((char*)block_array);
}
.oE
