...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
.TH XmFileSelectionBox 3X "" "" "" ""
...\" ______________ start of SML macros ______________
.ds !) CW
.ds !] (CW
.cs \*(!) 20
.bd \*(!) 2
.ds |A Chapter
.nr |P 0
.nr |D 1
.deaS
..
.deaE
..
.deoS
.SP
.ps -1
.ft \\*(!)
.nf
.nr !x 8*\\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.if\\n(.$>0 .in 0
..
.deoE
.ps +1
.ft R
.fi
.SP
..
.deiS
.SP
.ps -1
.ft B
.nf
..
.deiE
.ps +1
.ft R
.fi
.SP
..
.decS
.ig cE
..
.decE
..
.dezA
.SP 1
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (start)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (start)\ \ \\l\\n(|Qu
.br
..
.dezZ
.br
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (end)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (end)\ \ \\l\\n(|Qu
.SP 1
..
.delS
..
.delE
..
.nr Nn 0 1
.denS
.P
.nr Nn +1
.ie\\$1warning .ds yy Warning:\ \
.el.ie\\$1caution .ds yy Caution:\ \
.el.ie\\$1note .ds yy Note:\ \
.el.ie\\$1reviewnote \{\
.	ds yy
.	ps +2
.	ft B
.	P
Review Note To Developers:
.	P
.	ft
.	ps -2 \}
.el.ds yy \\$1:\ \
.ft B
.ll -\w\\*(yyu
.in +\w\\*(yyu
.ti -\w\\*(yyu
\\*(yy\c
.ft
..
.denE
.nr Nn -1
.in -\w\\*(yyu
.ll +\w\\*(yyu
.P
..
.de |F
.ie\\$1table .nr |F 1
.el.nr |F 0
.ie\\n(|D=0&\\n(|F=1 \{\
.	ds L \&\\f(HB
.	ds V \&\\f(HI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fH
.	ds C \&\\f\\*(!]
.	ds U \&\\f(HB
.	ds E \&\\f(HI
'	br \}
.el\{\
.	ds L \&\\fB
.	ds V \&\\fI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fR
.	ds C \&\\f\\*(!]
.	ds U \&\\fB
.	ds E \&\\fI
'	br \}
..
.|F general
.am TS
.|F table
..
.am TE
.|F general
..
.desS
.SP
..
.desE
.SP
..
.defS
.br
\&\fB\\$1(\fP
.nr !+ 1
.nr !% 0
..
.defE
\fB);\fP
.br
.if\\n(!%=1 .in -5i
.nr !+ 0
.nr !% 0
..
.dedS
.if\\n(!+=1 \{\
.	ie \\n(!%=0 .in +.5i
.	el \fB,\fP
'	br \}
.br
\&\fB\\$1\fR
.nr !% 1
..
.dedE
.if\\n(!+=0 \fB;\fR
..
.dekY
.ft B
<\\$1>
.ft
..
.de K,
\fB<\\$1>\fP\\$2
..
.de ,K
\&\\$1\fB<\\$2>\fP
..
.deeM
.ft I
\&\\$1
.ft
..
.de E,
\&\fI\\$1\fP\^\\$2
..
.de ,E
\&\\$1\^\fI\\$2\fP
..
.dedI
.so \\$1
..
.deeI
.nf
.ft CW
.nr !x 8*\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.de !~
so\\$1
\\..
.wh \\n(nlu+\\n(.tu-1v e,
.e:
!~
e;
.ft
.fi
.ch e,
..
.de e:
.eo
.c2 
.cc 
..
.de e;
cc
.c2
.ec
..
.de e,
e;
'bp
.e:
..
.depI
.br
.fl
.rs
.sy includePS "\\$1" "\\$2" "\\$3" > /tmp/pI.tmp.
.so /tmp/pI.tmp.
.sy rm -f /tmp/pI.tmp.
..
.depM
..
.denP
.bp
..
.denL
.br
..
.dewH
..
.rn RS rS
.rn RE rE
.detH
..
.am TH
.|Y TH "\\$1"
..
.am SH
.|Y SH "\\$1"
..
.am SS
.|Y SS "\\$1"
..
.nr Ll 0 1
.nr $A 0 1
.nr $M 0 1
.nr $V 0 1
.de |Y
.if\\n(Ll>0 \{\
.	tm unterminated list (no .LE) -- noticed by the .\\$1 "\\$2"
.	nr Ll 0
'	br \}
..
.rn PP P#
.dePP
.ie(\\n(Ll>0):(\\n(Nn>0) .sp \\n(PDu
.el.P#
..
.deML
.SP
.nr $M +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($M=1 .ds %\\n(Ll \(bu
.el\{\
.	ie t .ds %\\n(Ll \(em
.	el .ds %\\n(Ll --
'	br \}
.ien .ds %\\n(Ll "\ \ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \ \ \\*(%\\n(Ll
.nr #\\n(Ll 0 1
.ds #\\n(Ll M
..
.deVL
.SP
.nr $V +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.ie\\$1 .nr %\\n(Ll 1i
.el.nr %\\n(Ll \\$1n
.ds #\\n(Ll V
..
.deAL
.SP
.nr $A +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($A=1 .af #\\n(Ll 1
.el.ie\\n($A=2 .af #\\n(Ll a
.el.af #\\n(Ll i
.nr #\\n(Ll 0 1
.ds %\\n(Ll \\\\\\\\\\\\\\\\n+(#\\n(Ll
.ien .ds %\\n(Ll "\ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \\*(%\\n(Ll
.ds #\\n(Ll A
..
.deLI
.SP .25
.ie\\*(#\\n(LlV \{\
.	IP "\\$1" \\n(%\\n(Llu
'	br \}
.el.ie\\*(#\\n(LlM \{\
.	IP \\*(%\\n(Ll \\n(%\\n(Llu
'	br \}
.el.IP \\*(%\\n(Ll. \\n(%\\n(Llu
..
.deLE
.ie\\*(#\\n(LlA \{\
.	nr $A -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.ie\\*(#\\n(LlV \{\
.	nr $V -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.if\\*(#\\n(LlM \{\
.	nr $M -1
.	nr Ll -1
.	if \\n(Ll>=0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.SP
..
.deFG
.)F Figure 0 \\n+(Fg "\\$1"
..
.deTB
.)F Table 1 \\n+(Tb "\\$1"
..
.deEC
.)F Equation 2 \\n+(Ec "\\$1"
..
.deEX
.)F Exhibit 3 \\n+(Ex "\\$1"
..
.de )F
.sp \\n(PDu
.ce 1
\\$1\ \\n(H1\(mi\\$3.\ \ \\$4
.sp \\n(PDu
.if\\n(|Z=1 .tm !TOC: .if \\$2=\\\\\\\\$1 .)T 1 1 "\\$1\ \\n(H1\(mi\\$3.\ \ " "\\$4" \\nP \\n(H1
..
.deSP
.br
.nr |Q \\n(PDu
.if\\n(.$ .nr |Q \\$1v
.if!(\\n(nl=\\n(|B) .nr |A 0
.nr |Q -\\n(|Au
.if\\n(|Q \{\
.	sp \\n(|Qu
.	nr |A +\\n(|Qu
'	br \}
.nr |B \\n(nl
..
...\" ______________ end of SML macros ______________
.SH NAME
\*LXmFileSelectionBox\*O\(emThe FileSelectionBox widget class
.iX "XmFileSelectionBox"
.iX "widget class" "FileSelectionBox"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/FileSB.h>
.iE
.sE
.SH DESCRIPTION
FileSelectionBox traverses
through directories, views the files and subdirectories in them,
and then selects files.
.PP 
A FileSelectionBox has five main areas:
.ML
.LI
A text input field for displaying and editing a directory mask used to
select the files to be displayed
.LI
A scrollable list of filenames
.LI
A scrollable list of subdirectories
.LI
A text input field for displaying and editing a filename
.LI
A group of PushButtons,
labeled \*LOK\*O, \*LFilter\*O, \*LCancel\*O, and \*LHelp\*O
.LE 
.PP
Additional children may be added to the FileSelectionBox after
creation.
FileSelectionBox inherits the layout functionality provided
by SelectionBox for any additional children.
The list of filenames, the list of subdirectories, or both can be
removed from the FileSelectionBox after creation by unmanaging the
appropriate widgets and their labels.
The list and label widgets are obtained by calling the
.ne 5
function \*LXmFileSelectionBoxGetChild\*O.
To remove either the directory list or the file list, unmanage the
parent of the appropriate list widget and unmanage the corresponding
label.
.PP
The user can specify resources in a resource file for the automatically
created widgets and gadgets of FileSelectionBox.  The following list
identifies the names of these widgets (or gadgets) and the associated
FileSelectionBox areas.
.PP
        Filter Label\(em"FilterLabel"
.PP
        Filter Text\(em"Text"
.PP
        Directory List\(em"DirList"
.PP
        Directory List Label\(em"Dir"
.PP 
The directory mask is a string specifying the base directory to be
examined and a search pattern.
Ordinarily, the directory list displays the subdirectories of the base
directory, as well as the base directory itself and its parent
directory.
The file list ordinarily displays all files and/or subdirectories in the
base directory that match the search pattern.
.PP 
A procedure specified by the \*LXmNqualifySearchDataProc\*O resource
extracts the base directory and search pattern from the directory mask.
If the directory specification is empty, the current working directory
is used.
If the search pattern is empty, a pattern that matches all files is
used.
.PP 
An application can supply its own \*LXmNqualifySearchDataProc\*O as well
as its own procedures to search for subdirectories and files.
The default \*LXmNqualifySearchDataProc\*O works as follows:
The directory mask is a pathname that can contain zero or more
\*Vwildcard\*O characters in its directory portion, its file portion, or
both.
The directory components of the directory mask up to, but not
including, the first component with a wildcard character specify the
directory to be searched, relative to the current working directory.
The remaining components specify the search pattern.
If the directory mask is empty or if its first component contains a
wildcard character, the current working directory is searched.
If no component of the directory mask contains a wildcard character, the
entire directory mask is the directory specification, and all files in
that directory are matched.
.PP 
The user can select a new directory to examine by scrolling through the
list of directories and selecting the desired directory or by editing
the directory mask.
Selecting a new directory from the directory list does not change the
search pattern.
A user can select a new search pattern by editing the directory mask.
Double clicking or pressing \*LKActivate\*O on a directory in the
directory list initiates a search for files and subdirectories in the
new directory, using the current search pattern.
.PP 
The user can select a file by scrolling through the list of filenames
and selecting the desired file or by entering the filename directly into
the text edit area.
Selecting a file from the list causes that filename to appear in the
file selection text edit area.
.PP 
The user may select a new file as many times as desired.
The application is not notified until the user takes one of these actions:
.ML
.LI
Selects the \*LOK\*O PushButton
.LI
Presses \*LKActivate\*O while the selection text edit area has the
keyboard focus.
.LI
Double clicks or presses \*LKActivate\*O on an item in the file list
.LE 
.PP 
FileSelectionBox initiates a directory and file search when any of the
following occurs:
.ML
.LI
The FileSelectionBox is initialized
.LI
The function \*LXtSetValues\*O is used to change \*LXmNdirMask\*O,
\*LXmNdirectory\*O, \*LXmNpattern\*O, or \*LXmNfileTypeMask\*O
.LI
The user activates the \*LFilter\*O PushButton
.LI
The user double clicks or presses \*LKActivate\*O on an item in the
directory list
.LI
The application calls \*LXmFileSelectionDoSearch\*O
.LI
The user presses \*LKActivate\*O while the directory mask text edit area
has the keyboard focus
.LE 
.PP 
When a file search is initiated, the FileSelectionBox takes the
following actions:
.ML
.LI
Constructs an \*LXmFileSelectionBoxCallbackStruct\*O structure with
values appropriate for the action that initiated the search
.LI
Calls the \*LXmNqualifySearchDataProc\*O with the callback structure as
the data input argument
.LI
Sets \*LXmNdirectoryValid\*O and \*LXmNlistUpdated\*O to False
.LI
Calls the \*LXmNdirSearchProc\*O with the qualified data returned by the
\*LXmNqualifySearchDataProc\*O
.LE 
.PP 
If \*LXmNdirectoryValid\*O is True, the FileSelectionBox takes these
additional actions:
.ML
.LI
Sets \*LXmNlistUpdated\*O to False
.LI
Calls the \*LXmNfileSearchProc\*O with the qualified data returned by
the \*LXmNqualifySearchDataProc\*O (and possibly modified by the
\*LXmNdirSearchProc\*O)
.LI
If \*LXmNlistUpdated\*O is True and the file list is empty, displays the
\*LXmNnoMatchString\*O in the file list and clears the selection text
and \*LXmNdirSpec\*O
.LI
If \*LXmNlistUpdated\*O is True and the file list is not empty, sets the
selection text and \*LXmNdirSpec\*O to the qualified \*Vdir\*O returned
by the \*LXmNqualifySearchDataProc\*O (and possibly modified by the
\*LXmNdirSearchProc\*O)
.LI
Sets the directory mask text and \*LXmNdirMask\*O to the qualified
\*Vmask\*O returned by the \*LXmNqualifySearchDataProc\*O (and possibly
modified by the \*LXmNdirSearchProc\*O)
.LI
Sets \*LXmNdirectory\*O to the qualified \*Vdir\*O returned by the
\*LXmNqualifySearchDataProc\*O (and possibly modified by the
\*LXmNdirSearchProc\*O)
.LI
Sets \*LXmNpattern\*O to the qualified \*Vpattern\*O returned by the
\*LXmNqualifySearchDataProc\*O (and possibly modified by the
\*LXmNdirSearchProc\*O)
.LE 
.SS "Classes"
FileSelectionBox inherits behavior and
resources from \*LCore\*O, \*LComposite\*O, \*LConstraint\*O, \*LXmManager\*O,
\*LXmBulletinBoard\*O, and \*LXmSelectionBox\*O.
.PP 
The class pointer is \*LxmFileSelectionBoxWidgetClass\*O.
.PP
The class name is \*LXmFileSelectionBox\*O.
.SS "New Resources"
The following table defines a set of widget resources used by the programmer
to specify data.  The programmer can also set the resource values for the
inherited classes to set attributes for this widget.  To reference a
resource by name or by class in a .Xdefaults file, remove the \*LXmN\*O or
\*LXmC\*O prefix and use the remaining letters.  To specify one of the defined
values for a resource in a .Xdefaults file, remove the \*LXm\*O prefix and use
the remaining letters (in either lowercase or uppercase, but include any
underscores between words).
The codes in the access column indicate if the given resource can be
set at creation time (C),
set by using \*LXtSetValues\*O (S),
retrieved by using \*LXtGetValues\*O (G), or is not applicable (N/A).
.P 
...\" NROFF HACK START
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 48 49 50
.nr 48 0
.nr 38 \w\f3Name\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Class\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdirectory
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDirectory
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdirectoryValid
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDirectoryValid
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdirListItems
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDirListItems
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdirListItemCount
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDirListItemCount
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdirListLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDirListLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdirMask
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDirMask
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdirSearchProc
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDirSearchProc
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdirSpec
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDirSpec
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNfileListItems
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCItems
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNfileListItemCount
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCItemCount
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNfileListLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCFileListLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNfileSearchProc
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCFileSearchProc
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNfileTypeMask
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCFileTypeMask
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNfilterLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCFilterLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNlistUpdated
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCListUpdated
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNnoMatchString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCNoMatchString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNpattern
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCPattern
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNqualifySearchDataProc
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCQualifySearchDataProc
.if \n(48<\n(38 .nr 48 \n(38
.48
.rm 48
.nr 49 0
.nr 38 \w\f3Default\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Type\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmStringTable
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ int
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdefault procedure
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmSearchProc
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmStringTable
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic 
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ int
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdefault procedure
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmSearchProc
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmFILE_REGULAR
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ unsigned char
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w"\0[\0\0\0\0]\0"
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdefault procedure
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmQualifyProc
.if \n(49<\n(38 .nr 49 \n(38
.49
.rm 49
.nr 50 0
.nr 38 \w\f3Access\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.50
.rm 50
.nr 38 \w\f3XmFileSelectionBox Resource Set\fP-\n(48-3n-\n(49-3n-\n(50
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 49 +\n(38
.nr 50 +\n(38
.nr 38 1n
.nr 47 0
.nr 40 \n(47+((0*\n(38)/2)
.nr 48 +\n(40
.nr 41 \n(48+((6*\n(38)/2)
.nr 49 +\n(41
.nr 42 \n(49+((6*\n(38)/2)
.nr 50 +\n(42
.nr TW \n(50
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 285 file Input is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3XmFileSelectionBox Resource Set\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3Name\f\n(31\h'|\n(41u'\f3Default\f\n(31\h'|\n(42u'\f3Access\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\ \ \ \ \ \ Class\f\n(31\h'|\n(41u'\f3\ \ \ \ \ \ Type\f\n(31\h'|\n(42u'\f3\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdirectory\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDirectory\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdirectoryValid\h'|\n(41u'dynamic\h'|\n(42u'SG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDirectoryValid\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdirListItems\h'|\n(41u'dynamic\h'|\n(42u'SG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDirListItems\h'|\n(41u'\ \ \ \ \ \ \ XmStringTable\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdirListItemCount\h'|\n(41u'dynamic\h'|\n(42u'SG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDirListItemCount\h'|\n(41u'\ \ \ \ \ \ \ int\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdirListLabelString\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDirListLabelString\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdirMask\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDirMask\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdirSearchProc\h'|\n(41u'default procedure\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDirSearchProc\h'|\n(41u'\ \ \ \ \ \ \ XmSearchProc\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdirSpec\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDirSpec\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNfileListItems\h'|\n(41u'dynamic\h'|\n(42u'SG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCItems\h'|\n(41u'\ \ \ \ \ \ \ XmStringTable\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNfileListItemCount\h'|\n(41u'dynamic \h'|\n(42u'SG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCItemCount\h'|\n(41u'\ \ \ \ \ \ \ int\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNfileListLabelString\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCFileListLabelString\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNfileSearchProc\h'|\n(41u'default procedure\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCFileSearchProc\h'|\n(41u'\ \ \ \ \ \ \ XmSearchProc\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNfileTypeMask\h'|\n(41u'XmFILE_REGULAR\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCFileTypeMask\h'|\n(41u'\ \ \ \ \ \ \ unsigned char\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNfilterLabelString\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCFilterLabelString\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.wH .tH
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNlistUpdated\h'|\n(41u'dynamic\h'|\n(42u'SG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCListUpdated\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNnoMatchString\h'|\n(41u'"\0[\0\0\0\0]\0"\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCNoMatchString\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNpattern\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCPattern\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNqualifySearchDataProc\h'|\n(41u'default procedure\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCQualifySearchDataProc\h'|\n(41u'\ \ \ \ \ \ \ XmQualifyProc\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-67
...\" NROFF HACK END
.VL  
.LI "\*LXmNdirectory\*O"
Specifies the base directory used in combination with \*LXmNpattern\*O
in determining the files and directories to be displayed.
The default value is determined by the \*LXmNqualifySearchDataProc\*O
and depends on the initial values of \*LXmNdirMask\*O,
\*LXmNdirectory\*O, and \*LXmNpattern\*O.
If the default is NULL or empty, the current working directory is used.
.LI "\*LXmNdirectoryValid\*O"
Specifies an attribute that is set only by the directory search
procedure.
The value is set to True if the directory passed to the directory search
procedure can actually be searched.
If this value is False the file search procedure is not called, and
\*LXmNdirMask\*O, \*LXmNdirectory\*O, and \*LXmNpattern\*O are not
changed.
.LI "\*LXmNdirListItems\*O"
Specifies the items in the directory list.
\*LXtGetValues\*O for this resource returns the list items themselves,
not a copy of the list items.
The application must not free the returned items.
.LI "\*LXmNdirListItemCount\*O"
Specifies the number of items in the directory list.
The value must not be negative.
.LI "\*LXmNdirListLabelString\*O"
Specifies the label string of the directory list.
The default for this resource depends on the locale.
In the C locale the default is "Directories".
.nL
.ne 2i
.LI "\*LXmNdirMask\*O"
Specifies the directory mask used
in determining the files and directories to be displayed.
The default value is determined by the
.ne 5
\*LXmNqualifySearchDataProc\*O
and depends on the initial values of \*LXmNdirMask\*O,
\*LXmNdirectory\*O, and \*LXmNpattern\*O.
.LI "\*LXmNdirSearchProc\*O"
Specifies a directory search procedure to replace the default
directory-search procedure.
FileSelectionBox's default directory-search procedure fulfills the needs
of most applications.
Because it is impossible to cover the requirements of all applications,
you can replace the default search procedure.
.PP
The directory search procedure is called with two arguments:
the FileSelectionBox widget and a pointer to an
\*LXmFileSelectionBoxCallbackStruct\*O structure.
The callback structure is generated by the
\*LXmNqualifySearchDataProc\*O and contains all information required to
conduct a directory search, including the directory mask and a qualified
base directory and search pattern.
.ne 4
Once called, it is up to the search routine to generate a new list of
directories and update the FileSelectionBox widget by using
\*LXtSetValues\*O.
.PP
The search procedure must set \*LXmNdirectoryValid\*O and
\*LXmNlistUpdated\*O.
If it generates a new list of directories, it must also set
\*LXmNdirListItems\*O and \*LXmNdirListItemCount\*O.
.PP
If the search procedure cannot search the specified directory, it must
warn the user and set \*LXmNdirectoryValid\*O and \*LXmNlistUpdated\*O
to False, unless it prompts and subsequently obtains a valid directory.
If the directory is valid but is the same as the current
\*LXmNdirectory\*O, the search procedure must set
\*LXmNdirectoryValid\*O to True, but it may elect not to generate a new
list of directories.
In this case is must set \*LXmNlistUpdated\*O to False.
.PP
If the search procedure generates a new list of directories, it must set
\*LXmNdirListItems\*O to the new list of directories and
\*LXmNdirListItemCount\*O to the number of items in the list.
If there are no directories, it sets \*LXmNdirListItems\*O to NULL and
\*LXmNdirListItemCount\*O to 0.
In either case it must set \*LXmNdirectoryValid\*O and
\*LXmNlistUpdated\*O to True.
.PP
The search procedure ordinarily should not change the callback struct.
But if the original directory is not valid, the search procedure may
obtain a new directory from the user.
In this case it should set the \*Vdir\*O member of the callback struct
to the new directory, call the \*LXmNqualifySearchDataProc\*O with the
callback struct as the input argument, and copy the qualified data
returned by the \*LXmNqualifySearchDataProc\*O into the callback struct.
.LI "\*LXmNdirSpec\*O"
Specifies the full file path specification.
This is the \*LXmNtextString\*O resource in SelectionBox, renamed for
FileSelectionBox.
The default value is determined by the FileSelectionBox after conducting
the initial directory and file search.
.LI "\*LXmNfileListItems\*O"
Specifies the items in the file list.
This is the \*LXmNlistItems\*O resource in SelectionBox, renamed for
FileSelectionBox.
\*LXtGetValues\*O for this resource returns the list items themselves,
not a copy of the list items.
The application must not free the returned items.
.LI "\*LXmNfileListItemCount\*O"
Specifies the number of items in the file list.
This is the \*LXmNlistItemCount\*O resource in SelectionBox, renamed for
FileSelectionBox.
The value must not be negative.
.LI "\*LXmNfileListLabelString\*O"
Specifies the label string of the file list.
This is the \*LXmNlistLabelString\*O resource in SelectionBox, renamed
for FileSelectionBox.
The default for this resource depends on the locale.
In the C locale the default is "Files".
.LI "\*LXmNfileSearchProc\*O"
Specifies a file search procedure to replace the default file-search
procedure.
FileSelectionBox's default file-search procedure fulfills the needs of
most applications.
Because it is impossible to cover the requirements of all applications,
you can replace the default search procedure.
.PP
The file search procedure is called with two arguments:
the FileSelectionBox widget and a pointer to an
\*LXmFileSelectionBoxCallbackStruct\*O structure.
The callback structure is generated by the
\*LXmNqualifySearchDataProc\*O (and possibly modified by the
\*LXmNdirSearchProc\*O).
It contains all information required to conduct a file search, including
the directory mask and a qualified base directory and search pattern.
.ne 4
Once called, it is up to the search routine to generate a new list of
files and update the FileSelectionBox widget by using \*LXtSetValues\*O.
.PP
The search procedure must set \*LXmNlistUpdated\*O.
If it generates a new list of files, it must also set
\*LXmNfileListItems\*O and \*LXmNfileListItemCount\*O.
.PP
The search procedure is recommended always to generate a new list of
files.
If the \*Vmask\*O member of the callback struct is the same as the
\*Vmask\*O member of the callback struct in the preceding call to the
search procedure, the procedure may elect not to generate a new list of
files.
In this case it must set \*LXmNlistUpdated\*O to False.
.PP
If the search procedure generates a new list of files, it must set
\*LXmNfileListItems\*O to the new list of files and
\*LXmNfileListItemCount\*O to the number of items in the list.
If there are no files, it sets \*LXmNfileListItems\*O to NULL and
\*LXmNfileListItemCount\*O to 0.
In either case it must set \*LXmNlistUpdated\*O to True.
.PP
In constructing the list of files, the search procedure should include
only files of the types specified by the widget's \*LXmNfileTypeMask\*O.
.PP
Setting \*LXmNdirSpec\*O is optional, but recommended.
Set this attribute to the full file specification of the directory
searched.
The directory specification is displayed below the directory and file
lists.
.LI "\*LXmNfileTypeMask\*O"
Specifies the type of files listed in the file list.
Following are the possible values:
.wH .rS 
.ML
.LI
\*LXmFILE_REGULAR\*O restricts the file list to contain only regular
files.
.LI
\*LXmFILE_DIRECTORY\*O restricts the file list to contain only
directories.
.LI
\*LXmFILE_ANY_TYPE\*O allows the list to contain all file types
including directories.
.LE 
.wH .rE
.nL
.ne 7
.LI "\*LXmNfilterLabelString\*O"
Specifies the label string for the text entry field for the directory
mask.
The default for this resource depends on the locale.
In the C locale the default is "Filter".
.LI "\*LXmNlistUpdated\*O"
Specifies an attribute that is set only by the directory and file search
procedures.
Set to True if the search procedure updated the directory or file list.
.LI "\*LXmNnoMatchString\*O"
Specifies a string to be displayed in the file list if the list of files
is empty.
.LI "\*LXmNpattern\*O"
Specifies the search pattern used in combination with \*LXmNdirectory\*O
in determining the files and directories to be displayed.
The default value is determined by the \*LXmNqualifySearchDataProc\*O
and depends on the initial values of \*LXmNdirMask\*O,
\*LXmNdirectory\*O, and \*LXmNpattern\*O.
If the default is NULL or empty, a pattern that matches all files is
used.
.LI "\*LXmNqualifySearchDataProc\*O"
Specifies a search data qualification procedure to replace the default
data qualification procedure.
FileSelectionBox's default data qualification procedure fulfills the
needs of most applications.
Because it is impossible to cover the requirements of all applications,
you can replace the default procedure.
.PP
The data qualification procedure is called to generate a qualified
directory mask, base directory, and search pattern for use by the
directory and file search procedures.
It is called with three arguments:
the FileSelectionBox widget and pointers to two
\*LXmFileSelectionBoxCallbackStruct\*O structures.
The first callback struct contains the input data.
The second callback struct contains the output data, to be filled in by
the data qualification procedure.
.PP
.ne 5
If the input \*Vdir\*O and \*Vpattern\*O members are not NULL, the
procedure must copy them to the corresponding members of the output
callback struct.
.PP
.ne 6
If the input \*Vdir\*O is NULL, the procedure constructs the
output \*Vdir\*O as follows:
If the input \*Vmask\*O member is NULL, the procedure uses the
widget's \*LXmNdirectory\*O as the output \*Vdir\*O; otherwise, it
extracts the output \*Vdir\*O from the input \*Vmask\*O.
If the resulting output \*Vdir\*O is empty, the procedure uses
the current working directory instead.
.PP
If the input \*Vpattern\*O is NULL, the procedure constructs
the output \*Vpattern\*O as follows:
If the input \*Vmask\*O member is NULL, the procedure uses the
widget's \*LXmNpattern\*O as the output \*Vpattern\*O; otherwise, it
extracts the output \*Vpattern\*O from the input \*Vmask\*O.
If the resulting output \*Vpattern\*O is empty, the procedure
uses a pattern that matches all files instead.
.PP
The data qualification procedure constructs the output \*Vmask\*O from
the output \*Vdir\*O and \*Vpattern\*O.
The procedure must ensure that the output \*Vdir\*O, \*Vpattern\*O, and
\*Vmask\*O are fully qualified.
.PP
If the input \*Vvalue\*O member is not NULL, the procedure must copy it
to the output \*Vvalue\*O member; otherwise, the procedure must copy the
widget's \*LXmNdirSpec\*O to the output \*Vvalue\*O.
.PP
The data qualification procedure must calculate the lengths of the
output \*Vvalue\*O, \*Vmask\*O, \*Vdir\*O, and \*Vpattern\*O members and
must fill in the corresponding length members of the output callback
struct.
.PP
The data qualification procedure must copy the input \*Vreason\*O and
\*Vevent\*O members to the corresponding output members.
.LE
.PP
The values of the \*LXmNdirSearchProc\*O and \*LXmNfileSearchProc\*O
are procedure pointers of type \*LXmSearchProc\*O, defined as 
follows:
.sS
.iS
.sp \n(PDu
void (* XmSearchProc) (\*Vw, search_data\*L)
.ta .5i 1.25i
	Widget	\*Vw\*L;
	XtPointer	\*Vsearch_data\*L;
.iE
.sE
.VL
.LI "\*Vw\*O
The FileSelectionBox widget
.LI "\*Vsearch_data\*O
Pointer to an \*LXmFileSelectionBoxCallbackStruct\*O containing
information for conducting a search
.LI
.LE
.PP
The value of the \*LXmNqualifySearchDataProc\*O resource
is a procedure pointer of type \*LXmQualifyProc\*O, defined
as follows:
.sS
.iS
.sp \n(PDu
void (* XmQualifyProc) (\*Vw, input_data, output_data\*L)
.ta .5i 1.25i
	Widget	\*Vw\*L;
	XtPointer	\*Vinput_data\*L;
	XtPointer	\*Voutput_data\*L;
.iE
.sE
.VL
.LI "\*Vw\*O
The FileSelectionBox widget
.LI "\*Vinput_data\*O
Pointer to an \*LXmFileSelectionBoxCallbackStruct\*O containing
input data to be qualified
.LI "\*Voutput_data\*O"
Pointer to an \*LXmFileSelectionBoxCallbackStruct\*O containing
output data to be filled in by the qualification procedure
.LE
.SS "Inherited Resources"
FileSelectionBox inherits behavior and resources from the following
superclasses.  For a complete description of each resource, refer to the
man page for that superclass.
.P 
...\" NROFF HACK START
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 48 49 50
.nr 48 0
.nr 38 \w\f3Name\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Class\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNapplyCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNapplyLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCApplyLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNcancelCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNcancelLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCCancelLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNchildPlacement
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCChildPlacement
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdialogType
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDialogType
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNhelpLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCHelpLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNlistItemCount
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCItemCount
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNlistItems
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCItems
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNlistLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCListLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNlistVisibleItemCount
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCVisibleItemCount
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNminimizeButtons
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCMinimizeButtons
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNmustMatch
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCMustMatch
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNnoMatchCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNokCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNokLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCOkLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNselectionLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCSelectionLabelString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNtextAccelerators
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCTextAccelerators
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNtextColumns
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCColumns
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNtextString
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCTextString
.if \n(48<\n(38 .nr 48 \n(38
.48
.rm 48
.nr 49 0
.nr 38 \w\f3Default\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Type\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtCallbackList
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtCallbackList
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic 
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmPLACE_ABOVE_SELECTION
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ unsigned char
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmDIALOG_FILE_SELECTION 
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ unsigned char
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic 
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic 
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ int
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmStringTable
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic 
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ int
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wFalse
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wFalse 
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtCallbackList
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtCallbackList
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdefault
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtAccelerators
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ short
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.49
.rm 49
.nr 50 0
.nr 38 \w\f3Access\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wC
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wC
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wC
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wC
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wC
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.50
.rm 50
.nr 38 \w\f3XmSelectionBox Resource Set\fP-\n(48-3n-\n(49-3n-\n(50
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 49 +\n(38
.nr 50 +\n(38
.nr 38 1n
.nr 47 0
.nr 40 \n(47+((0*\n(38)/2)
.nr 48 +\n(40
.nr 41 \n(48+((6*\n(38)/2)
.nr 49 +\n(41
.nr 42 \n(49+((6*\n(38)/2)
.nr 50 +\n(42
.nr TW \n(50
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 664 file Input is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3XmSelectionBox Resource Set\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3Name\f\n(31\h'|\n(41u'\f3Default\f\n(31\h'|\n(42u'\f3Access\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\ \ \ \ \ \ Class\f\n(31\h'|\n(41u'\f3\ \ \ \ \ \ Type\f\n(31\h'|\n(42u'\f3\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNapplyCallback\h'|\n(41u'NULL\h'|\n(42u'C
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCCallback\h'|\n(41u'\ \ \ \ \ \ \ XtCallbackList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNapplyLabelString\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCApplyLabelString\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNcancelCallback\h'|\n(41u'NULL\h'|\n(42u'C
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCCallback\h'|\n(41u'\ \ \ \ \ \ \ XtCallbackList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNcancelLabelString\h'|\n(41u'dynamic \h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCCancelLabelString\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNchildPlacement\h'|\n(41u'XmPLACE_ABOVE_SELECTION\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCChildPlacement\h'|\n(41u'\ \ \ \ \ \ \ unsigned char\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdialogType\h'|\n(41u'XmDIALOG_FILE_SELECTION \h'|\n(42u'G
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDialogType\h'|\n(41u'\ \ \ \ \ \ \ unsigned char\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNhelpLabelString\h'|\n(41u'dynamic \h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCHelpLabelString\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNlistItemCount\h'|\n(41u'dynamic \h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCItemCount\h'|\n(41u'\ \ \ \ \ \ \ int\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNlistItems\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCItems\h'|\n(41u'\ \ \ \ \ \ \ XmStringTable\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNlistLabelString\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCListLabelString\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNlistVisibleItemCount\h'|\n(41u'dynamic \h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCVisibleItemCount\h'|\n(41u'\ \ \ \ \ \ \ int\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNminimizeButtons\h'|\n(41u'False\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCMinimizeButtons\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNmustMatch\h'|\n(41u'False \h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCMustMatch\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNnoMatchCallback\h'|\n(41u'NULL\h'|\n(42u'C
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCCallback\h'|\n(41u'\ \ \ \ \ \ \ XtCallbackList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.wH .tH
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNokCallback\h'|\n(41u'NULL\h'|\n(42u'C
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCCallback\h'|\n(41u'\ \ \ \ \ \ \ XtCallbackList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNokLabelString\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCOkLabelString\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNselectionLabelString\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCSelectionLabelString\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNtextAccelerators\h'|\n(41u'default\h'|\n(42u'C
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCTextAccelerators\h'|\n(41u'\ \ \ \ \ \ \ XtAccelerators\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNtextColumns\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCColumns\h'|\n(41u'\ \ \ \ \ \ \ short\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNtextString\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCTextString\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-73
...\" NROFF HACK END
.P 
...\" NROFF HACK START
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 48 49 50
.nr 48 0
.nr 38 \w\f3Name\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Class\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNallowOverlap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCAllowOverlap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNautoUnmanage
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCAutoUnmanage
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNbuttonFontList
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCButtonFontList
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNcancelButton
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCWidget
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdefaultButton
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCWidget
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdefaultPosition
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDefaultPosition
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdialogStyle
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDialogStyle
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdialogTitle
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDialogTitle
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNfocusCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNlabelFontList
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCLabelFontList
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNmapCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNmarginHeight
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCMarginHeight
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNmarginWidth
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCMarginWidth
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNnoResize
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCNoResize
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNresizePolicy
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCResizePolicy
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNshadowType
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCShadowType
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNtextFontList
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCTextFontList
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNtextTranslations
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCTranslations
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNunmapCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCCallback
.if \n(48<\n(38 .nr 48 \n(38
.48
.rm 48
.nr 49 0
.nr 38 \w\f3Default\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Type\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wTrue
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wFalse
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmFontList
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wCancel button
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Widget
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wOK button
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Widget
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wTrue
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ unsigned char
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmString
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtCallbackList
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmFontList
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtCallbackList
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w10
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Dimension
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w10 
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Dimension
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wFalse
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmRESIZE_ANY
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ unsigned char
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmSHADOW_OUT
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ unsigned char
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmFontList
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtTranslations
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtCallbackList
.if \n(49<\n(38 .nr 49 \n(38
.49
.rm 49
.nr 50 0
.nr 38 \w\f3Access\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wC
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wC
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wC
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wC
.if \n(50<\n(38 .nr 50 \n(38
.50
.rm 50
.nr 38 \w\f3XmBulletinBoard Resource Set\fP-\n(48-3n-\n(49-3n-\n(50
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 49 +\n(38
.nr 50 +\n(38
.nr 38 1n
.nr 47 0
.nr 40 \n(47+((0*\n(38)/2)
.nr 48 +\n(40
.nr 41 \n(48+((6*\n(38)/2)
.nr 49 +\n(41
.nr 42 \n(49+((6*\n(38)/2)
.nr 50 +\n(42
.nr TW \n(50
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 738 file Input is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3XmBulletinBoard Resource Set\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3Name\f\n(31\h'|\n(41u'\f3Default\f\n(31\h'|\n(42u'\f3Access\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\ \ \ \ \ \ Class\f\n(31\h'|\n(41u'\f3\ \ \ \ \ \ Type\f\n(31\h'|\n(42u'\f3\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNallowOverlap\h'|\n(41u'True\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCAllowOverlap\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNautoUnmanage\h'|\n(41u'False\h'|\n(42u'CG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCAutoUnmanage\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNbuttonFontList\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCButtonFontList\h'|\n(41u'\ \ \ \ \ \ \ XmFontList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNcancelButton\h'|\n(41u'Cancel button\h'|\n(42u'SG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCWidget\h'|\n(41u'\ \ \ \ \ \ \ Widget\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdefaultButton\h'|\n(41u'OK button\h'|\n(42u'SG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCWidget\h'|\n(41u'\ \ \ \ \ \ \ Widget\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdefaultPosition\h'|\n(41u'True\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDefaultPosition\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdialogStyle\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDialogStyle\h'|\n(41u'\ \ \ \ \ \ \ unsigned char\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdialogTitle\h'|\n(41u'NULL\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDialogTitle\h'|\n(41u'\ \ \ \ \ \ \ XmString\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNfocusCallback\h'|\n(41u'NULL\h'|\n(42u'C
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCCallback\h'|\n(41u'\ \ \ \ \ \ \ XtCallbackList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNlabelFontList\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCLabelFontList\h'|\n(41u'\ \ \ \ \ \ \ XmFontList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNmapCallback\h'|\n(41u'NULL\h'|\n(42u'C
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCCallback\h'|\n(41u'\ \ \ \ \ \ \ XtCallbackList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNmarginHeight\h'|\n(41u'10\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCMarginHeight\h'|\n(41u'\ \ \ \ \ \ \ Dimension\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNmarginWidth\h'|\n(41u'10 \h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCMarginWidth\h'|\n(41u'\ \ \ \ \ \ \ Dimension\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNnoResize\h'|\n(41u'False\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCNoResize\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.wH .tH
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNresizePolicy\h'|\n(41u'XmRESIZE_ANY\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCResizePolicy\h'|\n(41u'\ \ \ \ \ \ \ unsigned char\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNshadowType\h'|\n(41u'XmSHADOW_OUT\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCShadowType\h'|\n(41u'\ \ \ \ \ \ \ unsigned char\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNtextFontList\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCTextFontList\h'|\n(41u'\ \ \ \ \ \ \ XmFontList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNtextTranslations\h'|\n(41u'NULL\h'|\n(42u'C
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCTranslations\h'|\n(41u'\ \ \ \ \ \ \ XtTranslations\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNunmapCallback\h'|\n(41u'NULL\h'|\n(42u'C
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCCallback\h'|\n(41u'\ \ \ \ \ \ \ XtCallbackList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-70
...\" NROFF HACK END
.P 
...\" NROFF HACK START
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 48 49 50
.nr 48 0
.nr 38 \w\f3Name\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Class\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNbottomShadowColor
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCBottomShadowColor
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNbottomShadowPixmap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCBottomShadowPixmap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNforeground
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCForeground
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNhelpCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNhighlightColor
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCHighlightColor
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNhighlightPixmap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCHighlightPixmap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNinitialFocus
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCInitialFocus
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNnavigationType
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCNavigationType
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNshadowThickness
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCShadowThickness
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNstringDirection
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCStringDirection
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNtopShadowColor
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCTopShadowColor
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNtopShadowPixmap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCTopShadowPixmap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNtraversalOn
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCTraversalOn
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNunitType
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCUnitType
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNuserData
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCUserData
.if \n(48<\n(38 .nr 48 \n(38
.48
.rm 48
.nr 49 0
.nr 38 \w\f3Default\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Type\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixel
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmUNSPECIFIED_PIXMAP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixmap
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixel
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtCallbackList
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixel
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixmap
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Widget
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmTAB_GROUP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmNavigationType
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Dimension
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XmStringDirection
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixel
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixmap
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wTrue
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ unsigned char
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtPointer
.if \n(49<\n(38 .nr 49 \n(38
.49
.rm 49
.nr 50 0
.nr 38 \w\f3Access\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wC
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.50
.rm 50
.nr 38 \w\f3XmManager Resource Set\fP-\n(48-3n-\n(49-3n-\n(50
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 49 +\n(38
.nr 50 +\n(38
.nr 38 1n
.nr 47 0
.nr 40 \n(47+((0*\n(38)/2)
.nr 48 +\n(40
.nr 41 \n(48+((6*\n(38)/2)
.nr 49 +\n(41
.nr 42 \n(49+((6*\n(38)/2)
.nr 50 +\n(42
.nr TW \n(50
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 799 file Input is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3XmManager Resource Set\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3Name\f\n(31\h'|\n(41u'\f3Default\f\n(31\h'|\n(42u'\f3Access\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\ \ \ \ \ \ Class\f\n(31\h'|\n(41u'\f3\ \ \ \ \ \ Type\f\n(31\h'|\n(42u'\f3\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNbottomShadowColor\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCBottomShadowColor\h'|\n(41u'\ \ \ \ \ \ \ Pixel\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNbottomShadowPixmap\h'|\n(41u'XmUNSPECIFIED_PIXMAP\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCBottomShadowPixmap\h'|\n(41u'\ \ \ \ \ \ \ Pixmap\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNforeground\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCForeground\h'|\n(41u'\ \ \ \ \ \ \ Pixel\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNhelpCallback\h'|\n(41u'NULL\h'|\n(42u'C
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCCallback\h'|\n(41u'\ \ \ \ \ \ \ XtCallbackList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNhighlightColor\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCHighlightColor\h'|\n(41u'\ \ \ \ \ \ \ Pixel\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNhighlightPixmap\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCHighlightPixmap\h'|\n(41u'\ \ \ \ \ \ \ Pixmap\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNinitialFocus\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCInitialFocus\h'|\n(41u'\ \ \ \ \ \ \ Widget\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNnavigationType\h'|\n(41u'XmTAB_GROUP\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCNavigationType\h'|\n(41u'\ \ \ \ \ \ \ XmNavigationType\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNshadowThickness\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCShadowThickness\h'|\n(41u'\ \ \ \ \ \ \ Dimension\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNstringDirection\h'|\n(41u'dynamic\h'|\n(42u'CG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCStringDirection\h'|\n(41u'\ \ \ \ \ \ \ XmStringDirection\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNtopShadowColor\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCTopShadowColor\h'|\n(41u'\ \ \ \ \ \ \ Pixel\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNtopShadowPixmap\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCTopShadowPixmap\h'|\n(41u'\ \ \ \ \ \ \ Pixmap\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNtraversalOn\h'|\n(41u'True\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCTraversalOn\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNunitType\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCUnitType\h'|\n(41u'\ \ \ \ \ \ \ unsigned char\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNuserData\h'|\n(41u'NULL\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCUserData\h'|\n(41u'\ \ \ \ \ \ \ XtPointer\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-57
...\" NROFF HACK END
.P 
...\" NROFF HACK START
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 48 49 50
.nr 48 0
.nr 38 \w\f3Name\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Class\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNchildren
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCReadOnly
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNinsertPosition
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCInsertPosition
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNnumChildren
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCReadOnly
.if \n(48<\n(38 .nr 48 \n(38
.48
.rm 48
.nr 49 0
.nr 38 \w\f3Default\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Type\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ WidgetList
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtOrderProc
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w0
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Cardinal
.if \n(49<\n(38 .nr 49 \n(38
.49
.rm 49
.nr 50 0
.nr 38 \w\f3Access\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wG
.if \n(50<\n(38 .nr 50 \n(38
.50
.rm 50
.nr 38 \w\f3Composite Resource Set\fP-\n(48-3n-\n(49-3n-\n(50
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 49 +\n(38
.nr 50 +\n(38
.nr 38 1n
.nr 47 0
.nr 40 \n(47+((0*\n(38)/2)
.nr 48 +\n(40
.nr 41 \n(48+((6*\n(38)/2)
.nr 49 +\n(41
.nr 42 \n(49+((6*\n(38)/2)
.nr 50 +\n(42
.nr TW \n(50
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 824 file Input is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3Composite Resource Set\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3Name\f\n(31\h'|\n(41u'\f3Default\f\n(31\h'|\n(42u'\f3Access\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\ \ \ \ \ \ Class\f\n(31\h'|\n(41u'\f3\ \ \ \ \ \ Type\f\n(31\h'|\n(42u'\f3\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNchildren\h'|\n(41u'NULL\h'|\n(42u'G
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCReadOnly\h'|\n(41u'\ \ \ \ \ \ \ WidgetList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNinsertPosition\h'|\n(41u'NULL\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCInsertPosition\h'|\n(41u'\ \ \ \ \ \ \ XtOrderProc\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNnumChildren\h'|\n(41u'0\h'|\n(42u'G
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCReadOnly\h'|\n(41u'\ \ \ \ \ \ \ Cardinal\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-21
...\" NROFF HACK END
.P 
.wH .in 0 
...\" NROFF HACK START
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 48 49 50
.nr 48 0
.nr 38 \w\f3Name\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Class\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNaccelerators
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCAccelerators
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNancestorSensitive
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCSensitive
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNbackground
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCBackground
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNbackgroundPixmap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCPixmap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNborderColor
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCBorderColor
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNborderPixmap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCPixmap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNborderWidth
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCBorderWidth
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNcolormap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCColormap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdepth
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDepth
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdestroyCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCCallback
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNheight
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCHeight
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNinitialResourcesPersistent
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCInitialResourcesPersistent
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNmappedWhenManaged
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCMappedWhenManaged
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNscreen
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCScreen
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNsensitive
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCSensitive
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNtranslations
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCTranslations
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNwidth
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCWidth
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNx
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCPosition
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNy
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCPosition
.if \n(48<\n(38 .nr 48 \n(38
.48
.rm 48
.nr 49 0
.nr 38 \w\f3Default\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Type\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtAccelerators
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixel
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmUNSPECIFIED_PIXMAP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixmap
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXtDefaultForeground
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixel
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmUNSPECIFIED_PIXMAP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixmap
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w0
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Dimension
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Colormap
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ int
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtCallbackList
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Dimension
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wTrue
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wTrue
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Screen *
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wTrue
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Boolean
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtTranslations
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Dimension
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w0
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Position
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w0
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Position
.if \n(49<\n(38 .nr 49 \n(38
.49
.rm 49
.nr 50 0
.nr 38 \w\f3Access\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wN/A
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wC
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wC
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.50
.rm 50
.nr 38 \w\f3Core Resource Set\fP-\n(48-3n-\n(49-3n-\n(50
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 49 +\n(38
.nr 50 +\n(38
.nr 38 1n
.nr 47 0
.nr 40 \n(47+((0*\n(38)/2)
.nr 48 +\n(40
.nr 41 \n(48+((6*\n(38)/2)
.nr 49 +\n(41
.nr 42 \n(49+((6*\n(38)/2)
.nr 50 +\n(42
.nr TW \n(50
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 899 file Input is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3Core Resource Set\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3Name\f\n(31\h'|\n(41u'\f3Default\f\n(31\h'|\n(42u'\f3Access\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\ \ \ \ \ \ Class\f\n(31\h'|\n(41u'\f3\ \ \ \ \ \ Type\f\n(31\h'|\n(42u'\f3\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNaccelerators\h'|\n(41u'dynamic\h'|\n(42u'N/A
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCAccelerators\h'|\n(41u'\ \ \ \ \ \ \ XtAccelerators\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNancestorSensitive\h'|\n(41u'dynamic\h'|\n(42u'G
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCSensitive\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNbackground\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCBackground\h'|\n(41u'\ \ \ \ \ \ \ Pixel\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNbackgroundPixmap\h'|\n(41u'XmUNSPECIFIED_PIXMAP\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCPixmap\h'|\n(41u'\ \ \ \ \ \ \ Pixmap\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNborderColor\h'|\n(41u'XtDefaultForeground\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCBorderColor\h'|\n(41u'\ \ \ \ \ \ \ Pixel\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNborderPixmap\h'|\n(41u'XmUNSPECIFIED_PIXMAP\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCPixmap\h'|\n(41u'\ \ \ \ \ \ \ Pixmap\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNborderWidth\h'|\n(41u'0\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCBorderWidth\h'|\n(41u'\ \ \ \ \ \ \ Dimension\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNcolormap\h'|\n(41u'dynamic\h'|\n(42u'CG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCColormap\h'|\n(41u'\ \ \ \ \ \ \ Colormap\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdepth\h'|\n(41u'dynamic\h'|\n(42u'CG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDepth\h'|\n(41u'\ \ \ \ \ \ \ int\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdestroyCallback\h'|\n(41u'NULL\h'|\n(42u'C
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCCallback\h'|\n(41u'\ \ \ \ \ \ \ XtCallbackList\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNheight\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCHeight\h'|\n(41u'\ \ \ \ \ \ \ Dimension\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNinitialResourcesPersistent\h'|\n(41u'True\h'|\n(42u'C
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCInitialResourcesPersistent\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNmappedWhenManaged\h'|\n(41u'True\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCMappedWhenManaged\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNscreen\h'|\n(41u'dynamic\h'|\n(42u'CG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCScreen\h'|\n(41u'\ \ \ \ \ \ \ Screen *\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.wH .tH
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNsensitive\h'|\n(41u'True\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCSensitive\h'|\n(41u'\ \ \ \ \ \ \ Boolean\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNtranslations\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCTranslations\h'|\n(41u'\ \ \ \ \ \ \ XtTranslations\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNwidth\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCWidth\h'|\n(41u'\ \ \ \ \ \ \ Dimension\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNx\h'|\n(41u'0\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCPosition\h'|\n(41u'\ \ \ \ \ \ \ Position\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNy\h'|\n(41u'0\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCPosition\h'|\n(41u'\ \ \ \ \ \ \ Position\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-70
...\" NROFF HACK END
.wH .in  
.SS "Callback Information"
A pointer to the following structure is passed to each callback:
.sS
.iS
.ta .25i 1.1i
typedef struct
{
	int	\*Vreason\*L;
	\*LXEvent	\*V* event\*L;
	\*LXmString	\*Vvalue\*L;
	\*Lint	\*Vlength\*L;
	\*LXmString	\*Vmask\*L;
	\*Lint	\*Vmask_length\*L;
	\*LXmString	\*Vdir\*L;
	\*Lint	\*Vdir_length\*L;
	\*LXmString	\*Vpattern\*L;
	\*Lint	\*Vpattern_length\*L;
} XmFileSelectionBoxCallbackStruct;
.iE
.sE
.VL 1i 
.LI "\*Vreason\*O"
Indicates why the callback was invoked
.LI "\*Vevent\*O"
Points to the \*LXEvent\*O that triggered the callback
.LI "\*Vvalue\*O"
Specifies the current value of \*LXmNdirSpec\*O
.LI "\*Vlength\*O"
Specifies the number of bytes in \*Vvalue\*O
.LI "\*Vmask\*O"
Specifies the current value of \*LXmNdirMask\*O
.LI "\*Vmask_length\*O"
Specifies the number of bytes in \*Vmask\*O
.LI "\*Vdir\*O"
Specifies the current base directory
.LI "\*Vdir_length\*O"
Specifies the number of bytes in \*Vdir\*O
.LI "\*Vpattern\*O"
Specifies the current search pattern
.LI "\*Vpattern_length\*O"
Specifies the number of bytes in \*Vpattern\*O
.LE 
.SS "Translations"
XmFileSelectionBox inherits translations from XmSelectionBox.
.SS "Accelerators"
The \*LXmNtextAccelerators\*O from XmSelectionBox are added to the
selection and directory mask (filter) Text descendants of
XmFileSelectionBox.
.SS "Action Routines"
The XmFileSelectionBox action routines are described below:
.VL
.LI "\*LSelectionBoxUpOrDown(0|1|2|3)\*O:"
If neither the selection text nor the directory mask (filter) text has
the focus, this action does nothing.
.P 
.ne 3i
If the selection text has the focus, the term \*Vlist\*O in the
following description refers to the file list, and the term \*Vtext\*O
refers to the selection text.
If the directory mask text has the focus, \*Vlist\*O refers to the
directory list, and \*Vtext\*O refers to the directory mask text.
.P
When called with a 0 argument, selects the previous item in the
list and replaces the text with that item.
.P
When called with a 1 argument, selects the next item in the
list and replaces the text with that item.
.P
When called with a 2 argument, selects the first item in the
list and replaces the text with that item.
.P
When called with a 3 argument, selects the last item in the
list and replaces the text with that item.
.LI "\*LSelectionBoxRestore()\*O:"
If neither the selection text nor the directory mask (filter) text has
the focus, this action does nothing.
.P
If the selection text has the focus, replaces the selection text with
the selected item in the file list.
If no item in the file list is selected, clears the selection text.
.P
If the directory mask text has the focus, replaces the directory mask
text with a new directory mask constructed from the \*LXmNdirectory\*O
and \*LXmNpattern\*O resources.
.LE
.SS "Additional Behavior"
The FileSelectionBox widget has the additional behavior described below:
.VL
.LI "\*LMAny\ KCancel\*O:"
Calls the activate callbacks for the cancel button if it is sensitive.
If no cancel button exists and the parent of the FileSelectionBox is a manager,
passes the event to the parent.
.LI "\*L<KActivate>\*O\ in\ Selection\ Text:"
Calls the selection text widget's \*LXmNactivateCallback\*O callbacks.
If \*LXmNmustMatch\*O is True and the selection text does not match an
item in the file list, calls the \*LXmNnoMatchCallback\*O
callbacks with
reason \*LXmCR_NO_MATCH\*O.
Otherwise, calls the \*LXmNokCallback\*O callbacks with reason
\*LXmCR_OK\*O.
.nL
.ne 5
.LI "\*L<KActivate>\*O\ in\ Directory\ Mask\ Text:"
Calls the directory mask text widget's \*LXmNactivateCallback\*O
callbacks.
Initiates a directory and file search.
Calls the \*LXmNapplyCallback\*O callbacks with reason \*LXmCR_APPLY\*O.
.LI "\*L<DoubleClick>\*O\ or\ \*L<KActivate>\*O\ in\ Directory\ List:"
Calls the directory list widget's \*LXmNdefaultActionCallback\*O
callbacks.
Initiates a directory and file search.
Calls the \*LXmNapplyCallback\*O callbacks with reason \*LXmCR_APPLY\*O.
.LI "\*L<DoubleClick>\*O\ or\ \*L<KActivate>\*O\ in\ File\ List:"
Calls the file list widget's \*LXmNdefaultActionCallback\*O
callbacks.
Calls the \*LXmNokCallback\*O callbacks with reason \*LXmCR_OK\*O.
.LI "\*L<Single\ Select>\*O\ or\ \*L<Browse\ Select>\*O\ in\ Directory\ List:"
Generates a new directory mask, using the selected list item as the
directory and the pattern extracted from the current directory mask text
as the search pattern.
If the search pattern is empty, uses a pattern that matches all files in
the directory.
Replaces the directory mask text with the new directory mask.
.LI "\*L<Single\ Select>\*O\ or\ \*L<Browse\ Select>\*O\ in\ File\ List:"
Replaces the selection text with the selected list item.
.LI "\*L<BDrag>\*O in File List:"
Drags the content of one or more selected list items using the drag
and drop facility.  If \*LBDrag\*O is pressed on an unselected item,
drags only that item, excluding any other selected items.
.PP
The \*LXmNexportTargets\*O resource of the associated DragContext
is set to target types of COMPOUND_TEXT and FILE_NAME.  The
\*LXmNclientData\*O resource is set to the index of the item in the list.
.LI "\*L<BDrag>\*O in Directory List:"
Drags the content of one or more selected list items using the drag
and drop facility.  If \*LBDrag\*O is pressed on an unselected item,
drags only that item, excluding any other selected items.
.PP
The \*LXmNexportTargets\*O resource of the associated DragContext
is set to target types of COMPOUND_TEXT and FILE_NAME.  The
\*LXmNclientData\*O resource is set to the index of the item in the list.
.PP
.LI "\*L<Apply\ Button\ Activated>\*O:"
Initiates a directory and file search.
Calls the \*LXmNapplyCallback\*O callbacks with reason \*LXmCR_APPLY\*O.
.LI "\*L<OK\ Button\ Activated>\*O:"
If \*LXmNmustMatch\*O is True and the selection text does not match an
item in the file list, calls the \*LXmNnoMatchCallback\*O callbacks with
reason \*LXmCR_NO_MATCH\*O.
Otherwise, calls the \*LXmNokCallback\*O callbacks with reason
\*LXmCR_OK\*O.
.P 
.ne 3i
.LI "\*L<Cancel\ Button\ Activated>\*O:"
Calls the \*LXmNcancelCallback\*O callbacks with reason
\*LXmCR_CANCEL\*O.
.LI "\*L<Help\ Button\ Activated>\*O:"
Calls the \*LXmNhelpCallback\*O callbacks with reason \*LXmCR_HELP\*O.
.nL
.ne 5
.LI "\*L<KActivate>\*O:"
If no button, list widget, or text widget has the keyboard focus:
If \*LXmNmustMatch\*O is True and the selection text does not match an
item in the file list, calls the \*LXmNnoMatchCallback\*O callbacks with
reason \*LXmCR_NO_MATCH\*O.
Otherwise, calls the \*LXmNokCallback\*O callbacks with reason
\*LXmCR_OK\*O.
.LE
.SS "Virtual Bindings"
The bindings for virtual keys are vendor specific.
For information about bindings for virtual buttons and keys, see \*LVirtualBindings(3X)\*O.
.SH RELATED INFORMATION
.na
\*LComposite(3X)\*O,
\*LConstraint(3X)\*O,
\*LCore(3X)\*O,
\*LXmBulletinBoard(3X)\*O,
\*LXmCreateFileSelectionBox(3X)\*O,
\*LXmCreateFileSelectionDialog(3X)\*O,
\*LXmFileSelectionBoxGetChild(3X)\*O,
\*LXmFileSelectionDoSearch(3X)\*O,
\*LXmManager(3X)\*O, and
\*LXmSelectionBox(3X)\*O.
.ad
