...\" **
...\" **
...\" **  (c) Copyright 1991, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1991 by Hewlett-Packard Company
...\" **
...\" **
.TH XmDropSite 3X "" "" "" ""
...\" ______________ start of SML macros ______________
.ds !) CW
.ds !] (CW
.cs \*(!) 20
.bd \*(!) 2
.ds |A Chapter
.nr |P 0
.nr |D 1
.deaS
..
.deaE
..
.deoS
.SP
.ps -1
.ft \\*(!)
.nf
.nr !x 8*\\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.if\\n(.$>0 .in 0
..
.deoE
.ps +1
.ft R
.fi
.SP
..
.deiS
.SP
.ps -1
.ft B
.nf
..
.deiE
.ps +1
.ft R
.fi
.SP
..
.decS
.ig cE
..
.decE
..
.dezA
.SP 1
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (start)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (start)\ \ \\l\\n(|Qu
.br
..
.dezZ
.br
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (end)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (end)\ \ \\l\\n(|Qu
.SP 1
..
.delS
..
.delE
..
.nr Nn 0 1
.denS
.P
.nr Nn +1
.ie\\$1warning .ds yy Warning:\ \
.el.ie\\$1caution .ds yy Caution:\ \
.el.ie\\$1note .ds yy Note:\ \
.el.ie\\$1reviewnote \{\
.	ds yy
.	ps +2
.	ft B
.	P
Review Note To Developers:
.	P
.	ft
.	ps -2 \}
.el.ds yy \\$1:\ \
.ft B
.ll -\w\\*(yyu
.in +\w\\*(yyu
.ti -\w\\*(yyu
\\*(yy\c
.ft
..
.denE
.nr Nn -1
.in -\w\\*(yyu
.ll +\w\\*(yyu
.P
..
.de |F
.ie\\$1table .nr |F 1
.el.nr |F 0
.ie\\n(|D=0&\\n(|F=1 \{\
.	ds L \&\\f(HB
.	ds V \&\\f(HI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fH
.	ds C \&\\f\\*(!]
.	ds U \&\\f(HB
.	ds E \&\\f(HI
'	br \}
.el\{\
.	ds L \&\\fB
.	ds V \&\\fI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fR
.	ds C \&\\f\\*(!]
.	ds U \&\\fB
.	ds E \&\\fI
'	br \}
..
.|F general
.am TS
.|F table
..
.am TE
.|F general
..
.desS
.SP
..
.desE
.SP
..
.defS
.br
\&\fB\\$1(\fP
.nr !+ 1
.nr !% 0
..
.defE
\fB);\fP
.br
.if\\n(!%=1 .in -5i
.nr !+ 0
.nr !% 0
..
.dedS
.if\\n(!+=1 \{\
.	ie \\n(!%=0 .in +.5i
.	el \fB,\fP
'	br \}
.br
\&\fB\\$1\fR
.nr !% 1
..
.dedE
.if\\n(!+=0 \fB;\fR
..
.dekY
.ft B
<\\$1>
.ft
..
.de K,
\fB<\\$1>\fP\\$2
..
.de ,K
\&\\$1\fB<\\$2>\fP
..
.deeM
.ft I
\&\\$1
.ft
..
.de E,
\&\fI\\$1\fP\^\\$2
..
.de ,E
\&\\$1\^\fI\\$2\fP
..
.dedI
.so \\$1
..
.deeI
.nf
.ft CW
.nr !x 8*\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.de !~
so\\$1
\\..
.wh \\n(nlu+\\n(.tu-1v e,
.e:
!~
e;
.ft
.fi
.ch e,
..
.de e:
.eo
.c2 
.cc 
..
.de e;
cc
.c2
.ec
..
.de e,
e;
'bp
.e:
..
.depI
.br
.fl
.rs
.sy includePS "\\$1" "\\$2" "\\$3" > /tmp/pI.tmp.
.so /tmp/pI.tmp.
.sy rm -f /tmp/pI.tmp.
..
.depM
..
.denP
.bp
..
.denL
.br
..
.dewH
..
.rn RS rS
.rn RE rE
.detH
..
.am TH
.|Y TH "\\$1"
..
.am SH
.|Y SH "\\$1"
..
.am SS
.|Y SS "\\$1"
..
.nr Ll 0 1
.nr $A 0 1
.nr $M 0 1
.nr $V 0 1
.de |Y
.if\\n(Ll>0 \{\
.	tm unterminated list (no .LE) -- noticed by the .\\$1 "\\$2"
.	nr Ll 0
'	br \}
..
.rn PP P#
.dePP
.ie(\\n(Ll>0):(\\n(Nn>0) .sp \\n(PDu
.el.P#
..
.deML
.SP
.nr $M +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($M=1 .ds %\\n(Ll \(bu
.el\{\
.	ie t .ds %\\n(Ll \(em
.	el .ds %\\n(Ll --
'	br \}
.ien .ds %\\n(Ll "\ \ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \ \ \\*(%\\n(Ll
.nr #\\n(Ll 0 1
.ds #\\n(Ll M
..
.deVL
.SP
.nr $V +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.ie\\$1 .nr %\\n(Ll 1i
.el.nr %\\n(Ll \\$1n
.ds #\\n(Ll V
..
.deAL
.SP
.nr $A +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($A=1 .af #\\n(Ll 1
.el.ie\\n($A=2 .af #\\n(Ll a
.el.af #\\n(Ll i
.nr #\\n(Ll 0 1
.ds %\\n(Ll \\\\\\\\\\\\\\\\n+(#\\n(Ll
.ien .ds %\\n(Ll "\ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \\*(%\\n(Ll
.ds #\\n(Ll A
..
.deLI
.SP .25
.ie\\*(#\\n(LlV \{\
.	IP "\\$1" \\n(%\\n(Llu
'	br \}
.el.ie\\*(#\\n(LlM \{\
.	IP \\*(%\\n(Ll \\n(%\\n(Llu
'	br \}
.el.IP \\*(%\\n(Ll. \\n(%\\n(Llu
..
.deLE
.ie\\*(#\\n(LlA \{\
.	nr $A -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.ie\\*(#\\n(LlV \{\
.	nr $V -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.if\\*(#\\n(LlM \{\
.	nr $M -1
.	nr Ll -1
.	if \\n(Ll>=0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.SP
..
.deFG
.)F Figure 0 \\n+(Fg "\\$1"
..
.deTB
.)F Table 1 \\n+(Tb "\\$1"
..
.deEC
.)F Equation 2 \\n+(Ec "\\$1"
..
.deEX
.)F Exhibit 3 \\n+(Ex "\\$1"
..
.de )F
.sp \\n(PDu
.ce 1
\\$1\ \\n(H1\(mi\\$3.\ \ \\$4
.sp \\n(PDu
.if\\n(|Z=1 .tm !TOC: .if \\$2=\\\\\\\\$1 .)T 1 1 "\\$1\ \\n(H1\(mi\\$3.\ \ " "\\$4" \\nP \\n(H1
..
.deSP
.br
.nr |Q \\n(PDu
.if\\n(.$ .nr |Q \\$1v
.if!(\\n(nl=\\n(|B) .nr |A 0
.nr |Q -\\n(|Au
.if\\n(|Q \{\
.	sp \\n(|Qu
.	nr |A +\\n(|Qu
'	br \}
.nr |B \\n(nl
..
...\" ______________ end of SML macros ______________
.SH NAME
\*LXmDropSite\*O\(emThe DropSite Registry
.iX "XmDropSite"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/DragDrop.h>
.iE
.sE
.SH DESCRIPTION
A client registers a widget or gadget as a drop site using the
\*LXmDropSiteRegister\*O function.  In addition, this routine
defines the behavior and capabilities of a drop site by specifying
appropriate resources.  For example, the \*LXmNimportTargets\*O
and \*LXmNnumImportTargets\*O resources identify respectively the
selection target types and number of types supported by a drop
site.  The visual animation effects associated with
a drop site are also described with DropSite resources.
.PP
Drop site animation effects that occur in response to the pointer
entering a valid drop site are called drag-under effects.  A receiver
can select from several animation styles supplied by the toolkit or
can provide customized animation effects.  Drag-under effects supplied
by the toolkit include border highlighting, shadow in/out drawing,
and pixmap representation.
.PP
When a preregister drag protocol style is used, the toolkit generates
drag-under visual effects based on the value of the \*LXmNanimationStyle\*O
resource.  In dynamic mode, if the drop site \*LXmNdragProc\*O
resource is NULL, the toolkit also provides animation effects based on
the \*LXmNanimationStyle\*O resource.  Otherwise, if the \*LXmNdragProc\*O
routine is specified, the receiver can either assume
responsibility for animation effects (through the \*LXmNdragProc\*O routine)
or rely on the toolkit to provide animation. 
.PP
Drop sites may overlap.  The initial stacking order corresponds to the
order in which the drop sites were registered.  When a drop site
overlaps another drop site, the drag-under effects of the 
drop site underneath are clipped by the obscuring drop site(s).
.PP
The \*LXmDropSiteUpdate\*O routine sets resources for a widget
that is registered as a drop site.  \*LXmDropSiteRetrieve\*O gets drop 
site resource values previously specified for a registered widget.  These
routines are used instead of \*LXtSetValues\*O and \*LXtGetValues\*O.
.SS "Classes"
XmDropSite does not inherit from any widget class.
.SS "New Resources"
The following table defines a set of widget resources used by the
programmer to specify data.  To reference a resource by name 
or by class in a .Xdefaults file, remove the \*LXmN\*O or \*LXmC\*O
prefix and use the remaining letters.  To specify one of the defined
values for a resource in a .Xdefaults file, remove the \*LXm\*O prefix
and use the remaining letters (in either lowercase or uppercase, but include
any underscores between words).  The codes in the access column
indicate if the given resource can be set at creation time (\*LC\*O),
set by using \*LXmDropSiteUpdate\*O (\*LS\*O), retrieved by using
\*LXmDropSiteRetrieve\*O (\*LG\*O), or is not applicable (\*LN/A\*O).
.PP
...\" NROFF HACK START
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 48 49 50
.nr 48 0
.nr 38 \w\f3Name\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Class\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNanimationMask
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCAnimationMask
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNanimationPixmap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCAnimationPixmap
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNanimationPixmapDepth
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCAnimationPixmapDepth
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w XmNanimationStyle
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCAnimationStyle
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdragProc
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDragProc
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdropProc
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDropProc
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdropRectangles
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDropRectangles
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdropSiteActivity
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDropSiteActivity
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdropSiteOperations
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDropSiteOperations
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNdropSiteType
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCDropSiteType
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNimportTargets
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCImportTargets
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNnumDropRectangles
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCNumDropRectangles
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \wXmNnumImportTargets
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\ \ \ \ \ \ XmCNumImportTargets
.if \n(48<\n(38 .nr 48 \n(38
.48
.rm 48
.nr 49 0
.nr 38 \w\f3Default\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3\ \ \ \ \ \ Type\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmUNSPECIFIED_PIXMAP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixmap
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmUNSPECIFIED_PIXMAP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Pixmap
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w0
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ int
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmDRAG_UNDER_HIGHLIGHT
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ unsigned char
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtCallbackProc
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XtCallbackProc
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wdynamic
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ XRectangle *
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmDROP_SITE_ACTIVE
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ unsigned char
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmDROP_MOVE   XmDROP_COPY
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ unsigned char
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wXmDROP_SITE_SIMPLE
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ unsigned char
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \wNULL
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Atom *
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w1
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Cardinal
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w0
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\ \ \ \ \ \ \ Cardinal
.if \n(49<\n(38 .nr 49 \n(38
.49
.rm 49
.nr 50 0
.nr 38 \w\f3Access\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wCSG
.if \n(50<\n(38 .nr 50 \n(38
.50
.rm 50
.nr 38 \w\f3XmDropSite Resource Set\fP-\n(48-3n-\n(49-3n-\n(50
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 49 +\n(38
.nr 50 +\n(38
.nr 38 1n
.nr 47 0
.nr 40 \n(47+((0*\n(38)/2)
.nr 48 +\n(40
.nr 41 \n(48+((6*\n(38)/2)
.nr 49 +\n(41
.nr 42 \n(49+((6*\n(38)/2)
.nr 50 +\n(42
.nr TW \n(50
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 120 file Input is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3XmDropSite Resource Set\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3Name\f\n(31\h'|\n(41u'\f3Default\f\n(31\h'|\n(42u'\f3Access\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\ \ \ \ \ \ Class\f\n(31\h'|\n(41u'\f3\ \ \ \ \ \ Type\f\n(31\h'|\n(42u'\f3\f\n(31
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNanimationMask\h'|\n(41u'XmUNSPECIFIED_PIXMAP\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCAnimationMask\h'|\n(41u'\ \ \ \ \ \ \ Pixmap\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNanimationPixmap\h'|\n(41u'XmUNSPECIFIED_PIXMAP\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCAnimationPixmap\h'|\n(41u'\ \ \ \ \ \ \ Pixmap\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNanimationPixmapDepth\h'|\n(41u'0\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCAnimationPixmapDepth\h'|\n(41u'\ \ \ \ \ \ \ int\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u' XmNanimationStyle\h'|\n(41u'XmDRAG_UNDER_HIGHLIGHT\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCAnimationStyle\h'|\n(41u'\ \ \ \ \ \ \ unsigned char\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdragProc\h'|\n(41u'NULL\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDragProc\h'|\n(41u'\ \ \ \ \ \ \ XtCallbackProc\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdropProc\h'|\n(41u'NULL\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDropProc\h'|\n(41u'\ \ \ \ \ \ \ XtCallbackProc\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdropRectangles\h'|\n(41u'dynamic\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDropRectangles\h'|\n(41u'\ \ \ \ \ \ \ XRectangle *\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdropSiteActivity\h'|\n(41u'XmDROP_SITE_ACTIVE\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDropSiteActivity\h'|\n(41u'\ \ \ \ \ \ \ unsigned char\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdropSiteOperations\h'|\n(41u'XmDROP_MOVE   XmDROP_COPY\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDropSiteOperations\h'|\n(41u'\ \ \ \ \ \ \ unsigned char\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNdropSiteType\h'|\n(41u'XmDROP_SITE_SIMPLE\h'|\n(42u'CG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCDropSiteType\h'|\n(41u'\ \ \ \ \ \ \ unsigned char\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNimportTargets\h'|\n(41u'NULL\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCImportTargets\h'|\n(41u'\ \ \ \ \ \ \ Atom *\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNnumDropRectangles\h'|\n(41u'1\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCNumDropRectangles\h'|\n(41u'\ \ \ \ \ \ \ Cardinal\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'XmNnumImportTargets\h'|\n(41u'0\h'|\n(42u'CSG
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\ \ \ \ \ \ XmCNumImportTargets\h'|\n(41u'\ \ \ \ \ \ \ Cardinal\h'|\n(42u'
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-51
...\" NROFF HACK END
.PP
.VL
.LI "\*LXmNanimationMask\*O"
Specifies a mask to use with the pixmap specified
by \*LXmNanimationPixmap\*O when the animation style is
\*LXmDRAG_UNDER_PIXMAP\*O.
.LI "\*LXmNanimationPixmap\*O"
Specifies a pixmap for drag-under animation when the 
animation style is \*LXmDRAG_UNDER_PIXMAP\*O.  The pixmap
is drawn with its origin at the upper left corner of the
bounding box of the drop site.  If the drop site window
is larger than the animation pixmap, the portion of the
window not covered by the pixmap will be tiled with the
window's background color.
.LI "\*LXmNanimationPixmapDepth\*O"
Specifies the depth of the pixmap specified by the
\*LXmNanimationPixmap\*O resource.  When the depth is 1, the
colors are taken from the foreground and background of the
drop site widget.  For any other value, drop site animation
occurs only if the \*LXmNanimationPixmapDepth\*O matches the
depth of the drop site window.  Colors are derived from the
current colormap.
.LI "\*LXmNanimationStyle\*O"
Specifies the drag-under animation style used when a drag enters
a valid drop site.  The possible values are
.VL .25i
.LI "\*LXmDRAG_UNDER_HIGHLIGHT\*O"
The drop site uses highlighting effects.
.LI "\*LXmDRAG_UNDER_SHADOW_OUT\*O"
The drop site uses an outset shadow.
.LI "\*LXmDRAG_UNDER_SHADOW_IN\*O"
The drop site uses an inset shadow.
.LI "\*LXmDRAG_UNDER_PIXMAP\*O"
The drop site uses the pixmap specified by \*LXmNanimationPixmap\*O
to indicate that it can receive the drop.
.LI "\*LXmDRAG_UNDER_NONE\*O"
The drop site does not use animation effects.  A client
using a dynamic protocol, may provide drag-under
effects in its \*LXmNdragProc\*O routine.
.LE
.LI "\*LXmNdragProc\*O"
Specifies the procedure that is invoked when the drop site
receives a crossing, motion, or operation changed message.  This
procedure is called only when a dynamic protocol is used.
The type of structure whose address is passed to this 
procedure is \*LXmDragProcCallbackStruct\*O.
The reason sent to the procedure is one of
the following:
.VL .25i
.LI "\*LXmCR_DROP_SITE_ENTER_MESSAGE\*O"
.LI "\*LXmCR_DROP_SITE_LEAVE_MESSAGE\*O" 
.LI "\*LXmCR_DRAG_MOTION_MESSAGE\*O" 
.LI "\*LXmCR_OPERATION_CHANGED_MESSAGE\*O"
.LE
.PP
The drag procedure may change the values of some members of the
\*LXmDragProcCallbackStruct\*O passed to it.
After the drag procedure returns, the toolkit uses the final values in
initializing some members of the callback struct passed to the
appropriate callbacks of the initiator (the DragContext's
\*LXmNdropSiteEnterCallback\*O, \*LXmNdropSiteLeaveCallback\*O,
\*LXmNdragMotionCallback\*O, or \*LXmNoperationChangedCallback\*O
callbacks).
.LI "\*LXmNdropProc\*O"
Specifies the procedure that is invoked when a drop
(excluding a cancel or interrupt action) occurs
on a drop site regardless of the status of the drop site.  The
type of the structure whose address is passed to this procedure
is \*LXmDropProcCallbackStruct\*O.  The reason
sent to the procedure is \*LXmCR_DROP_MESSAGE\*O.
.PP
The drop procedure may change the values of some members of the
\*LXmDropProcCallbackStruct\*O passed to it.
After the drop procedure returns, the toolkit uses the final values in
initializing some members of the \*LXmDropStartCallbackStruct\*O passed
to the initiator's drop start callbacks (the DragContext's
\*LXmNdropStartCallback\*O callbacks).
.LI "\*LXmNdropRectangles\*O"
Specifies a list of rectangles that describe the shape of a 
drop site.  The locations of the rectangles are relative to the
origin of the enclosing object.  When \*LXmNdropRectangles\*O
is NULL, the drop site is assumed to be the sensitive area of 
the enclosing widget.  If \*LXmNdropSiteType\*O is
\*LXmDROP_SITE_COMPOSITE\*O, this resource cannot be specified by
the application.
.LI "\*LXmNdropSiteActivity\*O"
Indicates whether a drop site is active or inactive.  The values
are \*LXmDROP_SITE_ACTIVE\*O and \*LXmDROP_SITE_INACTIVE\*O.  An
active drop site can receive a drop, whereas an inactive drop
site is dormant.  An inactive drop site is treated as if it was
not a registered drop site and any drag-under visuals associated
with entering or leaving the drop site do not occur.  However, it
is still used for clipping drag-under effects.
.LI "\*LXmNdropSiteOperations\*O"
Specifies the set of valid operations associated with a drop site.
This resource is a bit mask that is formed by combining one or
more of the following values using a bitwise operation such as
inclusive OR (|):
\*LXmDROP_COPY\*O, \*LXmDROP_LINK\*O, and \*LXmDROP_MOVE\*O.
The value \*LXmDROP_NOOP\*O for this resource indicates that no
operations are valid.
.LI "\*LXmNdropSiteType\*O"
Specifies the type of the drop site. The possible values are
.VL .25i
.LI "\*LXmDROP_SITE_SIMPLE\*O"
The widget does not have any additional children that
are registered as drop sites.
.LI "\*LXmDROP_SITE_COMPOSITE\*O"
The widget will have children that are registered as drop
sites.
.LE
.LI "\*LXmNimportTargets\*O"
Specifies the list of target atoms that this drop site accepts.
.LI "\*LXmNnumDropRectangles\*O"
Specifies the number of rectangles in the \*LXmNdropRectangles\*O
list.  If the drop site type is \*LXmDROP_SITE_COMPOSITE\*O, this resource
can not be specified by the application.
.LI "\*LXmNnumImportTargets\*O"
Specifies the number of atoms in the target atom list.
.LE
.SS "Callback Information"
A pointer to the following structure is passed to the
\*LXmNdragProc\*O routine when the drop site receives
crossing, motion, or operation changed messages.
.sS
.iS
.ta .25i 1.5i
typedef struct
{
        int	\*Vreason\*L;
	XEvent	*\*Vevent\*L;
	Time	\*VtimeStamp\*L;
	Widget		\*VdragContext\*L
	Position	\*Vx\*L;
	Position	\*Vy\*L;
	unsigned char	\*VdropSiteStatus\*L;
	unsigned char	\*Voperation\*L;
	unsigned char	\*Voperations\*L;
	Boolean		\*Vanimate\*L;
} XmDragProcCallbackStruct, *XmDragProcCallback;
.iE
.sE
.VL 1.25i
.LI "\*Vreason\*O"
Indicates why the callback was invoked.
.LI "\*Vevent\*O"
Points to the \*LXEvent\*O that triggered the callback.
.LI "\*VtimeStamp\*O"
Specifies the timestamp of the logical event.
.LI "\*VdragContext\*O"
Specifies the ID of the DragContext widget associated with
the transaction.
.LI "\*Vx\*O"
Indicates the x-coordinate of the pointer relative
to the drop site.
.LI "\*Vy\*O"
Indicates the y-coordinate of the pointer relative
to the drop site.
.LI "\*VdropSiteStatus\*O"
An IN/OUT member that indicates whether or not a drop site is valid.
.PP
When the \*Vreason\*O is \*LXmCR_DROP_SITE_ENTER_MESSAGE\*O or
\*LXmCR_OPERATION_CHANGED_MESSAGE\*O, or when the reason is
\*LXmCR_DRAG_MOTION_MESSAGE\*O or \*LXmCR_DROP_SITE_LEAVE_MESSAGE\*O and
the pointer is not in the same drop site as on the previous invocation
of the drag procedure, the toolkit initializes \*VdropSiteStatus\*O as
follows:
the toolkit initializes \*VdropSiteStatus\*O to \*LXmDROP_SITE_VALID\*O
if the DragContext's \*LXmNexportTargets\*O and the DropSite's
\*LXmNimportTargets\*O are compatible and if the initial value of the
\*Voperation\*O member is not \*LXmDROP_NOOP\*O.
Otherwise, the toolkit initializes \*VdropSiteStatus\*O to
\*LXmDROP_SITE_INVALID\*O.
.PP
When the \*Vreason\*O is \*LXmCR_DRAG_MOTION_MESSAGE\*O or
\*LXmCR_DROP_SITE_LEAVE_MESSAGE\*O and the pointer is within the same
drop site as on the previous invocation of the drag procedure, the
toolkit initializes \*VdropSiteStatus\*O to the value of
\*VdropSiteStatus\*O at the time the previous invocation of the drag
procedure returns.
.PP
The drag procedure may change the value of this member.
After the drag procedure returns, the toolkit uses the final value in
initializing the \*VdropSiteStatus\*O member of the callback struct
passed to the appropriate callbacks of the initiator.
.LI "\*Voperation\*O"
An IN/OUT member that identifies an operation.
.PP
The toolkit initializes \*Voperation\*O by selecting an operation
from the bitwise AND of the initial value of the \*Voperations\*O member
and the value of the DropSite's \*LXmNdropSiteOperations\*O resource.
The toolkit searches this set first for \*LXmDROP_MOVE\*O, then for
\*LXmDROP_COPY\*O, then for \*LXmDROP_LINK\*O, and initializes
\*Voperation\*O to the first operation it finds in the set.
If the toolkit finds none of these operations in the set, it initializes
\*Voperation\*O to \*LXmDROP_NOOP\*O.
.PP
The drag procedure may change the value of this member.
After the drag procedure returns, the toolkit uses the final value in
initializing the \*Voperation\*O member of the callback struct
passed to the appropriate callbacks of the initiator.
.LI "\*Voperations\*O"
An IN/OUT member that indicates the set of operations supported for the
source data.
.PP
If the user does not select an operation (by pressing a modifier key),
the toolkit initializes \*Voperations\*O to the value of the
DragContext's \*LXmNdragOperations\*O resource.
If the user does select an operation, the toolkit initializes
\*Voperations\*O to the bitwise AND of the corresponding operation and
the value of the DragContext's \*LXmNdragOperations\*O resource.
If the resulting set of operations is empty, the toolkit initializes
\*Voperations\*O to \*LXmDROP_NOOP\*O.
.PP
The drag procedure may change the value of this member.
After the drag procedure returns, the toolkit uses the final value in
initializing the \*Voperations\*O member of the callback struct
passed to the appropriate callbacks of the initiator.
.LI "\*Vanimate\*O"
An OUT member that indicates whether the toolkit or
the receiver client provides drag-under effects for a valid
drop site.  If \*Vanimate\*O is set to True, the toolkit provides 
drop site animation per the \*LXmNanimationStyle\*O 
resource value; if it is set to False,
the receiver generates drag-under animation effects.
.LE
.PP
A pointer to the following structure is passed to the \*LXmNdropProc\*O
routine when the drop site receives a drop message:
.sS
.iS
.ta .25i 1.5i
typedef struct
{
        int	\*Vreason\*L;
	XEvent	*\*Vevent\*L;
	Time	\*VtimeStamp\*L;
	Widget		\*VdragContext\*L;
	Position	\*Vx\*L;
	Position	\*Vy\*L;
	unsigned char	\*VdropSiteStatus\*L;
	unsigned char	\*Voperation\*L;
	unsigned char	\*Voperations\*L;
	unsigned char	\*VdropAction\*L;
} XmDropProcCallbackStruct, *XmDropProcCallback;
.iE
.sE
.VL 1.25i
.LI "\*Vreason\*O"
Indicates why the callback was invoked.
.LI "\*Vevent\*O"
Specifies the \*LXEvent\*O that triggered the callback.
.LI "\*VtimeStamp\*O"
Specifies the timestamp of the logical event.
.LI "\*VdragContext\*O"
Specifies the ID of the DragContext widget associated with the
transaction.
.LI "\*Vx\*O"
Indicates the x-coordinate of the pointer relative to the
drop site.
.LI "\*Vy\*O"
Indicates the y-coordinate of the pointer relative to the
drop site.
.LI "\*VdropSiteStatus\*O"
An IN/OUT member that indicates whether or not a drop site is valid.
.PP
The toolkit initializes \*VdropSiteStatus\*O to \*LXmDROP_SITE_VALID\*O
if the DragContext's \*LXmNexportTargets\*O and the DropSite's
\*LXmNimportTargets\*O are compatible and if the initial value of the
\*Voperation\*O member is not \*LXmDROP_NOOP\*O.
Otherwise, the toolkit initializes \*VdropSiteStatus\*O to
\*LXmDROP_SITE_INVALID\*O.
.PP
The drop procedure may change the value of this member.
After the drop procedure returns, the toolkit uses the final value in
initializing the \*VdropSiteStatus\*O member of the
\*LXmDropStartCallbackStruct\*O passed to the initiator's drop start
callbacks (the DragContext's \*LXmNdropStartCallback\*O callbacks).
.LI "\*Voperation\*O"
An IN/OUT member that identifies an operation.
.PP
The toolkit initializes \*Voperation\*O by selecting an operation
from the bitwise AND of the initial value of the \*Voperations\*O member
and the value of the DropSite's \*LXmNdropSiteOperations\*O resource.
The toolkit searches this set first for \*LXmDROP_MOVE\*O, then for
\*LXmDROP_COPY\*O, then for \*LXmDROP_LINK\*O, and initializes
\*Voperation\*O to the first operation it finds in the set.
If it finds none of these operations in the set, it initializes
\*Voperation\*O to \*LXmDROP_NOOP\*O.
.PP
The drop procedure may change the value of this member.
After the drop procedure returns, the toolkit uses the final value in
initializing the \*Voperation\*O member of the
\*LXmDropStartCallbackStruct\*O passed to the initiator's drop start
callbacks (the DragContext's \*LXmNdropStartCallback\*O callbacks).
.LI "\*Voperations\*O"
An IN/OUT member that indicates the set of operations supported for the
source data.
.PP
If the user does not select an operation (by pressing a modifier key),
the toolkit initializes \*Voperations\*O to the value of the
DragContext's \*LXmNdragOperations\*O resource.
If the user does select an operation, the toolkit initializes
\*Voperations\*O to the bitwise AND of the corresponding operation and
the value of the DragContext's \*LXmNdragOperations\*O resource.
If the resulting set of operations is empty, the toolkit initializes
\*Voperations\*O to \*LXmDROP_NOOP\*O.
.PP
The drop procedure may change the value of this member.
After the drop procedure returns, the toolkit uses the final value in
initializing the \*Voperations\*O member of the
\*LXmDropStartCallbackStruct\*O passed to the initiator's drop start
callbacks (the DragContext's \*LXmNdropStartCallback\*O callbacks).
.LI "\*VdropAction\*O"
An IN/OUT member that identifies the action associated with the drop.
The possible values are
.VL .25i
.LI "\*LXmDROP\*O"
A drop was attempted.  If the drop site is valid, drop transfer
handling proceeds.
.LI "\*LXmDROP_HELP\*O"
The user has requested help on the drop site.
.LE
.PP
The drop procedure may change the value of this member.
After the drop procedure returns, the toolkit uses the final value in
initializing the \*VdropAction\*O member of the
\*LXmDropStartCallbackStruct\*O passed to the initiator's drop start
callbacks (the DragContext's \*LXmNdropStartCallback\*O callbacks).
.LE
.SH "RELATED INFORMATION"
.na
\*LXmDragContext(3X)\*O,
\*LXmDragIcon(3X)\*O,
\*LXmDropSiteConfigureStackingOrder(3X)\*O,
\*LXmDropSiteEndUpdate(3X)\*O,
\*LXmDropSiteQueryStackingOrder(3)\*O,
\*LXmDropSiteRegister(3X)\*O,
\*LXmDropSiteStartUpdate(3X)\*O,
\*LXmDropSiteUpdate(3X)\*O,
\*LXmDropSiteUnregister(3X)\*O,
\*LXmDropTransfer(3X)\*O, and
\*LXmTargetsAreCompatible(3X)\*O.
.ad
