...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmDialogShell 3X  "" "" "" ""
.SH NAME
\*LXmDialogShell\*O\(emThe DialogShell widget class
.iX "XmDialogShell"
.iX "widget class" "DialogShell"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/DialogS.h>
.iE
.sE
.SH DESCRIPTION
Modal and modeless dialogs use DialogShell as the Shell parent.
DialogShell widgets cannot
be iconified.  Instead, all secondary DialogShell widgets
associated with an ApplicationShell widget are iconified and
de-iconified as a group with the primary widget.
.PP 
The client indirectly manipulates DialogShell via the convenience
interfaces during creation, and it can directly manipulate its
BulletinBoard-derived child.
Much of the functionality of DialogShell assumes
that its child is a BulletinBoard subclass, although it
can potentially stand alone.
.PP
Setting \*LXmNheight\*O, \*LXmNwidth\*O, or \*LXmNborderWidth\*O for
either a DialogShell or its managed child usually sets that resource to the
same value in both the parent and the child.  When an off-the-spot input
method exists, the height and width of the shell may be greater than
those of the managed child in order to accommodate the input method.
In this case setting \*LXmNheight\*O or \*LXmNwidth\*O for the
shell does not necessarily set that resource to the same value in
the managed child, and setting \*LXmNheight\*O or \*LXmNwidth\*O
for the child does not necessarily set that resource to the same
value in the shell.
.PP 
For the managed child of a DialogShell, regardless of the value of
the shell's \*LXmNallowShellResize\*O, setting \*LXmNx\*O or \*LXmNy\*O
sets the corresponding resource of the parent but does not change the
child's position relative to the parent.
\*LXtGetValues\*O for the child's \*LXmNx\*O or \*LXmNy\*O yields the
value of the corresponding resource in the parent.
The \*Vx\*O and \*Vy\*O coordinates of the child's upper left outside
corner relative to the parent's upper left inside corner are both zero
minus the value of \*LXmNborderWidth\*O.
.PP 
Note that the \*VInter-Client Communication Conventions Manual\*O allows
a window manager to change or control the border width of a reparented
top-level window.
.SS "Classes"
DialogShell inherits behavior and resources from \*LCore\*O,
\*LComposite\*O, \*LShell\*O,
\*LWMShell\*O, \*LVendorShell\*O, and \*LTransientShell\*O classes.
.PP 
The class pointer is \*LxmDialogShellWidgetClass\*O.
.PP 
The class name is \*LXmDialogShell\*O.
.SS "New Resources"
DialogShell defines no new resources but overrides the \*LXmNdeleteResponse\*O
resource in the \*LVendorShell\*O class.
.SS "Inherited Resources"
DialogShell inherits behavior and resources from the following
superclasses.  For a complete description of each resource, refer to the
man page for that superclass.
.PP 
The following table defines a set of widget resources used by the programmer
to specify data.  The programmer can also set the resource values for the
inherited classes to set attributes for this widget.  To reference a
resource by name or by class in a .Xdefaults file, remove the \*LXmN\*O or
\*LXmC\*O prefix and use the remaining letters.  To specify one of the defined
values for a resource in a .Xdefaults file, remove the \*LXm\*O prefix and use
the remaining letters (in either lowercase or uppercase, but include any
underscores between words).
The codes in the access column indicate if the given resource can be
set at creation time (C),
set by using \*LXtSetValues\*O (S),
retrieved by using \*LXtGetValues\*O (G), or is not applicable
(N/A).
.P 
.TS 
center allbox;
cBp9 ssss
lBp8 lBp8 lBp8 lBp8 lBp8
lp8 lp8 lp8 lp8 lp8.
TransientShell Resource Set
Name	Class	Type	Default	Access
_
XmNtransientFor	XmCTransientFor	Widget	NULL	CSG
.TE
.P 
.TS 
center allbox;
cBp9 ssss
lBp8 lBp8 lBp8 lBp8 lBp8
lp8 lp8 lp8 lp8 lp8.
VendorShell Resource Set
Name	Class	Type	Default	Access
_
XmNaudibleWarning	XmCAudibleWarning	unsigned char	XmBELL	CSG
XmNbuttonFontList	XmCButtonFontList	XmFontList	dynamic	CSG
XmNdefaultFontList	XmCDefaultFontList	XmFontList	dynamic	CG
XmNdeleteResponse	XmCDeleteResponse	unsigned char	XmUNMAP	CSG
XmNinputMethod	XmCInputMethod	String	NULL	CSG
XmNkeyboardFocusPolicy	XmCKeyboardFocusPolicy	unsigned char	XmEXPLICIT	CSG
XmNlabelFontList	XmCLabelFontList	XmFontList	dynamic	CSG
XmNmwmDecorations	XmCMwmDecorations	int	-1	CSG
XmNmwmFunctions	XmCMwmFunctions	int	-1	CSG
XmNmwmInputMode	XmCMwmInputMode	int	-1	CSG
XmNmwmMenu	XmCMwmMenu	String	NULL	CSG
XmNpreeditType	XmCPreeditType	String	dynamic	CSG
XmNshellUnitType	XmCShellUnitType	unsigned char	XmPIXELS	CSG
XmNtextFontList	XmCTextFontList	XmFontList	dynamic	CSG
XmNuseAsyncGeometry	XmCUseAsyncGeometry	Boolean	False	CSG
.TE
.P 
.TS 
center allbox;
cBp9 ssss
lBp8 lBp8 lBp8 lBp8 lBp8
lp8 lp8 lp8 lp8 lp8.
WMShell Resource Set
Name	Class	Type	Default	Access
_
XmNbaseHeight	XmCBaseHeight	int	XtUnspecifiedShellInt	CSG
XmNbaseWidth	XmCBaseWidth	int	XtUnspecifiedShellInt	CSG
XmNheightInc	XmCHeightInc	int	XtUnspecifiedShellInt	CSG
XmNiconMask	XmCIconMask	Pixmap	NULL	CSG
XmNiconPixmap	XmCIconPixmap	Pixmap	NULL	CSG
XmNiconWindow	XmCIconWindow	Window	NULL	CSG
XmNiconX	XmCIconX	int	\-1	CSG
XmNiconY	XmCIconY	int	\-1	CSG
XmNinitialState	XmCInitialState	int	NormalState	CSG
XmNinput	XmCInput	Boolean	True	CSG
XmNmaxAspectX	XmCMaxAspectX	int	XtUnspecifiedShellInt	CSG
XmNmaxAspectY	XmCMaxAspectY	int	XtUnspecifiedShellInt	CSG
XmNmaxHeight	XmCMaxHeight	int	XtUnspecifiedShellInt	CSG
XmNmaxWidth	XmCMaxWidth	int	XtUnspecifiedShellInt	CSG
.wH .tH
XmNminAspectX	XmCMinAspectX	int	XtUnspecifiedShellInt	CSG
XmNminAspectY	XmCMinAspectY	int	XtUnspecifiedShellInt	CSG
XmNminHeight	XmCMinHeight	int	XtUnspecifiedShellInt	CSG
XmNminWidth	XmCMinWidth	int	XtUnspecifiedShellInt	CSG
XmNtitle	XmCTitle	String	dynamic	CSG
XmNtitleEncoding	XmCTitleEncoding	Atom	dynamic	CSG
XmNtransient	XmCTransient	Boolean	True	CSG
XmNwaitForWm	XmCWaitForWm	Boolean	True	CSG
XmNwidthInc	XmCWidthInc	int	XtUnspecifiedShellInt	CSG
XmNwindowGroup	XmCWindowGroup	Window	dynamic	CSG
XmNwinGravity	XmCWinGravity	int	dynamic	CSG
XmNwmTimeout	XmCWmTimeout	int	5000 ms	CSG
.TE
.P 
.TS 
center allbox;
cBp9 ssss
lBp8 lBp8 lBp8 lBp8 lBp8
lp8 lp8 lp8 lp8 lp8.
Shell Resource Set
Name	Class	Type	Default	Access
_
XmNallowShellResize	XmCAllowShellResize	Boolean	False	CG
XmNcreatePopupChildProc	XmCCreatePopupChildProc	XtCreatePopupChildProc	NULL	CSG
XmNgeometry	XmCGeometry	String	NULL	CSG
XmNoverrideRedirect	XmCOverrideRedirect	Boolean	False	CSG
XmNpopdownCallback	XmCCallback	XtCallbackList	NULL	C
XmNpopupCallback	XmCCallback	XtCallbackList	NULL	C
XmNsaveUnder	XmCSaveUnder	Boolean	True	CSG
XmNvisual	XmCVisual	Visual *	CopyFromParent	CSG
.TE
.P 
.TS 
center allbox;
cBp9 ssss
lBp8 lBp8 lBp8 lBp8 lBp8
lp8 lp8 lp8 lp8 lp8.
Composite Resource Set
Name	Class	Type	Default	Access
_
XmNchildren	XmCReadOnly	WidgetList	NULL	G
XmNinsertPosition	XmCInsertPosition	XtOrderProc	NULL	CSG
XmNnumChildren	XmCReadOnly	Cardinal	0	G
.TE
.P 
.wH .in 0 
.TS 
center allbox;
cBp9 ssss
lBp8 lBp8 lBp8 lBp8 lBp8
lp8 lp8 lp8 lp8 lp8.
Core Resource Set
Name	Class	Type	Default	Access
_
XmNaccelerators	XmCAccelerators	XtAccelerators	dynamic	CSG
XmNancestorSensitive	XmCSensitive	Boolean	dynamic	G
XmNbackground	XmCBackground	Pixel	dynamic	CSG
XmNbackgroundPixmap	XmCPixmap	Pixmap	XmUNSPECIFIED_PIXMAP	CSG
XmNborderColor	XmCBorderColor	Pixel	XtDefaultForeground	CSG
XmNborderPixmap	XmCPixmap	Pixmap	XmUNSPECIFIED_PIXMAP	CSG
XmNborderWidth	XmCBorderWidth	Dimension	1	CSG
XmNcolormap	XmCColormap	Colormap	dynamic	CG
XmNdepth	XmCDepth	int	dynamic	CG
XmNdestroyCallback	XmCCallback	XtCallbackList	NULL	C
XmNheight	XmCHeight	Dimension	dynamic	CSG
XmNinitialResourcesPersistent	XmCInitialResourcesPersistent	Boolean	True	C
XmNmappedWhenManaged	XmCMappedWhenManaged	Boolean	True	CSG
XmNscreen	XmCScreen	Screen *	dynamic	CG
.wH .tH
XmNsensitive	XmCSensitive	Boolean	True	CSG
XmNtranslations	XmCTranslations	XtTranslations	dynamic	CSG
XmNwidth	XmCWidth	Dimension	dynamic	CSG
XmNx	XmCPosition	Position	0	CSG
XmNy	XmCPosition	Position	0	CSG
.TE
.wH .in  
.SS "Translations"
There are no translations for XmDialogShell.
.SH RELATED INFORMATION
.na
\*LComposite(3X)\*O, \*LCore(3X)\*O, \*LShell(3X)\*O,
\*LTransientShell(3X)\*O, \*LWMShell(3X)\*O, \*LVendorShell(3X)\*O,
and \*LXmCreateDialogShell(3X)\*O.
.ad
