...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1988 by Massachusetts Institute of Technology
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmClipboardStartCopy 3X "" "" "" ""
...\" ______________ start of SML macros ______________
.ds !) CW
.ds !] (CW
.cs \*(!) 20
.bd \*(!) 2
.ds |A Chapter
.nr |P 0
.nr |D 1
.deaS
..
.deaE
..
.deoS
.SP
.ps -1
.ft \\*(!)
.nf
.nr !x 8*\\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.if\\n(.$>0 .in 0
..
.deoE
.ps +1
.ft R
.fi
.SP
..
.deiS
.SP
.ps -1
.ft B
.nf
..
.deiE
.ps +1
.ft R
.fi
.SP
..
.decS
.ig cE
..
.decE
..
.dezA
.SP 1
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (start)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (start)\ \ \\l\\n(|Qu
.br
..
.dezZ
.br
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (end)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (end)\ \ \\l\\n(|Qu
.SP 1
..
.delS
..
.delE
..
.nr Nn 0 1
.denS
.P
.nr Nn +1
.ie\\$1warning .ds yy Warning:\ \
.el.ie\\$1caution .ds yy Caution:\ \
.el.ie\\$1note .ds yy Note:\ \
.el.ie\\$1reviewnote \{\
.	ds yy
.	ps +2
.	ft B
.	P
Review Note To Developers:
.	P
.	ft
.	ps -2 \}
.el.ds yy \\$1:\ \
.ft B
.ll -\w\\*(yyu
.in +\w\\*(yyu
.ti -\w\\*(yyu
\\*(yy\c
.ft
..
.denE
.nr Nn -1
.in -\w\\*(yyu
.ll +\w\\*(yyu
.P
..
.de |F
.ie\\$1table .nr |F 1
.el.nr |F 0
.ie\\n(|D=0&\\n(|F=1 \{\
.	ds L \&\\f(HB
.	ds V \&\\f(HI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fH
.	ds C \&\\f\\*(!]
.	ds U \&\\f(HB
.	ds E \&\\f(HI
'	br \}
.el\{\
.	ds L \&\\fB
.	ds V \&\\fI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fR
.	ds C \&\\f\\*(!]
.	ds U \&\\fB
.	ds E \&\\fI
'	br \}
..
.|F general
.am TS
.|F table
..
.am TE
.|F general
..
.desS
.SP
..
.desE
.SP
..
.defS
.br
\&\fB\\$1(\fP
.nr !+ 1
.nr !% 0
..
.defE
\fB);\fP
.br
.if\\n(!%=1 .in -5i
.nr !+ 0
.nr !% 0
..
.dedS
.if\\n(!+=1 \{\
.	ie \\n(!%=0 .in +.5i
.	el \fB,\fP
'	br \}
.br
\&\fB\\$1\fR
.nr !% 1
..
.dedE
.if\\n(!+=0 \fB;\fR
..
.dekY
.ft B
<\\$1>
.ft
..
.de K,
\fB<\\$1>\fP\\$2
..
.de ,K
\&\\$1\fB<\\$2>\fP
..
.deeM
.ft I
\&\\$1
.ft
..
.de E,
\&\fI\\$1\fP\^\\$2
..
.de ,E
\&\\$1\^\fI\\$2\fP
..
.dedI
.so \\$1
..
.deeI
.nf
.ft CW
.nr !x 8*\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.de !~
so\\$1
\\..
.wh \\n(nlu+\\n(.tu-1v e,
.e:
!~
e;
.ft
.fi
.ch e,
..
.de e:
.eo
.c2 
.cc 
..
.de e;
cc
.c2
.ec
..
.de e,
e;
'bp
.e:
..
.depI
.br
.fl
.rs
.sy includePS "\\$1" "\\$2" "\\$3" > /tmp/pI.tmp.
.so /tmp/pI.tmp.
.sy rm -f /tmp/pI.tmp.
..
.depM
..
.denP
.bp
..
.denL
.br
..
.dewH
..
.rn RS rS
.rn RE rE
.detH
..
.am TH
.|Y TH "\\$1"
..
.am SH
.|Y SH "\\$1"
..
.am SS
.|Y SS "\\$1"
..
.nr Ll 0 1
.nr $A 0 1
.nr $M 0 1
.nr $V 0 1
.de |Y
.if\\n(Ll>0 \{\
.	tm unterminated list (no .LE) -- noticed by the .\\$1 "\\$2"
.	nr Ll 0
'	br \}
..
.rn PP P#
.dePP
.ie(\\n(Ll>0):(\\n(Nn>0) .sp \\n(PDu
.el.P#
..
.deML
.SP
.nr $M +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($M=1 .ds %\\n(Ll \(bu
.el\{\
.	ie t .ds %\\n(Ll \(em
.	el .ds %\\n(Ll --
'	br \}
.ien .ds %\\n(Ll "\ \ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \ \ \\*(%\\n(Ll
.nr #\\n(Ll 0 1
.ds #\\n(Ll M
..
.deVL
.SP
.nr $V +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.ie\\$1 .nr %\\n(Ll 1i
.el.nr %\\n(Ll \\$1n
.ds #\\n(Ll V
..
.deAL
.SP
.nr $A +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($A=1 .af #\\n(Ll 1
.el.ie\\n($A=2 .af #\\n(Ll a
.el.af #\\n(Ll i
.nr #\\n(Ll 0 1
.ds %\\n(Ll \\\\\\\\\\\\\\\\n+(#\\n(Ll
.ien .ds %\\n(Ll "\ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \\*(%\\n(Ll
.ds #\\n(Ll A
..
.deLI
.SP .25
.ie\\*(#\\n(LlV \{\
.	IP "\\$1" \\n(%\\n(Llu
'	br \}
.el.ie\\*(#\\n(LlM \{\
.	IP \\*(%\\n(Ll \\n(%\\n(Llu
'	br \}
.el.IP \\*(%\\n(Ll. \\n(%\\n(Llu
..
.deLE
.ie\\*(#\\n(LlA \{\
.	nr $A -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.ie\\*(#\\n(LlV \{\
.	nr $V -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.if\\*(#\\n(LlM \{\
.	nr $M -1
.	nr Ll -1
.	if \\n(Ll>=0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.SP
..
.deFG
.)F Figure 0 \\n+(Fg "\\$1"
..
.deTB
.)F Table 1 \\n+(Tb "\\$1"
..
.deEC
.)F Equation 2 \\n+(Ec "\\$1"
..
.deEX
.)F Exhibit 3 \\n+(Ex "\\$1"
..
.de )F
.sp \\n(PDu
.ce 1
\\$1\ \\n(H1\(mi\\$3.\ \ \\$4
.sp \\n(PDu
.if\\n(|Z=1 .tm !TOC: .if \\$2=\\\\\\\\$1 .)T 1 1 "\\$1\ \\n(H1\(mi\\$3.\ \ " "\\$4" \\nP \\n(H1
..
.deSP
.br
.nr |Q \\n(PDu
.if\\n(.$ .nr |Q \\$1v
.if!(\\n(nl=\\n(|B) .nr |A 0
.nr |Q -\\n(|Au
.if\\n(|Q \{\
.	sp \\n(|Qu
.	nr |A +\\n(|Qu
'	br \}
.nr |B \\n(nl
..
...\" ______________ end of SML macros ______________
.SH NAME
\*LXmClipboardStartCopy\*O\(emA clipboard function that sets up a storage and data structure
.iX "XmClipboardStartCopy"
.iX "clipboard functions" "XmClipboardStartCopy"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/Xm.h>
\&#include <Xm/CutPaste.h>
.sp \n(PDu
.ta 1i
int \*LXmClipboardStartCopy\*L (\*Vdisplay, window, clip_label,
	timestamp, widget, callback, item_id\*L)
.ta .5i 1.5i
	Display	\*V* display\*L;
	Window	\*Vwindow\*L;
	XmString	\*Vclip_label\*L;
	Time	\*Vtimestamp\*L;
	Widget	\*Vwidget\*L;
	XmCutPasteProc	\*Vcallback\*L;
	long	\*V* item_id\*L;
.wH .fi
.iE
.sE
.SH DESCRIPTION
\*LXmClipboardStartCopy\*O
sets up storage and data structures to receive clipboard data.
An application calls this function during a cut or copy operation.
The data item that these structures receive then becomes
the next data item in the clipboard.
.PP 
Copying a large piece of data to the clipboard can take a long time.
It is possible that, once copied, no application will ever request that
data.
The Motif Toolkit provides a mechanism so that an application does not need to
actually pass data to the clipboard until the data has been requested by
some application.
.PP 
Instead, the application passes format and length information
in \*LXmClipboardCopy\*O to the
clipboard functions, along with a widget ID and a callback function
address that is passed in \*LXmClipboardStartCopy\*O.
The widget ID is needed for communications between the clipboard
functions in the application that owns the data and the clipboard
functions in the application that requests the data.
.PP 
The callback functions are responsible for copying the actual data to
the clipboard via \*LXmClipboardCopyByName\*O.
The callback function is also called if the data item is removed from
the clipboard, and the actual data is therefore no longer needed.
.VL 1.2i 
.LI "\*Vdisplay\*O"
Specifies a pointer to the \*LDisplay\*O structure that was returned in a
previous call to \*LXOpenDisplay\*O or \*LXtDisplay\*O.
.LI "\*Vwindow\*O"
Specifies a widget's window ID that relates the application window to the
clipboard.  The widget's window ID can be obtained by using
\*LXtWindow\*O.
The same application instance should pass the same window ID to each of the
clipboard functions that it calls.
.LI "\*Vclip_label\*O"
Specifies the label to be associated with the data item.
This argument
is used to identify the data item, for example, in a clipboard viewer.
An example of a label is the name of the application that places the
data in the clipboard.
.LI "\*Vtimestamp\*O"
Specifies the time of the event that triggered the copy.
A valid timestamp must be supplied; it is not sufficient to use
\*LCurrentTime\*O.
.LI "\*Vwidget\*O"
Specifies the ID of the widget that receives messages requesting data
previously passed by name.
This argument must be present in order to pass data by name.
Any valid widget ID in your application can be used for this purpose and
all the message handling is taken care of by the cut and paste
functions.
.LI "\*Vcallback\*O"
Specifies the address of the callback function that is
called when the clipboard
needs data that was originally passed by name.
This is also the callback to receive the \*Ldelete\*O message for items
that were originally passed by name.
This argument must be present in order to pass data by name.
.LI "\*Vitem_id\*O"
Specifies the number assigned to this data item.
The application uses this number in calls to
\*LXmClipboardCopy\*O, \*LXmClipboardEndCopy\*O, and
\*LXmClipboardCancelCopy\*O.
.LE 
.PP 
For more information on passing data by name, see
\*LXmClipboardCopy(3X)\*O and \*LXmClipboardCopyByName(3X)\*O.
.PP 
The \*Vwidget\*O and \*Vcallback\*O arguments must be present in order to
pass data by name. The callback format is as follows:
.sS
.iS
.ta .25i 1.2i
void (*\*Vcallback)\*L (\*Vwidget, data_id, private, reason\*L)
	Widget	\*Vwidget\*L;
	int	*\*Vdata_id\*L;
	int	*\*Vprivate\*L;
	int	*\*Vreason\*L;
.iE
.sE
.wH .fi
.VL 1.2i 
.LI "\*Vwidget\*O"
Specifies the ID of the widget passed to this function.
.LI "\*Vdata_id\*O"
Specifies the identifying number returned by
\*LXmClipboardCopy\*O, which identifies the pass-by-name data.
.LI "\*Vprivate\*O"
Specifies the private information passed to
\*LXmClipboardCopy\*O.
.LI "\*Vreason\*O"
Specifies the reason, which is either \*LXmCR_CLIPBOARD_DATA_DELETE\*O
or \*LXmCR_CLIPBOARD_DATA_REQUEST\*O.
.LE
.nL
.ne 15
.SH RETURN VALUE
.VL 1.2i 
.LI "\*LClipboardSuccess\*O"
The function is successful.
.LI "\*LClipboardLocked\*O"
The function failed because the clipboard was locked by another
application.  The application can continue to call the function again with
the same parameters until the lock goes away.  This gives the application
the opportunity to ask if the user wants to keep trying or to give up
on the operation.
.LE 
.SH RELATED INFORMATION
.na
\*LXmClipboardCancelCopy(3X)\*O, \*LXmClipboardCopy(3X)\*O,
\*LXmClipboardCopyByName(3X)\*O,
\*LXmClipboardEndCopy(3X)\*O, \*LXmClipboardEndRetrieve(3X)\*O,
\*LXmClipboardInquireCount(3X)\*O, \*LXmClipboardInquireFormat(3X)\*O,
\*LXmClipboardInquireLength(3X)\*O, \*LXmClipboardInquirePendingItems(3X)\*O,
\*LXmClipboardLock(3X)\*O, \*LXmClipboardRegisterFormat(3X)\*O,
\*LXmClipboardRetrieve(3X)\*O,
\*LXmClipboardStartRetrieve(3X)\*O, \*LXmClipboardUndoCopy(3X)\*O,
\*LXmClipboardUnlock(3X)\*O, and \*LXmClipboardWithdrawFormat(3X)\*O.
.ad
