...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH UilDumpSymbolTable 3X
.SH NAME
\*LUilDumpSymbolTable\*O\(emDumps the contents of a named UIL symbol table to standard output
.iX "UilDumpSymbolTable"
.iX "uil functions" "UilDumpSymbolTable"
.SH SYNOPSIS
.sS
.iS
\&#include <uil/UilDef.h>
.sp \n(PDu
void UilDumpSymbolTable (\*Vroot_ptr\*L)
.ta 0.5i 2.5i
	sym_entry_type *\*Vroot_ptr\*L;
.iE
.sE
.SH DESCRIPTION
.PP 
The \*LUilDumpSymbolTable\*O function dumps
the contents of a
UIL symbol table pointer to standard output.
.VL 10n 
.LI "\*Vroot_ptr\*O"
Specifies a pointer to the the symbol table root entry.
This value can be taken from the \*Lparse_tree_root\*O part of
the \*LUil_compile_desc_type\*O data structure returned by \*LUil\*O.
.LE 
.PP 
.ne 20
By following the link from the root entry,
you can traverse the entire parse tree.
Symbol table entries are in the following format:
.PP 
\*Vhex.address\*O
.nL
\*Vsymbol.type\*O
.nL
\*Vsymbol.data\*O
.nL
 \*Vprev.source.position\*O
.nL
 \*Vsource.position\*O
.nL
 \*Vmodification.record\*O
.PP 
where:
.VL 20n 
.LI "\*Vhex.address\*O"
Specifies the hexadecimal address of this entry in the symbol table.
.LI "\*Vsymbol.type\*O"
Specifies the type of this symbol table entry.  Some possible types
are \*Lroot\*O, \*Lmodule\*O, \*Lvalue\*O, \*Lprocedure\*O, and \*Lwidget\*O.
.LI "\*Vsymbol.data\*O"
Specifies data for the symbol table entry.  The data varies with the
type of the entry.  Often it contains pointers to other symbol table entries,
or the actual data for the data type.
.LI "\*Vprev.source.position\*O"
Specifies the end point in the source code for the previous source item.
.LI "\*Vsource.position\*O"
Specifies the range of positions in the source code for this symbol.
.LE 
.PP 
The exact data structures for each symbol type are defined in the
include file \*LUilSymDef.h\*O.
Note that this file is automatically included when
an application includes the file \*LUilDef.h\*O.
.SH RELATED INFORMATION
.na
\*LUil(3X)\*O
.ad
