...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH Uil 3X
...\" ______________ start of SML macros ______________
.ds !) CW
.ds !] (CW
.cs \*(!) 20
.bd \*(!) 2
.ds |A Chapter
.nr |P 0
.nr |D 1
.deaS
..
.deaE
..
.deoS
.SP
.ps -1
.ft \\*(!)
.nf
.nr !x 8*\\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.if\\n(.$>0 .in 0
..
.deoE
.ps +1
.ft R
.fi
.SP
..
.deiS
.SP
.ps -1
.ft B
.nf
..
.deiE
.ps +1
.ft R
.fi
.SP
..
.decS
.ig cE
..
.decE
..
.dezA
.SP 1
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (start)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (start)\ \ \\l\\n(|Qu
.br
..
.dezZ
.br
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (end)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (end)\ \ \\l\\n(|Qu
.SP 1
..
.delS
..
.delE
..
.nr Nn 0 1
.denS
.P
.nr Nn +1
.ie\\$1warning .ds yy Warning:\ \
.el.ie\\$1caution .ds yy Caution:\ \
.el.ie\\$1note .ds yy Note:\ \
.el.ie\\$1reviewnote \{\
.	ds yy
.	ps +2
.	ft B
.	P
Review Note To Developers:
.	P
.	ft
.	ps -2 \}
.el.ds yy \\$1:\ \
.ft B
.ll -\w\\*(yyu
.in +\w\\*(yyu
.ti -\w\\*(yyu
\\*(yy\c
.ft
..
.denE
.nr Nn -1
.in -\w\\*(yyu
.ll +\w\\*(yyu
.P
..
.de |F
.ie\\$1table .nr |F 1
.el.nr |F 0
.ie\\n(|D=0&\\n(|F=1 \{\
.	ds L \&\\f(HB
.	ds V \&\\f(HI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fH
.	ds C \&\\f\\*(!]
.	ds U \&\\f(HB
.	ds E \&\\f(HI
'	br \}
.el\{\
.	ds L \&\\fB
.	ds V \&\\fI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fR
.	ds C \&\\f\\*(!]
.	ds U \&\\fB
.	ds E \&\\fI
'	br \}
..
.|F general
.am TS
.|F table
..
.am TE
.|F general
..
.desS
.SP
..
.desE
.SP
..
.defS
.br
\&\fB\\$1(\fP
.nr !+ 1
.nr !% 0
..
.defE
\fB);\fP
.br
.if\\n(!%=1 .in -5i
.nr !+ 0
.nr !% 0
..
.dedS
.if\\n(!+=1 \{\
.	ie \\n(!%=0 .in +.5i
.	el \fB,\fP
'	br \}
.br
\&\fB\\$1\fR
.nr !% 1
..
.dedE
.if\\n(!+=0 \fB;\fR
..
.dekY
.ft B
<\\$1>
.ft
..
.de K,
\fB<\\$1>\fP\\$2
..
.de ,K
\&\\$1\fB<\\$2>\fP
..
.deeM
.ft I
\&\\$1
.ft
..
.de E,
\&\fI\\$1\fP\^\\$2
..
.de ,E
\&\\$1\^\fI\\$2\fP
..
.dedI
.so \\$1
..
.deeI
.nf
.ft CW
.nr !x 8*\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.de !~
so\\$1
\\..
.wh \\n(nlu+\\n(.tu-1v e,
.e:
!~
e;
.ft
.fi
.ch e,
..
.de e:
.eo
.c2 
.cc 
..
.de e;
cc
.c2
.ec
..
.de e,
e;
'bp
.e:
..
.depI
.br
.fl
.rs
.sy includePS "\\$1" "\\$2" "\\$3" > /tmp/pI.tmp.
.so /tmp/pI.tmp.
.sy rm -f /tmp/pI.tmp.
..
.depM
..
.denP
.bp
..
.denL
.br
..
.dewH
..
.rn RS rS
.rn RE rE
.detH
..
.am TH
.|Y TH "\\$1"
..
.am SH
.|Y SH "\\$1"
..
.am SS
.|Y SS "\\$1"
..
.nr Ll 0 1
.nr $A 0 1
.nr $M 0 1
.nr $V 0 1
.de |Y
.if\\n(Ll>0 \{\
.	tm unterminated list (no .LE) -- noticed by the .\\$1 "\\$2"
.	nr Ll 0
'	br \}
..
.rn PP P#
.dePP
.ie(\\n(Ll>0):(\\n(Nn>0) .sp \\n(PDu
.el.P#
..
.deML
.SP
.nr $M +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($M=1 .ds %\\n(Ll \(bu
.el\{\
.	ie t .ds %\\n(Ll \(em
.	el .ds %\\n(Ll --
'	br \}
.ien .ds %\\n(Ll "\ \ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \ \ \\*(%\\n(Ll
.nr #\\n(Ll 0 1
.ds #\\n(Ll M
..
.deVL
.SP
.nr $V +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.ie\\$1 .nr %\\n(Ll 1i
.el.nr %\\n(Ll \\$1n
.ds #\\n(Ll V
..
.deAL
.SP
.nr $A +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($A=1 .af #\\n(Ll 1
.el.ie\\n($A=2 .af #\\n(Ll a
.el.af #\\n(Ll i
.nr #\\n(Ll 0 1
.ds %\\n(Ll \\\\\\\\\\\\\\\\n+(#\\n(Ll
.ien .ds %\\n(Ll "\ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \\*(%\\n(Ll
.ds #\\n(Ll A
..
.deLI
.SP .25
.ie\\*(#\\n(LlV \{\
.	IP "\\$1" \\n(%\\n(Llu
'	br \}
.el.ie\\*(#\\n(LlM \{\
.	IP \\*(%\\n(Ll \\n(%\\n(Llu
'	br \}
.el.IP \\*(%\\n(Ll. \\n(%\\n(Llu
..
.deLE
.ie\\*(#\\n(LlA \{\
.	nr $A -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.ie\\*(#\\n(LlV \{\
.	nr $V -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.if\\*(#\\n(LlM \{\
.	nr $M -1
.	nr Ll -1
.	if \\n(Ll>=0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.SP
..
.deFG
.)F Figure 0 \\n+(Fg "\\$1"
..
.deTB
.)F Table 1 \\n+(Tb "\\$1"
..
.deEC
.)F Equation 2 \\n+(Ec "\\$1"
..
.deEX
.)F Exhibit 3 \\n+(Ex "\\$1"
..
.de )F
.sp \\n(PDu
.ce 1
\\$1\ \\n(H1\(mi\\$3.\ \ \\$4
.sp \\n(PDu
.if\\n(|Z=1 .tm !TOC: .if \\$2=\\\\\\\\$1 .)T 1 1 "\\$1\ \\n(H1\(mi\\$3.\ \ " "\\$4" \\nP \\n(H1
..
.deSP
.br
.nr |Q \\n(PDu
.if\\n(.$ .nr |Q \\$1v
.if!(\\n(nl=\\n(|B) .nr |A 0
.nr |Q -\\n(|Au
.if\\n(|Q \{\
.	sp \\n(|Qu
.	nr |A +\\n(|Qu
'	br \}
.nr |B \\n(nl
..
...\" ______________ end of SML macros ______________
.SH NAME
\*LUil\*O\(emInvokes the UIL compiler from within an application
.iX "Uil"
.iX "uil functions" "Uil"
.iX "uil compiler"
.SH SYNOPSIS
.sS
.iS
\&#include <uil/UilDef.h>
.sp \n(PDu
.ta 1i
Uil_status_type Uil (\*Vcommand_desc, compile_desc, message_cb,
	message_data, status_cb, status_data\*L)
.ta 0.5i 2.5i
	Uil_command_type	\*V*command_desc\*L;
	Uil_compile_desc_type	\*V*compile_desc\*L;
	Uil_continue_type	(\*V*message_cb\*L) ();
	char	\*V*message_data\*L;
	Uil_continue_type	(\*V*status_cb\*L) ();
	char	\*V*status_data\*L;
.wH .fi
.nL
.ne 3i
.iE
.sE
.SH DESCRIPTION
The \*LUil\*O function provides a callable entry point for the UIL
compiler. The
\*LUil\*O callable interface can be used to process
a UIL source file and to
generate UID files, as well as return a detailed description of the
UIL source module in the form of a symbol table (parse tree).
.VL 20n 
.LI "\*Vcommand_desc\*O"
Specifies the \*Luil\*O command line.
.LI "\*Vcompile_desc\*O"
Returns the results of the compilation.
.LI "\*Vmessage_cb\*O"
Specifies a callback function that is called when the compiler
encounters errors in the UIL source.
.LI "\*Vmessage_data\*O"
Specifies user data that is passed to the message callback function
(message_cb). Note that this argument is not interpreted by UIL, and is
used exclusively by the calling application.
.nL
.ne 6
.LI "\*Vstatus_cb\*O"
Specifies a callback function that is called to allow X applications to service
X events such as updating the screen.  This function is called
at various check points, which have been hard coded into the UIL compiler.
The status_update_delay argument in command_desc specifies the number of
check points to be passed before the status_cb function is invoked.
.LI "\*Vstatus_data\*O"
Specifies user data that is passed to the status callback function
(status_cb). Note that this argument is not interpreted by the UIL compiler,
and is used exclusively by the calling application.
.LE 
.PP 
The data structures \*LUil_command_type\*O and
\*LUil_compile_desc_type\*O are detailed below.
.oS
typedef struct Uil_command_type {
char *source_file;
    /* single source to compile */
char *resource_file; /* name of output file */
char *listing_file; /* name of listing file */
unsigned int *include_dir_count;
    /* number of dirs. in include_dir */
char *((*include_dir) []);
    /* dir. to search for include files */
unsigned listing_file_flag: 1;
    /* produce a listing */
unsigned resource_file_flag: 1;
    /* generate UID output */
unsigned machine_code_flag: 1;
    /* generate machine code */
unsigned report_info_msg_flag: 1;
    /* report info messages */
unsigned report_warn_msg_flag: 1;
    /* report warnings */
unsigned parse_tree_flag: 1;
    /* generate parse tree */
unsigned int status_update_delay;
    /* number of times a status point is */
    /* passed before calling status_cb */
    /* function 0 means called every time */
char *database;
    /* name of database file */
unsigned database_flag: 1;
    /* read a new database file */
unsigned use_setlocale_flag: 1;
    /* enable calls to setlocale */
};
.sp 1
typedef struct Uil_compile_desc_type {
unsigned int compiler_version;
    /* version number of compiler */
unsigned int data_version;
    /* version number of structures */
char *parse_tree_root; /* parse tree output */
unsigned int message_count [Uil_k_max_status+1];
/* array of severity counts */
};
.oE
.PP 
.ne 3.5i
Following is a description of the message callback function specified by
\*Vmessage_cb\*O:
.nL
.ne 2i
.sS
.iS
.ta 1i
Uil_continue_type (\*V*message_cb\*L) (\*Vmessage_data, message_number,
	severity, msg_buffer, src_buffer, ptr_buffer, loc_buffer,
	message_count\*L)
.ta 0.5i 1.5i
	char	\*V*message_data\*L;
	int	\*Vmessage_number\*L;
	int	\*Vseverity\*L;
	char	\*V*msg_buffer\*L, \*V*src_buffer\*L;
	char	\*V*ptr_buffer\*L, \*V*loc_buffer\*L;
	int	\*Vmessage_count\*L[];
.iE
.sE
.PP 
Specifies a callback function that UIL invokes instead of printing an
error message when the compiler encounters an error in the UIL source.
The callback should return one of these values:
.VL 20n 
.LI "\*LUil_k_terminate\*O"
Tells UIL to terminate processing of the source file.
.LI "\*LUil_k_continue\*O"
Tells UIL to continue processing the source file.
.LE 
.PP 
.ne 3
Following are the arguments:
.VL 20n 
.LI "\*Vmessage_data\*O"
Data supplied by the application as the \*Vmessage_data\*O argument to
the \*LUil\*O function.
UIL does not interpret this data in any way; it just passes it to the
callback.
.LI "\*Vmessage_number\*O"
An index into a table of error messages and severities, for internal use
by UIL.
.LI "\*Vseverity\*O"
An integer that indicates the severity of the error.
The possible values are the status constants returned by the \*LUil\*O
function.
See the "RETURN VALUE" section below.
.LI "\*Vmsg_buffer\*O"
A string that describes the error.
.LI "\*Vsrc_buffer\*O"
A string consisting of the source line where the error occurred.
This is not always available; the argument is then NULL.
.nL
.ne 2i
.LI "\*Vptr_buffer\*O"
A string consisting of whitespace and a printing character in the
character position corresponding to the column of the source line where
the error occurred.
This string may be printed beneath the source line to provide a visual
indication of the column where the error occurred.
This is not always available; the argument is then NULL.
.LI "\*Vloc_buffer\*O"
A string identifying the line number and file of the source line where
the error occurred.
This is not always available; the argument is then NULL.
.LI "\*Vmessage_count\*O"
An array of integers containing the number of diagnostic messages issued
thus far for each severity level.
To find the number of messages issued for the current severity level,
use the \*Vseverity\*O argument as the index into this array.
.LE 
.PP 
.ne 7
Following is a description of the status callback function specified by
\*Vstatus_cb\*O:
.nL
.ne 2i
.sS
.iS
.ta 1i
Uil_continue_type (\*V*status_cb\*L) (\*Vstatus_data, percent_complete,
	lines_processed, current_file, message_count\*L)
.ta 0.5i 1.5i
	char	\*V*status_data\*L;
	int	\*Vpercent_complete\*L;
	int	\*Vlines_processed\*L;
	char	\*V*current_file\*L;
	int	\*Vmessage_count\*L[];
.iE
.sE
.PP 
Specifies a callback function that is invoked to allow X applications to
service X events such as updating the screen.
The callback should return one of these values:
.VL 20n 
.LI "\*LUil_k_terminate\*O"
Tells UIL to terminate processing of the source file.
.LI "\*LUil_k_continue\*O"
Tells UIL to continue processing the source file.
.LE 
.PP 
.ne 2i
Following are the arguments:
.VL 20n 
.LI "\*Vstatus_data\*O"
Data supplied by the application as the \*Vstatus_data\*O argument to
the \*LUil\*O function.
UIL does not interpret this data in any way; it just passes it to the
callback.
.LI "\*Vpercent_complete\*O"
An integer indicating what percentage of the current source file has
been processed so far.
.LI "\*Vlines_processed\*O"
An integer indicating how many lines of the current source file have
been read so far.
.LI "\*Vcurrent_file\*O"
A string containing the pathname of the current source file.
.LI "\*Vmessage_count\*O"
An array of integers containing the number of diagnostic messages issued
thus far for each severity level.
To find the number of messages issued for a given severity level, use
the severity level as the index into this array.
The possible severity levels
.ne 4
are the status constants returned by the
\*LUil\*O function.
See the "RETURN VALUE" section below.
.LE 
.SH RETURN VALUE
This function returns one of these
status return constants:
.VL 25n 
.LI "\*LUil_k_success_status\*O"
The operation succeeded.
.LI "\*LUil_k_info_status\*O"
The operation succeeded, and an informational
message is returned.
.LI "\*LUil_k_warning_status\*O"
The operation succeeded, and a warning
message is returned.
.LI "\*LUil_k_error_status\*O"
The operation failed due to an error.
.LI "\*LUil_k_severe_status\*O"
The operation failed due to an error.
.LE 
.SH RELATED INFORMATION
.na
\*LUilDumpSymbolTable(3X)\*O and
\*Luil(1X)\*O.
.ad
