/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: FontListC.c,v $ $Revision: 1.4 $ $Date: 92/03/13 17:51:00 $"
#endif
#endif

#include <stdio.h>
#include <testlib.h>

#include "FontList.h"

#define	NUM_TESTS 5

extern void	error_proc();

String		expected_result[NUM_TESTS] =
{
    "FAILURE",
    "SUCCESS",
    "FAILURE",
    "SUCCESS",
    "SUCCESS"
};

main(argc, argv)
     unsigned int	argc;
     char		*argv[];
{
    
    fontlist_num = font_num = charset_num = 0;
    errors = 0;
    
    CommonTestInit(argc, argv);

/*
 * Load valid fonts into font structures
 */

    for(font_num=1 ; font_num<NUM_FONTS ; font_num++) {

		if((font[font_num] = XLoadQueryFont(display, fontname[font_num]))
	   		== NULL) {
	    	sprintf(error_string, "Can't load font \"%s\"",
		    		fontname[font_num]);
	    	error_proc("FontListC", error_string);
		}

    }

    font_num = 0;

    fprintf(stdout, "                                          Expected  ");
    fprintf(stdout, " Actual\n");
    fprintf(stdout, "Test  Font      Character Set              Result   ");
    fprintf(stdout, " Result  Error\n");
    fprintf(stdout, "----  --------  ------------------------  --------  ");
    fprintf(stdout, "-------  -----\n");
    fflush(stdout);
   
/*
                                          Expected   Actual
Test  Font      Character Set              Result    Result  Error
----  --------  ------------------------  --------  -------  -----
*/

/*************************************************************
 * Test 1: Create a font list with an invalid font structure *
 *************************************************************/

    fprintf(stdout, "  %1d   %8s  %24s   %7s", fontlist_num+1,
	    	fontname[font_num], charsetname[charset_num],
	    	expected_result[fontlist_num]);
    fflush(stdout);

/*
 * Create a font list
 */

    if ((fontlist[fontlist_num++] = XmFontListCreate(font[font_num++],
						    						 charset[charset_num]))
       												 == NULL)
		fprintf(stdout, "  FAILURE\n");
    else {
		errors++;
		fprintf(stdout, "  SUCCESS    *\n");
    }
    
/**********************************************************
 * Test 2: Create a font list with a valid font structure *
 **********************************************************/

    fprintf(stdout, "  %1d   %8s  %24s   %7s", fontlist_num+1,
	    	fontname[font_num], charsetname[charset_num],
	    	expected_result[fontlist_num]);
    fflush(stdout);

/*
 * Create a font list
 */

    if ((fontlist[fontlist_num++] = XmFontListCreate(font[font_num],
						    						 charset[charset_num++]))
       												 == NULL) {
		errors++;
		fprintf(stdout, "  FAILURE    *\n");
    }
    else
		fprintf(stdout, "  SUCCESS\n");
    
/************************************************************
 * Test 3: Create a font list with an invalid character set *
 ************************************************************/

    fprintf(stdout, "  %1d   %8s  %24s   %7s", fontlist_num+1,
	    	fontname[font_num], charsetname[charset_num],
	    	expected_result[fontlist_num]);
    fflush(stdout);

/*
 * Create a font list
 */

    if ((fontlist[fontlist_num++] = XmFontListCreate(font[font_num++],
						    						 charset[charset_num++]))
       												 == NULL)
		fprintf(stdout, "  FAILURE\n");
    else {
		errors++;
		fprintf(stdout, "  SUCCESS    *\n");
    }

/*********************************************************
 * Test 4: Create a font list with a valid character set *
 *********************************************************/

    fprintf(stdout, "  %1d   %8s  %24s   %7s", fontlist_num+1,
	    	fontname[font_num], charsetname[charset_num],
	    	expected_result[fontlist_num]);
    fflush(stdout);

/*
 * Create a font list
 */

    if ((fontlist[fontlist_num++] = XmFontListCreate(font[font_num++],
						    						 charset[charset_num++]))
       												 == NULL) {
		errors++;
		fprintf(stdout, "  FAILURE    *\n");
    }
    else
		fprintf(stdout, "  SUCCESS\n");

/***********************************************
 * Test 5: Create a font list with a character *
 *         set defined in an app-defaults file *
 ***********************************************/

    fprintf(stdout, "  %1d   %8s  %24s   %7s", fontlist_num+1,
	    	fontname[font_num], charsetname[charset_num],
	    	expected_result[fontlist_num]);
    fflush(stdout);

/*
 * Create a font list
 */

    if ((fontlist[fontlist_num++] = XmFontListCreate(font[font_num],
						    						 charset[charset_num]))
       												 == NULL) {
		errors++;
		fprintf(stdout, "  FAILURE    *\n");
    }
    else
		fprintf(stdout, "  SUCCESS\n");

    summary_proc("FontListC", errors);

}
