/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: TransFamily.c,v $ $Revision: 1.4 $ $Date: 92/03/13 17:13:47 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */

/*
 *	file: TransFamily.c
 *
 *	This tests the 1.2 enhancements for mwm.
 *
 *	It also incidentally, shows PIR 3340, about the inheritance of the
 *  VendorShell resource XmMmwmMenu by DialogShell.
 *
 */

#include <testlib.h>
#include <X11/Shell.h>
#include <Xm/MwmUtil.h>

/* forward declarations */
static void  quitCB();


char	*modeless_msg = 
	"While this box is up, you should be able to use all other shells";
char	*primary_msg = 
	"While this box is up, you should not be able to use its parent";
char	*full_msg = 
	"While this box is up, you should not be able to use either topShell1 \
or topShell2 or any other dialog box.";
char	*system_msg =
	"While this box is up, you should not be able to use any other \
application nor any other part of this client.";

char	*menuStrTop1 = "RefreshWin f.refresh_win\n\
						NormalRaise f.normalize_and_raise\n\
						RaiseLower f.raise_lower";

char	*menuStrDia1 = "Beep f.beep";

#ifdef MOTIF1_2

Bool test1_2 = False;

char	*menuStrTop2 = "Restore f.restore";

char	*menuStrDia2 = "LowerWithin f.lower within\n\
						LowerFree f.lower freeFamily\n\
						RaiseWithin f.raise within\n\
						RaiseFree f.raise freeFamily";

#endif


/* callback procedures */

static void PostModelessDialog (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{
    Widget	parent, Dialog0, spawnButton;
    int 	n;
    Arg 	args[MAX_ARGS];
    XmString tcs;

    parent = (Widget) client_data;

    n = 0;
    /* message box resources */
    XtSetArg (args[n], XmNmessageString, 
			  XmStringCreateSimple (modeless_msg)); n++;
    XtSetArg (args[n], XmNautoUnmanage, True); n++;
    XtSetArg (args[n], XmNhelpLabelString, 
			  XmStringCreateSimple ("Spawn Dialog Child")); n++;

    /* dialog shell resources */
    XtSetArg (args[n], XmNtitle, "Modeless Dialog"); n++;
    XtSetArg (args[n], XmNdialogStyle, XmDIALOG_MODELESS); n++;

	/* VendorShell resources */
#ifdef MOTIF1_2

	if (test1_2 == True) {
		XtSetArg(args[n], XmNmwmMenu, menuStrDia2); n++;
	}
	else {
		XtSetArg(args[n], XmNmwmMenu, menuStrDia1); n++;
	}

#else

	XtSetArg(args[n], XmNmwmMenu, menuStrDia1); n++;

#endif /* MOTIF1_2 */

    Dialog0 = XmCreateMessageDialog(parent, "Dialog0", args, n);

/* make HELP button spawn a child */
    spawnButton = XmMessageBoxGetChild (Dialog0, XmDIALOG_HELP_BUTTON);
    XtAddCallback (spawnButton, XmNactivateCallback, 
				   PostModelessDialog, Dialog0);
    XtManageChild (Dialog0);

}

static void PostPrimaryModalDialog (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{
    Widget	parent, Dialog1, spawnButton;
    int 	n;
    Arg 	args[MAX_ARGS];
    XmString tcs;

    parent = (Widget) client_data;

    n = 0;
    /* message box resources */
    XtSetArg (args[n], XmNmessageString, 
			  XmStringCreateSimple (primary_msg)); n++;
    XtSetArg (args[n], XmNautoUnmanage, True); n++;
    XtSetArg (args[n], XmNhelpLabelString, 
			  XmStringCreateSimple ("Spawn Dialog Child")); n++;
    /* dialog shell resources */
    XtSetArg (args[n], XmNtitle, "Primary Application Modal Dialog"); n++;
    XtSetArg (args[n], XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL);
              n++;
	/* VendorShell resources */
#ifdef MOTIF1_2

	if (test1_2 == True) {
		XtSetArg(args[n], XmNmwmMenu, menuStrDia2); n++;
	}
	else {
		XtSetArg(args[n], XmNmwmMenu, menuStrDia1); n++;
	}

#else

	XtSetArg(args[n], XmNmwmMenu, menuStrDia1); n++;

#endif /* MOTIF1_2 */

    Dialog1 = XmCreateMessageDialog(parent, "Dialog1", args, n);

/* make HELP button spawn a child */
    spawnButton = XmMessageBoxGetChild (Dialog1, XmDIALOG_HELP_BUTTON);
    XtAddCallback (spawnButton, XmNactivateCallback, 
				   PostPrimaryModalDialog, Dialog1);
    XtManageChild (Dialog1);

}

static void PostFullAppModalDialog (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{

    Widget        parent, Dialog2;
    int n;
    Arg args[MAX_ARGS];

    parent = (Widget) client_data;

    n = 0;
    /* message box resources */
    XtSetArg (args[n], XmNmessageString, XmStringCreateSimple(full_msg)); n++;
    XtSetArg (args[n], XmNautoUnmanage, True); n++;
    /* dialog shell resources */
    XtSetArg (args[n], XmNtitle, "Full Application Modal Dialog"); n++;
    XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL);
              n++;
	/* VendorShell resources */
#ifdef MOTIF1_2

	if (test1_2 == True) {
		XtSetArg(args[n], XmNmwmMenu, menuStrDia2); n++;
	}

#endif /* MOTIF1_2 */

    Dialog2 = XmCreateMessageDialog(parent, "Dialog2", args, n);
    XtManageChild (Dialog2);

}


static void PostSystemModalDialog (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{

    Widget        parent, Dialog3;
    int n;
    Arg args[MAX_ARGS];

    parent = (Widget) client_data;

    n = 0;
    /* message box resources */
    XtSetArg (args[n], XmNmessageString, 
			  XmStringCreateSimple (system_msg)); n++;
    XtSetArg (args[n], XmNautoUnmanage, True); n++;
    /* dialog shell resources */
    XtSetArg (args[n], XmNtitle, "System Modal Dialog"); n++;
    XtSetArg (args[n], XmNdialogStyle, XmDIALOG_SYSTEM_MODAL); n++;
	/* VendorShell resources */
#ifdef MOTIF1_2

	if (test1_2 == True) {
		XtSetArg(args[n], XmNmwmMenu, menuStrDia2); n++;
	}

#endif /* MOTIF1_2 */

    Dialog3 = XmCreateMessageDialog(parent, "Dialog3", args, n);
    XtManageChild (Dialog3);

}


static void  quitCB(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
     printf("Begin exiting ... please standby ... \n");
     fflush(stdout);
     exit(0);
}


void  main(argc, argv)
    int     argc;
    char  **argv;
{

    register int  n;
    Arg           args[MAX_ARGS];
    XmString      tcs;
    Widget        topShell1, topShell2;
    Widget        BB1, BB2;
    Widget        exitButton;
    Widget        primaryButton1, primaryButton2;
    Widget        fullButton1, fullButton2;
    Widget        systemButton1, systemButton2;
    Widget        modelessButton1, modelessButton2;


    CommonTestInit(argc, argv);

    n = 0;
    XtSetArg(args[n], XmNmappedWhenManaged, True);  n++;
    XtSetArg(args[n], XmNallowShellResize, True);  n++;
    XtSetArg(args[n], XmNtitle, "topShell 1"); n++;
    topShell1 = XtCreatePopupShell("topShell 1", topLevelShellWidgetClass, 
								   Shell1, args, n);

    n = 0;
    XtSetArg(args[n], XmNmappedWhenManaged, True);  n++;
    XtSetArg(args[n], XmNallowShellResize, True);  n++;
    XtSetArg(args[n], XmNtitle, "topShell 2");         n++;
    XtSetArg(args[n], XtNgeometry, "+500+0");       n++;
    topShell2 = XtCreatePopupShell("topShell 2", topLevelShellWidgetClass, 
								   Shell1, args, n);
   
	n = 0;
	XtSetArg(args[n], XmNmwmMenu, menuStrTop1); n++;	/* PIR 3340 */
	XtSetValues(topShell1, args, n);

    /* Shell 1 children */

    n = 0;
    BB1 = XmCreateBulletinBoard (topShell1, "BB1", args, n);
    XtManageChild (BB1);
    
    n = 0;
    XtSetArg (args[n], XmNx, 300); n++;
    XtSetArg (args[n], XmNy, 10); n++;
    exitButton = XmCreatePushButtonGadget (BB1, "Exit", args, n);
    XtManageChild (exitButton);
    XtAddCallback (exitButton, XmNactivateCallback, quitCB, NULL);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 100); n++;
    XtSetArg (args[n], XmNlabelString,
	      	  XmStringCreateSimple ("Create Primary Modal from topShell1"));
			  n++;
    primaryButton1 = XmCreatePushButton (BB1, "primaryButton1", args, n);	  
    XtManageChild (primaryButton1);
    XtAddCallback (primaryButton1, XmNactivateCallback, 
				   PostPrimaryModalDialog, topShell1);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 150); n++;
    XtSetArg (args[n], XmNlabelString,
	      	  XmStringCreateSimple ("Create Full App Modal from topShell1"));
			  n++;
    fullButton1 = XmCreatePushButton (BB1, "fullButton1", args, n);	  
    XtManageChild (fullButton1);
    XtAddCallback (fullButton1,  XmNactivateCallback, PostFullAppModalDialog, 
				   topShell1);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 200); n++;
    XtSetArg (args[n], XmNlabelString,
	      	  XmStringCreateSimple ("Create System Modal from topShell1"));
			  n++;
    systemButton1 = XmCreatePushButton (BB1, "systemButton1", args, n);	  
    XtManageChild (systemButton1);
    XtAddCallback (systemButton1, XmNactivateCallback, PostSystemModalDialog, 
				   topShell1);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 250); n++;
    XtSetArg (args[n], XmNlabelString,
	      	  XmStringCreateSimple ("Create Modeless Dialog from topShell1"));
			  n++;
    modelessButton1 = XmCreatePushButton (BB1, "modelessButton1", args, n);	  
    XtManageChild (modelessButton1);
    XtAddCallback (modelessButton1, XmNactivateCallback, PostModelessDialog, 
				   topShell1);

    /* Shell 2 children */

    n = 0;
    BB2 = XmCreateBulletinBoard (topShell2, "BB2", args, n);    
    XtManageChild (BB2);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 100); n++;
    XtSetArg (args[n], XmNlabelString,
	      	  XmStringCreateSimple ("Create Primary Modal from topShell2"));
			  n++;
    primaryButton2 = XmCreatePushButton (BB2, "primaryButton2", args, n);	  
    XtManageChild (primaryButton2);
    XtAddCallback (primaryButton2, XmNactivateCallback, PostPrimaryModalDialog, 
				   topShell2);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 150); n++;
    XtSetArg (args[n], XmNlabelString,
	      	  XmStringCreateSimple ("Create Full App Modal from topShell2"));
			  n++;
    fullButton2 = XmCreatePushButton (BB2, "fullButton2", args, n);	  
    XtManageChild (fullButton2);
    XtAddCallback (fullButton2,  XmNactivateCallback, PostFullAppModalDialog, 
				   topShell2);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 200); n++;
    XtSetArg (args[n], XmNlabelString,
	      	  XmStringCreateSimple ("Create System Modal from topShell2"));
			  n++;
    systemButton2 = XmCreatePushButton (BB2, "systemButton2", args, n);	  
    XtManageChild (systemButton2);
    XtAddCallback (systemButton2,  XmNactivateCallback, PostSystemModalDialog, 
				   topShell2);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 250); n++;
    XtSetArg (args[n], XmNlabelString,
	      	  XmStringCreateSimple ("Create Modeless Dialog from topShell2"));
			  n++;
    modelessButton2 = XmCreatePushButton (BB2, "modelessButton2", args, n);	  
    XtManageChild (modelessButton2);
    XtAddCallback (modelessButton2, XmNactivateCallback, PostModelessDialog, 
				   topShell2);

    XtRealizeWidget(topShell1);
    XtPopup(topShell1, XtGrabNone);
    XtRealizeWidget(topShell2);
    XtPopup(topShell2, XtGrabNone);

	CommonPause();

#ifdef MOTIF1_2

	CommonPause();

	test1_2 = True;

	n = 0;
	XtSetArg(args[n], XmNmwmMenu, menuStrTop2); n++;
	XtSetValues(topShell1, args, n);
	XtSetValues(topShell2, args, n);

	XtPopdown(topShell1);
	XtPopdown(topShell2);
    XtPopup(topShell1, XtGrabNone);
    XtPopup(topShell2, XtGrabNone);

	CommonPause();

	CommonPause();

#endif /* MOTIF1_2 */

	CommonPause();

    XtAppMainLoop(app_context);

}
