/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: DiaShell4.c,v $ $Revision: 1.5 $ $Date: 92/03/13 17:13:00 $"
#endif
#endif
/*
*  (c) Copyright 1989, HEWLETT-PACKARD COMPANY */

#include <testlib.h>
#include <X11/Shell.h>
#include <Xm/MwmUtil.h>

/* forward declarations */
static void quitCB();


Widget	BulletinBoard1,
	PushButton1,
	PushButton2;
Widget  Scale;

Widget  ParentShell1, ParentShell2, DialogShell1;
int     count = 0;

char	*primary_msg = 
	"While this box is up, you should not be able to use its parent";
char	*full_msg = 
	"While this box is up, you should not be able to use either Shell1 \
or Shell2 nor any other dialog box.";
char	*system_msg =
	"While this box is up, you should not be able to use any other \
application nor any other part of this client.";

/* callback procedures */

static void PostPrimaryModalDialog (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{
    Widget        parent, Dialog1, spawnButton;
    int n;
    Arg args[10];
    XmString tcs;
    int delay;

    parent = (Widget) client_data;
    /* get the posting delay from the Scale*/
    n = 0;
    XtSetArg (args[n], XmNvalue, &delay); n++;
    XtGetValues (Scale, args, n);

    n = 0;
    /* message box resources */
    XtSetArg (args[n], XmNmessageString, 
			  XmStringCreateSimple (primary_msg)); n++;
    XtSetArg (args[n], XmNautoUnmanage, True); n++;
    XtSetArg (args[n], XmNhelpLabelString, 
			  XmStringCreateSimple ("Spawn Dialog Child")); n++;
    /* dialog shell resources */
    XtSetArg (args[n], XmNtitle, "Primary Application Modal Dialog"); n++;
    XtSetArg (args[n], XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL);
              n++;
    Dialog1 = XmCreateMessageDialog(parent, "Dialog1", args, n);

/* make HELP button spawn a child */
    spawnButton = XmMessageBoxGetChild (Dialog1, XmDIALOG_HELP_BUTTON);
    XtAddCallback (spawnButton, XmNactivateCallback, 
				   PostPrimaryModalDialog, Dialog1);
    if (delay) 
		sleep (delay);
    XtManageChild (Dialog1);
	if (parent == ParentShell2 && count == 0) {
		DialogShell1 = Dialog1;
		count = 1;
	}

}

static void PostFullAppModalDialog (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{

    Widget        parent, Dialog2;
    int n;
    Arg args[10];
    int delay;

    parent = (Widget) client_data;
    /* get the posting delay from the Scale*/
    n = 0;
    XtSetArg (args[n], XmNvalue, &delay); n++;
    XtGetValues (Scale, args, n);

    n = 0;
    /* message box resources */
    XtSetArg (args[n], XmNmessageString, XmStringCreateSimple(full_msg)); n++;
    XtSetArg (args[n], XmNautoUnmanage, True); n++;
    /* dialog shell resources */
    XtSetArg (args[n], XmNtitle, "Full Application Modal Dialog"); n++;
    XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL);
              n++;
    Dialog2 = XmCreateMessageDialog(parent, "Dialog1", args, n);
    if (delay) 
		sleep (delay);
    XtManageChild (Dialog2);

}

static void PostSystemModalDialog (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{

    Widget        parent, Dialog3;
    int n;
    Arg args[10];
    int delay;

    parent = (Widget) client_data;
    /* get the posting delay from the Scale*/
    n = 0;
    XtSetArg (args[n], XmNvalue, &delay); n++;
    XtGetValues (Scale, args, n);

    n = 0;
    /* message box resources */
    XtSetArg (args[n], XmNmessageString, 
			  XmStringCreateSimple (system_msg)); n++;
    XtSetArg (args[n], XmNautoUnmanage, True); n++;
    /* dialog shell resources */
    XtSetArg (args[n], XmNtitle, "System Modal Dialog"); n++;
    XtSetArg (args[n], XmNdialogStyle, XmDIALOG_SYSTEM_MODAL); n++;
    Dialog3 = XmCreateMessageDialog(parent, "Dialog1", args, n);
    if (delay) 
		sleep (delay);
    XtManageChild (Dialog3);

}

										/*BeginPIR2839*/
static void IconifyShell (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{

	Window	window;
	int		status;

	window = XtWindow((Widget)client_data);
	status = XIconifyWindow(display, window, DefaultScreen(display));

}

static void PopdownShell (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{

	XtPopdown((Widget)(client_data));

}

static void PopupShell (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{

	XtPopup((Widget)client_data, XtGrabNone);

}
										/*EndPIR2839*/

										/*BeginPIR2362*/
static void UnmanageShell (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{

	XtUnmanageChild((Widget)client_data);

}

static void ManageShell (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{

	XtManageChild((Widget)(client_data));

}

static void UnmanageDBox (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{

	XtUnmanageChild(DialogShell1);

}

static void ManageDBox (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;

{

	XtManageChild(DialogShell1);

}
										/*EndPIR2362*/


static void quitCB(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
     printf("Begin exiting ... please standby ... \n");
     fflush(stdout);
     exit(0);
}


void  main(argc, argv)
    int     argc;
    char  **argv;
{
    Boolean       trace = False;
    register int  n;
    Arg           args[MAX_ARGS];
    XmString      tcs;
    Widget        topShell1, topShell2;
    Widget        BB1, BB2;
    Widget        DB, DB2, exitButton;
    Widget        test1, test1a, test2, test3;
	Widget        iconify_2, popdown_2, popup_2;        /*PIR2839*/
	Widget        unmanage_2, manage_2, unmanage_2a, manage_2a;  /*PIR2362*/


    CommonTestInit(argc, argv);

    n = 0;
    XtSetArg(args[n], XmNmappedWhenManaged, True);  n++;
    XtSetArg(args[n], XmNallowShellResize, True);  n++;
    XtSetArg(args[n], XmNtitle, "Shell 1"); n++;
    topShell1 = XtCreatePopupShell("topShell 1", topLevelShellWidgetClass, 
								   Shell1, args, n);
	ParentShell1 = topShell1;

    n = 0;
    XtSetArg(args[n], XmNmappedWhenManaged, True);  n++;
    XtSetArg(args[n], XmNtitle, "Shell 2");         n++;
    XtSetArg(args[n], XtNgeometry, "+500+0");       n++;
    topShell2 = XtCreatePopupShell("topShell 2", topLevelShellWidgetClass, 
								   Shell1, args, n);
	ParentShell2 = topShell2;
   
    /* Shell 1 children */

    n = 0;
    BB1 = XmCreateBulletinBoard (topShell1, "BB1", args, n);
    XtManageChild (BB1);
    
    n = 0;
    XtSetArg (args[n], XmNx, 300); n++;
    XtSetArg (args[n], XmNy, 50); n++;
    XtSetArg (args[n], XmNlabelString,
	      XmStringCreateSimple ("Default Button")); n++;
    DB = XmCreatePushButton (BB1, "DB", args, n);	  
    XtManageChild (DB);

    n = 0;
    XtSetArg (args[n], XmNdefaultButton, DB); n++;
    XtSetValues (BB1, args, n);

    n = 0;
    XtSetArg (args[n], XmNx, 300); n++;
    XtSetArg (args[n], XmNy, 10); n++;
    exitButton = XmCreatePushButtonGadget (BB1, "Exit", args, n);
    XtManageChild (exitButton);
    XtAddCallback (exitButton, XmNactivateCallback, quitCB, NULL);

    n = 0;
    XtSetArg(args[n], XmNx, 12); n++;
    XtSetArg(args[n], XmNy, 20); n++;
    XtSetArg(args[n], XmNvalue, 0); n++;
    XtSetArg(args[n], XmNtitleString,
       XmStringCreateSimple ("Posting Delay")); n++;
    XtSetArg(args[n], XmNmaximum, 120); n++;
    XtSetArg(args[n], XmNminimum, 0); n++;
    XtSetArg(args[n], XmNshowValue, True); n++;
    XtSetArg(args[n], XmNprocessingDirection, XmMAX_ON_RIGHT); n++;
    XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
    Scale = XmCreateScale (BB1, "Scale", args, n);
    XtManageChild (Scale);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 100); n++;
    XtSetArg (args[n], XmNlabelString,
	      XmStringCreateSimple ("Create Primary Modal from topShell2")); n++;
    test1 = XmCreatePushButton (BB1, "test1", args, n);	  
    XtManageChild (test1);
    XtAddCallback (test1, XmNactivateCallback, PostPrimaryModalDialog, 
				   topShell2);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 150); n++;
    XtSetArg (args[n], XmNlabelString,
	      XmStringCreateSimple ("Create Primary Modal from topShell1")); n++;
    test1a = XmCreatePushButton (BB1, "test1a", args, n);	  
    XtManageChild (test1a);
    XtAddCallback (test1a, XmNactivateCallback, PostPrimaryModalDialog, 
				   topShell1);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 200); n++;
    XtSetArg (args[n], XmNlabelString,
	      XmStringCreateSimple ("Create Full App Modal Dialog")); n++;
    test2 = XmCreatePushButton (BB1, "test2", args, n);	  
    XtManageChild (test2);
    XtAddCallback (test2,  XmNactivateCallback, PostFullAppModalDialog, 
				   topShell1);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 250); n++;
    XtSetArg (args[n], XmNlabelString,
	      XmStringCreateSimple ("Create System Modal Dialog")); n++;
    test3 = XmCreatePushButton (BB1, "test3", args, n);	  
    XtManageChild (test3);
    XtAddCallback (test3, XmNactivateCallback, PostSystemModalDialog, 
				   topShell2);

										/*Begin PIR2839*/
    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 300); n++;
    XtSetArg (args[n], XmNlabelString,
	      XmStringCreateSimple ("Iconify topShell2 by XIconifyWindow")); n++;
    iconify_2 = XmCreatePushButton (BB1, "iconify_2", args, n);	  
    XtManageChild (iconify_2);
    XtAddCallback (iconify_2, XmNactivateCallback, IconifyShell, topShell2);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 350); n++;
    XtSetArg (args[n], XmNlabelString,
	      XmStringCreateSimple ("Popdown topShell2 by XtPopdown")); n++;
    popdown_2 = XmCreatePushButton (BB1, "popdown_2", args, n);	  
    XtManageChild (popdown_2);
    XtAddCallback (popdown_2, XmNactivateCallback, PopdownShell, topShell2);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 400); n++;
    XtSetArg (args[n], XmNlabelString,
	      XmStringCreateSimple ("Popup topShell2 by XtPopup")); n++;
    popup_2 = XmCreatePushButton (BB1, "popup_2", args, n);	  
    XtManageChild (popup_2);
    XtAddCallback (popup_2, XmNactivateCallback, PopupShell, topShell2);
										/*End PIR2839*/
										/*Begin PIR2362*/
    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 450); n++;
    XtSetArg (args[n], XmNlabelString,
	      XmStringCreateSimple ("Unmanage topShell2 by XtUnmanage")); n++;
    unmanage_2 = XmCreatePushButton (BB1, "unmanage_2", args, n);	  
    XtManageChild (unmanage_2);
    XtAddCallback (unmanage_2, XmNactivateCallback, UnmanageShell, topShell2);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 500); n++;
    XtSetArg (args[n], XmNlabelString,
	      XmStringCreateSimple ("Manage topShell2 by XtManage")); n++;
    manage_2 = XmCreatePushButton (BB1, "manage_2", args, n);	  
    XtManageChild (manage_2);
    XtAddCallback (manage_2, XmNactivateCallback, ManageShell, topShell2);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 550); n++;
    XtSetArg (args[n], XmNlabelString,
	      XmStringCreateSimple ("Unmanage DiaBox2 by XtUnmanage")); n++;
    unmanage_2a = XmCreatePushButton (BB1, "unmanage_2a", args, n);	  
    XtManageChild (unmanage_2a);
    XtAddCallback (unmanage_2a, XmNactivateCallback, UnmanageDBox, NULL);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 600); n++;
    XtSetArg (args[n], XmNlabelString,
	      XmStringCreateSimple ("Manage DiaBox2 by XtManage")); n++;
    manage_2a = XmCreatePushButton (BB1, "manage_2a", args, n);	  
    XtManageChild (manage_2a);
    XtAddCallback (manage_2a, XmNactivateCallback, ManageDBox, NULL);
										/*End PIR2362*/

    /* Shell 2 children */

    n = 0;
    BB2 = XmCreateBulletinBoard (topShell2, "BB2", args, n);    
    XtManageChild (BB2);

    n = 0;
    XtSetArg (args[n], XmNx, 200); n++;
    XtSetArg (args[n], XmNy, 50); n++;
    DB2 = XmCreatePushButtonGadget (BB2, "DB2", args, n);
    XtManageChild (DB2);

    n = 0;
    XtSetArg (args[n], XmNdefaultButton, DB2); n++;
    XtSetValues (BB2, args, n);
    
    XtRealizeWidget(topShell1);
    XtPopup(topShell1, XtGrabNone);
    XtRealizeWidget(topShell2);
    XtPopup(topShell2, XtGrabNone);
    XtAppMainLoop(app_context);
}
