/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: DiaShell2.c,v $ $Revision: 1.4 $ $Date: 92/03/13 17:12:45 $"
#endif
#endif
/*
*  (c) Copyright 1989, HEWLETT-PACKARD COMPANY */
#include "DiaShell2.h"
#include <X11/ShellP.h>

VendorShellWidget	DialogShell1;
Widget			BulletinBoard1,
			PushButton1,
			PushButton2;

static XtCallbackProc  QuitCB();

void  main(argc, argv)
    int     argc;
    char  **argv;
{
    register int  n;
    Arg           args[MAX_ARGS];
    XmString      tcs;

    signal(SIGHUP,  Quit);
    signal(SIGINT,  Quit);
    signal(SIGQUIT, Quit);

    XtToolkitInitialize();
    app_context = XtCreateApplicationContext();
    display = XtOpenDisplay(app_context, NULL, argv[0], "XMclient",
                            NULL, 0, &argc, argv);
    if (display == NULL) {
        fprintf(stderr, "%s:  Can't open display\n", argv[0]);
        exit(1);
    }

    n = 0;
    XtSetArg(args[n], XmNwidth,  400);  n++;
    XtSetArg(args[n], XmNheight, 300);  n++;
    XtSetArg(args[n], XmNallowShellResize, True);  n++;
    Shell1 = XtAppCreateShell(argv[0], NULL, applicationShellWidgetClass,
                              display, args, n);

    XtRealizeWidget(Shell1);

    n = 0;
    DialogShell1 = (VendorShellWidget) XtCreatePopupShell("DialogShell1", 
				      xmDialogShellWidgetClass, 
				      Shell1, args, n);
    XtManageChild(DialogShell1);

    n = 0;
    BulletinBoard1 = XmCreateBulletinBoard(DialogShell1, "BulletinBoard1", args, n);
    XtManageChild(BulletinBoard1);

    n = 0;
    PushButton1 = XmCreatePushButton(BulletinBoard1, "PushButton1", args, n);
    XtManageChild(PushButton1);

    n = 0;
    XtSetArg(args[n], XmNx, 50);  n++;
    XtSetArg(args[n], XmNy, 100);  n++;
    PushButton2 = XmCreatePushButton(BulletinBoard1, "PushButton2", args, n);
    XtManageChild(PushButton2);

    Pause();

    XtAppMainLoop(app_context);
}


static void  Quit()
{
     printf("Begin exiting ... please standby ... \n");
     fflush(stdout);
     exit(0);
}


static void  Pause()
{
    ContinuePopup = CreateContinuePopup();

    XtPopup(ContinuePopup, XtGrabNone);

    wait = True;
    while (wait)
        FlushEvents();
    Pause_cnt++;
}


static Widget CreateContinuePopup()
{
    Widget        popup;
    Widget        rowcol;
    Widget        message;
    Widget        exit_button, continue_button;
    Arg           args[MAX_ARGS];
    register int  n;
    XmString	  message_field, continue_field, exit_field;
    static XtTranslations tm_parsed, btn_parsed;
    static	  char tm[] =
"#override \n\
<Btn3Down>:MenuPopup(Next_event) \n\
<Btn3Up>:MenuPopdown(Next_event)";
    static 	char btn_tm[] =
"#override\n\
:<Key>p:MenuPopdown() \n\
:<Key>P:MenuPopdown(Next_event) \n\
:<Btn1Down>(2+):Noop() \n\
:<Btn1Up>(2+):Noop() \n\
:<Btn1Down>:Noop() \n\
:<Btn1Up>:Noop()";

    tm_parsed = XtParseTranslationTable(tm);

    XtOverrideTranslations(Shell1, tm_parsed);

    btn_parsed = XtParseTranslationTable(btn_tm);
    /*  create popup shell  */
    n = 0;
    XtSetArg(args[n], XtNgeometry, "+500+0");  n++;

    popup = XtCreatePopupShell("Next_event", topLevelShellWidgetClass,
                               Shell1, args, n);

    /*  create a frame for the pushbutton  */
    n = 0;
    XtSetArg(args[n], XmNmarginWidth,  12);  n++;
    XtSetArg(args[n], XmNmarginHeight, 12);  n++;
    rowcol = XmCreateRowColumn(popup, "frame", args, n);
    XtManageChild(rowcol);

    /*  create a Message Box and Control Continue and Exit */
    n = 0;
    message_field = XmStringCreateLtoR(Pause_events[Pause_cnt], XmSTRING_DEFAULT_CHARSET);
    continue_field = XmStringCreateLtoR("Continue", XmSTRING_DEFAULT_CHARSET);
    exit_field = XmStringCreateLtoR("Exit", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNtranslations, btn_parsed);  n++;
    XtSetArg(args[n], XmNmessageString, message_field); n++;
    XtSetArg(args[n], XmNokLabelString, continue_field); n++;
    XtSetArg(args[n], XmNcancelLabelString, exit_field); n++;
    message = XmCreateMessageBox(rowcol, "msgbox", args, n);
    XmStringFree(continue_field);
    XmStringFree(message_field);
    XmStringFree(exit_field);
    XtManageChild(message);
    continue_button = XmMessageBoxGetChild(message, XmDIALOG_OK_BUTTON);
    exit_button = XmMessageBoxGetChild(message, XmDIALOG_CANCEL_BUTTON);
    XtAddCallback(continue_button, XmNactivateCallback, ContinueCB, popup);
    XtAddCallback(exit_button, XmNactivateCallback, QuitCB, popup);

    return(popup);

}

static void  FlushEvents()
{
    XEvent event;

    while (XtAppPending(app_context)) {
        XtAppNextEvent(app_context, &event);
        XtDispatchEvent(&event);
    }
}


static XtCallbackProc  ContinueCB(w, client_data, call_data)
    Widget   w;
    caddr_t  client_data;
    caddr_t  call_data;
{
    wait = False;
    XtPopdown((Widget)client_data);
}


static XtCallbackProc  QuitCB(w, client_data, call_data)
    Widget   w;
    caddr_t  client_data;
    caddr_t  call_data;

{
	printf("Exiting...Please Standby...\n");
	exit(0);
}


