/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Scrollbar10.c,v $ $Revision: 1.4 $ $Date: 92/03/13 17:45:55 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */
/************************************************************************
 *
 *  Create a vertical scrollbar and test SetValue for some invalid
 *  data.  Ensure that the redisplay is correct.
 *
 ************************************************************************/

#include <X11/StringDefs.h>
#include <testlib.h>

static void ScrollCallback();

void DumpData(sbw)
Widget sbw;

{
   Arg args[10];
   int n;
   
   n = 0;
   XtSetArg(args[n], XmNminimum, NULL);	n++;
   XtSetArg(args[n], XmNmaximum, NULL);	n++;
   XtSetArg(args[n], XmNvalue, NULL);		n++;
   XtSetArg(args[n], XmNsliderSize, NULL);	n++;
   XtGetValues(sbw, args, n);
   printf("min = %d,   max = %d,   value = %d,  slider size = %d\n\n",
            args[0].value, args[1].value, args[2].value, args[3].value);
}



void main(argc, argv)
unsigned int argc;
char **argv;
{
  Widget frame;
  Widget scrollbar;
  Arg args[10];
  int n,i;

  CommonTestInit(argc, argv);

  frame = XmCreateFrame(Shell1, "frame", NULL, 0);
  XtManageChild(frame);

  n = 0;
  XtSetArg(args[n], XmNorientation, XmVERTICAL);		n++;
  XtSetArg(args[n], XmNheight, 400);		n++;
  scrollbar = XmCreateScrollBar(frame, "scrollbar", args, n);
  XtManageChild(scrollbar);
  XtRealizeWidget(Shell1);
  DumpData(scrollbar);
  CommonPause();

  printf("changing the slider size to 40 and value to 70\n");
  n = 0;
  XtSetArg(args[n], XmNsliderSize, 40);	n++;
  XtSetArg(args[n], XmNvalue, 70);		n++;
  XtSetValues(scrollbar, args, n);
  DumpData(scrollbar);
  CommonPause();

  printf("changing the maximum to 90 and value to 60\n");
  n = 0;
  XtSetArg(args[n], XmNmaximum, 90);	n++;
  XtSetArg(args[n], XmNvalue, 60);	n++;
  XtSetValues(scrollbar, args, n);
  DumpData(scrollbar);
  CommonPause();

  printf("changing the value to 50\n");
  n = 0;
  XtSetArg(args[n], XmNvalue, 50);	n++;
  XtSetValues(scrollbar, args, n);
  DumpData(scrollbar);
  CommonPause();

  printf("changing the maximum to 80\n");
  n = 0;
  XtSetArg(args[n], XmNmaximum, 80);	n++;
  XtSetValues(scrollbar, args, n);
  DumpData(scrollbar);
  CommonPause();

  printf("changing the value to 0 and the min to 10\n");
  n = 0;
  XtSetArg(args[n], XmNvalue, 0);	n++;
  XtSetArg(args[n], XmNminimum, 10);	n++;
  XtSetValues(scrollbar, args, n);
  DumpData(scrollbar);
  CommonPause();

  printf("changing the min to 20\n");
  n = 0;
  XtSetArg(args[n], XmNminimum, 20);	n++;
  XtSetValues(scrollbar, args, n);
  DumpData(scrollbar);

  XtAddCallback(scrollbar, XmNvalueChangedCallback,  ScrollCallback, NULL);
  XtAddCallback(scrollbar, XmNhelpCallback,          ScrollCallback, NULL);

  CommonPause();
  
  XtDestroyWidget(scrollbar);
  XtDestroyWidget(frame);
  CommonPause();
  XtAppMainLoop(app_context);
}

static void ScrollCallback(sbw, closure, call_data)
XmScrollBarWidget sbw;
caddr_t closure;
caddr_t call_data;
{
  int value;
  int reason;
  int pixel;
  Arg args[10];
  int n;

  XmScrollBarCallbackStruct * call_value = 
    (XmScrollBarCallbackStruct *) call_data;

  reason = call_value -> reason;
  value = call_value -> value;
  pixel = call_value -> pixel;

  switch(reason)
    {
    case XmCR_VALUE_CHANGED:
      printf("Reason = XmCR_VALUE_CHANGED,	Value = %d", value);
      break;

    case XmCR_HELP:
      printf("Reason = XmCR_HELP,	Value = %d\n", value);
      break;

    default:
      printf("Hit the default, incorrect reason sent!!\n");
      break;
    }

  n = 0;
  XtSetArg(args[n], XmNvalue, NULL);	n++;
  XtGetValues((Widget) sbw, args, n);
  printf(",   GetValues value = %d\n", args[0].value);
}
