/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Label2.c,v $ $Revision: 1.4 $ $Date: 92/03/13 17:33:14 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */
/*
 *  Read a set of images using _XmGetImageFromFile, store them in
 *  pixmaps, then create a drawing area with a set of labels containing
 *  the pixmaps.
 */


#include <signal.h>
#include <X11/StringDefs.h>

#include <testlib.h>
extern XImage * _XmGetImageFromFile();

/*  Forward declarations  */

static void flushEvents();

void main (argc, argv)
unsigned int argc;
char **argv;

{
  Widget drawarea;
  Widget label1, label2, label3, label4;
  Pixmap pixmap1, pixmap2, pixmap3, pixmap4;
  XImage *image1;
  XImage *image2;
  XImage *image3;
  XImage *image4;
  GC gc;
  Arg args[10];
  int n;

  CommonTestInit(argc, argv);
    
  n = 0;
  XtSetArg (args[n], XmNwidth, 400); n++;
  XtSetArg (args[n], XmNheight, 400); n++;
  XtSetValues(Shell1, args, n);

  /*  The drawing area creation.  Contained in an outer frame.  */
  
  n = 0;
  XtSetArg (args[n], XmNwidth, 400);	n++;
  XtSetArg (args[n], XmNheight, 400);	n++;
  drawarea = XmCreateDrawingArea (Shell1, "drawarea", args, n);
  XtManageChild (drawarea);

  XtRealizeWidget (Shell1);


  /*  Get the set of images  */

  image1 = _XmGetImageFromFile ("/usr/include/X11/bitmaps/tie_fighter");
  image2 = _XmGetImageFromFile ("/usr/include/X11/bitmaps/woman");
  image3 = _XmGetImageFromFile ("/usr/include/X11/bitmaps/right_ptr");
  image4 = _XmGetImageFromFile ("/usr/include/X11/bitmaps/target");

  /*  Create a set of pixmaps to copy the images to.  */

  pixmap1 = XCreatePixmap (XtDisplay (Shell1), XtWindow (Shell1),
			   image1->width, image1->height, 
			   DefaultDepthOfScreen (XtScreen (Shell1)));
  
  pixmap2 = XCreatePixmap (XtDisplay (Shell1), XtWindow (Shell1),
			   image2->width, image2->height,
			   DefaultDepthOfScreen (XtScreen (Shell1)));

  pixmap3 = XCreatePixmap (XtDisplay (Shell1), XtWindow (Shell1),
			   image3->width, image3->height,
			   DefaultDepthOfScreen (XtScreen (Shell1)));

  pixmap4 = XCreatePixmap (XtDisplay (Shell1), XtWindow (Shell1),
			   image4->width, image4->height,
			   DefaultDepthOfScreen (XtScreen (Shell1)));

  /*  Create a gc to be used to copy the images  */

  gc = XCreateGC (XtDisplay (Shell1), pixmap1, 0, 0);

  /*  Copy each image into its respective display  */

  XPutImage (XtDisplay (Shell1), pixmap1, gc, image1, 
	     0, 0, 0, 0, image1->width, image1->height);

  XPutImage (XtDisplay (Shell1), pixmap2, gc, image2, 
	     0, 0, 0, 0, image2->width, image2->height);

  XPutImage (XtDisplay (Shell1), pixmap3, gc, image3, 
	     0, 0, 0, 0, image3->width, image3->height);

  XPutImage (XtDisplay (Shell1), pixmap4, gc, image4, 
	     0, 0, 0, 0, image4->width, image4->height);

  XFreeGC (XtDisplay (Shell1), gc);

  /*  Create 4 labels in the drawing area  */

  n = 0;
  XtSetArg (args[n], XmNx, 25);		n++;
  XtSetArg (args[n], XmNy, 25);		n++;
  XtSetArg (args[n], XmNlabelType, XmPIXMAP);	n++;
  XtSetArg (args[n], XmNlabelPixmap, pixmap1);	n++;
  label1 = XmCreateLabel (drawarea, "label1", args, n);
  XtManageChild (label1);

  n = 0;
  XtSetArg (args[n], XmNx, 250); n++;
  XtSetArg (args[n], XmNy, 25);	n++;
  XtSetArg (args[n], XmNlabelType, XmPIXMAP);	n++;
  XtSetArg (args[n], XmNlabelPixmap, pixmap2);	n++;
  label2 = XmCreateLabel (drawarea, "label2", args, n);
  XtManageChild (label2);

  n = 0;
   XtSetArg (args[n], XmNx, 25);		n++;
  XtSetArg (args[n], XmNy, 250);		n++;
  XtSetArg (args[n], XmNlabelType, XmPIXMAP);	n++;
  XtSetArg (args[n], XmNlabelPixmap, pixmap3);	n++;
  label3 = XmCreateLabel (drawarea, "label3", args, n);
  XtManageChild (label3);

  n = 0;
  XtSetArg (args[n], XmNx, 250);		n++;
  XtSetArg (args[n], XmNy, 250);		n++;
  XtSetArg (args[n], XmNlabelType, XmPIXMAP);	n++;
  XtSetArg (args[n], XmNlabelPixmap, pixmap4);	n++;
  label4 = XmCreateLabel (drawarea, "label4", args, n);
  XtManageChild (label4);

  CommonPause();

  /* END */
  XtDestroyWidget(label1);
  XtDestroyWidget(label2);
  XtDestroyWidget(label3);
  XtDestroyWidget(label4);
  XtDestroyWidget(drawarea);
  CommonPause();
  XtAppMainLoop(app_context);
}

static void flushEvents(display, delay)
Display * display;
int delay;
{
  XEvent event;
  while (XPending(display)) {
    XNextEvent(display, &event);
    XtDispatchEvent(&event);
  }
  sleep(delay);
}
