/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: instructs.c,v $ $Revision: 1.4 $ $Date: 92/03/13 17:24:27 $"
#endif
#endif
/*
*  (c) Copyright 1989, HEWLETT-PACKARD COMPANY */

#include "instructs.h"

extern char *Pause_events[];
Boolean   wait;
Widget	ContinuePopup = NULL;
char      automatic = FALSE;
char      describe = FALSE;
int Pause_cnt = 0;

void  Quit()
{
  printf("Begin exiting ... please standby ... \n");
  fflush(stdout);
  exit(0);
}


void  Pause(shell, app_context)
     Widget		shell;
     XtAppContext	app_context;
{
  ContinuePopup = CreateContinuePopup(shell);

  XtPopup(ContinuePopup, XtGrabNone);

  wait = True;
  while (wait)
    FlushEvents(app_context);
  Pause_cnt++;
}


Widget CreateContinuePopup(shell)
     Widget	shell;
{
  Widget        popup;
  Widget        rowcol;
  Widget        message;
  Widget        exit_button, continue_button;
  Arg           args[NUM_ARGS];
  register int  n;
  XmString	  message_field, continue_field, exit_field;

  /*  create popup shell  */
  n = 0;
  XtSetArg(args[n], XtNgeometry, "+500+0");  n++;

  popup = XtCreatePopupShell("Next Event", topLevelShellWidgetClass,
			     shell, args, n);

  /*  create a frame for the pushbutton  */
  n = 0;
  XtSetArg(args[n], XmNmarginWidth,  12);  n++;
  XtSetArg(args[n], XmNmarginHeight, 12);  n++;
  rowcol = XmCreateRowColumn(popup, "frame", args, n);
  XtManageChild(rowcol);

  /*  create a Message Box and Control Continue and Exit */
  n = 0;
  message_field = XmStringCreateLtoR(Pause_events[Pause_cnt], XmSTRING_DEFAULT_CHARSET);
  continue_field = XmStringCreateLtoR("Continue", XmSTRING_DEFAULT_CHARSET);
  exit_field = XmStringCreateLtoR("Exit", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNmessageString, message_field); n++;
  XtSetArg(args[n], XmNokLabelString, continue_field); n++;
  XtSetArg(args[n], XmNcancelLabelString, exit_field); n++;
  message = XmCreateMessageBox(rowcol, "msgbox", args, n);
  XtManageChild(message);
  continue_button = XmMessageBoxGetChild(message, XmDIALOG_OK_BUTTON);
  exit_button = XmMessageBoxGetChild(message, XmDIALOG_CANCEL_BUTTON);
  XmStringFree(continue_field);
  XmStringFree(message_field);
  XmStringFree(exit_field);
  XtAddCallback(continue_button, XmNactivateCallback, ContinueCB, popup);
  XtAddCallback(exit_button, XmNactivateCallback, QuitCB, popup);

  return(popup);

}

void  GetOptions(argc, argv, trace, progname)
     int          argc;
     char       **argv;
     Boolean     *trace;
     char	*progname;
{
  register int i;

  for (i = 1; i < argc; i++) {
    if (argv[i][0] == '-') {
      switch (argv[i][1]) {
      case 'v':
	*trace = True;
	break;
      case 'a':
	automatic = True;
	break;
      default:
	fprintf(stderr, "\nusage:  %s [-va]\n", progname);
	fprintf(stderr, "        The -v option enables trace output.\n\n");
	fprintf(stderr, "        The -a option enables automatic execution.\n\n");
	exit(1);
      }
    }
  }
}


void  FlushEvents(app_context)
     XtAppContext app_context;
{
  XEvent event;

  while (XtAppPending(app_context)) {
    XtAppNextEvent(app_context, &event);
    XtDispatchEvent(&event);
  }
}


XtCallbackProc  ContinueCB(w, client_data, call_data)
     Widget   w;
     caddr_t  client_data;
     caddr_t  call_data;
{
  wait = False;
  XtPopdown((Widget)client_data);
}


XtCallbackProc  QuitCB(w, client_data, call_data)
     Widget   w;
     caddr_t  client_data;
     caddr_t  call_data;

{
  printf("Exiting...Please Standby...\n");
  exit(0);
}
